/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.core;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.bal.business.core.AbstractBalRepair;
import kd.bos.bal.business.core.BalEngineUtil;
import kd.bos.bal.business.core.Key;
import kd.bos.bal.business.core.RepairTaskHandle;
import kd.bos.bal.common.BalLogUtil;
import kd.bos.biz.balance.engine.UpdateRuleCache;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.biz.balance.model.IBalance;
import kd.bos.biz.balance.model.UpdateRule;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IModifyTimeProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.instance.Instance;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;

class RepairBillSpData
extends AbstractBalRepair {
    private Set<String> balQtyCol;
    private BalanceTB balanceTB;
    private UpdateRule rule;
    private String appId;
    private String occDb;

    public RepairBillSpData(DynamicObject taskInfo) {
        super(taskInfo);
        String ruleId = taskInfo.getString("rule.id");
        this.rule = UpdateRuleCache.getUpdateRuleFromCache(ruleId);
        if (this.rule == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u89c4\u5219\u89e3\u6790\u9519\u8bef\uff1arule is null\u3002", (String)"CheckRepairBillCreateSpData_0", (String)"bos-biz-balance", (Object[])new Object[0]));
        }
        this.balanceTB = this.rule.getBalanceTB();
        this.resultId = new HashSet(this.batch);
        MainEntityType metadataType = MetadataServiceHelper.getDataEntityType((String)this.seqEntityName);
        this.appId = metadataType.getAppId();
        this.occDb = metadataType.getDBRouteKey();
    }

    @Override
    protected String buildParamMsg() {
        String msg = super.buildParamMsg();
        msg = msg + String.format(", ruleFs = [%s], updatedFs = [%s]", this.rule.getFilter(), BalEngineUtil.getRuleUpdatedFs(this.rule));
        return msg;
    }

    @Override
    protected void checkUpdateRule() {
        if (!this.rule.isEnable()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u89c4\u5219\u4e0d\u80fd\u662f\u7981\u7528\u7684\u3002", (String)"RepairBillSpData_0", (String)"bos-biz-balance", (Object[])new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void checkData(TreeSet<Object> billIds) {
        try (TXHandle tx = TX.requiresNew((String)"applyCheck").setRollback(true);){
            this.applyCheck(billIds);
            try (DataSet data = null;){
                data = BalEngineUtil.getData(this.rule, billIds, null, true);
                DataSet oldSpData = BalEngineUtil.queryOldSpData(this.rule, billIds, null);
                JoinDataSet joinData = data.fullJoin(oldSpData).on("billid", this.balanceTB.toOldSpCol("billid")).on("entryid", this.balanceTB.toOldSpCol("entryid"));
                data = joinData.select(data.getRowMeta().getFieldNames(), oldSpData.getRowMeta().getFieldNames()).finish();
                if (this.cfg.isEngineDistinctEntryId()) {
                    data = BalEngineUtil.distinctEntryId(data, "entryid", this.balanceTB.toOldSpCol("entryid"));
                }
                Long billId = null;
                for (Row row : data) {
                    billId = this.getBillId(row);
                    if (this.resultId.contains(billId)) continue;
                    this.collectBillId(row, billId);
                }
            }
        }
    }

    private long[] applyCheck(TreeSet<Object> billIds) {
        ArrayList<Object[]> billParams = new ArrayList<Object[]>(billIds.size());
        String ruleId = this.rule.getId();
        String billName = this.rule.getEntityNumber();
        long[] ids = DB.genGlobalLongIds((int)billIds.size());
        int i = 0;
        String instanceid = Instance.getInstanceId();
        for (Object billId : billIds) {
            billParams.add(new Object[]{ids[i++], billId, this.occDb, this.appId, this.rule.getBalanceNo(), ruleId, billName, null, 0, 0, instanceid});
        }
        try {
            DB.executeBatch((DBRoute)IBalance.BAL_DB, (String)"INSERT INTO T_BAL_UPDATING (FID,FBILLID,FDB,FAPP,FBAL,FRULEID,FBILLENTITY,FCREATETIME,FTXID,FCREATERID,FINSTANCEID) VALUES (?,?,?,?,?,?,?,?,?,?,?) ", billParams);
        }
        catch (Throwable e) {
            if (BalLogUtil.isUniqueError(e)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u64cd\u4f5c\u6570\u636e\u4e2d\u8fd8\u6709\u4f59\u989d\u66f4\u65b0\u4e1a\u52a1\u6682\u672a\u5f02\u6b65\u5904\u7406\u5b8c\u6bd5\uff0c\u8bf7\u51e0\u5206\u949f\u540e\u518d\u91cd\u8bd5\uff0c\u8be6\u60c5\u53ef\u67e5\u770b\u66f4\u65b0\u4e2d\u5355\u636e\u5217\u8868\u3002", (String)"CheckRepairBillCreateSpData_1", (String)"bos-biz-balance", (Object[])new Object[0]));
            }
            throw e;
        }
        return ids;
    }

    private Long getBillId(Row row) {
        Long billId = row.getLong("billid");
        if (billId == null) {
            billId = row.getLong(this.balanceTB.toOldSpCol("billid"));
        }
        return billId;
    }

    private void collectBillId(Row row, Long billId) {
        boolean hasOldData;
        boolean hasNewData = row.getLong("entryid") != null;
        boolean bl = hasOldData = row.getLong(this.balanceTB.toOldSpCol("entryid")) != null;
        if (hasNewData && !hasOldData || !hasNewData && hasOldData || this.isKeyColChanged(row) || this.isQtyChanged(row)) {
            this.resultId.add(billId);
        }
    }

    private boolean isQtyChanged(Row row) {
        for (String qtyCol : this.getBalQtyCols()) {
            if (row.getBigDecimal(qtyCol).add(row.getBigDecimal(this.balanceTB.toOldSpCol(qtyCol))).compareTo(BigDecimal.ZERO) == 0) continue;
            return true;
        }
        return false;
    }

    private Set<String> getBalQtyCols() {
        return this.balQtyCol == null ? (this.balQtyCol = BalEngineUtil.getBalQtyCols(this.balanceTB)) : this.balQtyCol;
    }

    private boolean isKeyColChanged(Row row) {
        Key key = BalEngineUtil.calKey(row, this.rule.getUpdateKeyCol());
        String oldKey = row.getString(this.balanceTB.toOldSpCol("keycol"));
        return !BalEngineUtil.isTheSameKey(this.balanceTB, key.getkeyStr(), oldKey, row);
    }

    @Override
    public void repairData(TreeSet<Object> billIds) {
        RepairTaskHandle.repairBillCreateSpData(this.rule, billIds);
    }

    @Override
    protected void handleFs() {
        if ("C".equals(this.opRange)) {
            this.appendFs(this.parseBillFs());
        } else if (this.point != null) {
            MainEntityType type = MetadataServiceHelper.getDataEntityType((String)this.seqEntityName);
            IModifyTimeProperty pro = type.getModifyTimeProperty();
            if (pro != null) {
                this.appendFs(new QFilter(pro.getName(), ">=", (Object)new Date(this.point.getTimePoint())));
            } else {
                long l = this.fromId = this.point.getIdPonit() > this.fromId ? this.point.getIdPonit() : this.fromId;
            }
        }
        if ("B".equals(this.taskMode)) {
            this.fromId = this.lastSuccessId > this.fromId ? this.lastSuccessId : this.fromId;
        }
    }

    @Override
    protected void repair4Check(List<?> dataIds) {
        RepairTaskHandle.repairBillCreateSpData(this.rule, new HashSet<Object>(dataIds));
    }

    @Override
    protected String getTaskType4Point() {
        return "B";
    }
}

