/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.core;

import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bal.business.core.AbstractBalRepair;
import kd.bos.bal.business.core.RepairTaskHandle;
import kd.bos.biz.balance.engine.UpdateRuleCache;
import kd.bos.biz.balance.model.UpdateRule;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.exception.KDBizException;

class RepairRuleDisable
extends AbstractBalRepair {
    private UpdateRule rule;

    public RepairRuleDisable(DynamicObject taskInfo) {
        super(taskInfo);
        String ruleId = taskInfo.getString("rule.id");
        this.rule = UpdateRuleCache.getUpdateRuleFromCache(ruleId);
        if (this.rule == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u89c4\u5219\u89e3\u6790\u9519\u8bef\uff1arule is null\u3002", (String)"CheckRepairBillIsDelOrRollback_0", (String)"bos-biz-balance", (Object[])new Object[0]));
        }
        this.resultId = new HashSet(this.batch);
    }

    @Override
    protected void checkUpdateRule() {
        if (this.rule.isEnable()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u89c4\u5219\u4e0d\u80fd\u662f\u542f\u7528\u7684\u3002", (String)"RepairRuleDisable_0", (String)"bos-biz-balance", (Object[])new Object[0]));
        }
    }

    @Override
    protected void checkData() {
        this.checkUpdateRule();
        this.handleFs();
        this.taskInfo.set("param_tag", (Object)this.buildParamMsg());
        if (this.fromId >= this.toId) {
            return;
        }
        String actualtb = this.taskInfo.getString("sparseseq.actualtb");
        String dbKey = this.taskInfo.getString("sparseseq.dbkey");
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT DISTINCT", new Object[0]).append("fbillid", new Object[0]).append("FROM", new Object[0]).append(actualtb, new Object[0]);
        sql.append("WHERE", new Object[0]).append("fbillid>=?", new Object[]{this.fromId});
        sql.append("AND", new Object[0]).append("fbillid<?", new Object[]{this.toId});
        sql.append("AND", new Object[0]).append("fupdateruleid=?", new Object[]{this.rule.getId()});
        sql.append("AND", new Object[0]).append("fstatus=?", new Object[]{"A"});
        try (DataSet balData = DB.queryDataSet((String)"CheckBillIsDel.check", (DBRoute)DBRoute.of((String)dbKey), (SqlBuilder)sql);){
            for (Row row : balData) {
                this.resultId.add(row.getLong("fbillid"));
            }
        }
        if (this.toId < Long.MAX_VALUE) {
            this.setLastSuccessId(this.toId);
        }
    }

    @Override
    protected void repair4Check(List<?> dataIds) {
        RepairTaskHandle.repair4rollBack(this.rule, dataIds);
    }

    @Override
    public void repairData(TreeSet<Object> ids) {
        RepairTaskHandle.repair4rollBack(this.rule, ids);
    }

    @Override
    public void repair() {
        this.checkUpdateRule();
        this.checkData();
        if (!this.resultId.isEmpty()) {
            TreeSet<Object> ids = new TreeSet<Object>();
            for (Object billId : this.resultId) {
                ids.add(billId);
                if (ids.size() < this.batch) continue;
                this.repairData(ids);
                ids.clear();
            }
            if (!ids.isEmpty()) {
                this.repairData(ids);
            }
            this.resultId.clear();
        }
        if (this.fromId < this.toId && this.toId < Long.MAX_VALUE) {
            this.setLastSuccessId(this.toId);
        }
    }

    @Override
    protected void handleFs() {
        if ("B".equals(this.taskMode)) {
            this.fromId = this.lastSuccessId > this.fromId ? this.lastSuccessId : this.fromId;
        }
    }

    @Override
    protected void checkData(TreeSet<Object> dataIds) {
    }

    @Override
    protected String getTaskType4Point() {
        return "E";
    }
}

