/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.core;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import kd.bos.bal.business.core.AbstractBalRepair;
import kd.bos.bal.business.core.RepairTaskHandle;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;

public class RepairSpdataSumBal
extends AbstractBalRepair {
    private BalanceTB bal;

    public RepairSpdataSumBal(DynamicObject taskInfo) {
        super(taskInfo);
        this.bal = BalanceTB.getBalanceTB(this.seqEntityName);
    }

    @Override
    public void checkData(TreeSet<Object> balIds) {
        List<String> keycols = RepairTaskHandle.checkSpDataSumBal(this.bal, new ArrayList<Object>(balIds));
        this.resultId.addAll(keycols);
    }

    @Override
    protected void repair4Check(List<?> keycols) {
        RepairTaskHandle.repairSpDataSumBalByKey(this.bal, keycols);
    }

    @Override
    protected void repairData(TreeSet<Object> balIds) {
        RepairTaskHandle.repairSpDataSumBal(this.bal, balIds);
    }

    @Override
    protected void handleFs() {
        if ("D".equals(this.opRange)) {
            this.appendFs(this.parseBalFs());
        } else if (this.point != null) {
            String modifyTimeCol = this.bal.getModifyTimeCol();
            if (modifyTimeCol != null) {
                this.appendFs(new QFilter(modifyTimeCol, ">=", (Object)new Date(this.point.getTimePoint())));
            } else {
                long l = this.fromId = this.point.getIdPonit() > this.fromId ? this.point.getIdPonit() : this.fromId;
            }
        }
        if ("B".equals(this.taskMode)) {
            long l = this.fromId = this.lastSuccessId > this.fromId ? this.lastSuccessId : this.fromId;
        }
        if (this.bal.isPerBal()) {
            this.appendFs(new QFilter(this.bal.getEndPeriodCol(), "=", (Object)999999));
        }
    }

    @Override
    protected String getTaskType4Point() {
        return "C";
    }
}

