/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bal.business.core.BalConfig;
import kd.bos.bal.business.core.RepairTask;
import kd.bos.bal.business.sparse.SparseSeqParam;
import kd.bos.bal.common.BalPoolUtil;
import kd.bos.bal.common.QFUtil;
import kd.bos.bal.common.TaskMsg;
import kd.bos.bal.servicehelper.BalServiceHelper;
import kd.bos.biz.balance.engine.UpdateRuleCache;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.biz.balance.model.UpdateRule;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.mq.support.partition.PartitionStrategy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.xdb.XDBConfig;
import org.apache.commons.lang3.StringUtils;

class RepairTaskBuilder {
    RepairTaskBuilder() {
    }

    public static void publishTasks(List<TaskMsg> msgs) {
        if (msgs == null || msgs.isEmpty()) {
            return;
        }
        boolean useMQ = BalConfig.isServiceByMQ();
        if (useMQ) {
            RepairTaskBuilder.publishTaskByMQ(msgs);
        } else {
            RepairTaskBuilder.publishTaskByService(msgs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void publishTaskByMQ(List<TaskMsg> msgs) {
        try (MessagePublisher pub = null;){
            pub = MQFactory.get().createPartitionPublisher("bal_queue", "bal.check", PartitionStrategy.APP_ID);
            for (TaskMsg msg : msgs) {
                pub.publish((Object)msg, msg.getAppId());
                msg.setPubSuccess(true);
            }
        }
    }

    private static void publishTaskByService(List<TaskMsg> msgs) {
        Object result;
        ArrayList<TaskMsg> reTryMsgs = new ArrayList<TaskMsg>(8);
        for (TaskMsg msg : msgs) {
            result = BalServiceHelper.invokeBalService(msg.getAppId(), "mockCheckTaskMsg", msg);
            if ("1".equals(result)) {
                msg.setPubSuccess(true);
                continue;
            }
            reTryMsgs.add(msg);
        }
        if (!reTryMsgs.isEmpty()) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            for (TaskMsg msg : reTryMsgs) {
                result = BalServiceHelper.invokeBalService(msg.getAppId(), "mockCheckTaskMsg", msg);
                msg.setPubSuccess("1".equals(result));
            }
        }
    }

    public static void buildTask(DynamicObject checkRepair) {
        try {
            RepairTaskBuilder.addTask(checkRepair);
        }
        catch (Throwable e) {
            RepairTaskBuilder.delTask(checkRepair);
            throw e;
        }
        RepairTaskBuilder.publishTask(checkRepair);
    }

    private static void addTask(DynamicObject parentTask) {
        String taskType;
        switch (taskType = parentTask.getString("tasktype")) {
            case "A": {
                RepairTaskBuilder.addCheckBalKeyCol(parentTask);
                break;
            }
            case "B": {
                RepairTaskBuilder.addCheckBillCreateSpData(parentTask);
                break;
            }
            case "D": {
                RepairTaskBuilder.addCheckBillIsDel(parentTask);
                break;
            }
            case "J": {
                RepairTaskBuilder.addCheckRuleDisable(parentTask);
                break;
            }
            case "C": {
                RepairTaskBuilder.addCheckSpDataSumBal(parentTask);
                break;
            }
            case "E": {
                RepairTaskBuilder.addClearSpData(parentTask);
                break;
            }
            case "F": {
                RepairTaskBuilder.addRepairBalKeyCol(parentTask);
                break;
            }
            case "G": {
                RepairTaskBuilder.addRepairBillCreateSpData(parentTask);
                break;
            }
            case "I": {
                RepairTaskBuilder.addRepairBillIsDelOrRollback(parentTask);
                break;
            }
            case "H": {
                RepairTaskBuilder.addRepairSpDataSumBal(parentTask);
                break;
            }
        }
    }

    private static void delTask(DynamicObject checkRepair) {
        MainEntityType task = MetadataServiceHelper.getDataEntityType((String)"bal_check_repair_task");
        String tb = task.getAlias();
        String parentTaskCol = task.findProperty("parenttask").getAlias();
        String sql = "DELETE FROM " + tb + " WHERE " + parentTaskCol + "=" + checkRepair.getLong("id");
        checkRepair.set("opresult", (Object)"C");
        try (TXHandle tx = TX.requiresNew((String)"updateSubTaskStatus");){
            try {
                DB.execute((DBRoute)DBRoute.of((String)task.getDBRouteKey()), (String)sql);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkRepair});
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private static void publishTask(DynamicObject checkRepair) {
        ArrayList<TaskMsg> msgs = new ArrayList<TaskMsg>(16);
        long parentTaskId = checkRepair.getLong("id");
        QFilter fs = new QFilter("parenttask", "=", (Object)parentTaskId);
        try (DataSet data = QueryServiceHelper.queryDataSet((String)"batchPublishTask", (String)"bal_check_repair_task", (String)"id,msgappid", (QFilter[])fs.toArray(), null);){
            for (Row row : data) {
                String msgAppId = row.getString("msgappid");
                if (!StringUtils.isNotBlank((CharSequence)msgAppId)) continue;
                msgs.add(new TaskMsg(msgAppId, row.getLong("id"), null));
            }
        }
        RepairTaskBuilder.publishTasks(msgs);
        RepairTaskBuilder.updateSubTaskStatus(checkRepair);
        RepairTaskBuilder.markTaskBusy(msgs);
    }

    private static void markTaskBusy(List<TaskMsg> msgs) {
        List ids = msgs.stream().filter(t -> !t.isPubSuccess()).map(TaskMsg::getTaskId).collect(Collectors.toList());
        if (!ids.isEmpty()) {
            MainEntityType task = MetadataServiceHelper.getDataEntityType((String)"bal_check_repair_task");
            String tb = task.getAlias();
            String statusCol = task.findProperty("status").getAlias();
            String runStatusCol = task.findProperty("runstatus").getAlias();
            String sql = "UPDATE " + tb + " SET " + runStatusCol + "='3' WHERE FID " + QFUtil.getIdsFilter(ids) + " AND " + statusCol + "='A' ";
            try (TXHandle tx = TX.requiresNew((String)"markTaskBusy");){
                try {
                    DB.execute((DBRoute)DBRoute.of((String)task.getDBRouteKey()), (String)sql);
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }

    private static void updateSubTaskStatus(DynamicObject checkRepair) {
        MainEntityType task = MetadataServiceHelper.getDataEntityType((String)"bal_check_repair_task");
        String tb = task.getAlias();
        String statusCol = task.findProperty("status").getAlias();
        String runStatusCol = task.findProperty("runstatus").getAlias();
        String parentTaskCol = task.findProperty("parenttask").getAlias();
        String sql = "UPDATE " + tb + " SET " + statusCol + "='B'," + runStatusCol + "='1' WHERE " + parentTaskCol + "=" + checkRepair.getLong("id") + " AND " + statusCol + "='A' ";
        checkRepair.set("opresult", (Object)"B");
        try (TXHandle tx = TX.requiresNew((String)"updateSubTaskStatus");){
            try {
                DB.execute((DBRoute)DBRoute.of((String)task.getDBRouteKey()), (String)sql);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkRepair});
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private static void addRepairSpDataSumBal(DynamicObject parentTask) {
        RepairTaskBuilder.addCheckSpDataSumBal(parentTask);
    }

    private static void addRepairBillIsDelOrRollback(DynamicObject parentTask) {
        RepairTaskBuilder.addCheckBillIsDel(parentTask);
    }

    private static void addRepairBillCreateSpData(DynamicObject parentTask) {
        RepairTaskBuilder.addCheckBillCreateSpData(parentTask);
    }

    private static void addRepairBalKeyCol(DynamicObject parentTask) {
        RepairTaskBuilder.addCheckBalKeyCol(parentTask);
    }

    private static void addCheckBalKeyCol(DynamicObject parentTask) {
        RepairTaskBuilder.buildTasksByBal(parentTask);
    }

    private static void addCheckBillCreateSpData(DynamicObject parentTask) {
        List<UpdateRule> rules = RepairTaskBuilder.parseRuleFromParentTask(parentTask);
        for (UpdateRule rule : rules) {
            if (!rule.isEnable()) continue;
            RepairTaskBuilder.buildTasksByBill(parentTask, rule);
        }
    }

    private static void addCheckBillIsDel(DynamicObject parentTask) {
        String balName = parentTask.getString("bal.id");
        String billName = parentTask.getString("bill.id");
        String ruleId = parentTask.getString("updaterule.id");
        BalanceTB bal = BalanceTB.getBalanceTB(balName);
        if (StringUtils.isNotBlank((CharSequence)ruleId)) {
            RepairTaskBuilder.buildTaskBySpTb(parentTask, bal, ruleId, billName, "fbillid");
        } else if (StringUtils.isNotBlank((CharSequence)billName)) {
            RepairTaskBuilder.buildTaskBySpTb(parentTask, bal, null, billName, "fbillid");
        } else {
            List<UpdateRule> rules = UpdateRuleCache.getUpdateRuleByBal(balName);
            Set billNames = rules.stream().map(UpdateRule::getEntityNumber).collect(Collectors.toSet());
            for (String bill : billNames) {
                RepairTaskBuilder.buildTaskBySpTb(parentTask, bal, null, bill, "fbillid");
            }
        }
    }

    private static void addCheckSpDataSumBal(DynamicObject parentTask) {
        RepairTaskBuilder.buildTasksByBal(parentTask);
    }

    private static void addClearSpData(DynamicObject parentTask) {
        String balName = parentTask.getString("bal.id");
        BalanceTB bal = BalanceTB.getBalanceTB(balName);
        RepairTaskBuilder.buildTaskBySpTb(parentTask, bal, null, null, "fid");
    }

    private static void addCheckRuleDisable(DynamicObject parentTask) {
        List<UpdateRule> rules = RepairTaskBuilder.parseRuleFromParentTask(parentTask);
        for (UpdateRule rule : rules) {
            if (rule.isEnable()) continue;
            RepairTaskBuilder.buildTaskBySpTb(parentTask, rule.getBalanceTB(), rule.getId(), rule.getEntityNumber(), "fbillid");
        }
    }

    private static void buildTaskByEntity(String entityName, DynamicObject parentTask, UpdateRule rule) {
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)entityName);
        String[] tbs = RepairTaskBuilder.getXdbs(type.getAlias(), DBRoute.of((String)type.getDBRouteKey()));
        ArrayList<SparseSeqParam> params = new ArrayList<SparseSeqParam>(tbs.length);
        for (String table : tbs) {
            params.add(new SparseSeqParam(entityName, table));
        }
        String ruleId = null;
        String billName = null;
        if (rule != null) {
            ruleId = rule.getId();
            billName = rule.getEntityNumber();
        }
        RepairTaskBuilder.buildTaskBySeqParam(parentTask, params, ruleId, billName);
    }

    private static void buildTaskBySeqParam(DynamicObject parentTask, List<SparseSeqParam> params, String ruleId, String billName) {
        try {
            ArrayList<Future<String>> results = new ArrayList<Future<String>>(params.size());
            for (SparseSeqParam sparseSeqParam : params) {
                results.add(BalPoolUtil.submitByOtherExecutor(new RepairTask(parentTask, sparseSeqParam, ruleId, billName)));
            }
            ArrayList<String> msgs = new ArrayList<String>(params.size());
            for (Future future : results) {
                String msg = (String)future.get();
                if (msg == null) continue;
                msgs.add(msg);
            }
            if (msgs.size() > 0) {
                String string = ResManager.loadKDString((String)"\u4efb\u52a1\u5206\u89e3\u5f02\u5e38\uff0c\u67e5\u770bTraceId\uff1a{0}\u3002", (String)"RepairTaskBuilder_0", (String)"bos-biz-balance", (Object[])new Object[]{msgs});
                throw new RuntimeException(string);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static String[] getXdbs(final String tb, DBRoute route) {
        try {
            if (DB.isSharded((String)tb)) {
                return (String[])DB.__setupExtContextForUsingXdbTableManager((DBRoute)route, (boolean)true, (Callable)new Callable<String[]>(){

                    @Override
                    public String[] call() throws Exception {
                        return XDBConfig.getTableManager().getShardingTable(tb);
                    }
                });
            }
            return new String[]{tb};
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static void buildTasksByBill(DynamicObject parentTask, UpdateRule rule) {
        RepairTaskBuilder.buildTaskByEntity(rule.getEntityNumber(), parentTask, rule);
    }

    private static void buildTasksByBal(DynamicObject parentTask) {
        String balName = parentTask.getString("bal.id");
        RepairTaskBuilder.buildTaskByEntity(balName, parentTask, null);
    }

    private static void buildTaskBySpTb(DynamicObject parentTask, BalanceTB bal, String ruleId, String billName, String sparseCol) {
        DBRoute dbRoute = bal.getDbRoute();
        String entityTb = bal.getSnapshotTb();
        String[] tbs = RepairTaskBuilder.getXdbs(entityTb, dbRoute);
        ArrayList<SparseSeqParam> params = new ArrayList<SparseSeqParam>(tbs.length);
        for (String table : tbs) {
            params.add(new SparseSeqParam(dbRoute, entityTb, table, sparseCol));
        }
        RepairTaskBuilder.buildTaskBySeqParam(parentTask, params, ruleId, billName);
    }

    private static List<UpdateRule> parseRuleFromParentTask(DynamicObject parentTask) {
        String balName = parentTask.getString("bal.id");
        String billName = parentTask.getString("bill.id");
        String ruleId = parentTask.getString("updaterule.id");
        if (StringUtils.isNotBlank((CharSequence)ruleId)) {
            ArrayList<UpdateRule> rules = new ArrayList<UpdateRule>(1);
            rules.add(UpdateRuleCache.getUpdateRuleFromCache(ruleId));
            return rules;
        }
        if (StringUtils.isNotBlank((CharSequence)billName)) {
            return UpdateRuleCache.getUpdateRule(balName, billName);
        }
        return UpdateRuleCache.getUpdateRuleByBal(balName);
    }
}

