/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.core;

import java.util.Collection;
import kd.bos.bal.business.core.RepairBillIsDel;
import kd.bos.bal.business.core.RepairBillSpData;
import kd.bos.bal.business.core.RepairKeyCol;
import kd.bos.bal.business.core.RepairRuleDisable;
import kd.bos.bal.business.core.RepairSpdataSumBal;
import kd.bos.bal.common.TaskMsg;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;

class RepairTaskConsumer {
    RepairTaskConsumer() {
    }

    public static void handleRepairTaskMsg(DynamicObject taskInfo, TaskMsg msg) {
        String taskType;
        String opresult = taskInfo.getString("parenttask.opresult");
        if ("D".equals(opresult)) {
            taskInfo.set("status", (Object)"E");
            String showMsg = ResManager.loadKDString((String)"\u7236\u4efb\u52a1\u5df2\u624b\u5de5\u7ec8\u6b62\uff0c\u4e0d\u80fd\u518d\u6267\u884c\u64cd\u4f5c\u3002", (String)"BalCheckTaskConsumer_0", (String)"bos-biz-balance", (Object[])new Object[0]);
            taskInfo.set("errormsg_tag", (Object)showMsg);
            return;
        }
        switch (taskType = taskInfo.getString("parenttask.tasktype")) {
            case "A": {
                RepairTaskConsumer.checkBalKeyCol(taskInfo, msg);
                break;
            }
            case "B": {
                RepairTaskConsumer.checkBillSpData(taskInfo, msg);
                break;
            }
            case "D": {
                RepairTaskConsumer.checkBillIsDel(taskInfo, msg);
                break;
            }
            case "J": {
                RepairTaskConsumer.checkRuleDisable(taskInfo, msg);
                break;
            }
            case "C": {
                RepairTaskConsumer.checkSpDataSumBal(taskInfo, msg);
                break;
            }
            case "E": {
                RepairTaskConsumer.clearSpData(taskInfo);
                break;
            }
            case "F": {
                RepairTaskConsumer.repairBalKeyCol(taskInfo, msg);
                break;
            }
            case "G": {
                RepairTaskConsumer.repairBillSpData(taskInfo, msg);
                break;
            }
            case "I": {
                RepairTaskConsumer.repairBillIsDel(taskInfo, msg);
                break;
            }
            case "H": {
                RepairTaskConsumer.repairSpDataSumBal(taskInfo, msg);
                break;
            }
        }
    }

    private static void checkRuleDisable(DynamicObject taskInfo, TaskMsg msg) {
        RepairRuleDisable checker = new RepairRuleDisable(taskInfo);
        checker.setTaskMode(msg.getMode());
        checker.check();
        RepairTaskConsumer.updateTaskInfo(msg, taskInfo, checker.getResult());
    }

    private static void repairSpDataSumBal(DynamicObject taskInfo, TaskMsg msg) {
        RepairSpdataSumBal checker = new RepairSpdataSumBal(taskInfo);
        checker.setTaskMode(msg.getMode());
        checker.repair();
        taskInfo.set("status", (Object)"F");
    }

    private static void repairBillIsDel(DynamicObject taskInfo, TaskMsg msg) {
        RepairBillIsDel checker = new RepairBillIsDel(taskInfo);
        checker.setTaskMode(msg.getMode());
        checker.repair();
        taskInfo.set("status", (Object)"F");
    }

    private static void repairBillSpData(DynamicObject taskInfo, TaskMsg msg) {
        RepairBillSpData checker = new RepairBillSpData(taskInfo);
        checker.setTaskMode(msg.getMode());
        checker.repair();
        taskInfo.set("status", (Object)"F");
    }

    private static void repairBalKeyCol(DynamicObject taskInfo, TaskMsg msg) {
        RepairKeyCol checker = new RepairKeyCol(taskInfo);
        checker.setTaskMode(msg.getMode());
        checker.repair();
        taskInfo.set("status", (Object)"F");
    }

    private static void clearSpData(DynamicObject taskInfo) {
        long fromId = taskInfo.getLong("fromid");
        long toId = taskInfo.getLong("toid");
        long lastSuccessId = taskInfo.getLong("lastsuccessid");
        fromId = fromId > lastSuccessId ? fromId : lastSuccessId;
        String paramStr = String.format("fromId=%s,toId=%s", fromId, toId);
        taskInfo.set("param_tag", (Object)paramStr);
        if (toId > fromId) {
            DBRoute db = DBRoute.of((String)taskInfo.getString("sparseseq.dbkey"));
            String entitytb = taskInfo.getString("sparseseq.actualtb");
            SqlBuilder sql = new SqlBuilder();
            sql.append("DELETE FROM", new Object[0]).append(entitytb, new Object[0]).append("WHERE", new Object[0]);
            sql.append("fid>=?", new Object[]{fromId});
            sql.append("AND", new Object[0]).append("fid<?", new Object[]{toId});
            sql.append("AND", new Object[0]).append("fstatus=?", new Object[]{"B"});
            try (TXHandle tx = TX.requiresNew((String)"clearSpData");){
                DB.execute((DBRoute)db, (SqlBuilder)sql);
            }
            taskInfo.set("lastsuccessid", (Object)toId);
        }
        taskInfo.set("status", (Object)"F");
    }

    private static void checkSpDataSumBal(DynamicObject taskInfo, TaskMsg msg) {
        RepairSpdataSumBal checker = new RepairSpdataSumBal(taskInfo);
        checker.setTaskMode(msg.getMode());
        checker.check();
        RepairTaskConsumer.updateTaskInfo(msg, taskInfo, checker.getResult());
    }

    private static void checkBillIsDel(DynamicObject taskInfo, TaskMsg msg) {
        RepairBillIsDel checker = new RepairBillIsDel(taskInfo);
        checker.setTaskMode(msg.getMode());
        checker.check();
        RepairTaskConsumer.updateTaskInfo(msg, taskInfo, checker.getResult());
    }

    private static void checkBillSpData(DynamicObject taskInfo, TaskMsg msg) {
        RepairBillSpData checker = new RepairBillSpData(taskInfo);
        checker.setTaskMode(msg.getMode());
        checker.check();
        RepairTaskConsumer.updateTaskInfo(msg, taskInfo, checker.getResult());
    }

    private static void checkBalKeyCol(DynamicObject taskInfo, TaskMsg msg) {
        RepairKeyCol checker = new RepairKeyCol(taskInfo);
        checker.setTaskMode(msg.getMode());
        checker.check();
        RepairTaskConsumer.updateTaskInfo(msg, taskInfo, checker.getResult());
    }

    private static void updateTaskInfo(TaskMsg msg, DynamicObject taskInfo, Collection<Object> result) {
        String status = taskInfo.getString("status");
        status = !result.isEmpty() ? (RepairTaskConsumer.isRepairError(msg, status) ? status : "C") : (RepairTaskConsumer.isRepairError(msg, status) ? status : "D");
        taskInfo.set("status", (Object)status);
    }

    private static boolean isRepairError(TaskMsg msg, String status) {
        return "C".equals(msg.getMode()) && "E".equals(status);
    }
}

