/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.core;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.Collector;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import kd.bos.bal.business.core.BalEngineUtil;
import kd.bos.bal.business.core.BalKeyHandle;
import kd.bos.bal.business.core.BalManager;
import kd.bos.bal.business.core.HandleNullMapFunc;
import kd.bos.bal.common.QFUtil;
import kd.bos.biz.balance.model.BalReUpdateParam;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.biz.balance.model.UpdateRule;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.balance.BizDataType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.StringUtils;

class RepairTaskHandle {
    private static final String SP_ = "sp_";

    RepairTaskHandle() {
    }

    public static List<Object> checkBalKeyCol(BalanceTB bal, Collection<?> balIds) {
        ArrayList<Object> resultId = new ArrayList<Object>(balIds.size());
        List<String> keyCols = bal.getKeyCols();
        StringBuilder cols = new StringBuilder();
        cols.append("id");
        cols.append(',').append("keycol");
        cols.append(',').append(StringUtils.join(keyCols, (String)","));
        QFilter fs = new QFilter("id", "in", balIds);
        try (DataSet balData = QueryServiceHelper.queryDataSet((String)"checkBalKeyCol", (String)bal.getName(), (String)cols.toString(), (QFilter[])fs.toArray(), null);){
            for (Row row : balData) {
                if (BalKeyHandle.calKeyStr(row, keyCols).equals(row.getString("keycol"))) continue;
                resultId.add(row.getLong("id"));
            }
        }
        return resultId;
    }

    public static List<String> checkSpDataSumBal(BalanceTB bal, List<?> balIds) {
        if (bal.isRealBal()) {
            return RepairTaskHandle.checkSpDataSumRealBal(bal, balIds);
        }
        if (bal.isPerBal()) {
            return RepairTaskHandle.checkSpDataSumPerBal(bal, balIds);
        }
        return null;
    }

    public static void repairBalKeyCol(BalanceTB bal, Collection<?> balIds) {
        if (balIds == null || balIds.isEmpty()) {
            return;
        }
        if (bal.isPerBal()) {
            RepairTaskHandle.repairPerBalKeyCol(bal, balIds);
        } else if (bal.isRealBal()) {
            RepairTaskHandle.repairRealBalKeyCol(bal, balIds);
        }
    }

    public static void repairSpDataSumBal(BalanceTB bal, Collection<? extends Object> balIds) {
        List<String> keycols = RepairTaskHandle.getKeycols(bal, balIds);
        RepairTaskHandle.repairSpDataSumBalByKey(bal, keycols);
    }

    public static void repairSpDataSumBalByKey(BalanceTB bal, List<String> keycols) {
        if (bal.isRealBal()) {
            RepairTaskHandle.repairRealBalRecord(bal, keycols);
        } else if (bal.isPerBal()) {
            RepairTaskHandle.repairPerBalRecord(bal, keycols);
        }
    }

    public static void repair4rollBack(UpdateRule rule, Collection<?> billId) {
        BalReUpdateParam param = new BalReUpdateParam(new HashSet<Object>(billId), null, true);
        param.addReUpdateRules(rule);
        BalManager.doReUpdate(param);
    }

    public static void repair4rollBack(List<UpdateRule> rules, Collection<?> billId) {
        BalReUpdateParam param = new BalReUpdateParam(new HashSet<Object>(billId), null, true);
        param.addReUpdateRules(rules);
        BalManager.doReUpdate(param);
    }

    public static void repairBillCreateSpData(UpdateRule rule, Set<Object> billIds) {
        if (!rule.isEnable()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u89c4\u5219\u4e0d\u80fd\u662f\u7981\u7528\u7684\u3002", (String)"BalCheckRepairManager_0", (String)"bos-biz-balance", (Object[])new Object[0]));
        }
        BalReUpdateParam param = new BalReUpdateParam();
        param.setBillIds(billIds);
        param.addReUpdateRules(rule);
        param.setEnableUpdatedFs(true);
        BalManager.doReUpdate(param);
    }

    private static void repairPerBalRecord(BalanceTB bal, List<String> keycols) {
        HashMap<Long, String> duplicateData = new HashMap<Long, String>();
        try (DataSet balData = RepairTaskHandle.buildSpDataSumPerBalData(bal, keycols, duplicateData);){
            Set<String> checkCol = bal.getColsByDataType(BizDataType.ENDPER, BizDataType.INIT, BizDataType.IN, BizDataType.OUT, BizDataType.BAL, BizDataType.YEAR_IN, BizDataType.YEAR_OUT);
            Map<String, List<String>> updateQtySql = RepairTaskHandle.getUpdateQtySql(bal, checkCol);
            Map<String, List<Object[]>> sqlParams = RepairTaskHandle.initParamMap(updateQtySql.keySet(), keycols.size());
            String modifyTimeCol = bal.getModifyTimeCol();
            TreeSet<Long> ids = modifyTimeCol == null ? null : new TreeSet<Long>();
            ArrayList<DynamicObject> balRecords = new ArrayList<DynamicObject>(16);
            for (Row row : balData) {
                long id = row.getLong("id");
                if (id == 0L) {
                    id = RepairTaskHandle.getId();
                    balRecords.add(RepairTaskHandle.buildNewBal(bal, id, row));
                }
                for (Map.Entry entry : updateQtySql.entrySet()) {
                    Object[] param = BalEngineUtil.parseQtyParam(row, (List)entry.getValue(), checkCol);
                    if (param == null) continue;
                    param[param.length - 1] = id;
                    sqlParams.get(entry.getKey()).add(param);
                    if (ids == null) continue;
                    ids.add(id);
                }
            }
            if (ids != null && ids.size() > 0) {
                StringBuilder updateMt = new StringBuilder();
                updateMt.append(" UPDATE ").append(bal.getTb()).append(" SET ").append(bal.getColFieldMap().get(modifyTimeCol));
                updateMt.append(" =? WHERE ").append("fid").append(" =? ");
                ArrayList<Object[]> mtParams = new ArrayList<Object[]>(ids.size());
                Date now = new Date();
                for (Long tempId : ids) {
                    mtParams.add(new Object[]{now, tempId});
                }
                sqlParams.put(updateMt.toString(), mtParams);
            }
            DBRoute db = bal.getDbRoute();
            TXHandle tx = TX.requiresNew((String)"reSumQty");
            Object object = null;
            try {
                try {
                    if (!duplicateData.isEmpty()) {
                        String throwable = "DELETE FROM " + bal.getTb() + " WHERE FID " + QFUtil.getIdsFilter(duplicateData.keySet());
                        DB.update((DBRoute)db, (String)throwable);
                    }
                    if (!balRecords.isEmpty()) {
                        SaveServiceHelper.save((DynamicObject[])balRecords.toArray(new DynamicObject[0]));
                    }
                    for (Map.Entry<String, List<Object[]>> entry : sqlParams.entrySet()) {
                        RepairTaskHandle.executeBatch(db, entry.getKey(), entry.getValue());
                    }
                }
                catch (Throwable throwable) {
                    tx.markRollback();
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (object != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void repairRealBalRecord(BalanceTB bal, List<String> keycols) {
        Set<String> qtyCols = bal.getColsByDataType(BizDataType.OCC);
        Map<String, String> colFieldMap = bal.getColFieldMap();
        try (DataSet balQtyData = null;){
            balQtyData = RepairTaskHandle.getBalQtyData(bal, keycols, qtyCols);
            RepairTaskHandle.checkTempSyncSpData(bal, keycols);
            ArrayList<String> balCols = new ArrayList<String>(qtyCols.size());
            ArrayList<String> spCols = new ArrayList<String>(qtyCols.size());
            balCols.add("keycol");
            spCols.add(RepairTaskHandle.buildAs("fkeycol", "keycol"));
            for (String qtyCol : qtyCols) {
                balCols.add(RepairTaskHandle.buildAs("-" + qtyCol, qtyCol));
                spCols.add(RepairTaskHandle.buildAs(BalanceTB.parse2SnapName(colFieldMap.get(qtyCol)), qtyCol));
            }
            DBRoute db = bal.getDbRoute();
            SqlBuilder sql = new SqlBuilder();
            sql.append("SELECT", new Object[0]).append(String.join((CharSequence)",", spCols), new Object[0]).append("FROM", new Object[0]);
            sql.append(bal.getSnapshotTb(), new Object[0]).append("WHERE", new Object[0]);
            sql.appendIn("fkeycol", keycols.toArray());
            sql.append("AND", new Object[0]).append("fstatus=?", new Object[]{"A"});
            DataSet spQtyData = DB.queryDataSet((String)"reSumQty", (DBRoute)db, (SqlBuilder)sql);
            RepairTaskHandle.checkBalExpire(balQtyData.copy(), RepairTaskHandle.getBalQtyData(bal, keycols, qtyCols));
            balQtyData = balQtyData.select(balCols.toArray(new String[0])).union(spQtyData);
            GroupbyDataSet groupData = balQtyData.groupBy(new String[]{"keycol"});
            for (String qty : qtyCols) {
                groupData = groupData.sum(qty);
            }
            balQtyData = groupData.finish();
            Map<String, List<String>> updateQtySql = bal.getUpdateQtySql();
            Map<String, List<Object[]>> sqlParams = RepairTaskHandle.initParamMap(updateQtySql.keySet(), keycols.size());
            Object[] param = null;
            String modifyTimeCol = bal.getModifyTimeCol();
            TreeSet<String> keys = modifyTimeCol == null ? null : new TreeSet<String>();
            for (Row row : balQtyData) {
                for (Map.Entry<String, List<String>> entry : updateQtySql.entrySet()) {
                    param = BalEngineUtil.parseQtyParam(row, entry.getValue(), qtyCols);
                    if (param == null) continue;
                    sqlParams.get(entry.getKey()).add(param);
                    if (keys == null) continue;
                    keys.add(row.getString("keycol"));
                }
            }
            if (keys != null && keys.size() > 0) {
                StringBuilder updateMt = new StringBuilder();
                updateMt.append(" UPDATE ").append(bal.getTb()).append(" SET ").append(bal.getColFieldMap().get(modifyTimeCol));
                updateMt.append(" =? WHERE ").append("fkeycol").append(" =? ");
                ArrayList<Object[]> mtParams = new ArrayList<Object[]>(keys.size());
                Date now = new Date();
                for (String key : keys) {
                    mtParams.add(new Object[]{now, key});
                }
                sqlParams.put(updateMt.toString(), mtParams);
            }
            try (TXHandle tx = TX.requiresNew((String)"reSumQty");){
                try {
                    for (Map.Entry<String, List<Object[]>> entry : sqlParams.entrySet()) {
                        RepairTaskHandle.executeBatch(db, entry.getKey(), entry.getValue());
                    }
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }

    private static Map<String, List<Object[]>> initParamMap(Set<String> sqls, int paramSize) {
        HashMap<String, List<Object[]>> sqlAndParams = new HashMap<String, List<Object[]>>(sqls.size());
        for (String sql : sqls) {
            sqlAndParams.put(sql, new ArrayList(paramSize));
        }
        return sqlAndParams;
    }

    private static void executeBatch(DBRoute db, String sql, List<Object[]> param) {
        if (param == null) {
            DB.execute((DBRoute)db, (String)sql);
        } else if (!param.isEmpty()) {
            DB.executeBatch((DBRoute)db, (String)sql, param);
        }
    }

    private static long getId() {
        return DB.genGlobalLongId();
    }

    private static DynamicObject buildNewBal(BalanceTB bal, long id, Row row) {
        Set<String> cols = bal.getColsByDataType(BizDataType.MAIN, BizDataType.DIM, BizDataType.AUX, BizDataType.COVER, BizDataType.RDD);
        String keycol = row.getString("keycol");
        QFilter fs = new QFilter("keycol", "=", (Object)keycol);
        DynamicObject record = BusinessDataServiceHelper.newDynamicObject((String)bal.getName());
        DynamicObject info = QueryServiceHelper.queryOne((String)bal.getName(), (String)String.join((CharSequence)",", cols), (QFilter[])fs.toArray());
        for (String col : cols) {
            record.set(col, info.get(col));
        }
        record.set("id", (Object)id);
        String periodCol = bal.getPeriodCol();
        record.set(periodCol, (Object)row.getInteger(periodCol));
        record.set("keycol", (Object)keycol);
        String modifyTimeCol = bal.getModifyTimeCol();
        if (modifyTimeCol != null) {
            record.set(modifyTimeCol, (Object)new Date());
        }
        return record;
    }

    private static void groupCols(BalanceTB bal, Map<String, List<String>> colsGroup, Collection<String> cols) {
        Map<String, String> colTbMap = bal.getColTbMap();
        for (String qtyCol : cols) {
            String tempTb = colTbMap.get(qtyCol);
            List tempCols = colsGroup.computeIfAbsent(tempTb, k -> new ArrayList(16));
            tempCols.add(qtyCol);
        }
    }

    private static Map<String, List<String>> getUpdateQtySql(BalanceTB bal, Set<String> checkCols) {
        HashMap<String, List<String>> colGroup = new HashMap<String, List<String>>(4);
        HashMap<String, List<String>> sqls = new HashMap<String, List<String>>(2);
        RepairTaskHandle.groupCols(bal, colGroup, checkCols);
        String suffix = null;
        List cols = null;
        StringBuilder sql = null;
        Map<String, String> colFieldMap = bal.getColFieldMap();
        for (Map.Entry entry : colGroup.entrySet()) {
            suffix = (String)entry.getKey();
            cols = (List)entry.getValue();
            sql = new StringBuilder(" UPDATE ");
            sql.append(bal.getTb()).append(suffix).append(" SET ");
            String ftempcol = null;
            int i = 0;
            for (String col : cols) {
                ftempcol = colFieldMap.get(col);
                if (i++ != 0) {
                    sql.append(",");
                }
                sql.append(ftempcol).append("=").append(ftempcol).append("+? ");
            }
            sql.append(" WHERE ").append("fid").append("=").append("? ");
            cols.add("id");
            sqls.put(sql.toString(), cols);
        }
        return sqls;
    }

    private static void repairPerBalKeyCol(BalanceTB bal, Collection<?> balIds) {
        int size = balIds.size();
        List<String> keyCols = bal.getKeyCols();
        StringBuilder cols = new StringBuilder();
        cols.append("id");
        cols.append(',').append("keycol");
        cols.append(',').append(StringUtils.join(keyCols, (String)","));
        QFilter fs = new QFilter("id", "in", balIds);
        try (DataSet balanceData = QueryServiceHelper.queryDataSet((String)"repairPerBalKeyCol", (String)bal.getName(), (String)cols.toString(), (QFilter[])fs.toArray(), null);){
            String key = null;
            String oldKey = null;
            ArrayList<Object[]> balParam = new ArrayList<Object[]>(size);
            ArrayList<Object[]> spParam = new ArrayList<Object[]>(size);
            HashSet<String> paramSet = new HashSet<String>(size);
            for (Row row : balanceData) {
                key = BalKeyHandle.calKeyStr(row, keyCols);
                if (key.equals(oldKey = row.getString("keycol"))) continue;
                balParam.add(new Object[]{key, row.getLong("id")});
                if (!paramSet.add(key + oldKey)) continue;
                spParam.add(new Object[]{key, oldKey});
            }
            RepairTaskHandle.batchUpdateKeyCol(bal, balParam, spParam);
        }
    }

    private static void repairRealBalKeyCol(BalanceTB bal, Collection<?> balIds) {
        int size = balIds.size();
        List<String> keyCols = bal.getKeyCols();
        StringBuilder cols = new StringBuilder();
        cols.append("id");
        cols.append(',').append("keycol");
        cols.append(',').append(StringUtils.join(keyCols, (String)","));
        ArrayList<Object[]> msgs = new ArrayList<Object[]>();
        QFilter fs = new QFilter("id", "in", balIds);
        try (DataSet balanceData = QueryServiceHelper.queryDataSet((String)"repairRealBalKeyCol", (String)bal.getName(), (String)cols.toString(), (QFilter[])fs.toArray(), null);){
            String key = null;
            String oldKey = null;
            HashMap<String, Object> newKeyMap = new HashMap<String, Object>(size);
            HashMap<Object, String> oldKeyMap = new HashMap<Object, String>(size);
            Long id = null;
            Object exsistKeyId = null;
            for (Row row : balanceData) {
                key = BalKeyHandle.calKeyStr(row, keyCols);
                oldKey = row.getString("keycol");
                id = row.getLong("id");
                if (key.equals(oldKey)) continue;
                exsistKeyId = newKeyMap.get(key);
                if (exsistKeyId != null) {
                    msgs.add(new Object[]{id, key, oldKey, exsistKeyId});
                    continue;
                }
                newKeyMap.put(key, id);
                oldKeyMap.put(id, oldKey);
            }
            if (!newKeyMap.isEmpty()) {
                RepairTaskHandle.batchUpdateKeyCol(bal, msgs, newKeyMap, oldKeyMap);
            }
            if (!msgs.isEmpty()) {
                String msg = ResManager.loadKDString((String)"\u91cd\u590dKEYCOL\u4e2d\u51fa\u73b0\u51b2\u7a81,\u8bf7\u6839\u636e\u65e5\u5fd7\u5148\u5904\u7406\u597d\u51b2\u7a81\u7684KEYCOL", (String)"RepairTaskHandle_0", (String)"bos-biz-balance", (Object[])new Object[0]);
                throw new RuntimeException(msg);
            }
        }
    }

    private static void batchUpdateKeyCol(BalanceTB bal, List<Object[]> msgs, Map<String, Object> newKeyMap, Map<Object, String> oldKeyMap) {
        Set<String> exsistKey = RepairTaskHandle.checkExsistKeyCol(bal, msgs, newKeyMap, oldKeyMap);
        int len = newKeyMap.size() - exsistKey.size();
        ArrayList<Object[]> params = new ArrayList<Object[]>(len);
        ArrayList<Object[]> spParams = new ArrayList<Object[]>(len);
        String key = null;
        Object id = null;
        for (Map.Entry<String, Object> entry : newKeyMap.entrySet()) {
            key = entry.getKey();
            if (exsistKey.contains(key)) continue;
            id = entry.getValue();
            params.add(new Object[]{key, id});
            spParams.add(new Object[]{key, oldKeyMap.get(id)});
        }
        if (!msgs.isEmpty()) {
            String msg = RepairTaskHandle.buildMsg(msgs);
            throw new RuntimeException(msg);
        }
        RepairTaskHandle.batchUpdateKeyCol(bal, params, spParams);
    }

    private static String buildMsg(List<Object[]> msgs) {
        StringBuilder msg = new StringBuilder();
        msg.append(ResManager.loadKDString((String)"\u51c6\u5907\u66f4\u65b0\u7684ID\uff0c\u65b0\u8ba1\u7b97\u7684KEYCOL\uff0c\u5386\u53f2\u7684KEYCOL\uff0c\u51b2\u7a81\u7684ID\u3002", (String)"BalCheckRepairManager_3", (String)"bos-biz-balance", (Object[])new Object[0]));
        for (Object[] info : msgs) {
            msg.append("\r\n");
            msg.append(StringUtils.join((Object[])info, (String)","));
        }
        return msg.toString();
    }

    private static Set<String> checkExsistKeyCol(BalanceTB bal, List<Object[]> msgs, Map<String, Object> newKeyMap, Map<Object, String> oldKeyMap) {
        HashSet<String> exsistKeys = new HashSet<String>(newKeyMap.size());
        QFilter fs = new QFilter("keycol", "in", newKeyMap.keySet());
        try (DataSet datas = QueryServiceHelper.queryDataSet((String)"getExsistKeyCol", (String)bal.getName(), (String)"keycol,id", (QFilter[])fs.toArray(), null);){
            String key = null;
            Object id = null;
            for (Row row : datas) {
                key = row.getString("keycol");
                exsistKeys.add(key);
                id = newKeyMap.get(key);
                if (msgs.size() >= 1000) continue;
                msgs.add(new Object[]{id, key, oldKeyMap.get(id), row.get("id")});
            }
        }
        return exsistKeys;
    }

    private static void batchUpdateKeyCol(BalanceTB bal, List<Object[]> params, List<Object[]> spParams) {
        if (!params.isEmpty()) {
            try (TXHandle tx = TX.requiresNew((String)"BAL_RECAL_KEYCOL");){
                try {
                    StringBuilder updateSql = new StringBuilder(" UPDATE ");
                    updateSql.append(bal.getTb());
                    updateSql.append(" SET ").append("fkeycol").append(" = ? WHERE ").append("fid").append(" = ? ");
                    DB.executeBatch((DBRoute)bal.getDbRoute(), (String)updateSql.toString(), params);
                    updateSql = new StringBuilder(" UPDATE ");
                    updateSql.append(bal.getSnapshotTb());
                    updateSql.append(" SET ").append("fkeycol").append(" = ? WHERE ").append("fkeycol").append(" = ? ");
                    DB.executeBatch((DBRoute)bal.getDbRoute(), (String)updateSql.toString(), spParams);
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }

    private static List<String> checkSpDataSumPerBal(BalanceTB bal, List<?> balIds) {
        HashSet<String> result = new HashSet<String>(balIds.size());
        List<String> keycols = RepairTaskHandle.getKeycols(bal, balIds);
        HashMap<Long, String> duplicateData = new HashMap<Long, String>();
        try (DataSet balData = RepairTaskHandle.buildSpDataSumPerBalData(bal, keycols, duplicateData);){
            String[] checkCol = bal.getColsByDataType(BizDataType.ENDPER, BizDataType.INIT, BizDataType.IN, BizDataType.OUT, BizDataType.BAL, BizDataType.YEAR_IN, BizDataType.YEAR_OUT).toArray(new String[0]);
            for (Row row : balData) {
                long id = row.getLong("id");
                if (id != 0L && RepairTaskHandle.isAllZero(row, checkCol)) continue;
                result.add(row.getString("keycol"));
            }
        }
        result.addAll(duplicateData.values());
        return new ArrayList<String>(result);
    }

    private static DataSet buildSpDataSumPerBalData(BalanceTB bal, List<String> keycols, Map<Long, String> duplicateData) {
        RowMeta rowMeta;
        Map<String, String> colFieldMap = bal.getColFieldMap();
        String periodCol = bal.getPeriodCol();
        String endPeriodCol = bal.getEndPeriodCol();
        DBRoute db = bal.getDbRoute();
        Set<String> spQtyCols = bal.getColsByDataType(BizDataType.INIT, BizDataType.IN, BizDataType.OUT);
        Set<String> appendQtyCols = bal.getColsByDataType(BizDataType.BAL, BizDataType.YEAR_IN, BizDataType.YEAR_OUT);
        ArrayList<String> balSelectCols = new ArrayList<String>(spQtyCols.size() + appendQtyCols.size() + 2);
        balSelectCols.addAll(spQtyCols);
        balSelectCols.addAll(appendQtyCols);
        balSelectCols.add(periodCol);
        balSelectCols.add(endPeriodCol);
        ArrayList<String> spSelectCols = new ArrayList<String>(spQtyCols.size() + 2);
        ArrayList<String> spQtyCols4Check = new ArrayList<String>(spQtyCols.size());
        for (String qtyCol : spQtyCols) {
            String asCol = RepairTaskHandle.buildAs(BalanceTB.parse2SnapName(colFieldMap.get(qtyCol)), qtyCol);
            spSelectCols.add(asCol);
            spQtyCols4Check.add(asCol);
        }
        spSelectCols.add(RepairTaskHandle.buildAs("fkeycol", "keycol"));
        spSelectCols.add(RepairTaskHandle.buildAs(colFieldMap.get(periodCol), periodCol));
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT", new Object[0]).append(String.join((CharSequence)",", spSelectCols), new Object[0]).append("FROM", new Object[0]);
        sql.append(bal.getSnapshotTb(), new Object[0]).append("WHERE", new Object[0]);
        sql.appendIn("fkeycol", keycols.toArray());
        sql.append("AND", new Object[0]).append("fstatus=?", new Object[]{"A"});
        HashMap<Long, Object[]> rowDataCollect = new HashMap<Long, Object[]>(100);
        DataSet tempBalData = RepairTaskHandle.getBalQtyData(bal, keycols, balSelectCols);
        Object object = null;
        try {
            rowMeta = tempBalData.getRowMeta();
            RepairTaskHandle.collectRowData(tempBalData, rowDataCollect, duplicateData, periodCol);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (tempBalData != null) {
                if (object != null) {
                    try {
                        tempBalData.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    tempBalData.close();
                }
            }
        }
        RepairTaskHandle.checkTempSyncSpData(bal, keycols);
        ArrayList balList = new ArrayList(rowDataCollect.size());
        for (Map.Entry entry : rowDataCollect.entrySet()) {
            if (duplicateData.containsKey(entry.getKey())) continue;
            balList.add(entry.getValue());
        }
        DataSet balData = Algo.create((String)"buildSpDataSumPerBalData").createDataSet(balList, rowMeta);
        DataSet dataSet2 = DB.queryDataSet((String)"reSumQty", (DBRoute)db, (SqlBuilder)sql);
        dataSet2 = dataSet2.map((MapFunction)new HandleNullMapFunc(dataSet2.getRowMeta(), spQtyCols4Check));
        RepairTaskHandle.checkBalExpire(rowDataCollect, RepairTaskHandle.getBalQtyData(bal, keycols, balSelectCols));
        int size = (spQtyCols.size() + appendQtyCols.size()) * 2 + 5;
        ArrayList<String> balCols = new ArrayList<String>(size);
        ArrayList<String> spCols = new ArrayList<String>(size);
        ArrayList<String> dValCols = new ArrayList<String>(size);
        balCols.add("keycol");
        balCols.add(periodCol);
        spCols.add("keycol");
        spCols.add(periodCol);
        dValCols.add("keycol");
        dValCols.add(periodCol);
        balCols.add("id");
        spCols.add(RepairTaskHandle.asBalCol("0L", "id"));
        dValCols.add("id");
        balCols.add(endPeriodCol);
        balCols.add(RepairTaskHandle.asSpCol("0", endPeriodCol));
        spCols.add(RepairTaskHandle.asBalCol("0", endPeriodCol));
        spCols.add(RepairTaskHandle.asSpCol("0", endPeriodCol));
        dValCols.add(RepairTaskHandle.getDValCol(endPeriodCol));
        for (String qtyCol : spQtyCols) {
            balCols.add(qtyCol);
            balCols.add(RepairTaskHandle.asSpCol("0.0", qtyCol));
            spCols.add(RepairTaskHandle.asBalCol("0.0", qtyCol));
            spCols.add(RepairTaskHandle.asSpCol(qtyCol, qtyCol));
            dValCols.add(RepairTaskHandle.getDValCol(qtyCol));
        }
        for (String qtyCol : appendQtyCols) {
            balCols.add(qtyCol);
            balCols.add(RepairTaskHandle.asSpCol("0.0", qtyCol));
            spCols.add(RepairTaskHandle.asBalCol("0.0", qtyCol));
            spCols.add(RepairTaskHandle.asSpCol("0.0", qtyCol));
            dValCols.add(RepairTaskHandle.getDValCol(qtyCol));
        }
        DataSet dataSet3 = dataSet2.select(spCols.toArray(new String[0]));
        balData = balData.select(balCols.toArray(new String[0]));
        balData = balData.union(dataSet3);
        String[] allCols = balData.getRowMeta().getFieldNames();
        GroupbyDataSet groupData = balData.groupBy(new String[]{"keycol", periodCol});
        for (String col : allCols) {
            if (col.equals("keycol") || col.equals(periodCol)) continue;
            groupData = groupData.sum(col);
        }
        balData = groupData.finish();
        balData = balData.orderBy(new String[]{periodCol + " ASC"});
        balData = balData.groupBy(new String[]{"keycol"}).reduceGroup((ReduceGroupFunctionWithCollector)new CalPerData(balData.getRowMeta(), bal));
        balData = balData.select(dValCols.toArray(new String[0]));
        return balData;
    }

    private static void collectRowData(DataSet balData, Map<Long, Object[]> rowDataCollect, Map<Long, String> idKeycol, String periodCol) {
        RowMeta rowMeta = balData.getRowMeta();
        int idIdx = rowMeta.getFieldIndex("id");
        int keyIdx = rowMeta.getFieldIndex("keycol");
        int periodIdx = rowMeta.getFieldIndex(periodCol);
        HashSet<String> keycolPeriodStr = new HashSet<String>(100);
        for (Row row : balData) {
            Long id = row.getLong(idIdx);
            rowDataCollect.put(id, RowUtil.toArray((Row)row));
            String keyCol = row.getString(keyIdx);
            String str = keyCol + row.getInteger(periodIdx);
            if (keycolPeriodStr.add(str)) continue;
            idKeycol.put(id, keyCol);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> checkSpDataSumRealBal(BalanceTB bal, List<?> balIds) {
        List<String> keycols = RepairTaskHandle.getKeycols(bal, balIds);
        Set<String> qtyCols = bal.getColsByDataType(BizDataType.OCC);
        Map<String, String> colFieldMap = bal.getColFieldMap();
        try (DataSet balQtyData = null;){
            balQtyData = RepairTaskHandle.getBalQtyData(bal, keycols, qtyCols);
            RepairTaskHandle.checkTempSyncSpData(bal, keycols);
            ArrayList<String> balCols = new ArrayList<String>(qtyCols.size());
            ArrayList<String> spCols = new ArrayList<String>(qtyCols.size());
            balCols.add("keycol");
            spCols.add(RepairTaskHandle.buildAs("fkeycol", "keycol"));
            ArrayList<String> spQtyCols4Check = new ArrayList<String>(qtyCols.size());
            for (String qtyCol : qtyCols) {
                balCols.add(RepairTaskHandle.buildAs("-" + qtyCol, qtyCol));
                String asCol = RepairTaskHandle.buildAs(BalanceTB.parse2SnapName(colFieldMap.get(qtyCol)), qtyCol);
                spCols.add(asCol);
                spQtyCols4Check.add(asCol);
            }
            DBRoute db = bal.getDbRoute();
            SqlBuilder sql = new SqlBuilder();
            sql.append("SELECT", new Object[0]).append(String.join((CharSequence)",", spCols), new Object[0]).append("FROM", new Object[0]);
            sql.append(bal.getSnapshotTb(), new Object[0]).append("WHERE", new Object[0]);
            sql.appendIn("fkeycol", keycols.toArray());
            sql.append("AND", new Object[0]).append("fstatus=?", new Object[]{"A"});
            DataSet spQtyData = DB.queryDataSet((String)"reSumQty", (DBRoute)db, (SqlBuilder)sql);
            spQtyData = spQtyData.map((MapFunction)new HandleNullMapFunc(spQtyData.getRowMeta(), spQtyCols4Check));
            RepairTaskHandle.checkBalExpire(balQtyData.copy(), RepairTaskHandle.getBalQtyData(bal, keycols, qtyCols));
            balQtyData = balQtyData.select(balCols.toArray(new String[0])).union(spQtyData);
            GroupbyDataSet groupData = balQtyData.groupBy(new String[]{"keycol"});
            for (String qty : qtyCols) {
                groupData = groupData.sum(qty);
            }
            balQtyData = groupData.finish();
            String[] checkZeros = qtyCols.toArray(new String[0]);
            ArrayList<String> result = new ArrayList<String>(8);
            for (Row row : balQtyData) {
                if (RepairTaskHandle.isAllZero(row, checkZeros)) continue;
                result.add(row.getString("keycol"));
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
    }

    private static List<String> getKeycols(BalanceTB bal, Collection<? extends Object> balIds) {
        ArrayList<String> keycols = new ArrayList<String>(balIds.size());
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT", new Object[0]).append("fkeycol", new Object[0]).append("FROM", new Object[0]).append(bal.getTb(), new Object[0]).append("WHERE", new Object[0]).appendIn("fid", balIds.toArray());
        try (DataSet data = DB.queryDataSet((String)"getKeycols", (DBRoute)bal.getDbRoute(), (SqlBuilder)sql);){
            for (Row row : data) {
                keycols.add(row.getString("fkeycol"));
            }
        }
        return keycols;
    }

    private static void checkTempSyncSpData(BalanceTB bal, List<String> keycols) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("SELECT TOP 1 ", new Object[0]).append("fkeycol", new Object[0]).append("FROM", new Object[0]).append(bal.getTmpSnapshotTb(), new Object[0]);
        sql.append("WHERE", new Object[0]).appendIn("fkeycol", keycols.toArray());
        sql.append("AND", new Object[0]).append("fsync=?", new Object[]{"1"});
        try (DataSet data = DB.queryDataSet((String)"checkAndFilter", (DBRoute)bal.getDbRoute(), (SqlBuilder)sql);){
            if (data.hasNext()) {
                String key = data.next().getString(0);
                throw new KDBizException(ResManager.loadKDString((String)"\u4f59\u989d\u6570\u636e\u6b63\u5728\u66f4\u65b0\u4e2d\uff0c\u65e0\u6cd5\u52a8\u6001\u5408\u8ba1\u6b63\u786e\uff0c\u8bf7\u95f4\u9694\u51e0\u5206\u949f\u540e\u518d\u91cd\u8bd5\uff0ckeycol={0}\u3002", (String)"BalCheckRepairManager_2", (String)"bos-biz-balance", (Object[])new Object[]{key}));
            }
        }
    }

    private static String buildAs(String col, String asCol) {
        return col + " " + asCol;
    }

    private static void checkBalExpire(DataSet balQtyData, DataSet balQtyDataNew) {
        HashMap<Long, Object[]> rowData = new HashMap<Long, Object[]>(100);
        for (Row row : balQtyData) {
            rowData.put(row.getLong("id"), RowUtil.toArray((Row)row));
        }
        RepairTaskHandle.checkBalExpire(rowData, balQtyDataNew);
    }

    private static void checkBalExpire(Map<Long, Object[]> rowData, DataSet balQtyDataNew) {
        boolean expire = false;
        for (Row row : balQtyDataNew) {
            Long id = row.getLong("id");
            Object[] val = rowData.remove(id);
            if (val != null && RepairTaskHandle.valEques(val, RowUtil.toArray((Row)row))) continue;
            expire = true;
            break;
        }
        if (expire || !rowData.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f59\u989d\u6570\u636e\u6070\u597d\u6b63\u5728\u66f4\u65b0\u4e2d\uff0c\u8bf7\u8fc7\u51e0\u5206\u949f\u540e\u518d\u91cd\u8bd5\u3002", (String)"BalCheckRepairManager_1", (String)"bos-biz-balance", (Object[])new Object[0]));
        }
    }

    private static boolean isAllZero(Row row, String[] cols) {
        for (String col : cols) {
            if (row.getBigDecimal(col).compareTo(BigDecimal.ZERO) == 0) continue;
            return false;
        }
        return true;
    }

    private static boolean valEques(Object[] val, Object[] newVal) {
        for (int i = 0; i < val.length; ++i) {
            if ((val[i] == null || val[i].equals(newVal[i])) && (newVal[i] == null || val[i].equals(val[i]))) continue;
            return false;
        }
        return true;
    }

    private static DataSet getBalQtyData(BalanceTB bal, List<String> keycols, Collection<String> balSelectCols) {
        String selectCols = String.join((CharSequence)",", balSelectCols) + "," + "id" + "," + "keycol";
        QFilter fs = new QFilter("keycol", "in", keycols);
        DataSet data = QueryServiceHelper.queryDataSet((String)"reSumQty", (String)bal.getName(), (String)selectCols, (QFilter[])fs.toArray(), null);
        data = data.map((MapFunction)new HandleNullMapFunc(data.getRowMeta(), RepairTaskHandle.filterQtyCols(bal, balSelectCols)));
        return data;
    }

    private static List<String> filterQtyCols(BalanceTB bal, Collection<String> balSelectCols) {
        Set<String> cols = bal.getColsByDataType(BizDataType.OCC, BizDataType.INIT, BizDataType.IN, BizDataType.OUT, BizDataType.BAL, BizDataType.YEAR_IN, BizDataType.YEAR_OUT);
        return balSelectCols.stream().filter(col -> cols.contains(col)).collect(Collectors.toList());
    }

    private static String asSpCol(String col) {
        return SP_ + col;
    }

    private static String asSpCol(String defVal, String col) {
        return defVal + " " + SP_ + col;
    }

    private static String asBalCol(String defVal, String col) {
        return defVal + " " + col;
    }

    private static String getDValCol(String col) {
        return SP_ + col + "-" + col + " " + col;
    }

    private static class CalPerData
    extends ReduceGroupFunctionWithCollector {
        private static final long serialVersionUID = 2735272525180497811L;
        private RowMeta rowMeta;
        private int[] idxQty;
        private int[] idxQtyIn;
        private int[] idxQtyOut;
        private int[] idxQtyBal;
        private int[] idxQtyYearIn;
        private int[] idxQtyIn4Year;
        private int[] idxQtyYearOut;
        private int[] idxQtyOut4Year;
        private int idxPeriod;
        private int idxEndPeriod;

        public CalPerData(RowMeta rowMeta, BalanceTB bal) {
            this.rowMeta = rowMeta;
            this.buildIdx(bal);
        }

        private void buildIdx(BalanceTB bal) {
            Set<String> yearOutCols;
            String periodCol = bal.getPeriodCol();
            String endPeriodCol = bal.getEndPeriodCol();
            this.idxPeriod = this.rowMeta.getFieldIndex(periodCol);
            this.idxEndPeriod = this.rowMeta.getFieldIndex(RepairTaskHandle.asSpCol(endPeriodCol));
            String[] qtys = bal.getColsByDataType(BizDataType.INIT).toArray(new String[0]);
            int len = qtys.length;
            this.idxQty = new int[len];
            this.idxQtyIn = new int[len];
            this.idxQtyOut = new int[len];
            this.idxQtyBal = new int[len];
            for (int i = 0; i < len; ++i) {
                this.idxQty[i] = this.rowMeta.getFieldIndex(RepairTaskHandle.asSpCol(qtys[i]));
                this.idxQtyIn[i] = this.rowMeta.getFieldIndex(RepairTaskHandle.asSpCol(qtys[i] + "_in"));
                this.idxQtyOut[i] = this.rowMeta.getFieldIndex(RepairTaskHandle.asSpCol(qtys[i] + "_out"));
                this.idxQtyBal[i] = this.rowMeta.getFieldIndex(RepairTaskHandle.asSpCol(qtys[i] + "_bal"));
                if (this.idxQtyYearIn != null) {
                    this.idxQtyYearIn[i] = this.rowMeta.getFieldIndex(RepairTaskHandle.asSpCol(qtys[i] + "_yearin"));
                }
                if (this.idxQtyYearOut == null) continue;
                this.idxQtyYearOut[i] = this.rowMeta.getFieldIndex(RepairTaskHandle.asSpCol(qtys[i] + "_yearout"));
            }
            Set<String> yearInCols = bal.getColsByDataType(BizDataType.YEAR_IN);
            int colsSize = yearInCols.size();
            if (colsSize > 0) {
                this.idxQtyYearIn = new int[colsSize];
                this.idxQtyIn4Year = new int[colsSize];
                int i = 0;
                for (String yearInCol : yearInCols) {
                    int idx = this.findIdx(qtys, yearInCol, "_yearin");
                    if (idx == -1) {
                        this.idxQtyYearIn[i] = -1;
                        continue;
                    }
                    this.idxQtyYearIn[i] = this.rowMeta.getFieldIndex(RepairTaskHandle.asSpCol(yearInCol));
                    this.idxQtyIn4Year[i] = this.idxQtyIn[idx];
                }
            }
            if ((colsSize = (yearOutCols = bal.getColsByDataType(BizDataType.YEAR_OUT)).size()) > 0) {
                this.idxQtyYearOut = new int[colsSize];
                this.idxQtyOut4Year = new int[colsSize];
                int i = 0;
                for (String yearOutCol : yearOutCols) {
                    int idx = this.findIdx(qtys, yearOutCol, "_yearout");
                    if (idx == -1) {
                        this.idxQtyYearOut[i] = -1;
                        continue;
                    }
                    this.idxQtyYearOut[i] = this.rowMeta.getFieldIndex(RepairTaskHandle.asSpCol(yearOutCol));
                    this.idxQtyOut4Year[i] = this.idxQtyOut[idx];
                }
            }
        }

        private int findIdx(String[] qtys, String yearCol, String suffixYear) {
            int len = qtys.length;
            for (int i = 0; i < len; ++i) {
                if (!yearCol.equals(qtys[i] + suffixYear)) continue;
                return i;
            }
            return -1;
        }

        public RowMeta getResultRowMeta() {
            return this.rowMeta;
        }

        private void setBalQty(Object[] data) {
            int len = this.idxQty.length;
            for (int i = 0; i < len; ++i) {
                BigDecimal qty = (BigDecimal)DataType.convertValue((DataType)DataType.BigDecimalType, (Object)data[this.idxQty[i]]);
                BigDecimal qtyIn = (BigDecimal)DataType.convertValue((DataType)DataType.BigDecimalType, (Object)data[this.idxQtyIn[i]]);
                BigDecimal qtyOut = (BigDecimal)DataType.convertValue((DataType)DataType.BigDecimalType, (Object)data[this.idxQtyOut[i]]);
                data[this.idxQtyBal[i]] = qty.add(qtyIn).subtract(qtyOut);
            }
        }

        private void setInitQty(List<Object[]> datas, int row) {
            Object[] currentRow = datas.get(row);
            Object[] preRow = datas.get(row - 1);
            int len = this.idxQty.length;
            for (int i = 0; i < len; ++i) {
                currentRow[this.idxQty[i]] = ((BigDecimal)DataType.convertValue((DataType)DataType.BigDecimalType, (Object)currentRow[this.idxQty[i]])).add((BigDecimal)DataType.convertValue((DataType)DataType.BigDecimalType, (Object)preRow[this.idxQtyBal[i]]));
            }
        }

        public void reduce(Iterator<Row> it, Collector ct) {
            ArrayList<Object[]> datas = new ArrayList<Object[]>(60);
            HashMap<Integer, BigDecimal[]> yearInDatas = this.idxQtyYearIn == null ? null : new HashMap<Integer, BigDecimal[]>(8);
            HashMap<Integer, BigDecimal[]> yearOutDatas = this.idxQtyYearOut == null ? null : new HashMap<Integer, BigDecimal[]>(8);
            int i = 0;
            while (it.hasNext()) {
                Object[] data = RowUtil.toArray((Row)it.next());
                datas.add(data);
                if (i != 0) {
                    this.setInitQty(datas, i);
                }
                this.setBalQty(data);
                this.sumYearData(yearInDatas, yearOutDatas, data);
                ++i;
            }
            this.setEndPeriod(datas);
            for (Object[] rowData : datas) {
                this.setYearData(yearInDatas, yearOutDatas, rowData);
                ct.collect(rowData);
            }
        }

        private void setEndPeriod(List<Object[]> datas) {
            int len = datas.size();
            for (int i = 0; i < len; ++i) {
                Object[] data = datas.get(i);
                data[this.idxEndPeriod] = i == len - 1 ? Integer.valueOf(999999) : datas.get(i + 1)[this.idxPeriod];
            }
        }

        private Integer parseYearInfo(Object val) {
            return (Integer)DataType.convertValue((DataType)DataType.IntegerType, (Object)val) / 100 * 100;
        }

        private void setYearData(Map<Integer, BigDecimal[]> yearInDatas, Map<Integer, BigDecimal[]> yearOutDatas, Object[] rowData) {
            int i;
            int len;
            Integer year = null;
            if (this.idxQtyYearIn != null) {
                year = this.parseYearInfo(rowData[this.idxPeriod]);
                BigDecimal[] yearInData = yearInDatas.get(year);
                len = this.idxQtyYearIn.length;
                for (i = 0; i < len; ++i) {
                    rowData[this.idxQtyYearIn[i]] = yearInData[i];
                }
            }
            if (this.idxQtyYearOut != null) {
                year = year == null ? this.parseYearInfo(rowData[this.idxPeriod]) : year;
                BigDecimal[] yearOutData = yearOutDatas.get(year);
                len = this.idxQtyYearOut.length;
                for (i = 0; i < len; ++i) {
                    rowData[this.idxQtyYearOut[i]] = yearOutData[i];
                }
            }
        }

        private BigDecimal[] initYearQty(int len) {
            BigDecimal[] zeroData = new BigDecimal[len];
            for (int i = 0; i < len; ++i) {
                zeroData[i] = BigDecimal.ZERO;
            }
            return zeroData;
        }

        private void sumYearData(Map<Integer, BigDecimal[]> yearInDatas, Map<Integer, BigDecimal[]> yearOutDatas, Object[] rowData) {
            int i;
            int len;
            Integer year = null;
            if (this.idxQtyYearIn != null) {
                year = this.parseYearInfo(rowData[this.idxPeriod]);
                BigDecimal[] yearInData = yearInDatas.computeIfAbsent(year, key -> this.initYearQty(this.idxQtyYearIn.length));
                len = this.idxQtyYearIn.length;
                for (i = 0; i < len; ++i) {
                    if (this.idxQtyYearIn[i] < 0) continue;
                    yearInData[i] = yearInData[i].add((BigDecimal)DataType.convertValue((DataType)DataType.BigDecimalType, (Object)rowData[this.idxQtyIn4Year[i]]));
                }
            }
            if (this.idxQtyYearOut != null) {
                year = year == null ? this.parseYearInfo(rowData[this.idxPeriod]) : year;
                BigDecimal[] yearOutData = yearOutDatas.computeIfAbsent(year, key -> this.initYearQty(this.idxQtyYearOut.length));
                len = this.idxQtyYearOut.length;
                for (i = 0; i < len; ++i) {
                    if (this.idxQtyYearOut[i] < 0) continue;
                    yearOutData[i] = yearOutData[i].add((BigDecimal)DataType.convertValue((DataType)DataType.BigDecimalType, (Object)rowData[this.idxQtyOut4Year[i]]));
                }
            }
        }
    }
}

