/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.core;

import java.math.BigDecimal;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.bal.business.core.HandleNullMapFunc;
import kd.bos.biz.balance.engine.policy.ICalPeriodPolicy;
import kd.bos.biz.balance.model.UpdateRule;

class SpDataMapFunc
extends HandleNullMapFunc {
    private static final long serialVersionUID = 1407122739795099711L;
    private int[] qtyIdxs;
    private int perColIdx;
    private ICalPeriodPolicy cal;

    SpDataMapFunc(RowMeta rowMeta, UpdateRule rule) {
        super(rowMeta, rule.getOccCol4Update());
        if (rule.getUpdateType() == -1) {
            this.qtyIdxs = this.checkQtyIdxs;
        }
        if (rule.getBalanceTB().isPerBal()) {
            this.cal = rule.getPerCalPolicy();
            this.perColIdx = rowMeta.getFieldIndex(rule.getBalanceTB().getPeriodCol());
        }
    }

    @Override
    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    @Override
    public Object[] map(Row row) {
        Object[] result = super.map(row);
        if (this.qtyIdxs != null) {
            for (int idx : this.qtyIdxs) {
                result[idx] = ((BigDecimal)DataType.convertValue((DataType)DataType.BigDecimalType, (Object)result[idx])).negate();
            }
        }
        if (this.cal != null) {
            result[this.perColIdx] = this.cal.calPeriodVal(row);
        }
        return result;
    }
}

