/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.business.core;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Collector;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowUtil;
import kd.bos.biz.balance.engine.UpdateRuleCache;
import kd.bos.biz.balance.model.BalanceTB;
import kd.bos.biz.balance.model.UpdateRule;

class SpDataReduceGroup
extends ReduceGroupFunctionWithCollector {
    private static final long serialVersionUID = -7064899392842427077L;
    private RowMeta rowMeta;
    private String[] coverCols;
    private int[] coverColsIdx;
    private int[] coverColsFlagIdx;
    private String[] qtyCols;
    private int[] qtyColsIdx;
    private int ruleIdx;
    private int moveTypeIdx;
    private int coverFlagIdx;
    private int updateTimeIdx;
    private int idIdx;
    private Map<String, Long> txCache;
    private Map<String, Set<String>> ruleCache;

    public SpDataReduceGroup(RowMeta rowMeta, Set<String> coverCols, Set<String> qtyCols, String balName) {
        this.rowMeta = rowMeta;
        this.qtyCols = qtyCols.toArray(new String[0]);
        this.coverCols = coverCols.toArray(new String[0]);
        this.qtyColsIdx = new int[this.qtyCols.length];
        this.coverColsIdx = new int[this.coverCols.length];
        this.coverColsFlagIdx = new int[this.coverCols.length];
        this.initIdx();
        this.txCache = new HashMap<String, Long>(coverCols.size());
        this.ruleCache = this.buildRuleCache(balName);
    }

    private void initIdx() {
        int i;
        int len = this.qtyCols.length;
        for (i = 0; i < len; ++i) {
            this.qtyColsIdx[i] = this.rowMeta.getFieldIndex(this.qtyCols[i]);
        }
        len = this.coverCols.length;
        for (i = 0; i < len; ++i) {
            this.coverColsIdx[i] = this.rowMeta.getFieldIndex(this.coverCols[i]);
            this.coverColsFlagIdx[i] = this.rowMeta.getFieldIndex(BalanceTB.parseCoverFlag(this.coverCols[i]));
        }
        this.ruleIdx = this.rowMeta.getFieldIndex("updaterule");
        this.moveTypeIdx = this.rowMeta.getFieldIndex("movetype");
        this.coverFlagIdx = this.rowMeta.getFieldIndex("coverflag");
        this.updateTimeIdx = this.rowMeta.getFieldIndex("updatetime");
        this.idIdx = this.rowMeta.getFieldIndex("id");
    }

    private Map<String, Set<String>> buildRuleCache(String balName) {
        List<UpdateRule> rules = UpdateRuleCache.getUpdateRuleByBal(balName);
        HashMap<String, Set<String>> caches = new HashMap<String, Set<String>>(32);
        for (UpdateRule rule : rules) {
            caches.put(rule.getId(), rule.getCoverCol4Update());
        }
        return caches;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public void reduce(Iterator<Row> rows, Collector ct) {
        StringBuilder idMove = new StringBuilder();
        StringBuilder idDel = new StringBuilder();
        Object[] result = null;
        BigDecimal[] qtyColResult = new BigDecimal[this.qtyCols.length];
        while (rows.hasNext()) {
            Row data = rows.next();
            if (result == null) {
                result = RowUtil.toArray((Row)data);
                this.initResultRow(data, qtyColResult, result);
            } else {
                this.merge(data, qtyColResult, result);
            }
            if ("1".equals(data.getString(this.moveTypeIdx))) {
                if (idMove.length() != 0) {
                    idMove.append(',');
                }
                idMove.append(data.getLong(this.idIdx));
                continue;
            }
            if (idDel.length() != 0) {
                idDel.append(',');
            }
            idDel.append(data.getLong(this.idIdx));
        }
        if (result != null) {
            for (int i = 0; i < qtyColResult.length; ++i) {
                result[this.qtyColsIdx[i]] = qtyColResult[i];
            }
            result[this.rowMeta.getFieldIndex((String)"ids_move")] = idMove.toString();
            result[this.rowMeta.getFieldIndex((String)"ids_del")] = idDel.toString();
            ct.collect(result);
        }
    }

    private boolean checkCover(Row row) {
        return "1".equals(row.getString(this.moveTypeIdx)) && "1".equals(row.getString(this.coverFlagIdx));
    }

    private void initResultRow(Row row, BigDecimal[] qtyColResult, Object[] result) {
        Set<String> updateCols;
        int i;
        long txId = row.getLong(this.updateTimeIdx);
        for (i = 0; i < qtyColResult.length; ++i) {
            BigDecimal qty = row.getBigDecimal(this.qtyColsIdx[i]);
            qtyColResult[i] = qty == null ? BigDecimal.ZERO : qty;
        }
        for (i = 0; i < this.coverCols.length; ++i) {
            this.txCache.put(this.coverCols[i], txId);
        }
        if (this.checkCover(row) && (updateCols = this.ruleCache.get(row.getString(this.ruleIdx))) != null) {
            for (int i2 = 0; i2 < this.coverCols.length; ++i2) {
                if (!updateCols.contains(this.coverCols[i2])) continue;
                result[this.coverColsFlagIdx[i2]] = "1";
            }
        }
    }

    private void merge(Row next, BigDecimal[] qtyColResult, Object[] result) {
        for (int i = 0; i < qtyColResult.length; ++i) {
            BigDecimal qty = next.getBigDecimal(this.qtyColsIdx[i]);
            if (qty == null) continue;
            qtyColResult[i] = qtyColResult[i].add(qty);
        }
        if (this.checkCover(next)) {
            long txId = next.getLong(this.updateTimeIdx);
            Set<String> updateCols = this.ruleCache.get(next.getString(this.ruleIdx));
            if (updateCols != null) {
                for (int i = 0; i < this.coverCols.length; ++i) {
                    if (!updateCols.contains(this.coverCols[i]) || txId <= this.txCache.get(this.coverCols[i])) continue;
                    result[this.coverColsIdx[i]] = next.get(this.coverCols[i]);
                    result[this.coverColsFlagIdx[i]] = "1";
                }
            }
        }
    }
}

