/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.formplugin;

import java.util.EventObject;
import java.util.List;
import kd.bos.bal.common.FormUtil;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.biz.balance.engine.UpdateRuleCache;
import kd.bos.biz.balance.model.UpdateRule;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.servicehelper.MetadataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class BalCheckRepairSettingEdit
extends AbstractBasePlugIn {
    private static final String F_BAL_ID = "bal.number";
    private static final String EF_HAS_FILTER = "hasfilter";
    private static final String F_BAL = "bal";
    private static final String E_RULE_ENTRY = "ruleentry";
    private static final String EF_BILL_FS = "billfs_tag";
    private static final String EF_BILL_FS_ST = "billfs_st";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{EF_BILL_FS_ST});
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control contrl = (Control)evt.getSource();
        switch (key = contrl.getKey()) {
            case "billfs_st": {
                this.clickBillFsSt(evt);
                break;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        DynamicObject data = this.getModel().getDataEntity(true);
        DynamicObjectCollection entrys = data.getDynamicObjectCollection(E_RULE_ENTRY);
        String fsStr = null;
        CRCondition condition = null;
        for (DynamicObject entry : entrys) {
            fsStr = entry.getString(EF_BILL_FS);
            if (!StringUtils.isNotBlank((CharSequence)fsStr)) continue;
            condition = (CRCondition)SerializationUtils.fromJsonString((String)fsStr, CRCondition.class);
            entry.set(EF_BILL_FS_ST, (Object)condition.getExprDesc());
        }
        this.getModel().setDataChanged(false);
    }

    private void clickBillFsSt(EventObject evt) {
        IDataModel model = this.getModel();
        int row = model.getEntryCurrentRowIndex(E_RULE_ENTRY);
        DynamicObject rule = (DynamicObject)model.getValue("rule", row);
        String billName = rule.getString("sourceentitynumber.number");
        MainEntityType srcType = MetadataServiceHelper.getDataEntityType((String)billName);
        String conditionJson = (String)model.getValue(EF_BILL_FS, row);
        TreeNode tree = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)srcType, null);
        String jsonTree = SerializationUtils.toJsonString((Object)tree);
        this.showConditionForm(conditionJson, srcType.getName(), jsonTree, EF_BILL_FS_ST);
    }

    private void showConditionForm(String conditionJson, String entityNumber, String fieldNodes, String fieldKey) {
        FormShowParameter showParameter = FormUtil.buildConditionForm(conditionJson, entityNumber, fieldNodes);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, fieldKey));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        switch (actionId = e.getActionId()) {
            case "billfs_st": {
                this.billFsStCallBack(e);
                break;
            }
        }
    }

    private void billFsStCallBack(ClosedCallBackEvent e) {
        String conditionJson = (String)e.getReturnData();
        if (StringUtils.isNotBlank((CharSequence)conditionJson)) {
            CRCondition condition = (CRCondition)SerializationUtils.fromJsonString((String)conditionJson, CRCondition.class);
            String expression = condition.getExpression();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{expression})) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9ad8\u7ea7\u8fc7\u6ee4\u6761\u4ef6\u6682\u4e0d\u652f\u6301\uff0c\u8bf7\u5173\u6ce8\u540e\u7eed\u7248\u672c\u3002", (String)"BalCheckRepairSettingEdit_0", (String)"bos-biz-balance", (Object[])new Object[0]));
                return;
            }
            IDataModel model = this.getModel();
            int row = model.getEntryCurrentRowIndex(E_RULE_ENTRY);
            model.setValue(EF_BILL_FS_ST, (Object)condition.getExprDesc(), row);
            model.setValue(EF_BILL_FS, (Object)conditionJson, row);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "bal": {
                this.balchanged();
                break;
            }
            case "hasfilter": {
                this.hasFilteChanged(e);
                break;
            }
            case "billfs_st": {
                this.billFsStChanged(e);
                break;
            }
        }
    }

    private void billFsStChanged(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        IDataModel model = this.getModel();
        String fsSt = (String)model.getValue(EF_BILL_FS_ST);
        if (StringUtils.isBlank((CharSequence)fsSt)) {
            model.setValue(EF_BILL_FS, null, rowIndex);
        }
    }

    private void hasFilteChanged(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        IDataModel model = this.getModel();
        String hasFilter = (String)model.getValue(EF_HAS_FILTER, rowIndex);
        if (!"A".equals(hasFilter)) {
            model.setValue(EF_BILL_FS, null, rowIndex);
            model.setValue(EF_BILL_FS_ST, null, rowIndex);
        }
    }

    private void balchanged() {
        List<UpdateRule> rules;
        int size;
        this.getModel().deleteEntryData(E_RULE_ENTRY);
        IDataModel model = this.getModel();
        String balName = model.getDataEntity().getString(F_BAL_ID);
        if (balName != null && (size = (rules = UpdateRuleCache.getUpdateRuleByBal(balName)).size()) > 0) {
            int[] rows = model.batchCreateNewEntryRow(E_RULE_ENTRY, rules.size());
            for (int i = 0; i < size; ++i) {
                model.setValue("rule", (Object)rules.get(i).getId(), rows[i]);
            }
        }
    }
}

