/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.formplugin;

import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bal.business.core.BalConfig;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.events.ItemClickEvent;

public class BalConfigEdit
extends AbstractBasePlugIn {
    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "reset": {
                this.clickReSet();
                break;
            }
            case "showparam": {
                this.clickShowParam();
            }
        }
    }

    private void clickShowParam() {
        this.getView().setVisible(Boolean.TRUE, new String[]{"paramdetailap"});
        String bal = this.getModel().getDataEntity().getString("bal.id");
        CodeEdit sqlEditor = (CodeEdit)this.getControl("paramdetail");
        sqlEditor.setText(BalConfig.loadBalConfig(bal).showParams().toString(new SerializerFeature[]{SerializerFeature.PrettyFormat}));
    }

    private void clickReSet() {
        this.initDefVal();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("oldapistatus".equals(name)) {
            this.changeOldApiStatus();
        }
    }

    public void afterBindData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"paramdetailap"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initDefVal();
        this.getModel().setDataChanged(false);
    }

    private void initDefVal() {
        IDataModel model = this.getModel();
        Map<String, Object> colVals = BalConfig.getDevConf();
        for (Map.Entry<String, Object> entry : colVals.entrySet()) {
            model.setValue(entry.getKey(), entry.getValue());
        }
    }

    public void beforeBindData(EventObject e) {
        DynamicObject data = this.getModel().getDataEntity();
        String flag = (String)AppCache.get((String)"bal").get("bal.oldapistatus", String.class);
        data.set("oldapistatus", (Object)"1".equals(flag));
        this.getModel().setDataChanged(false);
    }

    private void changeOldApiStatus() {
        boolean status = this.getModel().getDataEntity().getBoolean("oldapistatus");
        IAppCache cache = AppCache.get((String)"bal");
        if (status) {
            cache.put("bal.oldapistatus", (Object)"1");
        } else {
            cache.remove("bal.oldapistatus");
        }
    }
}

