/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class BalanceLogEdit
extends AbstractBasePlugIn {
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.loadBillNos();
        this.getModel().setDataChanged(false);
    }

    private void loadBillNos() {
        DynamicObject data = this.getModel().getDataEntity();
        DynamicObject bill = data.getDynamicObject("billname");
        if (bill == null) {
            return;
        }
        String idStr = data.getString("billids_tag");
        if (StringUtils.isBlank((CharSequence)idStr)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)(idStr = idStr.replace("[", "").replace("]", "")))) {
            return;
        }
        String[] idStrs = idStr.split(",");
        ArrayList<Long> ids = new ArrayList<Long>(idStrs.length);
        for (String stringId : idStrs) {
            ids.add(Long.valueOf(stringId));
        }
        String billEntity = bill.getString("id");
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)billEntity);
        IDataEntityProperty billNo = type.findProperty("billno");
        if (billNo != null) {
            QFilter fs = new QFilter("id", "in", ids);
            StringBuilder nos = new StringBuilder();
            try (DataSet billNos = QueryServiceHelper.queryDataSet((String)"loadBillNos", (String)billEntity, (String)"billno", (QFilter[])fs.toArray(), null);){
                int i = 0;
                for (Row row : billNos) {
                    if (i++ != 0) {
                        nos.append(',');
                    }
                    nos.append(row.getString("billno"));
                }
            }
            this.getModel().setValue("billnos_tag", (Object)nos.toString());
        }
    }
}

