/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.formplugin.updaterule;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.bal.common.FormUtil;
import kd.bos.bal.formplugin.updaterule.RuleBindHandler;
import kd.bos.bal.formplugin.updaterule.RulePackager;
import kd.bos.bal.formplugin.updaterule.RuleUtil;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ISVInfo;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.balance.BizDataType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.IntegerProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.balance.BalanceUpdateRuleElement;
import kd.bos.metadata.balance.BalanceUpdateRuleMetadata;
import kd.bos.metadata.balance.BalanceUpdateRuleReader;
import kd.bos.metadata.balance.BalanceUpdateRuleTemplate;
import kd.bos.metadata.balance.BalanceUpdateRuleWriter;
import kd.bos.metadata.balance.policy.BalanceCondition;
import kd.bos.metadata.balance.policy.BalanceFormula;
import kd.bos.metadata.devportal.EnvTypeHelper;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class RuleEdit
extends AbstractFormPlugin
implements RowClickEventListener,
BeforeF7SelectListener,
IConfirmCallBack {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"datafilter", "billmaincolname", "bizdatefieldname", "yearfieldname", "monthfieldname", "periodfieldname", "dimbillcolname", "occbillcolname", "sortcolname", "logicsrcname", "occavbqty", "dimexpr"});
        this.addItemClickListeners(new String[]{"bar_main"});
        FormUtil.addF7Listener(this, "bal", "logiccol");
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String ruleId = (String)this.getView().getFormShowParameter().getCustomParam("ruleid");
        BalanceUpdateRuleMetadata ruleMetadata = null;
        if (StringUtils.isNotBlank((CharSequence)ruleId)) {
            BalanceUpdateRuleReader reader = new BalanceUpdateRuleReader();
            ruleMetadata = reader.loadMeta(ruleId, false);
            BalanceUpdateRuleElement element = ruleMetadata.getRuleElement();
            String entity = element.getBalanceTableNumber();
            try {
                MetadataServiceHelper.getDataEntityType((String)entity);
            }
            catch (Exception ex) {
                String msg = ResManager.loadKDString((String)"\u4f59\u989d\u8868{0}\u5b9e\u4f53\u4e0d\u5b58\u5728\u3002", (String)"RuleEdit_10", (String)"bos-biz-balance", (Object[])new Object[]{entity});
                this.getView().showTipNotification(msg);
                return;
            }
            entity = element.getSourceEntityNumber();
            try {
                MetadataServiceHelper.getDataEntityType((String)entity);
            }
            catch (Exception ex) {
                String msg = ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e{0}\u5b9e\u4f53\u4e0d\u5b58\u5728\u3002", (String)"RuleEdit_11", (String)"bos-biz-balance", (Object[])new Object[]{entity});
                this.getView().showTipNotification(msg);
                return;
            }
        }
        BalanceUpdateRuleTemplate template = new BalanceUpdateRuleTemplate();
        ruleMetadata = template.CreateBlankRule();
        ruleMetadata.setIsv(ISVService.getISVInfo().getId());
        RuleBindHandler.init(this.getView(), ruleMetadata);
        this.cacheRuleMetaData(ruleMetadata);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey;
        super.beforeItemClick(evt);
        if (EnvTypeHelper.isProductEnv() && "save".equals(itemKey = evt.getItemKey())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u4ea7\u73af\u5883\u4e0d\u80fd\u76f4\u63a5\u8c03\u6574\u914d\u7f6e\uff0c\u8bf7\u5728\u5f00\u53d1\u73af\u5883\u4fee\u6539\u9a8c\u8bc1\u540e\uff0c\u53d1\u5e03\u5230\u751f\u4ea7\u73af\u5883\u3002", (String)"RuleEdit_9", (String)"bos-biz-balance", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    private void cacheRuleMetaData(BalanceUpdateRuleMetadata ruleMetadata) {
        BalanceUpdateRuleTemplate template = new BalanceUpdateRuleTemplate();
        String json = template.serializeToJSONString(ruleMetadata, null);
        this.getPageCache().put("update_rule_cache", json);
    }

    private BalanceUpdateRuleMetadata getCachedRuleMetaData() {
        String json = this.getPageCache().get("update_rule_cache");
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        BalanceUpdateRuleTemplate template = new BalanceUpdateRuleTemplate();
        BalanceUpdateRuleMetadata ruleMetadata = (BalanceUpdateRuleMetadata)template.deserializeFromJSONString(json, null);
        return ruleMetadata;
    }

    private boolean isSameIsv() {
        ISVInfo info = ISVService.getISVInfo();
        if (info == null || info.getId() == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f3a\u5c11\u5f00\u53d1\u5546\u6807\u8bc6\uff0c\u8bf7\u627e\u7cfb\u7edf\u7ba1\u7406\u5458\u7ef4\u62a4\u3002", (String)"RuleEdit_0", (String)"bos-biz-balance", (Object[])new Object[0]));
            return false;
        }
        return info.getId().equals((String)this.getModel().getValue("isv"));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean notSameIsv = !this.isSameIsv();
        this.getView().setVisible(Boolean.valueOf(notSameIsv), new String[]{"lbisv"});
        if (notSameIsv) {
            IClientViewProxy clientViewProxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
            clientViewProxy.removeAction("setFormStatus");
            clientViewProxy.addAction("setFormStatus", (Object)BillOperationStatus.VIEW.getValue());
        }
        String ruleId = (String)this.getView().getFormShowParameter().getCustomParam("ruleid");
        this.getView().setEnable(Boolean.valueOf(StringUtils.isBlank((CharSequence)ruleId)), new String[]{"bal", "bill", "updatetype"});
    }

    public void click(EventObject evt) {
        String key;
        Control contrl = (Control)evt.getSource();
        switch (key = contrl.getKey()) {
            case "datafilter": {
                this.clickDataFilter(evt);
                break;
            }
            case "dimexpr": {
                this.clickDimExpr();
                break;
            }
            case "dimbillcolname": {
                this.clickDimBillCol();
                break;
            }
            case "occbillcolname": {
                this.clickOccBillCol();
                break;
            }
            case "occavbqty": {
                this.clickOccAvbQty();
                break;
            }
            case "sortcolname": {
                this.clickSortCol();
                break;
            }
            case "bizdatefieldname": {
                this.clickBizDate();
                break;
            }
            case "billmaincolname": {
                this.clickMainCol();
                break;
            }
            case "yearfieldname": {
                this.clickYear();
                break;
            }
            case "monthfieldname": {
                this.clickMonth();
                break;
            }
            case "periodfieldname": {
                this.clickPeriod();
                break;
            }
            case "logicsrcname": {
                this.clickLogicSrc();
                break;
            }
        }
    }

    private void clickDimExpr() {
        IDataModel model = this.getModel();
        int rowIndex = model.getEntryCurrentRowIndex("dimentry");
        String formula = (String)model.getValue("dimexprformula_tag", rowIndex);
        PropTreeBuildOption ops = new PropTreeBuildOption();
        ops.setIncludePKField(true);
        TreeNode billTree = new TreeNode();
        this.showFormulaForm(formula, SerializationUtils.toJsonString((Object)billTree), "dimexpr");
    }

    private void clickLogicSrc() {
        IDataModel model = this.getModel();
        MainEntityType billEntity = RuleUtil.getMainEntityType(model, "bill");
        PropTreeBuildOption ops = new PropTreeBuildOption();
        ops.setIncludePKField(false);
        TreeNode srcBillNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)billEntity, (PropTreeBuildOption)ops);
        this.showSelectFieldForm(srcBillNode, "logicsrc");
    }

    private void clickPeriod() {
        MainEntityType billEntity = RuleUtil.getMainEntityType(this.getModel(), "bill");
        PropTreeBuildOption ops = new PropTreeBuildOption();
        ops.addMatchedClassTypes(BasedataProp.class);
        TreeNode srcBillNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)billEntity, (PropTreeBuildOption)ops);
        this.showSelectFieldForm(srcBillNode, "periodfield");
    }

    private void clickMonth() {
        MainEntityType billEntity = this.getMainEntityType4YearMonth();
        PropTreeBuildOption ops = new PropTreeBuildOption();
        ops.addMatchedClassTypes(IntegerProp.class);
        TreeNode srcBillNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)billEntity, (PropTreeBuildOption)ops);
        this.showSelectFieldForm(srcBillNode, "monthfield");
    }

    private MainEntityType getMainEntityType4YearMonth() {
        DynamicObject data = this.getModel().getDataEntity();
        String policy = data.getString("periodpolicy");
        if ("2".equals(policy)) {
            return RuleUtil.getPeriodEntityType(this.getModel());
        }
        if ("0".equals(policy)) {
            return RuleUtil.getMainEntityType(this.getModel(), "bill");
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u671f\u95f4\u8ba1\u7b97\u7b56\u7565\u9700\u9009\u4e2d\u201c\u6309\u6e90\u5355\u671f\u95f4\u5e74\u6708\u5b57\u6bb5\u8ba1\u7b97\u201d\u6216\u201c\u6309\u6e90\u5355\u671f\u95f4\u5b57\u6bb5\u8ba1\u7b97\u201d\u3002", (String)"RuleEdit_1", (String)"bos-biz-balance", (Object[])new Object[0]));
    }

    private void clickYear() {
        MainEntityType billEntity = this.getMainEntityType4YearMonth();
        PropTreeBuildOption ops = new PropTreeBuildOption();
        ops.addMatchedClassTypes(IntegerProp.class);
        TreeNode srcBillNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)billEntity, (PropTreeBuildOption)ops);
        this.showSelectFieldForm(srcBillNode, "yearfield");
    }

    private void clickMainCol() {
        MainEntityType billEntity = RuleUtil.getMainEntityType(this.getModel(), "bill");
        PropTreeBuildOption ops = new PropTreeBuildOption();
        ops.addMatchedClassTypes(OrgProp.class);
        TreeNode srcBillNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)billEntity, (PropTreeBuildOption)ops);
        this.showSelectFieldForm(srcBillNode, "billmaincol");
    }

    private void clickBizDate() {
        MainEntityType billEntity = RuleUtil.getMainEntityType(this.getModel(), "bill");
        PropTreeBuildOption ops = new PropTreeBuildOption();
        ops.addMatchedClassTypes(DateTimeProp.class);
        TreeNode srcBillNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)billEntity, (PropTreeBuildOption)ops);
        this.showSelectFieldForm(srcBillNode, "bizdatefield");
    }

    private void clickOccAvbQty() {
        IDataModel model = this.getModel();
        int rowIndex = model.getEntryCurrentRowIndex("occentry");
        String updatePolicy = (String)model.getValue("updatepolicy");
        if ("0".equals(updatePolicy)) {
            return;
        }
        String colType = (String)model.getValue("occcoltype", rowIndex);
        if (BizDataType.COVER.getNumber().equals(colType)) {
            return;
        }
        String avbQtyColFormula = (String)model.getValue("occavbqtyformula", rowIndex);
        String balField = (String)this.getModel().getValue("occbalcol", rowIndex);
        MainEntityType balEntity = RuleUtil.getMainEntityType(this.getModel(), "bal");
        IDataEntityProperty balPro = balEntity.findProperty(balField);
        PropTreeBuildOption ops = new PropTreeBuildOption();
        ops.setIncludePKField(true);
        ops.setMatchedProperty(balPro);
        TreeNode billTree = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)balEntity, (PropTreeBuildOption)ops);
        this.showFormulaForm(avbQtyColFormula, SerializationUtils.toJsonString((Object)billTree), "occavbqty");
    }

    private void clickOccBillCol() {
        int rowIndex;
        IDataModel model = this.getModel();
        String valType = (String)model.getValue("occvaltype", rowIndex = model.getEntryCurrentRowIndex("occentry"));
        if (!"0".equals(valType)) {
            return;
        }
        MainEntityType billEntity = RuleUtil.getMainEntityType(model, "bill");
        MainEntityType balEntity = RuleUtil.getMainEntityType(model, "bal");
        String balField = (String)this.getModel().getValue("occbalcol", rowIndex);
        PropTreeBuildOption ops = this.getColMatchTreeOp(balEntity, balField);
        TreeNode srcBillNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)billEntity, (PropTreeBuildOption)ops);
        this.showSelectFieldForm(srcBillNode, "occbillcol");
    }

    private void clickDimBillCol() {
        int rowIndex;
        IDataModel model = this.getModel();
        String valType = (String)model.getValue("dimvaltype", rowIndex = model.getEntryCurrentRowIndex("dimentry"));
        if (!"0".equals(valType)) {
            return;
        }
        MainEntityType billEntity = RuleUtil.getMainEntityType(model, "bill");
        MainEntityType balEntity = RuleUtil.getMainEntityType(model, "bal");
        String balField = (String)this.getModel().getValue("dimbalcol", rowIndex);
        PropTreeBuildOption ops = this.getColMatchTreeOp(balEntity, balField);
        TreeNode srcBillNode = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)billEntity, (PropTreeBuildOption)ops);
        this.showSelectFieldForm(srcBillNode, "dimbillcol");
    }

    private void clickSortCol() {
        Set<String> col = this.getSortCols();
        if (col.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u6392\u5e8f\u5b57\u6bb5\u3002", (String)"RuleEdit_2", (String)"bos-biz-balance", (Object[])new Object[0]));
            return;
        }
        IDataModel model = this.getModel();
        PropTreeBuildOption ops = new PropTreeBuildOption();
        ops.setIncludePKField(true);
        ops.setOnlyPhysicsField(true);
        MainEntityType balEntity = RuleUtil.getMainEntityType(model, "bal");
        TreeNode balTree = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)balEntity, (PropTreeBuildOption)ops);
        List cls = balTree.getChildren();
        ArrayList<TreeNode> newCls = new ArrayList<TreeNode>(16);
        for (TreeNode cl : cls) {
            if (!"billhead".equals(cl.getId())) continue;
            List subCls = cl.getChildren();
            for (TreeNode subCl : subCls) {
                if (!col.contains(subCl.getId())) continue;
                newCls.add(subCl);
            }
        }
        balTree.setChildren(newCls);
        this.showSelectFieldForm(balTree, "sortcol");
    }

    private Set<String> getSortCols() {
        HashSet<String> cols = new HashSet<String>(8);
        DynamicObject data = this.getModel().getDataEntity(true);
        DynamicObjectCollection rows = data.getDynamicObjectCollection("dimentry");
        for (DynamicObject row : rows) {
            if (!"5".equals(row.getString("dimvaltype"))) continue;
            cols.add(row.getString("dimbalcol"));
        }
        rows = data.getDynamicObjectCollection("occentry");
        for (DynamicObject row : rows) {
            cols.add(row.getString("occbalcol"));
        }
        return cols;
    }

    private void clickDataFilter(EventObject evt) {
        DynamicObject data = this.getModel().getDataEntity();
        MainEntityType srcType = RuleUtil.getMainEntityType(this.getModel(), "bill");
        String conditionJson = data.getString("datafilterformula_tag");
        TreeNode tree = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)srcType, null);
        String jsonTree = SerializationUtils.toJsonString((Object)tree);
        this.showConditionForm(conditionJson, srcType.getName(), jsonTree, "datafilter");
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        Object returnData = e.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId = e.getActionId()) {
            case "datafilter": {
                this.receiveDataFilter((String)returnData);
                break;
            }
            case "dimbillcol": {
                this.callBack4DimBillCol((String)returnData);
                break;
            }
            case "occbillcol": {
                this.callBack4OCCBillCol((String)returnData);
                break;
            }
            case "sortcol": {
                this.callBack4SortCol((String)returnData);
                break;
            }
            case "occavbqty": {
                this.callBack4OccAvbQty((String)returnData);
                break;
            }
            case "billmaincol": {
                this.callBack4MainCol((String)returnData);
            }
            case "periodfield": {
                this.callBack4Period((String)returnData);
                break;
            }
            case "bizdatefield": {
                this.callBack4BizDate((String)returnData);
                break;
            }
            case "monthfield": {
                this.callBack4Month((String)returnData);
                break;
            }
            case "yearfield": {
                this.callBack4Year((String)returnData);
                break;
            }
            case "logicsrc": {
                this.callBack4LogicSrcCol((String)returnData);
                break;
            }
            case "dimexpr": {
                this.callBack4DimExpr((String)returnData);
                break;
            }
        }
    }

    private void callBack4DimExpr(String formulaJson) {
        if (StringUtils.isBlank((CharSequence)formulaJson)) {
            return;
        }
        BalanceFormula formula = (BalanceFormula)SerializationUtils.fromJsonString((String)formulaJson, BalanceFormula.class);
        if (StringUtils.isBlank((CharSequence)formula.getExpression())) {
            return;
        }
        int row = this.getModel().getEntryCurrentRowIndex("dimentry");
        String exprDesc = formula.getExprDesc();
        this.getModel().setValue("dimexpr", (Object)exprDesc, row);
        this.getModel().setValue("dimexprformula_tag", (Object)formulaJson, row);
    }

    private void callBack4LogicSrcCol(String field) {
        if (StringUtils.isBlank((CharSequence)field)) {
            return;
        }
        IDataModel model = this.getModel();
        MainEntityType billEntity = RuleUtil.getMainEntityType(model, "bill");
        int row = model.getEntryCurrentRowIndex("logicentry");
        model.setValue("logicsrc", (Object)field, row);
        model.setValue("logicsrcname", (Object)RuleUtil.getColFullName(billEntity, field), row);
    }

    private void callBack4Period(String returnData) {
        this.setFieldValue(returnData, "periodfield");
    }

    private void callBack4Year(String returnData) {
        DynamicObject data = this.getModel().getDataEntity();
        String policy = data.getString("periodpolicy");
        if ("2".equals(policy)) {
            this.setFieldValue(returnData, "yearfield", RuleUtil.getPeriodEntityType(this.getModel()));
        } else {
            this.setFieldValue(returnData, "yearfield");
        }
    }

    private void setFieldValue(String returnData, String key, MainEntityType entity) {
        if (StringUtils.isBlank((CharSequence)returnData)) {
            return;
        }
        IDataModel model = this.getModel();
        model.setValue(key, (Object)returnData);
        model.setValue(key + "name", (Object)RuleUtil.getColFullName(entity, returnData));
    }

    private void setFieldValue(String returnData, String key) {
        if (StringUtils.isBlank((CharSequence)returnData)) {
            return;
        }
        this.setFieldValue(returnData, key, RuleUtil.getMainEntityType(this.getModel(), "bill"));
    }

    private void callBack4Month(String returnData) {
        DynamicObject data = this.getModel().getDataEntity();
        String policy = data.getString("periodpolicy");
        if ("2".equals(policy)) {
            this.setFieldValue(returnData, "monthfield", RuleUtil.getPeriodEntityType(this.getModel()));
        } else {
            this.setFieldValue(returnData, "monthfield");
        }
    }

    private void callBack4BizDate(String returnData) {
        this.setFieldValue(returnData, "bizdatefield");
    }

    private void callBack4MainCol(String returnData) {
        this.setFieldValue(returnData, "billmaincol");
    }

    private void callBack4OccAvbQty(String formulaJson) {
        if (StringUtils.isBlank((CharSequence)formulaJson)) {
            return;
        }
        BalanceFormula formula = (BalanceFormula)SerializationUtils.fromJsonString((String)formulaJson, BalanceFormula.class);
        int row = this.getModel().getEntryCurrentRowIndex("occentry");
        String exprDesc = formula.getExprDesc();
        this.getModel().setValue("occavbqty", (Object)exprDesc, row);
        this.getModel().setValue("occavbqtyformula", (Object)formulaJson, row);
    }

    private void callBack4SortCol(String field) {
        if (StringUtils.isBlank((CharSequence)field)) {
            return;
        }
        if (this.alreadyExist(field)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5728\u6392\u5e8f\u5217\u8868\u4e2d\u3002", (String)"RuleEdit_3", (String)"bos-biz-balance", (Object[])new Object[0]));
            return;
        }
        IDataModel model = this.getModel();
        MainEntityType balEntity = RuleUtil.getMainEntityType(model, "bal");
        int row = model.getEntryCurrentRowIndex("sortentry");
        model.setValue("sortcol", (Object)field, row);
        model.setValue("sortcolname", (Object)RuleUtil.getColFullName(balEntity, field), row);
    }

    private boolean alreadyExist(String field) {
        IDataModel model = this.getModel();
        int count = model.getEntryRowCount("sortentry");
        for (int i = 0; i < count; ++i) {
            String sortCol = (String)model.getValue("sortcol", i);
            if (!field.equals(sortCol)) continue;
            return true;
        }
        return false;
    }

    private void callBack4DimBillCol(String field) {
        if (StringUtils.isBlank((CharSequence)field)) {
            return;
        }
        IDataModel model = this.getModel();
        MainEntityType billEntity = RuleUtil.getMainEntityType(model, "bill");
        int row = model.getEntryCurrentRowIndex("dimentry");
        model.setValue("dimbillcol", (Object)field, row);
        model.setValue("dimbillcolname", (Object)RuleUtil.getColFullName(billEntity, field), row);
    }

    private void callBack4OCCBillCol(String field) {
        if (StringUtils.isBlank((CharSequence)field)) {
            return;
        }
        IDataModel model = this.getModel();
        MainEntityType billEntity = RuleUtil.getMainEntityType(model, "bill");
        int row = model.getEntryCurrentRowIndex("occentry");
        model.setValue("occbillcol", (Object)field, row);
        model.setValue("occbillcolname", (Object)RuleUtil.getColFullName(billEntity, field), row);
    }

    private void receiveDataFilter(String conditionJson) {
        if (StringUtils.isNotBlank((CharSequence)conditionJson)) {
            BalanceCondition condition = (BalanceCondition)SerializationUtils.fromJsonString((String)conditionJson, BalanceCondition.class);
            String expression = condition.getExpression();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{expression})) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9ad8\u7ea7\u8fc7\u6ee4\u6761\u4ef6\u6682\u4e0d\u652f\u6301\uff0c\u8bf7\u5173\u6ce8\u540e\u7eed\u7248\u672c\u3002", (String)"RuleEdit_4", (String)"bos-biz-balance", (Object[])new Object[0]));
                return;
            }
            this.getModel().setValue("datafilter", (Object)condition.getExprDesc());
            this.getModel().setValue("datafilterformula_tag", (Object)conditionJson);
        }
    }

    private void showFormulaForm(String formulaJson, String fieldNodes, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_formula");
        showParameter.getCustomParams().put("formula", formulaJson);
        showParameter.getCustomParams().put("treenodes", fieldNodes);
        String funcsXML = "";
        showParameter.getCustomParams().put("functiontypes", funcsXML);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private PropTreeBuildOption getColMatchTreeOp(MainEntityType balEntity, String balField) {
        IDataEntityProperty balPro = balEntity.findProperty(balField);
        if (balPro == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f59\u989d\u8868\u4e2d\u4e0d\u5b58\u5728\u5c5e\u6027{0},\u8bf7\u68c0\u67e5\u5143\u6570\u636e\u662f\u5426\u8bbe\u8ba1\u6b63\u786e\u3002", (String)"RuleEdit_5", (String)"bos-biz-balance", (Object[])new Object[]{balField}));
        }
        PropTreeBuildOption ops = new PropTreeBuildOption();
        ops.setIncludePKField(true);
        ops.setMatchedProperty(balPro);
        return ops;
    }

    private void showSelectFieldForm(TreeNode srcBillNode, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name;
        switch (name = evt.getProperty().getName()) {
            case "bal": {
                this.addBalanceTBFilter(evt);
                break;
            }
            case "logiccol": {
                this.selectLogicCol(evt);
                break;
            }
        }
    }

    private void selectLogicCol(BeforeF7SelectEvent evt) {
        ((ListShowParameter)evt.getFormShowParameter()).setMultiSelect(false);
    }

    private void addBalanceTBFilter(BeforeF7SelectEvent evt) {
        ListFilterParameter fs = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
        QFilter f = new QFilter("istemplate", "=", (Object)"0");
        fs.getQFilters().add(f);
    }

    private void showConditionForm(String conditionJson, String entityNumber, String fieldNodes, String fieldKey) {
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_condition");
        showParameter.setCustomParam("formula", (Object)conditionJson);
        showParameter.setCustomParam("entitynumber", (Object)entityNumber);
        showParameter.setCustomParam("treenodes", (Object)fieldNodes);
        String funcsXML = "";
        showParameter.setCustomParam("functiontypes", (Object)funcsXML);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, fieldKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        this.getModel().setDataChanged(true);
        IDataEntityProperty prop = e.getProperty();
        switch (prop.getName()) {
            case "bill": {
                this.srcBillChanged(e);
                break;
            }
            case "bal": {
                this.balEntityChanged(e);
                break;
            }
            case "dimvaltype": {
                this.dimValTypeChanged(e);
                break;
            }
            case "occvaltype": {
                this.occValTypeChanged(e);
                break;
            }
            case "dimexpr": {
                this.dimExprChanged(e);
                break;
            }
            case "occbillcolname": {
                this.occBillColChanged(e);
                break;
            }
            case "dimbillcolname": {
                this.dimBillColChanged(e);
                break;
            }
            case "logicsrcname": {
                this.logicBillColChanged(e);
                break;
            }
            case "occavbqty": {
                this.occAvbQtyChanged(e);
                break;
            }
            case "sortcolname": {
                this.sortColChanged(e);
                break;
            }
            case "periodqtytype": {
                this.periodQtyTypeChanged(e);
                break;
            }
            case "periodpolicy": {
                this.periodPolicyChanged(e);
                break;
            }
            case "periodfieldname": {
                this.periodColChanged(e);
                break;
            }
            case "bizdatefieldname": {
                this.bizDateColChanged(e);
                break;
            }
            case "yearfieldname": {
                this.yearColChanged(e);
                break;
            }
            case "monthfieldname": {
                this.monthColChanged(e);
                break;
            }
            case "billmaincolname": {
                this.billMainColChanged(e);
            }
        }
    }

    private void logicBillColChanged(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        this.setNull4EntryCol("logicsrc", rowIndex);
    }

    private void dimExprChanged(PropertyChangedArgs e) {
        int rowIndex;
        IDataModel model = this.getModel();
        String val = (String)model.getValue("dimexpr", rowIndex = e.getChangeSet()[0].getRowIndex());
        if (StringUtils.isBlank((CharSequence)val)) {
            model.setValue("dimexprformula_tag", null, rowIndex);
        }
    }

    private void billMainColChanged(PropertyChangedArgs e) {
        this.setNull4Col("billmaincol");
    }

    private void monthColChanged(PropertyChangedArgs e) {
        this.setNull4Col("monthfield");
    }

    private void yearColChanged(PropertyChangedArgs e) {
        this.setNull4Col("yearfield");
    }

    private void bizDateColChanged(PropertyChangedArgs e) {
        this.setNull4Col("bizdatefield");
    }

    private void periodColChanged(PropertyChangedArgs e) {
        this.setNull4Col("periodfield");
    }

    private void periodPolicyChanged(PropertyChangedArgs e) {
        this.clearSelectCols("periodfield", "yearfield", "monthfield", "bizdatefield");
    }

    private void clearSelectCols(String ... cols) {
        IDataModel model = this.getModel();
        for (String col : cols) {
            model.setValue(col, null);
            model.setValue(col + "name", null);
        }
    }

    private void periodQtyTypeChanged(PropertyChangedArgs e) {
        RuleBindHandler.periodQtyTypeChanged(this.getView());
    }

    private void setNull4EntryCol(String col, int rowIndex) {
        IDataModel model = this.getModel();
        String val = (String)model.getValue(col + "name", rowIndex);
        if (StringUtils.isBlank((CharSequence)val)) {
            model.setValue(col, null, rowIndex);
        }
    }

    private void setNull4Col(String col) {
        IDataModel model = this.getModel();
        String nameVal = (String)model.getValue(col + "name");
        if (StringUtils.isBlank((CharSequence)nameVal)) {
            model.setValue(col, null);
        }
    }

    private void sortColChanged(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        this.setNull4EntryCol("sortcol", rowIndex);
    }

    private void occAvbQtyChanged(PropertyChangedArgs e) {
        int rowIndex;
        IDataModel model = this.getModel();
        String val = (String)model.getValue("occavbqty", rowIndex = e.getChangeSet()[0].getRowIndex());
        if (StringUtils.isBlank((CharSequence)val)) {
            model.setValue("occavbqtyformula", null, rowIndex);
        }
    }

    private void dimBillColChanged(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        this.setNull4EntryCol("dimbillcol", rowIndex);
    }

    private void occBillColChanged(PropertyChangedArgs e) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        this.setNull4EntryCol("occbillcol", rowIndex);
    }

    private void srcBillChanged(PropertyChangedArgs e) {
        this.resetDataFilter();
        RuleBindHandler.setEntryConfig(this.getView(), null);
        RuleUtil.reSetOpSelect(this.getView());
        this.periodPolicyChanged(null);
    }

    private void resetDataFilter() {
        this.getModel().setValue("datafilter", null);
        this.getModel().setValue("datafilterformula_tag", null);
    }

    private void balEntityChanged(PropertyChangedArgs e) {
        boolean isPeriodBal;
        IDataModel model = this.getModel();
        DynamicObject data = model.getDataEntity();
        DynamicObject bal = data.getDynamicObject("bal");
        boolean bl = isPeriodBal = bal != null && "period".equals(bal.getString("balancetype"));
        if (isPeriodBal) {
            model.setValue("periodqtytype", (Object)"2");
        }
        RuleBindHandler.setDimValtypes(this.getView());
        RuleBindHandler.setEntryConfig(this.getView(), null);
    }

    private void occValTypeChanged(PropertyChangedArgs e) {
        int rowIndex;
        IDataModel model = this.getModel();
        String typeStr = (String)model.getValue("occvaltype", rowIndex = e.getChangeSet()[0].getRowIndex());
        if ("5".equals(typeStr)) {
            model.setValue("occbillcol", null, rowIndex);
            model.setValue("occbillcolname", null, rowIndex);
            model.setValue("occavbqty", null, rowIndex);
            model.setValue("occavbqtyformula", null, rowIndex);
        }
    }

    private void dimValTypeChanged(PropertyChangedArgs e) {
        String typeStr;
        IDataModel model = this.getModel();
        int index = e.getChangeSet()[0].getRowIndex();
        switch (typeStr = (String)model.getValue("dimvaltype", index)) {
            case "0": {
                model.setValue("dimexpr", null, index);
                model.setValue("dimexprformula_tag", null, index);
                break;
            }
            case "4": {
                model.setValue("dimexpr", null, index);
                model.setValue("dimexprformula_tag", null, index);
                model.setValue("dimbillcol", null, index);
                model.setValue("dimbillcolname", null, index);
                break;
            }
            case "6": {
                model.setValue("dimbillcol", null, index);
                model.setValue("dimbillcolname", null, index);
                break;
            }
        }
        if (!"5".equals(typeStr)) {
            String balCol = (String)model.getValue("dimbalcol", index);
            this.clearSortCol(balCol);
        }
        this.calUpdatePolicy();
    }

    private void clearSortCol(String col) {
        IDataModel model = this.getModel();
        int count = model.getEntryRowCount("sortentry");
        ArrayList<Integer> indexs = new ArrayList<Integer>(8);
        for (int i = 0; i < count; ++i) {
            String[] strArr;
            String sortCol = (String)model.getValue("sortcol", i);
            if (StringUtils.isBlank((CharSequence)sortCol) || !col.equals((strArr = sortCol.split("\\."))[0])) continue;
            indexs.add(i);
        }
        if (indexs.isEmpty()) {
            return;
        }
        int[] indexArr = new int[indexs.size()];
        int i = 0;
        for (Integer index : indexs) {
            indexArr[i++] = index;
        }
        model.deleteEntryRows("sortentry", indexArr);
    }

    private void calUpdatePolicy() {
        IDataModel model = this.getModel();
        DynamicObjectCollection entrys = model.getDataEntity(true).getDynamicObjectCollection("dimentry");
        boolean matchAll = true;
        for (DynamicObject entry : entrys) {
            if (!"5".equals(entry.getString("dimvaltype"))) continue;
            matchAll = false;
            break;
        }
        model.setValue("updatepolicy", (Object)(matchAll ? "0" : "1"));
        if (matchAll) {
            this.getModel().deleteEntryData("sortentry");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key;
        super.afterDoOperation(e);
        switch (key = e.getOperateKey()) {
            case "save": {
                this.doSave(e);
                break;
            }
        }
    }

    private void doSave(AfterDoOperationEventArgs e) {
        OperationResult result = e.getOperationResult();
        if (!result.isSuccess()) {
            return;
        }
        BalanceUpdateRuleMetadata rule = this.getCachedRuleMetaData();
        DynamicObject data = this.getModel().getDataEntity(true);
        RulePackager.packageRule(rule, data);
        BalanceUpdateRuleWriter.save((BalanceUpdateRuleMetadata)rule);
        this.getModel().setDataChanged(false);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        if (e.isCheckDataChange() && this.checkDataChanged(e)) {
            e.setCancel(true);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("close", (IConfirmCallBack)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"RuleEdit_6", (String)"bos-biz-balance", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"RuleEdit_7", (String)"bos-biz-balance", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"RuleEdit_8", (String)"bos-biz-balance", (Object[])new Object[0]);
            msg = StringUtils.isNotBlank((CharSequence)msg) ? msg.replaceAll("\\\\r\\\\n", "\r\n") : msg;
            this.getView().showConfirm(msg, this.getModel().getChangeDesc(), options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
            return;
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        if ("close".equals(e.getCallBackId()) && e.getResult() == MessageBoxResult.Yes) {
            this.getModel().setDataChanged(false);
            this.getView().close();
        }
    }

    private boolean checkDataChanged(BeforeClosedEvent e) {
        return this.getModel().getDataChanged() && StringUtils.isNotBlank((CharSequence)this.getModel().getChangeDesc());
    }
}

