/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.opplugin;

import java.util.Date;
import kd.bos.bal.business.core.BalRepairManager;
import kd.bos.bal.task.BalAutoRepair;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.trace.util.TraceIdUtil;
import org.apache.commons.lang3.StringUtils;

public class BalCheckRepairPublishTaskOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        BalAutoRepair.clearInvalidTasks();
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] data = e.getDataEntities();
        if (data.length > 0) {
            BalRepairManager.buildCheckRepairTask(data[0]);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new PublishTaskValidator());
    }

    private static class PublishTaskValidator
    extends AbstractValidator {
        private PublishTaskValidator() {
        }

        public void validate() {
            ExtendedDataEntity[] dataExts = this.getDataEntities();
            if (dataExts.length > 1) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u6279\u91cf\u64cd\u4f5c\u3002", (String)"BalCheckRepairPublishTaskOp_0", (String)"bos-biz-balance", (Object[])new Object[0]));
            }
            ExtendedDataEntity dataExt = dataExts[0];
            long limit = new Date().getTime() - 604800000L;
            Date createTime = dataExt.getDataEntity().getDate("createdate");
            if (createTime == null || createTime.getTime() < limit) {
                this.addErrorMessage(dataExt, ResManager.loadKDString((String)"7\u5929\u524d\u7684\u4efb\u52a1\uff0c\u4e0d\u80fd\u518d\u6b21\u6267\u884c\uff0c\u53ef\u521b\u5efa\u65b0\u4efb\u52a1\u3002", (String)"BalCheckRepairPublishTaskOp_1", (String)"bos-biz-balance", (Object[])new Object[0]));
                return;
            }
            DynamicObject data = dataExt.getDataEntity();
            String taskType = data.getString("tasktype");
            String opRange = data.getString("oprange");
            if (opRange == null) {
                return;
            }
            String taskNo = data.getString("taskno");
            if (StringUtils.isNotBlank((CharSequence)taskNo) && taskNo.length() >= 4 && (taskNo = taskNo.substring(0, 4)).equalsIgnoreCase("auto")) {
                this.addErrorMessage(dataExt, ResManager.loadKDString((String)"\u4efb\u52a1\u7f16\u53f7\u4e0d\u80fd\u4ee5auto\u5f00\u5934\uff0c\u65e0\u8bba\u5927\u5c0f\u5199\u3002", (String)"BalCheckRepairPublishTaskOp_2", (String)"bos-biz-balance", (Object[])new Object[0]));
                return;
            }
            switch (taskType) {
                case "A": 
                case "F": {
                    if (this.isMatch(opRange, "A", "B", "D")) break;
                    this.addErrorMessage(dataExt, ResManager.loadKDString((String)"\u64cd\u4f5c\u8303\u56f4\u53ea\u80fd\u9009\u62e9\u201c\u589e\u91cf\u64cd\u4f5c\u201d\u3001\u201c\u5168\u91cf\u64cd\u4f5c\u201d\u3001\u201c\u6309\u4f59\u989d\u6761\u4ef6\u64cd\u4f5c\u201d\u3002", (String)"BalCheckRepairPublishTaskOp_3", (String)"bos-biz-balance", (Object[])new Object[0]));
                    return;
                }
                case "B": 
                case "G": {
                    if (this.isMatch(opRange, "A", "B", "C")) break;
                    this.addErrorMessage(dataExt, ResManager.loadKDString((String)"\u64cd\u4f5c\u8303\u56f4\u53ea\u80fd\u9009\u62e9\u201c\u589e\u91cf\u64cd\u4f5c\u201d\u3001\u201c\u5168\u91cf\u64cd\u4f5c\u201d\u3001\u201c\u6309\u5355\u636e\u6761\u4ef6\u64cd\u4f5c\u201d\u3002", (String)"BalCheckRepairPublishTaskOp_4", (String)"bos-biz-balance", (Object[])new Object[0]));
                    return;
                }
                case "D": 
                case "I": {
                    if (this.isMatch(opRange, "A", "B")) break;
                    this.addErrorMessage(dataExt, ResManager.loadKDString((String)"\u64cd\u4f5c\u8303\u56f4\u53ea\u80fd\u9009\u62e9\u201c\u589e\u91cf\u64cd\u4f5c\u201d\u3001\u201c\u5168\u91cf\u64cd\u4f5c\u201d\u3002", (String)"BalCheckRepairPublishTaskOp_5", (String)"bos-biz-balance", (Object[])new Object[0]));
                    return;
                }
                case "C": 
                case "H": {
                    if (this.isMatch(opRange, "A", "B", "D")) break;
                    this.addErrorMessage(dataExt, ResManager.loadKDString((String)"\u64cd\u4f5c\u8303\u56f4\u53ea\u80fd\u9009\u62e9\u201c\u589e\u91cf\u64cd\u4f5c\u201d\u3001\u201c\u5168\u91cf\u64cd\u4f5c\u201d\u3001\u201c\u6309\u4f59\u989d\u6761\u4ef6\u64cd\u4f5c\u201d\u3002", (String)"BalCheckRepairPublishTaskOp_3", (String)"bos-biz-balance", (Object[])new Object[0]));
                    return;
                }
                case "J": 
                case "E": {
                    if (this.isMatch(opRange, "B")) break;
                    this.addErrorMessage(dataExt, ResManager.loadKDString((String)"\u64cd\u4f5c\u8303\u56f4\u53ea\u80fd\u9009\u62e9\u201c\u5168\u91cf\u64cd\u4f5c\u201d\u3002", (String)"BalCheckRepairPublishTaskOp_6", (String)"bos-biz-balance", (Object[])new Object[0]));
                    return;
                }
                default: {
                    throw new KDBizException("tasktype: " + taskType + " not support");
                }
            }
            if ("C".equals(opRange) && StringUtils.isBlank((CharSequence)data.getString("bill.id"))) {
                this.addErrorMessage(dataExt, ResManager.loadKDString((String)"\u201c\u6309\u5355\u636e\u6761\u4ef6\u64cd\u4f5c\u201d\u65f6\u5355\u636e\u5b9e\u4f53\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BalCheckRepairPublishTaskOp_7", (String)"bos-biz-balance", (Object[])new Object[0]));
                return;
            }
            if (this.hasTasks(dataExt)) {
                this.addErrorMessage(dataExt, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u4efb\u52a1\uff0c\u4e0d\u80fd\u91cd\u590d\u90e8\u5206\u4efb\u52a1\uff0c\u70b9\u51fb\u67e5\u770b\u4efb\u52a1\u67e5\u770b\u3002", (String)"BalCheckRepairPublishTaskOp_8", (String)"bos-biz-balance", (Object[])new Object[0]));
                return;
            }
            if (!opRange.equals("D")) {
                data.set("balfsinfo_tag", null);
                data.set("balfsinfo", null);
            } else if (!opRange.equals("C")) {
                data.set("billfsinfo_tag", null);
                data.set("billfsinfo", null);
            }
            data.set("traceid", (Object)TraceIdUtil.getCurrentTraceIdString());
        }

        private boolean hasTasks(ExtendedDataEntity data) {
            Object id = data.getDataEntity().getPkValue();
            if (id == null || id.equals(0L)) {
                return false;
            }
            return QueryServiceHelper.exists((String)"bal_check_repair_task", (QFilter[])new QFilter("parenttask", "=", id).toArray());
        }

        private boolean isMatch(String str, String ... items) {
            for (String item : items) {
                if (!str.equals(item)) continue;
                return true;
            }
            return false;
        }
    }
}

