/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.opplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bal.business.core.BalRepairManager;
import kd.bos.bal.common.BalUtil;
import kd.bos.bal.common.QFUtil;
import kd.bos.bal.common.TaskMsg;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.trace.util.TraceIdUtil;
import org.apache.commons.lang3.StringUtils;

public class BalCheckRepairTaskOp
extends AbstractOperationServicePlugIn {
    public static final String OP_RETRY = "retry";
    public static final String OP_GOON = "goon";
    public static final String OP_REPAIR = "repair";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("parenttask");
        fieldKeys.add("msgappid");
        fieldKeys.add("managertraceid");
        fieldKeys.add("status");
        fieldKeys.add("runstatus");
        fieldKeys.add("resultdata_tag");
        fieldKeys.add("createdate");
    }

    private List<TaskMsg> buildTaskMsgs(DynamicObject[] datas, String type) {
        String managertraceid = TraceIdUtil.getCurrentTraceIdString();
        ArrayList<TaskMsg> msgs = new ArrayList<TaskMsg>(datas.length);
        for (DynamicObject info : datas) {
            info.set("managertraceid", (Object)managertraceid);
            info.set("runstatus", (Object)"1");
            String msgAppId = info.getString("msgappid");
            if (!StringUtils.isNotBlank((CharSequence)msgAppId)) continue;
            msgs.add(new TaskMsg(msgAppId, info.getLong("id"), type));
        }
        return msgs;
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new TaskOpValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String key;
        DynamicObject[] datas = e.getDataEntities();
        switch (key = e.getOperationKey()) {
            case "retry": {
                this.reTry(datas);
                break;
            }
            case "goon": {
                this.goOn(datas);
                break;
            }
            case "repair": {
                this.repair(datas);
                break;
            }
        }
    }

    private void repair(DynamicObject[] datas) {
        List<TaskMsg> msgs = this.buildTaskMsgs(datas, "C");
        this.saveByNewTx(datas);
        BalRepairManager.publishTasks(msgs);
        this.markTaskBusy(msgs);
    }

    private void markTaskBusy(List<TaskMsg> msgs) {
        List ids = msgs.stream().filter(t -> !t.isPubSuccess()).map(TaskMsg::getTaskId).collect(Collectors.toList());
        if (!ids.isEmpty()) {
            MainEntityType task = MetadataServiceHelper.getDataEntityType((String)"bal_check_repair_task");
            String tb = task.getAlias();
            String runStatusCol = task.findProperty("runstatus").getAlias();
            String sql = "UPDATE " + tb + " SET " + runStatusCol + "='3' WHERE FID " + QFUtil.getIdsFilter(ids);
            try (TXHandle tx = TX.requiresNew((String)"markTaskBusy");){
                try {
                    DB.execute((DBRoute)DBRoute.of((String)task.getDBRouteKey()), (String)sql);
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }

    private void goOn(DynamicObject[] datas) {
        List<TaskMsg> msgs = this.buildTaskMsgs(datas, "B");
        this.saveByNewTx(datas);
        BalRepairManager.publishTasks(msgs);
        this.markTaskBusy(msgs);
    }

    private void reTry(DynamicObject[] datas) {
        List<TaskMsg> msgs = this.buildTaskMsgs(datas, "A");
        this.saveByNewTx(datas);
        BalRepairManager.publishTasks(msgs);
        this.markTaskBusy(msgs);
    }

    private void saveByNewTx(DynamicObject[] datas) {
        try (TXHandle tx = TX.requiresNew((String)"BalCheckRepairTaskOp.savestatus");){
            SaveServiceHelper.save((DynamicObject[])datas);
        }
    }

    private static class TaskOpValidator
    extends AbstractValidator {
        private TaskOpValidator() {
        }

        public void validate() {
            String key = this.getOperateKey();
            this.commonCheck();
            this.whenClearSpData(key);
            switch (key) {
                case "retry": {
                    this.reTryValidator();
                    break;
                }
                case "goon": {
                    this.goOnValidator();
                    break;
                }
                case "repair": {
                    this.repairValidator();
                    break;
                }
            }
        }

        private void commonCheck() {
            ExtendedDataEntity[] dataExts;
            long limit = new Date().getTime() - 604800000L;
            for (ExtendedDataEntity dataExt : dataExts = this.getDataEntities()) {
                String opResult;
                Date createTime = dataExt.getDataEntity().getDate("createdate");
                if (createTime == null || createTime.getTime() < limit) {
                    this.addErrorMessage(dataExt, ResManager.loadKDString((String)"7\u5929\u524d\u7684\u4efb\u52a1\uff0c\u4e0d\u80fd\u518d\u6b21\u6267\u884c\uff0c\u53ef\u521b\u5efa\u65b0\u4efb\u52a1\u3002", (String)"BalCheckRepairTaskOp_0", (String)"bos-biz-balance", (Object[])new Object[0]));
                }
                if (!"D".equals(opResult = dataExt.getDataEntity().getString("parenttask.opresult"))) continue;
                this.addErrorMessage(dataExt, ResManager.loadKDString((String)"\u7236\u4efb\u52a1\u5df2\u624b\u5de5\u7ec8\u6b62\uff0c\u4e0d\u80fd\u518d\u6267\u884c\u64cd\u4f5c\u3002", (String)"BalCheckRepairTaskOp_4", (String)"bos-biz-balance", (Object[])new Object[0]));
            }
        }

        private void repairValidator() {
            ExtendedDataEntity[] dataExts;
            for (ExtendedDataEntity dataExt : dataExts = this.getDataEntities()) {
                if (!StringUtils.isBlank((CharSequence)dataExt.getDataEntity().getString("resultdata_tag"))) continue;
                this.addErrorMessage(dataExt, ResManager.loadKDString((String)"\u6ca1\u6709\u5dee\u5f02\u6570\u636e\uff0c\u4e0d\u80fd\u6267\u884c\u4fee\u590d\u5dee\u5f02\u3002", (String)"BalCheckRepairTaskOp_1", (String)"bos-biz-balance", (Object[])new Object[0]));
            }
        }

        private void goOnValidator() {
            ExtendedDataEntity[] dataExts;
            for (ExtendedDataEntity dataExt : dataExts = this.getDataEntities()) {
                if (!StringUtils.isNotBlank((CharSequence)dataExt.getDataEntity().getString("resultdata_tag"))) continue;
                this.addErrorMessage(dataExt, ResManager.loadKDString((String)"\u5b58\u5728\u5dee\u5f02\u6570\u636e\uff0c\u9700\u5148\u6267\u884c\u4fee\u590d\u5dee\u5f02\u3002", (String)"BalCheckRepairTaskOp_2", (String)"bos-biz-balance", (Object[])new Object[0]));
            }
        }

        private void reTryValidator() {
        }

        private void whenClearSpData(String key) {
            ExtendedDataEntity[] dataExts = this.getDataEntities();
            if (BalUtil.isMatch(key, BalCheckRepairTaskOp.OP_GOON, BalCheckRepairTaskOp.OP_REPAIR)) {
                for (ExtendedDataEntity dataExt : dataExts) {
                    if (!"E".equals(dataExt.getDataEntity().getString("parenttask.tasktype"))) continue;
                    this.addErrorMessage(dataExt, ResManager.loadKDString((String)"\u4efb\u52a1\u7c7b\u578b\u4e3a\u201c\u6e05\u9664\u5df2\u56de\u6eda\u7684\u5feb\u7167\u201d\uff0c\u8bf7\u4f7f\u7528\u91cd\u65b0\u6267\u884c\u6309\u94ae\u3002", (String)"BalCheckRepairTaskOp_3", (String)"bos-biz-balance", (Object[])new Object[0]));
                }
            }
        }
    }
}

