/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.bal.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.algo.Collector;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.RowUtil;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.db.DataSetDataType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

class SpJoinBalReduceGroupFunc
extends ReduceGroupFunctionWithCollector {
    private static final int INIT_SIZE = 512;
    private static final long serialVersionUID = -6479211224196996634L;
    private RowMeta spRowMeta;
    private RowMeta rowMeta;
    private String balEntity;
    private List<String> balCols;
    private int keyColIdx = -1;
    private int newLen;
    private String balColStr;

    public SpJoinBalReduceGroupFunc(RowMeta spRowMeta, String balEntity, Set<String> balCols) {
        this.balEntity = balEntity;
        this.balCols = new ArrayList<String>(balCols);
        this.spRowMeta = spRowMeta;
        this.keyColIdx = spRowMeta.getFieldIndex("keycol");
        this.newLen = spRowMeta.getFieldCount() + balCols.size();
    }

    private RowMeta buildRowMeta(RowMeta spRowMeta) {
        Field[] spFields = spRowMeta.getFields();
        String[] fieldNames = new String[spFields.length + this.balCols.size()];
        DataType[] dataTypes = new DataType[fieldNames.length];
        int i = 0;
        for (Field spField : spFields) {
            fieldNames[i] = spField.getName();
            dataTypes[i] = spField.getDataType();
            ++i;
        }
        MainEntityType balMeta = MetadataServiceHelper.getDataEntityType((String)this.balEntity);
        IDataEntityProperty pro = null;
        for (String balCol : this.balCols) {
            pro = balMeta.findProperty(balCol);
            if (pro instanceof IComplexProperty) {
                pro = ((IComplexProperty)pro).getComplexType().getPrimaryKey();
            }
            fieldNames[i] = balCol;
            dataTypes[i] = DataSetDataType.getDataType((Class)pro.getPropertyType());
            ++i;
        }
        return RowMetaFactory.createRowMeta((String[])fieldNames, (DataType[])dataTypes);
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta == null ? (this.rowMeta = this.buildRowMeta(this.spRowMeta)) : this.rowMeta;
    }

    public void reduce(Iterator<Row> rows, Collector ct) {
        ArrayList<Object[]> vals = new ArrayList<Object[]>(512);
        HashSet<String> keycols = new HashSet<String>(512);
        Object[] val = null;
        while (rows.hasNext()) {
            val = RowUtil.toArray((Row)rows.next());
            vals.add(val);
            keycols.add((String)val[this.keyColIdx]);
            if (vals.size() <= 10000) continue;
            this.leftJoinData(vals, keycols);
            for (Object[] newVal : vals) {
                ct.collect(newVal);
            }
            vals.clear();
            keycols.clear();
        }
        if (!vals.isEmpty()) {
            this.leftJoinData(vals, keycols);
            for (Object[] newVal : vals) {
                ct.collect(newVal);
            }
        }
    }

    private String buildSelectBalCols() {
        return this.balColStr == null ? (this.balColStr = String.join((CharSequence)",", this.balCols) + "," + "keycol") : this.balColStr;
    }

    private Object[] parseVals(Row row) {
        Object[] val = new Object[this.balCols.size()];
        int i = 0;
        for (String col : this.balCols) {
            val[i++] = row.get(col);
        }
        return val;
    }

    private void leftJoinData(List<Object[]> vals, Set<String> keycols) {
        QFilter fs = new QFilter("keycol", "in", keycols);
        HashMap<String, Object[]> valMap = new HashMap<String, Object[]>(512);
        try (DataSet data = QueryServiceHelper.queryDataSet((String)"joinData", (String)this.balEntity, (String)this.buildSelectBalCols(), (QFilter[])fs.toArray(), null);){
            for (Row row : data) {
                valMap.put(row.getString("keycol"), this.parseVals(row));
            }
            Object[] newVal = null;
            Object[] val = null;
            Object[] appendVal = null;
            int len = vals.size();
            for (int i = 0; i < len; ++i) {
                val = vals.get(i);
                newVal = new Object[this.newLen];
                System.arraycopy(val, 0, newVal, 0, val.length);
                appendVal = (Object[])valMap.get(val[this.keyColIdx]);
                if (appendVal != null) {
                    System.arraycopy(appendVal, 0, newVal, val.length, appendVal.length);
                }
                vals.set(i, newVal);
            }
        }
    }
}

