/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.mservice.taxcode;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bamp.bastax.common.util.DBUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TaxCodeUpgradeService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(TaxCodeUpgradeService.class);
    private static final String SELECT_TAXCODE_SQL = "select fid from t_bastax_taxcode where foffsetlogo not in('0','1') ";
    private static final String INSERT_TAXCODE_SQL = "update t_bastax_taxcode set foffsetlogo = '0' where fid = ? ";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        result.setSuccess(true);
        String msg = this.doUpgrade();
        result.setLog(msg);
        return result;
    }

    public String doUpgrade() {
        Throwable throwable = null;
        try (TXHandle h = TX.requiresNew();){
            String dbkey = DBRoute.basedata.getRouteKey();
            List querys = DBUtils.query((String)dbkey, (String)SELECT_TAXCODE_SQL);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(16);
            for (Map map : querys) {
                Object[] param = new Object[]{Long.valueOf(map.get("FID").toString())};
                paramList.add(param);
            }
            int size = paramList.size();
            if (size > 0) {
                DBUtils.executeBatch((String)dbkey, (String)INSERT_TAXCODE_SQL, paramList);
            }
            String string = String.format("TaxCodeUpgradeService success\uff1a%s", size);
            return string;
        }
        catch (Throwable t) {
            try {
                logger.error((Object)"TaxCodeUpgradeService error", t);
                h.markRollback();
                throw t;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

