/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.common.util;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bamp.bastax.common.util.EmptyCheckUtils;
import kd.bamp.bastax.common.util.StringUtil;
import kd.bamp.bastax.common.util.param.SystemParamUtil;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class OrgUtils {
    private static Comparator<Object> CHINA_COMPARATOR = Collator.getInstance(Locale.CHINA);

    public static Long getDefaultViewSchemaInfoId() {
        return OrgUtils.getDefaultViewSchemaByTypeId("40");
    }

    public static Long getDefaultViewSchemaByTypeId(String typeId) {
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"bos_org_viewschema", (String)"id", (QFilter[])OrgUtils.getDefaultViewSchemaQFilter(typeId));
        return EmptyCheckUtils.isEmpty(coll) ? 0L : ((DynamicObject)coll.get(0)).getLong("id");
    }

    public static QFilter[] getDefaultViewSchemaQFilter(String typeId) {
        QFilter f = new QFilter("isdefault", "=", (Object)"1");
        QFilter qf = new QFilter("treetype", "=", (Object)typeId);
        return new QFilter[]{f, qf};
    }

    public static Map<String, Map<String, String>> getAllOrgByViewId(Long orgViewSchemaId) {
        return OrgUtils.getAllOrgByViewId(orgViewSchemaId, null);
    }

    public static Map<String, Map<String, String>> getAllOrgByViewId(Long orgViewSchemaId, QFilter qFilter) {
        QFilter orgViewIdFilter = new QFilter("view", "=", (Object)orgViewSchemaId);
        if (qFilter != null) {
            orgViewIdFilter.and(qFilter);
        }
        orgViewIdFilter.and(new QFilter("org.enable", "=", (Object)"1"));
        HashMap<String, Map<String, String>> orgTreeMap = new HashMap<String, Map<String, String>>();
        try (DataSet data = QueryServiceHelper.queryDataSet((String)"kd.tmc.fbd.formplugin.companysys.CompanySysViewEdit.getAllOrgByViewId()", (String)"bos_org_structure", (String)"id,org.id,org.name,org.number,parent.id,isleaf,longnumber", (QFilter[])orgViewIdFilter.toArray(), (String)"longnumber");){
            while (data.hasNext()) {
                HashMap<String, String> mtree = new HashMap<String, String>();
                Row row = data.next();
                String id = String.valueOf(row.getLong("org.id"));
                mtree.put("id", id);
                mtree.put("name", row.getString("org.name"));
                mtree.put("number", row.getString("org.number"));
                mtree.put("parentid", String.valueOf(row.getLong("parent.id")));
                mtree.put("isleaf", row.getBoolean("isleaf") != false ? "1" : "0");
                mtree.put("longnumber", row.getString("longnumber"));
                orgTreeMap.put(id, mtree);
            }
        }
        return orgTreeMap;
    }

    public static Map<String, Map<String, String>> getAllOrgByOrgpatternId(Long viewId, Long orgpatternId) {
        QFilter qFilter = new QFilter("org.orgpattern", "=", (Object)orgpatternId);
        qFilter.or(new QFilter("parent.id", "=", (Object)0));
        return OrgUtils.getAllOrgByViewId(viewId, qFilter);
    }

    public static Map<String, DynamicObject> getAllOrgByView(Long orgViewSchemaId, QFilter qFilter) {
        QFilter orgIdFilter;
        DynamicObject[] ordDynamicObjects;
        QFilter orgViewIdFilter = new QFilter("view", "=", (Object)orgViewSchemaId);
        if (qFilter != null) {
            orgViewIdFilter.and(qFilter);
        }
        orgViewIdFilter.and(new QFilter("org.enable", "=", (Object)"1"));
        HashMap<String, DynamicObject> orgTreeMap = new HashMap<String, DynamicObject>();
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)"id,org", (QFilter[])new QFilter[]{orgViewIdFilter}, (String)"longnumber");
        ArrayList<Long> ids = new ArrayList<Long>();
        if (Objects.nonNull(dynamicObjects) && dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                ids.add(dynamicObject.getLong("org.id"));
            }
        }
        if (Objects.nonNull(ordDynamicObjects = BusinessDataServiceHelper.load((String)"bos_org", (String)"id,uniformsocialcreditcode,orgpattern,registeredcapital,establishmentdate,frepresentative", (QFilter[])new QFilter[]{orgIdFilter = new QFilter("id", "in", ids)})) && ordDynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : ordDynamicObjects) {
                String orgId = dynamicObject.getString("id");
                orgTreeMap.put(orgId, dynamicObject);
            }
        }
        return orgTreeMap;
    }

    private static long getViewTreeType(long viewId) {
        return (Long)DB.query((DBRoute)DBRoute.of((String)"sys"), (String)"select ftreetypeid as treetype from t_org_viewschema where fid = ? ", (Object[])new Object[]{viewId}, e -> e.next() ? e.getLong("treetype") : 10L);
    }

    public static Map<String, Map<String, Object>> getAllOrgMapByView(Long orgViewSchemaId, QFilter qFilter) {
        QFilter orgIdFilter;
        String selectProperties;
        DynamicObject[] ordDynamicObjects;
        QFilter orgViewIdFilter = new QFilter("view", "=", (Object)orgViewSchemaId);
        if (qFilter != null) {
            orgViewIdFilter.and(qFilter);
        }
        orgViewIdFilter.and(new QFilter("org.enable", "=", (Object)"1"));
        HashMap<String, Map<String, Object>> orgTreeMap = new HashMap<String, Map<String, Object>>();
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)"id,org,view", (QFilter[])new QFilter[]{orgViewIdFilter}, (String)"longnumber");
        ArrayList<Long> ids = new ArrayList<Long>();
        HashMap<Long, Long> orgCmborgtypeMap = new HashMap<Long, Long>();
        HashMap<Long, Long> viewMap = new HashMap<Long, Long>();
        if (Objects.nonNull(dynamicObjects) && dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                long orgId = dynamicObject.getLong("org.id");
                ids.add(orgId);
                long viewId = dynamicObject.getLong("view.id");
                Long treetype = (Long)viewMap.get(viewId);
                if (null == treetype) {
                    treetype = OrgUtils.getViewTreeType(viewId);
                    viewMap.put(viewId, treetype);
                }
                orgCmborgtypeMap.put(orgId, treetype);
            }
        }
        if (Objects.nonNull(ordDynamicObjects = BusinessDataServiceHelper.load((String)"bos_org", (String)(selectProperties = "id,uniformsocialcreditcode,orgpattern,registeredcapital,establishmentdate,frepresentative"), (QFilter[])new QFilter[]{orgIdFilter = new QFilter("id", "in", ids)})) && ordDynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : ordDynamicObjects) {
                String orgId = dynamicObject.getString("id");
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("org", dynamicObject);
                map.put("cmborgtype", orgCmborgtypeMap.getOrDefault(Long.parseLong(orgId), 10L));
                orgTreeMap.put(orgId, map);
            }
        }
        return orgTreeMap;
    }

    public static Map<String, List<Map<String, String>>> getOrgTreeMap(Map<String, Map<String, String>> orgMap) {
        HashMap<String, List<Map<String, String>>> orgTreeMap = new HashMap<String, List<Map<String, String>>>();
        for (Map.Entry<String, Map<String, String>> orgId : orgMap.entrySet()) {
            OrgUtils.buildOrgTree(orgId.getValue(), orgMap, orgTreeMap);
        }
        return orgTreeMap;
    }

    public static void buildOrgTree(Map<String, String> org, Map<String, Map<String, String>> orgMap, Map<String, List<Map<String, String>>> orgTreeMap) {
        List<Map<String, String>> parentList;
        String orgid = org.get("id");
        if (orgid == null || orgid.equalsIgnoreCase("0")) {
            return;
        }
        String parentid = org.get("parentid");
        Map<String, String> parentOrg = orgMap.get(parentid);
        if (orgTreeMap.get(orgid) == null) {
            orgTreeMap.put(orgid, new ArrayList());
        }
        if (parentOrg == null) {
            return;
        }
        if (orgTreeMap.get(parentid) == null) {
            OrgUtils.buildOrgTree(parentOrg, orgMap, orgTreeMap);
        }
        if ((parentList = orgTreeMap.get(parentid)) == null) {
            return;
        }
        if (!parentList.contains(org)) {
            parentList.add(org);
        }
    }

    public static TreeNode createTreeNode(Map<String, Map<String, String>> orgTreeMap) {
        Map<String, Map> rootIdMap = orgTreeMap.entrySet().stream().filter(v -> "0".equals(((Map)v.getValue()).get("parentid"))).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Map)e.getValue()));
        Set<String> rootIdSet = rootIdMap.keySet();
        if (rootIdSet.isEmpty()) {
            return null;
        }
        String rootId = rootIdSet.toArray(new String[0])[0];
        String rootName = orgTreeMap.get(rootId).get("name");
        TreeNode root = new TreeNode();
        root.setParentid("");
        root.setId(rootId);
        root.setText(rootName);
        root.setIsOpened(true);
        root.setLongNumber(orgTreeMap.get(rootId).get("longnumber"));
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("isleaf", "0");
        dataMap.put("level", "1");
        dataMap.put("fullname", rootName);
        root.setData(dataMap);
        return root;
    }

    public static TreeNode createChildNodes(Map<String, List<Map<String, String>>> orgTreeMap, String rootId, TreeNode root) {
        if (orgTreeMap == null || rootId == null || orgTreeMap.size() == 0 || root == null) {
            return null;
        }
        OrgUtils.buildTreeNode(orgTreeMap, rootId, root);
        return root;
    }

    public static void buildTreeNode(Map<String, List<Map<String, String>>> orgTreeMap, String rootId, TreeNode treeNode) {
        List<Map<String, String>> childList = orgTreeMap.get(rootId);
        HashMap dataMap = (HashMap)treeNode.getData();
        if (childList == null || childList.size() == 0) {
            dataMap.put("isleaf", "1");
            return;
        }
        String parentLongNumber = treeNode.getLongNumber();
        int parentLevel = Integer.parseInt((String)dataMap.get("level"));
        String parentName = (String)dataMap.get("fullname");
        for (Map<String, String> org : childList) {
            TreeNode childrenTree = new TreeNode();
            String orgid = org.get("id");
            if ("0".equals(orgid) || StringUtil.isEmpty((CharSequence)org.get("name"))) continue;
            childrenTree.setParentid(org.get("parentid"));
            childrenTree.setId(orgid);
            childrenTree.setText(org.get("name"));
            childrenTree.setIsOpened(false);
            childrenTree.setLongNumber(parentLongNumber + "!" + orgid);
            HashMap<String, String> childDataMap = new HashMap<String, String>();
            childDataMap.put("isleaf", "0");
            childDataMap.put("level", String.valueOf(parentLevel + 1));
            childDataMap.put("fullname", parentName + "_" + org.get("name"));
            childrenTree.setData(childDataMap);
            treeNode.addChild(childrenTree);
            OrgUtils.buildTreeNode(orgTreeMap, orgid, childrenTree);
        }
        OrgUtils.sortTreeNode(treeNode.getChildren());
    }

    public static void sortTreeNode(List<TreeNode> nodes) {
        if (nodes != null && !nodes.isEmpty()) {
            Collections.sort(nodes, (node1, node2) -> CHINA_COMPARATOR.compare(node1.getText(), node2.getText()));
        }
    }

    public static TreeNode getTreeNodeById(String nodeId, TreeNode unitTreeNode) {
        int j = unitTreeNode.getNodeLevel(nodeId, 0);
        return unitTreeNode.getTreeNode(nodeId, j);
    }

    public static List<TreeNode> buildTreeNodeByList(TreeNode parentTreeNode, List<Map<String, Object>> leftNodes) {
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(leftNodes.size());
        HashMap parentData = (HashMap)parentTreeNode.getData();
        for (Map<String, Object> treeNode : leftNodes) {
            if (parentTreeNode.getId().equals(treeNode.get("id"))) continue;
            TreeNode childrenTree = new TreeNode();
            childrenTree.setParentid(parentTreeNode.getId());
            childrenTree.setId((String)treeNode.get("id"));
            childrenTree.setText((String)treeNode.get("text"));
            childrenTree.setIsOpened(false);
            childrenTree.setLongNumber(parentTreeNode.getLongNumber() + "!" + treeNode.get("id"));
            HashMap<String, String> childDataMap = new HashMap<String, String>();
            childDataMap.put("isleaf", "1");
            int level = Integer.parseInt((String)parentData.get("level")) + 1;
            childDataMap.put("level", String.valueOf(level));
            childDataMap.put("fullname", parentTreeNode.getText() + "_" + treeNode.get("text"));
            childrenTree.setData(childDataMap);
            treeNodes.add(childrenTree);
        }
        return treeNodes;
    }

    public static Long getLocalDefaultViewId() {
        QFilter f = new QFilter("isdefault", "=", (Object)"1").and(new QFilter("enable", "=", (Object)"1"));
        DynamicObjectCollection coll = QueryServiceHelper.query((String)"tctb_org_default_view", (String)"id", (QFilter[])new QFilter[]{f});
        return coll == null || coll.isEmpty() ? 0L : ((DynamicObject)coll.get(0)).getLong("id");
    }

    public static final List<String> getOrgIdByStructurePkids(List<String> structureIds) {
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"bos_org_structure", (String)"org", (QFilter[])new QFilter[]{new QFilter("id", "in", structureIds.stream().map(v -> Long.parseLong(v)).collect(Collectors.toList()))});
        return EmptyCheckUtils.isEmpty(dys) ? new ArrayList<String>() : dys.stream().map(v -> v.getString("org")).collect(Collectors.toList());
    }

    public static boolean isSyncOldTaxView(String paramKey) {
        boolean isSync = false;
        Object sync = SystemParamUtil.getAppParameter("bastax", paramKey);
        if (sync instanceof Boolean && ((Boolean)sync).booleanValue()) {
            isSync = true;
        }
        return isSync;
    }
}

