/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.common.validator;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bamp.bastax.common.enums.QuoteOrgEntityEnum;
import kd.bamp.bastax.common.util.StringUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class TaxorgQuoteValidator {
    private static Log logger = LogFactory.getLog(TaxorgQuoteValidator.class);
    public static final String BOS_ENTITYOBJECT = "bos_entityobject";

    public static QuoteOrgEntityEnum validatorTaxOrgQuote(List<Long> orgIds) {
        logger.info("TaxorgQuoteValidator begin validatorTaxOrgQuote");
        List ids = Arrays.stream(QuoteOrgEntityEnum.values()).map(o -> o.getEntityName()).collect(Collectors.toList());
        DynamicObjectCollection collection = QueryServiceHelper.query((String)BOS_ENTITYOBJECT, (String)"number,id", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        if (null != collection && collection.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                QFilter[] qFilter;
                String entityName = ((DynamicObject)collection.get(i)).getString("number");
                if (!StringUtil.isNotEmpty((CharSequence)EntityMetadataCache.getDataEntityType((String)entityName).getAlias())) continue;
                QuoteOrgEntityEnum entityEnum = QuoteOrgEntityEnum.getQuoteEntityEnumByEntityName(entityName);
                String[] fields = StringUtil.split((String)entityEnum.getSelectFields(), (String)",");
                QFilter fieldsQ = QFilter.isNotNull((String)"id");
                if (fields.length == 1) {
                    fieldsQ.and(new QFilter(fields[0], "in", orgIds));
                } else if (fields.length > 1) {
                    qFilter = new QFilter(fields[0], "in", orgIds);
                    for (int j = 1; j < fields.length; ++j) {
                        String field = fields[j];
                        qFilter.or(new QFilter(field, "in", orgIds));
                    }
                    fieldsQ.and((QFilter)qFilter);
                } else {
                    fieldsQ.and(QFilter.isNull((String)"id"));
                }
                qFilter = new QFilter[]{fieldsQ};
                if (!QueryServiceHelper.exists((String)entityName, (QFilter[])qFilter)) continue;
                logger.info("TaxorgQuoteValidator exists quote");
                return entityEnum;
            }
        }
        logger.info("TaxorgQuoteValidator not exists quote");
        return null;
    }
}

