/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.formplugin.euproduct;

import java.util.Date;
import java.util.Objects;
import kd.bamp.bastax.common.util.DateUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class EUproductOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject currentObj = dataEntity.getDataEntity();
                    Date start = currentObj.getDate("startdate");
                    Date end = currentObj.getDate("enddate");
                    Long country = currentObj.getLong("country.id");
                    if (!ObjectUtils.isEmpty((Object)start) && !ObjectUtils.isEmpty((Object)end) && start.compareTo(end) > 0) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u751f\u6548\u65e5\u671f\u3002", (String)"EUproductOp_0", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
                        continue;
                    }
                    boolean isEffective = false;
                    QFilter idQFilter = new QFilter("id", "!=", currentObj.get("id"));
                    QFilter countryQFilter = new QFilter("country", "=", (Object)country);
                    QFilter enableQFilter = new QFilter("enable", "=", (Object)"1");
                    QFilter[] qFilters = new QFilter[]{idQFilter, countryQFilter, enableQFilter};
                    DynamicObjectCollection colls = QueryServiceHelper.query((String)currentObj.getDataEntityType().getExtendName(), (String)"id,startdate,enddate,country", (QFilter[])qFilters);
                    for (DynamicObject exist : colls) {
                        Date existStart = exist.getDate("startdate");
                        Date existEnd = exist.getDate("enddate");
                        if (Objects.isNull(end) && Objects.isNull(existEnd)) {
                            isEffective = true;
                            break;
                        }
                        if (!DateUtils.isEffectiveDate((Date)start, (Date)existStart, (Date)existEnd) && !DateUtils.isEffectiveDate((Date)existStart, (Date)start, (Date)end)) continue;
                        isEffective = true;
                        break;
                    }
                    if (!isEffective) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6709\u6548\u671f\u5185\u5df2\u5b58\u5728\u76f8\u540c\u7684\u56fd\u5bb6\u6216\u5730\u533a\uff1a%s\u3002", (String)"EUproductOp_1", (String)"bamp-bastax-formplugin", (Object[])new Object[0]), currentObj.getString("country.name")));
                }
            }
        });
    }
}

