/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.formplugin.hscode;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kd.bamp.bastax.business.hscode.TaxcHscodeBusiness;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;

public class TaxcHscodeImportPlugin
extends BatchImportPlugin {
    public List<ComboItem> getOverrideFieldsConfig() {
        return super.getOverrideFieldsConfig().stream().filter(comboItem -> "number".equalsIgnoreCase(comboItem.getValue()) || "enddate".equalsIgnoreCase(comboItem.getValue())).collect(Collectors.toList());
    }

    public String getDefaultKeyFields() {
        return "number,enddate";
    }

    protected void beforeSave(List<ImportBillData> datas, ImportLogger logger) {
        super.beforeSave(datas, logger);
        Iterator<ImportBillData> partList = datas.iterator();
        while (partList.hasNext()) {
            Date endDate;
            ImportBillData data = partList.next();
            String number = data.getData().getString("number");
            String taxrate = data.getData().getString("taxrate");
            Date startDate = data.getData().getDate("startdate");
            if (TaxcHscodeBusiness.checkGroupFieldUnique((String)number, (Date)startDate, (Date)(endDate = data.getData().getDate("enddate")))) {
                partList.remove();
                continue;
            }
            data.getData().putIfAbsent((Object)"issystem", (Object)"1");
            if (taxrate == null || !taxrate.contains(",")) continue;
            data.getData().put("taxrate", (Object)taxrate.split(",")[1]);
        }
    }
}

