/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.formplugin.taxproject;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bamp.bastax.common.util.StringUtil;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.AdminDivisionEdit;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;

public class TaxprojectEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String TAXORG = "taxorg";
    private static final String ORG = "org";
    private static final String ID = "id";
    public static final String SWQSYTFL = "swqsytfl";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit reporttype = (BasedataEdit)this.getControl(TAXORG);
        reporttype.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        DynamicObject accountOrg = (DynamicObject)this.getModel().getValue(ORG);
        if (StringUtil.equalsIgnoreCase((CharSequence)name, (CharSequence)TAXORG) && accountOrg != null) {
            Long accountOrgId = accountOrg.getLong(ID);
            List taxOrgIds = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"40", (Long)accountOrgId);
            QFilter idQFilter = new QFilter(ID, "in", (Object)taxOrgIds);
            ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            formShowParameter.getListFilterParameter().getQFilters().add(idQFilter);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map params;
        Object parentParam;
        Long accountOrgId;
        List taxOrgIds;
        DynamicObject accountOrg = (DynamicObject)this.getModel().getValue(ORG);
        if (accountOrg != null && (taxOrgIds = OrgUnitServiceHelper.getAllToOrg((String)"10", (String)"40", (Long)(accountOrgId = Long.valueOf(accountOrg.getLong(ID))))) != null && taxOrgIds.size() == 1) {
            this.getModel().setValue(TAXORG, taxOrgIds.get(0));
        }
        if ((parentParam = (params = this.getView().getFormShowParameter().getCustomParams()).get("tree_parent_id")) == null || !(parentParam instanceof Map)) {
            return;
        }
        Map parentParamMap = (Map)parentParam;
        Object value = parentParamMap.get("value");
        this.getModel().setValue("group", value);
        this.setMustInput("taxorgan", true);
        this.setMustInput("projectlocation", true);
        this.setMustInput("zsfs", true);
        this.setMustInput("syslzsl", true);
    }

    private void setMustInput(String key, boolean mustInput) {
        FieldEdit control = (FieldEdit)this.getControl(key);
        control.setMustInput(mustInput);
    }

    public void afterLoadData(EventObject e) {
        DynamicObject groupObj = (DynamicObject)this.getModel().getValue("group");
        if ("003".equals(groupObj.get("number"))) {
            ((BasedataEdit)this.getControl("taxorgan")).setMustInput(false);
            ((AdminDivisionEdit)this.getControl("projectlocation")).setMustInput(false);
            ((ComboEdit)this.getControl("zsfs")).setMustInput(false);
        } else {
            ((BasedataEdit)this.getControl("taxorgan")).setMustInput(true);
            ((AdminDivisionEdit)this.getControl("projectlocation")).setMustInput(true);
            ((ComboEdit)this.getControl("zsfs")).setMustInput(true);
        }
        String swqsytfl = (String)this.getModel().getValue(SWQSYTFL);
        if (StringUtil.isNotEmpty((CharSequence)swqsytfl)) {
            this.updateComboItems(swqsytfl);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        ChangeData cd = e.getChangeSet()[0];
        if (StringUtils.equals((CharSequence)SWQSYTFL, (CharSequence)fieldKey)) {
            this.updateComboItems((String)cd.getNewValue());
        }
    }

    public void updateComboItems(String newValue) {
        ComboEdit combo = (ComboEdit)this.getControl("swyt");
        ComboProp comboProp = (ComboProp)this.getModel().getProperty("swyt");
        List swytComboItems = comboProp.getComboItems();
        List comboItems = swytComboItems.stream().map(mapItem -> {
            ComboItem item = new ComboItem();
            item.setValue(mapItem.getValue());
            item.setCaption(mapItem.getName());
            return item;
        }).collect(Collectors.toList());
        if ("0".equals(newValue)) {
            comboItems.remove(3);
            combo.setComboItems(comboItems);
        } else if ("1".equals(newValue)) {
            combo.setComboItems(comboItems);
        }
    }

    public void beforePropertyChanged(PropertyChangedArgs e) {
        String fieldKey = e.getProperty().getName();
        if (SWQSYTFL.equals(fieldKey)) {
            boolean modifyExistBill;
            Object oldProject = e.getChangeSet()[0].getOldValue();
            Object newProject = e.getChangeSet()[0].getNewValue();
            String cancelFlag = this.getPageCache().get("cancelFlag");
            boolean bl = modifyExistBill = !"Boolean.TRUE".equals(cancelFlag) && oldProject != null;
            if (modifyExistBill && !newProject.equals(oldProject)) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(SWQSYTFL, oldProject);
                DynamicObjectCollection tdzzsCol = this.getModel().getEntryEntity("tdzzsentryentity");
                if (tdzzsCol != null && tdzzsCol.size() != 0) {
                    String jsonString = JSON.toJSONString(map);
                    String msg = ResManager.loadKDString((String)"\u4e0b\u65b9\u8868\u683c\u533a\u57df\u6240\u6709\u5185\u5bb9\u4f1a\u88ab\u6e05\u7a7a\uff0c\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f", (String)"TaxprojectEdit_0", (String)"bamp-bastax-formplugin", (Object[])new Object[0]);
                    ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(fieldKey, (IFormPlugin)this);
                    this.getView().showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBackListener, new HashMap(), jsonString);
                }
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callBackId = evt.getCallBackId();
        if (SWQSYTFL.equals(callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)evt.getResult())) {
                this.getModel().deleteEntryData("tdzzsentryentity");
            } else {
                JSONObject jsonObject;
                this.getPageCache().put("cancelFlag", "Boolean.TRUE");
                JSONObject map = jsonObject = JSONObject.parseObject((String)evt.getCustomVaule());
                this.getModel().setValue(SWQSYTFL, map.get(SWQSYTFL));
                this.getPageCache().put("cancelFlag", "Boolean.FALSE");
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String swqsytfl;
        super.beforeDoOperation(args);
        FormOperate source = (FormOperate)args.getSource();
        String key = source.getOperateKey();
        if ("newswytentry".equals(key) && StringUtil.isEmpty((CharSequence)(swqsytfl = (String)this.getModel().getValue(SWQSYTFL)))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u6e05\u7b97\u4e1a\u6001\u5206\u7c7b\u3002", (String)"TaxprojectEdit_1", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }
}

