/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.formplugin.taxview;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bamp.bastax.common.util.OrgUtils;
import kd.bamp.bastax.common.util.StringUtil;
import kd.bamp.bastax.formplugin.taxview.AbstractOrgViewPlugin;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class OrgViewCustomPlugin
extends AbstractOrgViewPlugin {
    private static final Log logger = LogFactory.getLog(OrgViewCustomPlugin.class);

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String viewId = (String)customParams.get("viewid");
        this.setModelValueByViewId(this.getModel(), viewId);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        this.getModel().setValue("lockflag", customParams.get("lockflag"));
        this.getModel().setDataChanged(false);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String viewId = (String)customParams.get("viewid");
        this.initOrgTreeByViewId(viewId);
    }

    private void initOrgTreeByViewId(String viewId) {
        Long id = 0L;
        if (!StringUtils.isEmpty((CharSequence)viewId)) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)viewId, (String)"tctb_org_view_custom");
            id = Long.parseLong(dynamicObject.getString("id"));
        }
        Long orgDefaultViewSchemaId = OrgUtils.getDefaultViewSchemaInfoId();
        this.getPageCache().put("mainViewId", orgDefaultViewSchemaId + "");
        Map unitTreeMap = OrgUtils.getAllOrgByViewId((Long)orgDefaultViewSchemaId);
        Map flatOrgTreeMap = OrgUtils.getOrgTreeMap((Map)unitTreeMap);
        TreeNode unitRoot = OrgUtils.createTreeNode((Map)unitTreeMap);
        if (unitRoot == null) {
            unitRoot = OrgUtils.createTreeNode((Map)unitTreeMap);
        } else {
            OrgUtils.createChildNodes((Map)flatOrgTreeMap, (String)unitRoot.getId(), (TreeNode)unitRoot);
        }
        if (unitRoot == null) {
            return;
        }
        this.bizunittree.addNode(unitRoot);
        this.getPageCache().put("bizunittree", SerializationUtils.toJsonString((Object)unitRoot));
        Map viewTreeMap = OrgUtils.getAllOrgByViewId((Long)id);
        Map flatOrgTreeMap2 = OrgUtils.getOrgTreeMap((Map)viewTreeMap);
        TreeNode viewRoot = OrgUtils.createTreeNode((Map)viewTreeMap);
        if (!this.getView().getFormShowParameter().getStatus().toString().equals(OperationStatus.ADDNEW)) {
            if (viewRoot == null) {
                viewRoot = OrgUtils.createTreeNode((Map)unitTreeMap);
            } else {
                OrgUtils.createChildNodes((Map)flatOrgTreeMap2, (String)viewRoot.getId(), (TreeNode)viewRoot);
                this.getView().setEnable(Boolean.FALSE, new String[]{"number", "name", "enable"});
            }
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{"enable"});
        this.bizviewtree.addNode(viewRoot);
        this.cacheTreeNode(unitRoot, viewRoot);
    }

    public void save(IFormView view) {
        DynamicObject dynamic;
        logger.info("\u3010OrgViewCustomPlugin\u3011\u5f00\u59cb\u6267\u884c\u7a0e\u52a1\u7ba1\u63a7\u89c6\u56fe\u4fdd\u5b58\u3002\u3002\u3002");
        long start = System.currentTimeMillis();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String viewId = (String)customParams.get("viewid");
        TreeNode treeNode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get("viewtreenode"), TreeNode.class);
        List childList = treeNode.getChildren();
        if (childList == null || childList.size() <= 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"OrgViewCustomPlugin_0", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
            return;
        }
        String number = (String)this.getModel().getValue("number");
        String name = (String)this.getModel().getValue("name");
        if (StringUtil.isEmpty((CharSequence)number) && StringUtil.isEmpty((CharSequence)name)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u7f16\u7801\u201d\u3001\u201c\u540d\u79f0\u201d\u3002", (String)"OrgViewCustomPlugin_1", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
            return;
        }
        if (StringUtil.isEmpty((CharSequence)number)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u7f16\u7801\u201d\u3002", (String)"OrgViewCustomPlugin_2", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
            return;
        }
        if (StringUtil.isEmpty((CharSequence)name)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u540d\u79f0\u201d\u3002", (String)"OrgViewCustomPlugin_3", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter filter = new QFilter("name", "=", (Object)name).or(new QFilter("number", "=", (Object)number));
        if (!StringUtils.isEmpty((CharSequence)viewId)) {
            filter = filter.and(new QFilter("id", "!=", (Object)Long.valueOf(viewId)));
        }
        if ((dynamic = QueryServiceHelper.queryOne((String)"tctb_org_view_custom", (String)"name,number", (QFilter[])new QFilter[]{filter})) != null) {
            if (number.equalsIgnoreCase(dynamic.getString("number"))) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u91cd\u590d\u3002", (String)"OrgViewCustomPlugin_4", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
                return;
            }
            if (name.equalsIgnoreCase(dynamic.getString("name"))) {
                view.showErrorNotification(ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u91cd\u590d\u3002", (String)"OrgViewCustomPlugin_5", (String)"bamp-bastax-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        Long pkId = this.saveViewAndOrgDuty();
        IPageCache pageCache1 = (IPageCache)view.getService(IPageCache.class);
        pageCache1.put("viewid", pkId.toString());
        logger.info("\u3010OrgViewCustomPlugin\u3011\u7ed3\u675f\u6267\u884c\u7a0e\u52a1\u7ba1\u63a7\u89c6\u56fe\u4fdd\u5b58\uff0c\u603b\u8017\u65f6:" + (System.currentTimeMillis() - start));
    }
}

