/*
 * Decompiled with CFR 0.152.
 */
package kd.bamp.bastax.business.hscode;

import java.util.Date;
import java.util.List;
import kd.bamp.bastax.business.hscode.TaxcHscodeDao;
import kd.bamp.bastax.business.hscode.TaxcHscodeService;
import kd.bamp.bastax.common.constant.HscodeConstant;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class TaxcHscodeBusiness {
    public static boolean queryTaxcHscodeIsSystemById(long id) {
        DynamicObject doc = TaxcHscodeDao.queryTaxcHscodeById(id);
        if (doc != null) {
            return TaxcHscodeService.filterIsSystem(doc, "1");
        }
        return Boolean.FALSE;
    }

    public static DynamicObject queryTaxcHscodeByNumber(String number) {
        DynamicObject doc = TaxcHscodeDao.queryTaxcHscodeByNumber(number);
        return doc;
    }

    public static DynamicObject[] queryTaxcHscodeByNumbers(List<String> numbers) {
        DynamicObject[] doc = TaxcHscodeDao.queryTaxcHscodeByNumbers(numbers);
        return doc;
    }

    public static DynamicObject[] queryTaxcHscodeByNumbers(List<String> numbers, Date effectiveDate) {
        DynamicObject[] docs = TaxcHscodeDao.queryTaxcHscodeByNumbers(numbers);
        return TaxcHscodeService.filterEffective(docs, effectiveDate);
    }

    public static DynamicObject[] queryTaxcHscodeByIds(List<Long> ids) {
        DynamicObject[] doc = TaxcHscodeDao.queryTaxcHscodeByIds(ids);
        return doc;
    }

    public static boolean checkGroupFieldUnique(DynamicObject obj) {
        QFilter filter = new QFilter("number", "=", (Object)obj.getString("number")).and("enable", "=", (Object)"1");
        QFilter startQfilter = new QFilter("startdate", ">=", (Object)obj.getDate("startdate")).and("startdate", "<=", (Object)obj.getDate("enddate"));
        QFilter endQfilter = new QFilter("enddate", ">=", (Object)obj.getDate("startdate")).and("startdate", "<=", (Object)obj.getDate("enddate"));
        filter.and(startQfilter.or(endQfilter));
        filter.and(HscodeConstant.ID, "!=", (Object)obj.getLong(HscodeConstant.ID));
        return QueryServiceHelper.exists((String)HscodeConstant.ENTITYNAME, (QFilter[])new QFilter[]{filter});
    }

    public static boolean checkGroupFieldUnique(DynamicObject obj, DynamicObject targetObj) {
        boolean isDuplicateNumber = StringUtils.equals((CharSequence)obj.getString("number"), (CharSequence)targetObj.getString("number"));
        boolean isOverlapTime = obj.getDate("startdate").after(targetObj.getDate("enddate")) || obj.getDate("enddate").before(targetObj.getDate("startdate"));
        return isDuplicateNumber && !isOverlapTime;
    }

    public static boolean checkGroupFieldUnique(String number, Date startDate, Date endDate) {
        QFilter filter = new QFilter("number", "=", (Object)number).and("enable", "=", (Object)"1").and("issystem", "=", (Object)"0");
        QFilter startQfilter = new QFilter("startdate", ">=", (Object)startDate).and("startdate", "<=", (Object)endDate);
        QFilter endQfilter = new QFilter("enddate", ">=", (Object)startDate).and("startdate", "<=", (Object)endDate);
        filter.and(startQfilter.or(endQfilter));
        return QueryServiceHelper.exists((String)HscodeConstant.ENTITYNAME, (QFilter[])new QFilter[]{filter});
    }
}

