/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.pbd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.GroupProp;
import kd.bos.entity.property.ParentBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.basedata.IBaseDataCtrlPlugin;
import kd.bos.servicehelper.org.OrgServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class PbdGroupStandardUtils {
    public static Set<Long> getGroupOrgId(String entity, Set<Long> useOrgs) {
        DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)entity);
        HashSet<Object> numberSets = new HashSet<Object>();
        ORM ormOv = ORM.create();
        if (ctrlview != null) {
            try (DataSet ds = ormOv.queryDataSet(PbdGroupStandardUtils.class.getName(), "bos_org_structure", "longnumber,org", new QFilter[]{new QFilter("org", "in", useOrgs), new QFilter("view.id", "=", (Object)ctrlview.getLong("id"))});){
                for (Row d : ds) {
                    String longnumber = d.getString("longnumber");
                    String[] numbers = longnumber.split("!");
                    numberSets.addAll(Arrays.asList((Object[])numbers.clone()));
                }
            }
        }
        HashSet<Long> orgIds = new HashSet<Long>();
        if (numberSets.size() > 0) {
            DataSet ds = ormOv.queryDataSet(PbdGroupStandardUtils.class.getName(), "bos_org", "id", new QFilter[]{new QFilter("number", "in", numberSets)});
            Object object = null;
            try {
                for (Row d : ds) {
                    orgIds.add(d.getLong("id"));
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (object != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        return orgIds;
    }

    public static Set<Long> getCreateOrgs(ListShowParameter param, String entityName, String useOrgId) {
        String createOrg = null;
        HashSet<Long> createOrgs = null;
        if (param.isLookUp()) {
            long createOrgId;
            Map customParams = param.getCustomParams();
            List col = (List)customParams.get("useOrgs");
            if (col != null && !col.isEmpty()) {
                createOrgs = new HashSet(col);
            }
            if (StringUtils.isBlank((CharSequence)(createOrg = (String)customParams.get("useOrg"))) && (createOrgId = param.getUseOrgId()) != 0L) {
                createOrg = createOrgId + "";
            }
        } else {
            if (StringUtils.isNotBlank((CharSequence)useOrgId)) {
                createOrg = useOrgId;
            }
            if (StringUtils.isBlank((CharSequence)createOrg)) {
                String appNumber = param.getAppId();
                createOrg = PbdGroupStandardUtils.getDefaultUseOrg(PbdGroupStandardUtils.getMasterDataOrg(entityName, appNumber));
            }
        }
        if (createOrgs == null || createOrgs.isEmpty()) {
            createOrgs = new HashSet<Long>();
            if (StringUtils.isBlank((CharSequence)createOrg)) {
                return createOrgs;
            }
            createOrgs.add(Long.valueOf(createOrg));
        }
        return createOrgs;
    }

    public static DynamicObjectCollection getMasterDataOrg(String entityType, String appNumber) {
        QFilter extendOrgQFilter;
        String orgFuncPro;
        long userId = RequestContext.get().getCurrUserId();
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appNumber, (String)entityType, (String)"47150e89000000ac");
        if (result == null) {
            return new DynamicObjectCollection();
        }
        String useOrgFunc = BaseDataServiceHelper.getUseOrgFunc((String)entityType);
        QFilter[] filters = null;
        QFilter idsFilter = new QFilter("org", "in", (Object)result.getHasPermOrgs());
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        if (!StringUtils.isEmpty((CharSequence)useOrgFunc) && StringUtils.isNotEmpty((CharSequence)(orgFuncPro = OrgServiceHelper.getOrgBizPro((String)useOrgFunc)))) {
            QFilter orgFuncFilter = new QFilter(orgFuncPro, "=", (Object)Boolean.TRUE);
            filterList.add(orgFuncFilter);
        }
        DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)entityType);
        ArrayList<Long> viewOrgIds = new ArrayList<Long>();
        String view = "";
        view = null == ctrlview ? "16" : ctrlview.getString("id");
        QFilter f2 = new QFilter("view.id", "=", (Object)Long.valueOf(view));
        QFilter f3 = new QFilter("isctrlunit", "=", (Object)Boolean.TRUE);
        QFilter[] qfilters = null;
        qfilters = result.hasAllOrgPerm() ? new QFilter[]{f2, f3} : new QFilter[]{f2, f3, idsFilter};
        DynamicObject[] viewOrgs = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)"org", (QFilter[])qfilters);
        if (null == viewOrgs) {
            return new DynamicObjectCollection();
        }
        for (DynamicObject viewOrg : viewOrgs) {
            if (viewOrg.getDynamicObject("org") == null) continue;
            viewOrgIds.add((Long)viewOrg.getDynamicObject("org").getPkValue());
        }
        idsFilter = new QFilter("id", "in", viewOrgIds);
        filterList.add(idsFilter);
        IBaseDataCtrlPlugin baseDataCtrlPlugin = BaseDataServiceHelper.getBaseDataCtrlPlugin((String)entityType);
        if (baseDataCtrlPlugin != null && (extendOrgQFilter = baseDataCtrlPlugin.getExtendOrgQFilter()) != null) {
            filterList.add(extendOrgQFilter);
        }
        filters = filterList.toArray(new QFilter[0]);
        DynamicObjectCollection col = QueryServiceHelper.query((String)"bos_org", (String)"id,name", (QFilter[])filters);
        return col;
    }

    private static String getDefaultUseOrg(DynamicObjectCollection col) {
        String defaultUseOrg = null;
        long longinOrg = RequestContext.get().getOrgId();
        boolean flag = false;
        if (col != null && col.size() > 0) {
            for (DynamicObject row : col) {
                if (longinOrg != row.getLong("id")) continue;
                defaultUseOrg = String.valueOf(longinOrg);
                flag = true;
                break;
            }
            return flag ? defaultUseOrg : String.valueOf(((DynamicObject)col.get(0)).get("id"));
        }
        return defaultUseOrg;
    }

    public static Long getDataByType(Object object) {
        Long dataId = 0L;
        if (object instanceof DynamicObject) {
            DynamicObject baseData = (DynamicObject)object;
            dataId = (Long)baseData.getPkValue();
        } else if (object instanceof Long) {
            dataId = (Long)object;
        }
        return dataId;
    }

    public static long getMaterialGroupType(String entity) {
        if (StringUtils.isNotBlank((CharSequence)entity)) {
            return 730148448254487552L;
        }
        throw new KDBizException("entity is required!");
    }

    public static Map<? extends Long, ? extends Set<Long>> getGroupOrgMap(String entity, Set<Long> createOrgs) {
        DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)entity);
        HashSet<Object> numberSets = new HashSet<Object>();
        HashMap<String, Long> numberToCreateOrg = new HashMap<String, Long>();
        HashMap<Long, HashSet<Long>> resultMap = new HashMap<Long, HashSet<Long>>();
        ORM ormOv = ORM.create();
        try (DataSet ds = ormOv.queryDataSet(PbdGroupStandardUtils.class.getName(), "bos_org_structure", "longnumber,org", new QFilter[]{new QFilter("org", "in", createOrgs), new QFilter("view.id", "=", (Object)ctrlview.getLong("id"))});){
            for (Row d : ds) {
                String longnumber = d.getString("longnumber");
                String[] numbers = longnumber.split("!");
                numberSets.addAll(Arrays.asList((Object[])numbers.clone()));
                for (String number : numbers) {
                    numberToCreateOrg.put(number, d.getLong("org"));
                }
            }
        }
        if (numberSets.size() > 0) {
            ds = ormOv.queryDataSet(PbdGroupStandardUtils.class.getName(), "bos_org", "id,number", new QFilter[]{new QFilter("number", "in", numberSets)});
            var8_8 = null;
            try {
                for (Row d : ds) {
                    Long createOrgId = (Long)numberToCreateOrg.get(d.getString("number"));
                    if (createOrgId == null) continue;
                    HashSet<Long> orgIdList = (HashSet<Long>)resultMap.get(createOrgId);
                    if (orgIdList == null) {
                        orgIdList = new HashSet<Long>();
                        resultMap.put(createOrgId, orgIdList);
                    }
                    orgIdList.add(d.getLong("id"));
                }
            }
            catch (Throwable throwable) {
                var8_8 = throwable;
                throw throwable;
            }
            finally {
                if (ds != null) {
                    if (var8_8 != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable throwable) {
                            var8_8.addSuppressed(throwable);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
        }
        return resultMap;
    }

    public static List<Long> queryGroupsByGroupId(String entity, Object standardId, Object id, Set<Long> useOrgs) {
        if (id == null) {
            return null;
        }
        ArrayList<Long> list = new ArrayList<Long>();
        Long dataId = Long.valueOf(id.toString());
        DynamicObject group = BusinessDataServiceHelper.loadSingleFromCache((String)entity, (String)"longnumber,parent", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)dataId)});
        list.add(dataId);
        if (group == null) {
            return list;
        }
        String longNumberDlm = ".";
        MainEntityType dataEntityType = (MainEntityType)group.getDataEntityType();
        DynamicProperty property = dataEntityType.getProperty("parent");
        GroupProp grop = (GroupProp)property;
        if (grop instanceof ParentBasedataProp) {
            longNumberDlm = ((ParentBasedataProp)grop).getLongNumberDLM();
        }
        String longnumber = group.getString("longnumber");
        QFilter f1 = new QFilter("longnumber", "like", (Object)(longnumber + longNumberDlm + "%"));
        QFilter f2 = new QFilter("standard", "=", (Object)Long.valueOf(standardId.toString()));
        f1.and(f2);
        if (useOrgs != null) {
            QFilter f3 = new QFilter("createorg", "in", useOrgs);
            f1.and(f3);
        }
        ORM ormOv = ORM.create();
        DataSet ds = ormOv.queryDataSet(PbdGroupStandardUtils.class.getName(), entity, "id", new QFilter[]{f1});
        for (Row d : ds) {
            list.add(d.getLong("id"));
        }
        return list;
    }

    public static Map<Long, Long> getMaterialToGroupInStd(Set<Long> materialSets, String entity) {
        HashMap<Long, Long> materialGroupMap = new HashMap<Long, Long>(materialSets.size());
        if (materialSets != null) {
            QFilter mQfilter = new QFilter("material", "in", materialSets);
            mQfilter.and("standard", "=", (Object)PbdGroupStandardUtils.getMaterialGroupType(entity));
            Map materialGroupDetails = BusinessDataServiceHelper.loadFromCache((String)"bd_materialgroupdetail", (String)"standard,group,createorg,material", (QFilter[])new QFilter[]{mQfilter});
            for (DynamicObject value : materialGroupDetails.values()) {
                Long material = PbdGroupStandardUtils.getDataByType(value.get("material"));
                Long group = PbdGroupStandardUtils.getDataByType(value.get("group"));
                materialGroupMap.put(material, group);
            }
        }
        return materialGroupMap;
    }
}

