/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.pbd.sdk;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sdk.bd.basedata.service.SuppChangeBizpartnerService;

public class SrmSuppChangeBizpartnerServiceImpl
implements SuppChangeBizpartnerService {
    private Log log = LogFactory.getLog(this.getClass());
    private static final String SrmBillTableName = "T_PUR_REGSUPPLIER";
    private static final String PurBillTableName = "T_PUR_ORDER";
    private static final String MalBillTableName = "T_MAL_SUPENTER";
    private static final String SouBillTableName = "T_PUR_QUOTE";
    private static final String SrcBillTableName = "T_SRC_PROJECT";
    private static final String ScmSupplierName = "FSUPPLIERID";
    private static final String ScmBizpartnerName = "FBIZPARTNERID";

    public Set<Long> checkSrmDataReference(Map<Long, Long> checkDatas) {
        HashSet<Long> supplierIdSet = new HashSet<Long>(16);
        HashSet<Long> bizpartnerIdSet = new HashSet<Long>(16);
        for (Map.Entry<Long, Long> entry : checkDatas.entrySet()) {
            supplierIdSet.add(entry.getKey());
            bizpartnerIdSet.add(entry.getValue());
        }
        if (supplierIdSet != null && !supplierIdSet.isEmpty() && bizpartnerIdSet != null && !bizpartnerIdSet.isEmpty()) {
            this.checkSrmDatas(SrmBillTableName, ScmSupplierName, ScmBizpartnerName, checkDatas, supplierIdSet, bizpartnerIdSet);
        }
        if (supplierIdSet != null && !supplierIdSet.isEmpty() && bizpartnerIdSet != null && !bizpartnerIdSet.isEmpty()) {
            this.checkSrmDatas(PurBillTableName, ScmSupplierName, ScmBizpartnerName, checkDatas, supplierIdSet, bizpartnerIdSet);
        }
        if (supplierIdSet != null && !supplierIdSet.isEmpty() && bizpartnerIdSet != null && !bizpartnerIdSet.isEmpty()) {
            this.checkSrmDatas(MalBillTableName, ScmSupplierName, ScmBizpartnerName, checkDatas, supplierIdSet, bizpartnerIdSet);
        }
        if (supplierIdSet != null && !supplierIdSet.isEmpty() && bizpartnerIdSet != null && !bizpartnerIdSet.isEmpty()) {
            this.checkSrmDatas(SouBillTableName, ScmSupplierName, ScmBizpartnerName, checkDatas, supplierIdSet, bizpartnerIdSet);
        }
        this.log.info("supplierIdSet\uff1a" + supplierIdSet);
        return supplierIdSet;
    }

    private void checkSrmDatas(String tableName, String supplierName, String bizpartnerName, Map<Long, Long> checkDatas, Set<Long> supplierIdSet, Set<Long> bizpartnerIdSet) {
        DBRoute purdbRoute = new DBRoute("pur");
        String querysql = " select distinct " + supplierName + "," + bizpartnerName + " from  " + tableName + " where " + bizpartnerName + " in  " + this.getBizpartnerFilter(bizpartnerIdSet);
        DataSet bizpartnerDataSet = DB.queryDataSet((String)"bizpartnerfix", (DBRoute)purdbRoute, (String)querysql);
        while (bizpartnerDataSet.hasNext()) {
            Row next = bizpartnerDataSet.next();
            Object supObject = next.get(supplierName);
            Object bizpartnerObject = next.get(bizpartnerName);
            if (supObject == null || bizpartnerObject == null) continue;
            Long curSupplier = Long.parseLong(supObject.toString());
            Long curBizpartner = Long.parseLong(bizpartnerObject.toString());
            if (!checkDatas.containsKey(curSupplier) || !curBizpartner.equals(checkDatas.get(curSupplier))) continue;
            supplierIdSet.remove(curSupplier);
        }
    }

    private String getBizpartnerFilter(Set<Long> bizpartnerIdSet) {
        StringBuilder bizpartnerFilter = new StringBuilder("(");
        boolean first = true;
        for (Long bizpartnerId : bizpartnerIdSet) {
            if (!first) {
                bizpartnerFilter.append(",");
            }
            bizpartnerFilter.append(bizpartnerId);
            first = false;
        }
        bizpartnerFilter.append(")");
        return bizpartnerFilter.toString();
    }
}

