/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata;

import java.util.Date;
import java.util.List;
import kd.bd.assistant.helper.BizLogHelper;
import kd.bd.assistant.plugin.basedata.FinOrgResInValidator;
import kd.bd.assistant.plugin.helper.BankCateHelper;
import kd.bd.assistant.plugin.helper.FinOperateServiceHelper;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class FinOrgResInOp
extends AbstractOperationServicePlugIn {
    public static final String BOS_BD_OPPLUGIN = "bos-bd-opplugin";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("number");
        fieldKeys.add("name");
        fieldKeys.add("name_eng");
        fieldKeys.add("country");
        fieldKeys.add("province");
        fieldKeys.add("city");
        fieldKeys.add("address");
        fieldKeys.add("telephone");
        fieldKeys.add("fax");
        fieldKeys.add("union_number");
        fieldKeys.add("swift_code");
        fieldKeys.add("routingnum");
        fieldKeys.add("other_code");
        fieldKeys.add("address_eng");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new FinOrgResInValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        Date currTime = new Date();
        String userId = RequestContext.get().getUserId();
        for (DynamicObject data : e.getDataEntities()) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"bd_finorginfo");
            DynamicObject finOrgInfo = new DynamicObject((DynamicObjectType)entityType);
            String unionNumber = data.getString("union_number");
            String name = data.getString("name");
            DynamicObject bankCate = BankCateHelper.findBankCate((String)name, (String)unionNumber);
            if (bankCate != null) {
                finOrgInfo.set("bank_cate", (Object)bankCate);
                finOrgInfo.set("logo", (Object)bankCate.getString("logo"));
            }
            QFilter bankFinOrgTypeFilter = new QFilter("type", "=", (Object)"0");
            DynamicObject bankType = BusinessDataServiceHelper.loadSingle((String)"bd_finorgtype", (String)"id,type", (QFilter[])new QFilter[]{bankFinOrgTypeFilter});
            finOrgInfo.set("finorgtype", (Object)bankType);
            finOrgInfo.set("name", (Object)data.getLocaleString("name").getLocaleValue());
            finOrgInfo.set("name_eng", (Object)data.getString("name_eng"));
            finOrgInfo.set("address", (Object)data.getString("address"));
            finOrgInfo.set("telephone", (Object)data.getString("telephone"));
            finOrgInfo.set("fax", (Object)data.getString("fax"));
            finOrgInfo.set("union_number", (Object)data.getString("union_number"));
            finOrgInfo.set("swift_code", (Object)data.getString("swift_code"));
            finOrgInfo.set("routingnum", (Object)data.getString("routingnum"));
            finOrgInfo.set("address_eng", (Object)data.getString("address_eng"));
            finOrgInfo.set("other_code", (Object)data.getString("other_code"));
            finOrgInfo.set("country", (Object)data.getDynamicObject("country"));
            finOrgInfo.set("province", (Object)data.getDynamicObject("province"));
            finOrgInfo.set("city", (Object)data.getDynamicObject("city"));
            finOrgInfo.set("bebank", data.getPkValue());
            finOrgInfo.set("creator", (Object)userId);
            finOrgInfo.set("createtime", (Object)currTime);
            finOrgInfo.set("modifier", (Object)userId);
            finOrgInfo.set("modifytime", (Object)currTime);
            finOrgInfo.set("enable", (Object)"1");
            finOrgInfo.set("enable_time", (Object)new Date());
            finOrgInfo.set("status", (Object)"C");
            finOrgInfo.set("parent", null);
            OperationResult opRes = FinOperateServiceHelper.execOperate((String)"save", (String)entityType.getName(), (DynamicObject[])new DynamicObject[]{finOrgInfo}, (OperateOption)OperateOption.create());
            Object pk = opRes.getSuccessPkIds().get(0);
            DynamicObject newFinOrgInfo = BusinessDataServiceHelper.loadSingle(pk, (String)entityType.getName());
            String logMsg = String.format(ResManager.loadKDString((String)"\u7f16\u53f7%1$s, %2$s\u6210\u529f", (String)"FinOrgResInOp_0", (String)BOS_BD_OPPLUGIN, (Object[])new Object[0]), newFinOrgInfo.getString("number"), ResManager.loadKDString((String)"\u8d44\u6e90\u5f15\u5165", (String)"FinOrgResInOp_1", (String)BOS_BD_OPPLUGIN, (Object[])new Object[0]));
            BizLogHelper.addLog(null, "bd_finorginfo", ResManager.loadKDString((String)"\u8d44\u6e90\u5f15\u5165", (String)"FinOrgResInOp_1", (String)BOS_BD_OPPLUGIN, (Object[])new Object[0]), logMsg, 0L);
        }
    }
}

