/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.basedata.BaseDataResponse;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class BdCtrlImportAssignService {
    private static final String CONSUME_TIMES = "consumetimes";
    private static final String CONSUME_TIME = "consumetime";
    private static final String CONSUME_STATUS = "consumestatus";
    private static final String FAIL_LOG = "faillog";
    private static final String BOS_BD_OP_PLUGIN = "bos_bd_opplugin";
    private static final String BD_ASSIGN_IMPORT = "bd_assign_import";

    /*
     * WARNING - void declaration
     */
    public static void assignDatas(DynamicObject[] objs) {
        if (objs == null || objs.length == 0) {
            return;
        }
        HashMap<String, void> identifyMap = new HashMap<String, void>(8);
        for (DynamicObject obj : objs) {
            void var7_9;
            String datatype = obj.getString("datatype");
            if (StringUtils.isEmpty((String)datatype)) continue;
            List list = (List)identifyMap.get(datatype);
            if (CollectionUtils.isEmpty((Collection)list)) {
                ArrayList arrayList = new ArrayList(8);
            }
            var7_9.add(obj);
            identifyMap.put(datatype, var7_9);
        }
        if (CollectionUtils.isEmpty(identifyMap)) {
            return;
        }
        for (Map.Entry entry : identifyMap.entrySet()) {
            Long orgId;
            List objectList = (List)entry.getValue();
            if (CollectionUtils.isEmpty((Collection)objectList)) continue;
            HashMap<Long, ArrayList<DynamicObject>> orgGroupMap = new HashMap<Long, ArrayList<DynamicObject>>(8);
            for (DynamicObject dynamicObject : objectList) {
                if (dynamicObject == null) continue;
                orgId = dynamicObject.getLong("assignorg.id");
                ArrayList<DynamicObject> numberList = (ArrayList<DynamicObject>)orgGroupMap.get(orgId);
                if (CollectionUtils.isEmpty((Collection)numberList)) {
                    numberList = new ArrayList<DynamicObject>(8);
                }
                numberList.add(dynamicObject);
                orgGroupMap.put(orgId, numberList);
            }
            if (CollectionUtils.isEmpty(orgGroupMap)) continue;
            for (Map.Entry entry2 : orgGroupMap.entrySet()) {
                Map<String, Set<Long>> dataMap;
                String appId;
                orgId = (Long)entry2.getKey();
                List dynamicObjectList = (List)entry2.getValue();
                if (CollectionUtils.isEmpty((Collection)dynamicObjectList)) continue;
                DynamicObject object = (DynamicObject)dynamicObjectList.get(0);
                String entityId = object.getString("datatype");
                BaseDataResponse response = BaseDataServiceHelper.assign((String)entityId, (Long)orgId, (String)(appId = BdCtrlImportAssignService.getAppId(entityId)), (dataMap = BdCtrlImportAssignService.getDataFileId(dynamicObjectList)).get("dataIds"), dataMap.get("userOrgIds"));
                if (response.isSuccess() && CollectionUtils.isEmpty((Map)response.getResult())) {
                    BdCtrlImportAssignService.assignSuccess(dynamicObjectList);
                    continue;
                }
                BdCtrlImportAssignService.assignError(dynamicObjectList, entityId, appId, orgId);
            }
        }
    }

    private static void assignSuccess(List<DynamicObject> objectList) {
        DynamicObject[] dataArr = new DynamicObject[objectList.size()];
        int count = 0;
        for (DynamicObject object : objectList) {
            object.set(CONSUME_TIME, (Object)new Date());
            object.set(CONSUME_TIMES, (Object)(object.getInt(CONSUME_TIMES) + 1));
            object.set(CONSUME_STATUS, (Object)1);
            object.set(FAIL_LOG, (Object)" ");
            dataArr[count] = object;
            ++count;
        }
        SaveServiceHelper.save((DynamicObject[])dataArr);
    }

    private static void assignError(List<DynamicObject> objectList, String entityId, String appId, Long orgId) {
        for (DynamicObject object : objectList) {
            Long dataId = object.getLong("data.id");
            Long userOrgId = object.getLong("useorg.id");
            if (dataId == null || userOrgId == null) continue;
            HashSet<Long> dataIds = new HashSet<Long>(1);
            dataIds.add(dataId);
            HashSet<Long> userOrgIds = new HashSet<Long>(1);
            userOrgIds.add(userOrgId);
            BaseDataResponse response = BaseDataServiceHelper.assign((String)entityId, (Long)orgId, (String)appId, dataIds, userOrgIds);
            if (response.isSuccess()) {
                ArrayList<DynamicObject> ob = new ArrayList<DynamicObject>(1);
                ob.add(object);
                BdCtrlImportAssignService.assignSuccess(ob);
                continue;
            }
            String errorMsg = response.getErrorMsg();
            errorMsg = String.format(ResManager.loadKDString((String)"\u5206\u914d\u5931\u8d25%s", (String)"BdCtrlImportAssignListPlugin_4", (String)"bd-assistant-opplugin", (Object[])new Object[0]), errorMsg);
            if (errorMsg.length() > 255) {
                errorMsg = errorMsg.substring(0, 200);
            }
            object.set(CONSUME_TIME, (Object)new Date());
            object.set(CONSUME_TIMES, (Object)(object.getInt(CONSUME_TIMES) + 1));
            object.set(CONSUME_STATUS, (Object)-1);
            object.set(FAIL_LOG, (Object)errorMsg);
            DynamicObject[] dataArr = new DynamicObject[]{object};
            SaveServiceHelper.save((DynamicObject[])dataArr);
        }
    }

    private static Map<String, Set<Long>> getDataFileId(List<DynamicObject> objectList) {
        HashSet<Long> fdataList = new HashSet<Long>(objectList.size());
        HashSet<Long> userorgList = new HashSet<Long>(objectList.size());
        for (DynamicObject object : objectList) {
            fdataList.add(object.getLong("data.id"));
            userorgList.add(object.getLong("useorg.id"));
        }
        HashMap<String, Set<Long>> dataMap = new HashMap<String, Set<Long>>(2);
        dataMap.put("dataIds", fdataList);
        dataMap.put("userOrgIds", userorgList);
        return dataMap;
    }

    private static String getAppId(String entityType) {
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)entityType);
        if (met == null || met.getAppId() == null) {
            return null;
        }
        return met.getAppId();
    }

    public static int deleteAssignSuccessDatas() {
        QFilter[] filters = new QFilter[]{new QFilter(CONSUME_STATUS, "=", (Object)"1")};
        return DeleteServiceHelper.delete((String)BD_ASSIGN_IMPORT, (QFilter[])filters);
    }
}

