/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.gmc.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class UserUtil {
    public static Object getUserID() {
        return Long.parseLong(RequestContext.get().getUserId());
    }

    public static List<Object> getOwnerIDs() {
        return UserUtil.getOwnerIDs(UserUtil.getUserID());
    }

    public static Object getDefaultOwnerID() {
        List<Object> ownerIDs = UserUtil.getOwnerIDs();
        if (ownerIDs.size() == 0) {
            return 0L;
        }
        return ownerIDs.get(0);
    }

    public static List<Object> getOwnerIDs(Object userId) {
        QFilter fs = new QFilter("sysuser", "=", userId);
        fs.and("enable", "=", (Object)"1");
        fs.and("owner.status", "=", (Object)"C");
        fs.and("owner.enable", "=", (Object)"1");
        Map userInfos = BusinessDataServiceHelper.loadFromCache((String)"dbd_drp_user", (QFilter[])fs.toArray());
        ArrayList<Object> owners = new ArrayList<Object>(userInfos.size());
        if (userInfos.isEmpty()) {
            return owners;
        }
        Object defaultId = null;
        Object id = null;
        DynamicObject owner = null;
        for (DynamicObject userInfo : userInfos.values()) {
            owner = userInfo.getDynamicObject("owner");
            if (owner == null) continue;
            id = owner.getPkValue();
            if (defaultId == null && userInfo.getBoolean("isdefault")) {
                defaultId = id;
                continue;
            }
            owners.add(id);
        }
        if (defaultId != null) {
            if (owners.isEmpty()) {
                owners.add(defaultId);
            } else {
                Object tempId = owners.get(0);
                owners.add(0, defaultId);
                owners.add(tempId);
            }
        }
        return owners;
    }

    public static QFilter getOwnerIdsQFilter(String filed) {
        return new QFilter(filed, "in", UserUtil.getOwnerIDs());
    }
}

