/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.assistant.api.MaterialCategoryService;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;

public class MaterialCategoryServiceImpl
implements MaterialCategoryService {
    private static Log logger = LogFactory.getLog(MaterialCategoryServiceImpl.class);

    public Map<Long, Map<Long, Long>> getMaterialCategoryByOrgAndMaterial(Map<Long, Set<Long>> orgMaterialIdMap) {
        logger.info("\u7269\u6599\u6838\u7b97\u4fe1\u606f\u4f20\u5165\u53c2\u6570" + orgMaterialIdMap);
        if (orgMaterialIdMap == null || orgMaterialIdMap.isEmpty()) {
            logger.info("\u7269\u6599\u6838\u7b97\u4fe1\u606f\u8fd4\u56de\u53c2\u6570" + null);
            return null;
        }
        try (AlgoContext context = Algo.newContext();){
            Map<Long, Map<Long, Long>> map;
            HashSet<Long> hasMaterialOrgIds = new HashSet<Long>(16);
            HashSet<Long> noMaterialOrgIds = new HashSet<Long>(16);
            HashSet<Long> materialids = new HashSet<Long>(16);
            for (Map.Entry<Long, Set<Long>> longSetEntry : orgMaterialIdMap.entrySet()) {
                Long orgid = longSetEntry.getKey();
                Set<Long> set = longSetEntry.getValue();
                if (set == null) {
                    noMaterialOrgIds.add(orgid);
                    continue;
                }
                hasMaterialOrgIds.add(orgid);
                materialids.addAll(set);
            }
            DataSet ds = this.getMaterialCalInfoDSByOrgMaterial(hasMaterialOrgIds, materialids, noMaterialOrgIds);
            Map<Long, Map<Long, Long>> map2 = map = this.resolveMaterialCalInfoDS2Category(ds, orgMaterialIdMap);
            return map2;
        }
    }

    private Map<Long, Map<Long, Long>> resolveMaterialCalInfoDS2Category(DataSet ds, Map<Long, Set<Long>> orgMaterialIdMap) {
        Long createorg;
        HashMap<Long, Long> publicMap = new HashMap<Long, Long>(16);
        HashMap<Long, Map<Long, Long>> resultMap = new HashMap<Long, Map<Long, Long>>(16);
        for (Row row : ds) {
            createorg = row.getLong("createorg");
            Long masterid = row.getLong("masterid");
            String ctrlstrategy = row.getString("ctrlstrategy");
            Long materialCategory = row.getLong("group");
            if ("5".equals(ctrlstrategy)) {
                publicMap.put(masterid, materialCategory);
                continue;
            }
            if (!"7".equals(ctrlstrategy)) continue;
            Map map = resultMap.computeIfAbsent(createorg, k -> new HashMap(16));
            Set<Long> materialids = orgMaterialIdMap.get(createorg);
            if (materialids != null && !materialids.contains(masterid)) continue;
            map.put(masterid, materialCategory);
        }
        if (publicMap.isEmpty()) {
            return resultMap;
        }
        for (Map.Entry<Long, Set<Long>> longSetEntry : orgMaterialIdMap.entrySet()) {
            createorg = longSetEntry.getKey();
            Set<Long> materialids = longSetEntry.getValue();
            Map map = resultMap.computeIfAbsent(createorg, k -> new HashMap(16));
            if (materialids == null) {
                map.putAll(publicMap);
                continue;
            }
            for (Long materialid : materialids) {
                Long materialCategory = (Long)publicMap.get(materialid);
                if (materialCategory == null) continue;
                map.put(materialid, materialCategory);
            }
        }
        return resultMap;
    }

    private DataSet getMaterialCalInfoDSByOrgMaterial(Set<Long> hasMaterialOrgIds, Set<Long> materialids, Set<Long> noMaterialOrgIds) {
        ArrayList<Input> inputs = new ArrayList<Input>(16);
        HashSet<Long> batchMatIds = new HashSet<Long>(16);
        QFilter filter = new QFilter("status", "=", (Object)"C");
        boolean needQueryAllShare = true;
        if (noMaterialOrgIds != null && !noMaterialOrgIds.isEmpty()) {
            inputs.addAll(this.getInputsByMaterialFilter(filter, noMaterialOrgIds, null, needQueryAllShare));
            needQueryAllShare = false;
        }
        for (Long materialid : materialids) {
            batchMatIds.add(materialid);
            if (batchMatIds.size() < 50000) continue;
            inputs.addAll(this.getInputsByMaterialFilter(filter, hasMaterialOrgIds, batchMatIds, needQueryAllShare));
            batchMatIds = new HashSet(50000);
        }
        inputs.addAll(this.getInputsByMaterialFilter(filter, hasMaterialOrgIds, batchMatIds, needQueryAllShare));
        DataSet ds = Algo.create((String)this.getClass().getName()).createDataSet((Input[])inputs.toArray(new OrmInput[inputs.size()]));
        return ds;
    }

    private List<Input> getInputsByMaterialFilter(QFilter filter, Set<Long> orgIds, Set<Long> materialIds, boolean needQueryAllShare) {
        ArrayList<Input> inputs = new ArrayList<Input>(4);
        QFilter privateFilter = new QFilter("createorg", "in", orgIds);
        if (materialIds != null) {
            privateFilter.and("masterid", "in", materialIds);
        }
        privateFilter.and("ctrlstrategy", "=", (Object)"7");
        privateFilter.and(filter);
        OrmInput input1 = new OrmInput(this.getClass().getName(), "bd_materialcalinfo", "createorg,masterid,ctrlstrategy,group", privateFilter.toArray());
        inputs.add((Input)input1);
        if (!needQueryAllShare) {
            return inputs;
        }
        QFilter shareFilter = new QFilter("ctrlstrategy", "=", (Object)"5");
        if (materialIds != null) {
            shareFilter.and("masterid", "in", materialIds);
        }
        shareFilter.and(filter);
        OrmInput input2 = new OrmInput(this.getClass().getName(), "bd_materialcalinfo", "createorg,masterid,ctrlstrategy,group", shareFilter.toArray());
        inputs.add((Input)input2);
        return inputs;
    }

    public Map<Long, Map<Long, Set<Long>>> getMaterialByOrgAndMaterialCategory(Map<Long, Set<Long>> orgMaterialCategoryIdMap) {
        logger.info("\u7269\u6599\u6838\u7b97\u4fe1\u606f\u4f20\u5165\u53c2\u6570" + orgMaterialCategoryIdMap);
        if (orgMaterialCategoryIdMap == null || orgMaterialCategoryIdMap.isEmpty()) {
            logger.info("\u7269\u6599\u6838\u7b97\u4fe1\u606f\u8fd4\u56de\u53c2\u6570" + null);
            return null;
        }
        HashSet<Long> hasCategoryOrgIds = new HashSet<Long>(16);
        HashSet<Long> noCategoryOrgIds = new HashSet<Long>(16);
        HashSet<Long> allMaterialCategoryIds = new HashSet<Long>(16);
        for (Map.Entry<Long, Set<Long>> longSetEntry : orgMaterialCategoryIdMap.entrySet()) {
            if (longSetEntry.getValue() == null) {
                noCategoryOrgIds.add(longSetEntry.getKey());
                continue;
            }
            hasCategoryOrgIds.add(longSetEntry.getKey());
            allMaterialCategoryIds.addAll((Collection<Long>)longSetEntry.getValue());
        }
        try (DataSet ds = this.getMaterialCalInfoDSByOrgMaterialCategory(hasCategoryOrgIds, allMaterialCategoryIds, noCategoryOrgIds);){
            Map<Long, Map<Long, Set<Long>>> resultMap;
            Map<Long, Map<Long, Set<Long>>> map = resultMap = this.resolveMaterialCalInfoDS2Material(ds, orgMaterialCategoryIdMap);
            return map;
        }
    }

    private Map<Long, Map<Long, Set<Long>>> resolveMaterialCalInfoDS2Material(DataSet ds, Map<Long, Set<Long>> orgMaterialCategoryIdMap) {
        HashMap<Long, Set> publicMap = new HashMap<Long, Set>(16);
        HashMap<Long, Map<Long, Set<Long>>> resultMap = new HashMap<Long, Map<Long, Set<Long>>>(16);
        for (Row row : ds) {
            Set<Long> set;
            Long createorg = row.getLong("createorg");
            Long masterid = row.getLong("masterid");
            String ctrlstrategy = row.getString("ctrlstrategy");
            Long materialCategory = row.getLong("group");
            if ("5".equals(ctrlstrategy)) {
                Set set2 = publicMap.computeIfAbsent(materialCategory, k -> new HashSet(16));
                set2.add(masterid);
                continue;
            }
            if (!"7".equals(ctrlstrategy) || (set = orgMaterialCategoryIdMap.get(createorg)) != null && !set.contains(materialCategory)) continue;
            Map map = resultMap.computeIfAbsent(createorg, k -> new HashMap(16));
            Set materialids = map.computeIfAbsent(materialCategory, k -> new HashSet(16));
            materialids.add(masterid);
        }
        if (publicMap.isEmpty()) {
            return resultMap;
        }
        for (Map.Entry<Long, Set<Long>> longSetEntry : orgMaterialCategoryIdMap.entrySet()) {
            Set materialids;
            Long orgid = longSetEntry.getKey();
            Set<Long> materialCategorys = longSetEntry.getValue();
            Map map = resultMap.computeIfAbsent(orgid, k -> new HashMap(16));
            if (materialCategorys == null) {
                for (Map.Entry entry : publicMap.entrySet()) {
                    materialids = map.computeIfAbsent(entry.getKey(), k -> new HashSet(16));
                    materialids.addAll((Collection)entry.getValue());
                }
                continue;
            }
            for (Long l : materialCategorys) {
                if (publicMap.get(l) == null) continue;
                materialids = map.computeIfAbsent(l, k -> new HashSet(16));
                materialids.addAll((Collection)publicMap.get(l));
            }
        }
        return resultMap;
    }

    private DataSet getMaterialCalInfoDSByOrgMaterialCategory(Set<Long> hasCategoryOrgIds, Set<Long> allMaterialCategoryIds, Set<Long> noCategoryOrgIds) {
        ArrayList<Input> inputs = new ArrayList<Input>(16);
        QFilter filter = new QFilter("status", "=", (Object)"C");
        boolean needQueryAllShare = true;
        if (noCategoryOrgIds != null && !noCategoryOrgIds.isEmpty()) {
            inputs.addAll(this.getInputsByMaterialCategoryFilter(filter, noCategoryOrgIds, null, true));
        }
        inputs.addAll(this.getInputsByMaterialCategoryFilter(filter, hasCategoryOrgIds, allMaterialCategoryIds, needQueryAllShare));
        DataSet ds = Algo.create((String)this.getClass().getName()).createDataSet((Input[])inputs.toArray(new OrmInput[inputs.size()]));
        return ds;
    }

    private List<Input> getInputsByMaterialCategoryFilter(QFilter filter, Set<Long> orgIds, Set<Long> materialCategoryIds, boolean needQueryAllShare) {
        ArrayList<Input> inputs = new ArrayList<Input>(4);
        QFilter privateFilter = new QFilter("createorg", "in", orgIds);
        if (materialCategoryIds != null) {
            privateFilter.and("group", "in", materialCategoryIds);
        }
        privateFilter.and("ctrlstrategy", "=", (Object)"7");
        privateFilter.and(filter);
        OrmInput input1 = new OrmInput(this.getClass().getName(), "bd_materialcalinfo", "createorg,masterid,ctrlstrategy,group", privateFilter.toArray());
        inputs.add((Input)input1);
        if (!needQueryAllShare) {
            return inputs;
        }
        QFilter shareFilter = new QFilter("ctrlstrategy", "=", (Object)"5");
        if (materialCategoryIds != null) {
            shareFilter.and("group", "in", materialCategoryIds);
        }
        shareFilter.and(filter);
        OrmInput input2 = new OrmInput(this.getClass().getName(), "bd_materialcalinfo", "createorg,masterid,ctrlstrategy,group", shareFilter.toArray());
        inputs.add((Input)input2);
        return inputs;
    }
}

