/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata;

import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.collections.CollectionUtils;

public class FinOrgResInListPlugin
extends AbstractListPlugin {
    public static final String BTN_OK = "btnok";
    public static final String BTN_RESIN = "btn_resin";
    public static final String RESIN = "resin";
    public static final String RESINLINK = "resinlink";

    public void initialize() {
        super.initialize();
        ListShowParameter showPara = (ListShowParameter)this.getView().getFormShowParameter();
        Object resin = showPara.getCustomParam(RESIN);
        boolean isResIn = resin != null;
        this.getView().setVisible(Boolean.valueOf(!isResIn), new String[]{BTN_OK});
        this.getView().setVisible(Boolean.valueOf(isResIn), new String[]{BTN_RESIN, RESINLINK});
        Button resinBtn = (Button)this.getControl(BTN_RESIN);
        if (resinBtn != null) {
            resinBtn.addClickListener(new ClickListener(){

                public void click(EventObject evt) {
                    FinOrgResInListPlugin.this.getView().invokeOperation(FinOrgResInListPlugin.RESIN);
                }
            });
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if (StringUtils.equals((CharSequence)"number", (CharSequence)fieldName)) {
            ListShowParameter formShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
            boolean lookUp = formShowParameter.isLookUp();
            Object resin = formShowParameter.getCustomParam(RESIN);
            if (lookUp && resin != null) {
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult result = afterDoOperationEventArgs.getOperationResult();
        if (StringUtils.equals((CharSequence)RESIN, (CharSequence)operateKey) && null != result && result.isSuccess() && CollectionUtils.isNotEmpty((Collection)result.getSuccessPkIds())) {
            List successPkIds = result.getSuccessPkIds();
            int totalCount = successPkIds.size();
            QFilter nonBankCateFilter = new QFilter("bank_cate", "=", (Object)0L);
            QFilter idFilter = new QFilter("bebank", "in", (Object)successPkIds);
            DynamicObject[] nonBankNumbers = BusinessDataServiceHelper.load((String)"bd_finorginfo", (String)"number", (QFilter[])new QFilter[]{nonBankCateFilter, idFilter});
            String successMsg = String.format(ResManager.loadKDString((String)"\u5df2\u6210\u529f\u5f15\u5165%d\u6761\u6570\u636e", (String)"FinOrgResInListPlugin_0", (String)"bos-bd-formplugin", (Object[])new Object[0]), totalCount);
            String messageDetail = "";
            if (nonBankNumbers.length > 0) {
                String numberString = Arrays.stream(nonBankNumbers).map(o -> o.getString("number")).reduce((s1, s2) -> s1 + ", " + s2).get();
                messageDetail = String.format(ResManager.loadKDString((String)"\u6240\u5f15\u5165\u6570\u636e\u7f16\u7801%s\u672a\u80fd\u5339\u914d\u5230\u94f6\u884c\u7c7b\u522b\uff0c\u8bf7\u624b\u5de5\u6307\u5b9a\u94f6\u884c\u7c7b\u522b\u3002", (String)"FinOrgResInListPlugin_1", (String)"bos-bd-formplugin", (Object[])new Object[0]), numberString);
            }
            this.getView().showMessage(successMsg, messageDetail, MessageTypes.Commit);
            this.getView().returnDataToParent((Object)successPkIds);
            this.getView().close();
        }
    }
}

