/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import kd.bd.assistant.project.sdk.impl.ProLimitAddOnDetailPlugin;
import kd.bd.assistant.project.sdk.inter.IProLimitAddOnDetailPlugin;
import kd.bd.assistant.projectkind.ProjectKindTreeService;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.permission.api.PermissionService;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class ProjectListPlugin
extends AbstractTreeListPlugin {
    private static final Log logger = LogFactory.getLog(ProjectListPlugin.class);
    private static final String KINDCACHE = "KINDCACHE";
    private static final String VERIFY_ORG = "verifyOrg";
    private static final String FORMBILLID = "bd_project";
    private static final String PROJECT_KIND_FORM_ID = "bd_projectkind";
    private static final String KINDID = "kindId";
    private static final String OPERATE_DELETE = "delete";
    private static final String OPERATE_NEW = "new";
    private static final String OPERATE_REFRESH = "refresh";
    private static final String OPERATE_REFPROKIND = "refprokind";
    private static final String ISLEAF = "isleaf";
    private static final String Issys = "issys";
    private static final String BD_KIND = "bd_projectkind";
    private static final String DEFAULT_TREE_SEARCH_PANNEL = "flexpanel_treebtn";
    private static final String TREE_VIEW = "treeview";
    public static final String PROJECT_KIND_LIST_CACHE_KEY = "PROJECT_KIND_LIST_CACHE_KEY";
    private static final String SEARCH_USER_ORG_ID = "useorg";
    private static final String GROUP = "group";
    private static final String CREATE_ORG = "createorg";
    private static final String NUMBER = "number";
    private static final String NEED_TO_REBUILD_TREE = "NEED_TO_REBUILD_TREE";
    private static final String OPERATE_PRO_KIND_ORG = "OPERATE_PRO_KIND_ORG";
    private static final String CURRENT_CHECHED_NODE_ID = "CURRENT_CHECHED_NODE_ID";
    private static final String BTN_NEW = "btnnew";
    private static final String BTN_EDIT = "btnedit";
    private static final String BTN_DEL = "btndel";
    private static final String SHOW_NUMBER_CACHE_KEY = "shownumber";
    private ProjectKindTreeService projectKindTreeService = new ProjectKindTreeService();

    public void initialize() {
        super.initialize();
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_NEW, BTN_EDIT, BTN_DEL});
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        String fieldName;
        Map currentCommonFilter = args.getCurrentCommonFilter();
        if (currentCommonFilter != null && StringUtils.startsWith((CharSequence)(fieldName = ((List)currentCommonFilter.get("FieldName")).get(0).toString()), (CharSequence)SEARCH_USER_ORG_ID) && currentCommonFilter.get("Value") != null && !((List)currentCommonFilter.get("Value")).isEmpty()) {
            Long userOrgId = Long.parseLong(((List)currentCommonFilter.get("Value")).get(0).toString());
            Boolean showNumber = Boolean.parseBoolean(this.getPageCache().get(SHOW_NUMBER_CACHE_KEY));
            List childNode = this.projectKindTreeService.getChildNode(userOrgId, showNumber);
            this.getView().getPageCache().put(PROJECT_KIND_LIST_CACHE_KEY, SerializationUtils.toJsonString((Object)childNode));
            this.getPageCache().put(NEED_TO_REBUILD_TREE, Boolean.TRUE.toString());
        }
        super.filterContainerSearchClick(args);
    }

    public void createNewData(BizDataEventArgs e) {
        List childNode;
        if (this.getTreeListView() == null) {
            return;
        }
        long orgId = this.getDefaultOrgId();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter instanceof ListShowParameter) {
            this.projectKindTreeService.setTreeFilterParameter(((ListShowParameter)formShowParameter).getTreeFilterParameter());
        }
        Boolean showNumber = Boolean.parseBoolean(this.getPageCache().get(SHOW_NUMBER_CACHE_KEY));
        Object parentF7Custom = this.getView().getFormShowParameter().getCustomParam("ParentF7");
        boolean isParentF7 = false;
        if (parentF7Custom != null) {
            isParentF7 = (Boolean)parentF7Custom;
        }
        if (isParentF7) {
            List<Long> permOrgList = this.getAllPermOrgsByPermItem("15", String.valueOf(RequestContext.get().getCurrUserId()), this.getView().getFormShowParameter().getAppId(), "bd_projectkind", "47150e89000000ac");
            childNode = this.projectKindTreeService.getChildNodeByOrgList(permOrgList, showNumber);
        } else {
            childNode = this.projectKindTreeService.getChildNode(Long.valueOf(orgId), showNumber);
        }
        this.getView().getPageCache().put(PROJECT_KIND_LIST_CACHE_KEY, SerializationUtils.toJsonString((Object)childNode));
    }

    public void afterBindData(EventObject e) {
        if (this.getTreeListView() == null) {
            return;
        }
        Object source = e.getSource();
        boolean needToRebuildTree = Boolean.parseBoolean(this.getPageCache().get(NEED_TO_REBUILD_TREE));
        if (source instanceof ListView || needToRebuildTree) {
            this.rebuildProjectKindTree(this.getTreeListView(), this.rebuildProjectKindTreeRoot());
            this.getPageCache().put(NEED_TO_REBUILD_TREE, Boolean.FALSE.toString());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection selectedRows;
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        this.getPageCache().put(NEED_TO_REBUILD_TREE, Boolean.TRUE.toString());
        if (OPERATE_NEW.equals(operateKey)) {
            ListView view = (ListView)this.getView();
            ListSelectedRowCollection selectedRows2 = view.getSelectedRows();
            if (selectedRows2 != null && selectedRows2.size() > 0) {
                return;
            }
            Object currentNodeId = this.getTreeModel().getCurrentNodeId();
            String id = this.getTreeModel().getRoot().getId();
            ProLimitAddOnDetailPlugin proLimitAddOnDetailPlugin = new ProLimitAddOnDetailPlugin();
            PluginProxy pluginProxy = PluginProxy.create((Object)proLimitAddOnDetailPlugin, IProLimitAddOnDetailPlugin.class, (String)"kd.bd.assistant.project.sdk.inter.IProLimitAddOnDetailPlugin", null);
            List booleans = pluginProxy.callReplaceIfPresent(IProLimitAddOnDetailPlugin::limitOnlyAddOnDetail);
            boolean onlyAddOnDetail = true;
            if (booleans.size() > 0) {
                onlyAddOnDetail = (Boolean)booleans.get(0);
            }
            if (!id.equals(currentNodeId) && onlyAddOnDetail) {
                QFilter queryFilter = new QFilter(ISLEAF, "=", (Object)Character.valueOf('1'));
                queryFilter.and(new QFilter("id", "=", (Object)Long.valueOf(currentNodeId.toString())));
                DynamicObject[] kinds = BusinessDataServiceHelper.load((String)"bd_projectkind", (String)"id,name,number", (QFilter[])new QFilter[]{queryFilter});
                if (kinds == null || kinds.length <= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u662f\u53f6\u5b50\u8282\u70b9\u7684\u9879\u76ee\u5206\u7c7b\u3002", (String)"ProjectListPlugin_0", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                }
            }
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)OPERATE_REFPROKIND)) {
            this.beforeDoRefProKind(args);
        } else if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"newsub") && (selectedRows = ((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection()).size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u4e2a\u9879\u76ee\u3002", (String)"ProjectListPlugin_6", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (operationResult != null && operationResult.isSuccess() && StringUtils.equals((CharSequence)operateKey, (CharSequence)"newsub")) {
            this.addSubProject();
        }
    }

    private void addSubProject() {
        ListView view = (ListView)this.getView();
        ListSelectedRowCollection selectedRows = ((ListView)this.getView()).getSelectedRows().getBillListSelectedRowCollection();
        if (selectedRows.size() == 1) {
            Object primaryKeyValue = selectedRows.get(0).getPrimaryKeyValue();
            BaseShowParameter parameter = new BaseShowParameter();
            parameter.setFormId(FORMBILLID);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setCustomParam("parentProId", primaryKeyValue);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private void beforeDoRefProKind(BeforeDoOperationEventArgs args) {
        ListSelectedRowCollection selectedRows = args.getListSelectedData();
        Object[] projectIdArray = selectedRows.stream().map(selectRow -> selectRow.getPrimaryKeyValue()).toArray();
        DynamicObject[] projectArray = BusinessDataServiceHelper.load((Object[])projectIdArray, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)FORMBILLID));
        int canRefProKindCount = 0;
        for (DynamicObject project : projectArray) {
            Long filterOrgId;
            String number = project.getString(NUMBER);
            boolean canRefProKind = true;
            if (project.getDynamicObject(GROUP) != null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"%s\uff1a\u9879\u76ee\u5206\u7c7b\u4e3a\u7a7a\u7684\u6570\u636e\u624d\u80fd\u5173\u8054\u9879\u76ee\u5206\u7c7b\u3002", (String)"ProjectListPlugin_1", (String)"bd-assistant-formplugin", (Object[])new Object[]{number}));
                canRefProKind = false;
            }
            if (!(filterOrgId = Long.valueOf(Long.parseLong(this.getPageCache().get(VERIFY_ORG)))).equals(project.getDynamicObject(CREATE_ORG).getPkValue())) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"%s\uff1a\u201c\u4f7f\u7528\u7ec4\u7ec7\u201d\u4e0e\u201c\u521b\u5efa\u7ec4\u7ec7\u201d\u76f8\u540c\u65f6\u624d\u80fd\u5173\u8054\u9879\u76ee\u5206\u7c7b\u3002", (String)"ProjectListPlugin_2", (String)"bd-assistant-formplugin", (Object[])new Object[]{number}));
                canRefProKind = false;
            }
            if (!canRefProKind) continue;
            ++canRefProKindCount;
        }
        if (canRefProKindCount > 0) {
            ListShowParameter parameter = ShowFormHelper.createShowListForm((String)"bd_projectkind", (boolean)false);
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, OPERATE_REFPROKIND);
            parameter.setCloseCallBack(callBack);
            List useOrgIdList = this.getControlFilters().getFilter("useorg.id");
            long orgId = useOrgIdList == null || useOrgIdList.isEmpty() ? RequestContext.get().getOrgId() : Long.parseLong(useOrgIdList.get(0).toString());
            QFilter ctrlStrategyFilter = BaseDataServiceHelper.getBaseDataIdInFilter((String)"bd_projectkind", (Long)orgId);
            ArrayList<QFilter> treeFilterList = new ArrayList<QFilter>(1);
            treeFilterList.add(ctrlStrategyFilter);
            parameter.getTreeFilterParameter().setQFilters(treeFilterList);
            ArrayList<QFilter> listFilterList = new ArrayList<QFilter>(1);
            QFilter statusFilter = new QFilter("status", "=", (Object)"C");
            listFilterList.add(statusFilter);
            QFilter leafFilter = new QFilter(ISLEAF, "=", (Object)true);
            listFilterList.add(leafFilter);
            listFilterList.add(ctrlStrategyFilter);
            parameter.getListFilterParameter().setQFilters(listFilterList);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        super.closedCallBack(event);
        String actionId = event.getActionId();
        if (actionId.equals(OPERATE_REFPROKIND) && event.getReturnData() != null) {
            this.refProKindCloseBack((ListSelectedRowCollection)event.getReturnData());
        }
    }

    private void refProKindCloseBack(ListSelectedRowCollection collection) {
        if (!collection.isEmpty()) {
            DynamicObject[] projectArray;
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            Object[] projectIdArray = selectedRows.stream().map(ListSelectedRow::getPrimaryKeyValue).toArray();
            for (DynamicObject project : projectArray = BusinessDataServiceHelper.load((Object[])projectIdArray, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)FORMBILLID))) {
                project.set(GROUP, collection.get(0).getPrimaryKeyValue());
            }
            SaveServiceHelper.update((DynamicObject[])projectArray);
            this.getView().invokeOperation(OPERATE_REFRESH);
        }
    }

    public void setTreeListView(ITreeListView treeListView) {
        List childrenNodes;
        if (this.treeListView == null || this.treeListView.getTreeModel() == null || this.treeListView.getTreeModel().getRoot() == null || this.treeListView.getTreeModel().getRoot().getChildren() == null) {
            return;
        }
        this.treeListView.getTreeModel().getRoot().getChildren().clear();
        String projectKinds = this.getPageCache().get(PROJECT_KIND_LIST_CACHE_KEY);
        if (StringUtils.isBlank((CharSequence)projectKinds)) {
            Boolean showNumber;
            long orgId = this.getDefaultOrgId();
            String showNumberStr = this.getPageCache().get(SHOW_NUMBER_CACHE_KEY);
            if (StringUtils.isNotBlank((CharSequence)showNumberStr)) {
                showNumber = Boolean.parseBoolean(showNumberStr);
            } else {
                BooleanProp prop = (BooleanProp)this.getModel().getProperty(SHOW_NUMBER_CACHE_KEY);
                showNumber = (Boolean)prop.getDefValue();
                this.getPageCache().put(SHOW_NUMBER_CACHE_KEY, showNumber.toString());
            }
            Object parentF7Custom = this.getView().getFormShowParameter().getCustomParam("ParentF7");
            boolean isParentF7 = false;
            if (parentF7Custom != null) {
                isParentF7 = (Boolean)parentF7Custom;
            }
            if (isParentF7) {
                List<Long> permOrgList = this.getAllPermOrgsByPermItem("15", String.valueOf(RequestContext.get().getCurrUserId()), this.getView().getFormShowParameter().getAppId(), "bd_projectkind", "47150e89000000ac");
                childrenNodes = this.projectKindTreeService.getChildNodeByOrgList(permOrgList, showNumber);
            } else {
                childrenNodes = this.projectKindTreeService.getChildNode(Long.valueOf(orgId), showNumber);
            }
            this.getView().getPageCache().put(PROJECT_KIND_LIST_CACHE_KEY, SerializationUtils.toJsonString((Object)childrenNodes));
        } else {
            childrenNodes = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get(PROJECT_KIND_LIST_CACHE_KEY), TreeNode.class);
        }
        treeListView.getTreeModel().getRoot().getChildren().addAll(childrenNodes);
        super.setTreeListView(treeListView);
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        ListView view = (ListView)this.getView();
        OperationStatus status = e.getParameter().getStatus();
        if (status.equals((Object)OperationStatus.ADDNEW)) {
            Object currentNodeId;
            ListSelectedRowCollection selectedRows = view.getSelectedRows();
            if (selectedRows != null && selectedRows.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u4e2d\u591a\u884c\u65b0\u589e\u3002", (String)"ProjectListPlugin_3", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            if ((selectedRows == null || selectedRows.size() == 0) && (currentNodeId = this.getTreeModel().getCurrentNodeId()) != null) {
                e.getParameter().setCustomParam("projectKindId", currentNodeId);
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        if (this.getTreeListView() != null) {
            Object treeNodeId = this.getTreeModel().getCurrentNodeId();
            if (!"8609760E-EF83-4775-A9FF-CCDEC7C0B689".equals(treeNodeId.toString())) {
                DynamicObject projectKind = BusinessDataServiceHelper.loadSingle((Object)treeNodeId, (String)"bd_projectkind");
                if (projectKind != null) {
                    logger.info("setFilter: projectKind treeeNode ID {}", treeNodeId);
                    logger.info("before setFilter e.getQFilters()\uff1a{} ", (Object)e.getQFilters());
                    List useOrgIdList = this.getControlFilters().getFilter("useorg.id");
                    List<Object> orgIdList = new ArrayList();
                    if (useOrgIdList == null || useOrgIdList.isEmpty()) {
                        Object parentF7Custom = this.getView().getFormShowParameter().getCustomParam("ParentF7");
                        boolean isParentF7 = false;
                        if (parentF7Custom != null) {
                            isParentF7 = (Boolean)parentF7Custom;
                        }
                        if (isParentF7) {
                            List<Long> permOrgList = this.getAllPermOrgsByPermItem("15", String.valueOf(RequestContext.get().getCurrUserId()), this.getView().getFormShowParameter().getAppId(), "bd_projectkind", "47150e89000000ac");
                            orgIdList.addAll(permOrgList);
                        } else {
                            orgIdList.add(this.getDefaultOrgId());
                        }
                    } else {
                        orgIdList = useOrgIdList.stream().map(o -> Long.parseLong(o.toString())).collect(Collectors.toList());
                    }
                    QFilter ctrlStrategyFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_projectkind", orgIdList, (boolean)false);
                    DynamicObjectCollection kindList = QueryServiceHelper.query((String)"bd_projectkind", (String)"id", (QFilter[])new QFilter[]{ctrlStrategyFilter});
                    Set kindIdList = kindList.stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toSet());
                    if (kindIdList.add(projectKind.getLong("id"))) {
                        QFilter kindIdFilter = new QFilter("1", "!=", (Object)1);
                        if (e.getQFilters() != null && !e.getQFilters().isEmpty()) {
                            for (QFilter filter : e.getQFilters()) {
                                if (!GROUP.equals(filter.getProperty())) continue;
                                filter.and(kindIdFilter);
                            }
                        }
                    } else {
                        QFilter kindIdFilter = new QFilter(GROUP, "=", (Object)projectKind.getLong("id"));
                        if (e.getQFilters() != null && !e.getQFilters().isEmpty()) {
                            for (QFilter filter : e.getQFilters()) {
                                if (!GROUP.equals(filter.getProperty())) continue;
                                filter.or(kindIdFilter);
                            }
                        }
                    }
                    Object parentF7Custom = this.getView().getFormShowParameter().getCustomParam("ParentF7");
                    boolean isParentF7 = false;
                    if (parentF7Custom != null) {
                        isParentF7 = (Boolean)parentF7Custom;
                    }
                    if (isParentF7) {
                        QFilter dataRuleFilter = PermissionServiceHelper.getDataRule((long)UserServiceHelper.getCurrentUserId(), (String)"basedata", (String)FORMBILLID, (String)"47150e89000000ac");
                        e.getQFilters().add(dataRuleFilter);
                    } else {
                        QFilter dataRuleFilter = ((PermissionService)ServiceFactory.getService(PermissionService.class)).getDataRuleWithoutDim(RequestContext.get().getCurrUserId(), "basedata", FORMBILLID, "47150e89000000ac", orgIdList);
                        e.getQFilters().add(dataRuleFilter);
                    }
                    logger.info("afer setfilter e.getQFilters()\uff1a{} ", (Object)e.getQFilters());
                }
            } else {
                CopyOnWriteArrayList<QFilter> qFilterList = new CopyOnWriteArrayList<QFilter>(e.getQFilters());
                if (e.getQFilters() != null && !e.getQFilters().isEmpty()) {
                    for (QFilter filter : qFilterList) {
                        if (!GROUP.equals(filter.getProperty())) continue;
                        qFilterList.remove(filter);
                    }
                }
                List useOrgIdList = this.getControlFilters().getFilter("useorg.id");
                List<Object> orgIdList = new ArrayList();
                boolean isParentF7 = false;
                List<Long> permOrgList = this.getAllPermOrgsByPermItem("15", String.valueOf(RequestContext.get().getCurrUserId()), this.getView().getFormShowParameter().getAppId(), "bd_projectkind", "47150e89000000ac");
                if (useOrgIdList == null || useOrgIdList.isEmpty()) {
                    Object parentF7Custom = this.getView().getFormShowParameter().getCustomParam("ParentF7");
                    if (parentF7Custom != null) {
                        isParentF7 = (Boolean)parentF7Custom;
                    }
                    if (isParentF7) {
                        orgIdList.addAll(permOrgList);
                    } else {
                        orgIdList.add(this.getDefaultOrgId());
                    }
                } else {
                    orgIdList = useOrgIdList.stream().map(o -> Long.parseLong(o.toString())).collect(Collectors.toList());
                }
                QFilter ctrlStrategyFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_projectkind", orgIdList, (boolean)false);
                DynamicObjectCollection kindList = QueryServiceHelper.query((String)"bd_projectkind", (String)"id", (QFilter[])new QFilter[]{ctrlStrategyFilter});
                Set kindIdList = kindList.stream().map(dyn -> dyn.getLong("id")).collect(Collectors.toSet());
                if (isParentF7) {
                    QFilter kindFilter = new QFilter(GROUP, "in", kindIdList);
                    QFilter orgNotKindFilter = new QFilter(GROUP, "=", (Object)0L);
                    QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)FORMBILLID, permOrgList, (boolean)false);
                    orgNotKindFilter = orgNotKindFilter.and(baseDataFilter);
                    qFilterList.add(kindFilter.or(orgNotKindFilter));
                    QFilter dataRuleFilter = PermissionServiceHelper.getDataRule((long)UserServiceHelper.getCurrentUserId(), (String)"basedata", (String)FORMBILLID, (String)"47150e89000000ac");
                    qFilterList.add(dataRuleFilter);
                } else {
                    kindIdList.add(0L);
                    QFilter kindFilter = new QFilter(GROUP, "in", kindIdList);
                    qFilterList.add(kindFilter);
                    QFilter dataRuleFilter = ((PermissionService)ServiceFactory.getService(PermissionService.class)).getDataRuleWithoutDim(RequestContext.get().getCurrUserId(), "basedata", FORMBILLID, "47150e89000000ac", orgIdList);
                    qFilterList.add(dataRuleFilter);
                }
                if (e.getQFilters() != null) {
                    e.getQFilters().clear();
                    e.getQFilters().addAll(qFilterList);
                }
                logger.info("after setfilter on tree e.getQFilters()\uff1a{} ", (Object)e.getQFilters());
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (StringUtils.equals((CharSequence)SHOW_NUMBER_CACHE_KEY, (CharSequence)name)) {
            this.getPageCache().put(SHOW_NUMBER_CACHE_KEY, ((Boolean)newValue).toString());
            this.getPageCache().remove(PROJECT_KIND_LIST_CACHE_KEY);
            this.getTreeListView().focusRootNode();
            this.getTreeListView().refreshTreeView();
        }
    }

    protected TreeNode rebuildProjectKindTreeRoot() {
        TreeNode root = new TreeNode();
        root.setId("8609760E-EF83-4775-A9FF-CCDEC7C0B689");
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"ProjectListPlugin_5", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
        return root;
    }

    protected ITreeListView rebuildProjectKindTree(ITreeListView treeListView, TreeNode root) {
        treeListView.getTreeView().deleteAllNodes();
        treeListView.getTreeView().addNode(root);
        List childrenNodes = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get(PROJECT_KIND_LIST_CACHE_KEY), TreeNode.class);
        if (!childrenNodes.isEmpty()) {
            root.setChildren(childrenNodes);
        }
        root.setIsOpened(true);
        return treeListView;
    }

    private long getDefaultOrgId() {
        long orgId = 0L;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter instanceof ListShowParameter) {
            ListShowParameter listShowParameter = (ListShowParameter)formShowParameter;
            orgId = listShowParameter.getUseOrgId();
        }
        if (orgId == 0L) {
            String createOrgCache = this.getPageCache().get("createOrg");
            orgId = StringUtils.isBlank((CharSequence)createOrgCache) || Long.parseLong(createOrgCache) == 0L ? RequestContext.get().getOrgId() : Long.parseLong(createOrgCache);
        }
        return orgId;
    }

    private List<Long> getAllPermOrgsByPermItem(String orgViewType, String userId, String appId, String entityNum, String permItemId) {
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((long)Long.parseLong(userId), (String)orgViewType, (String)appId, (String)entityNum, (String)permItemId);
        if (result.hasAllOrgPerm()) {
            ArrayList<Long> orgList = new ArrayList<Long>(10);
            orgList.add(OrgUnitServiceHelper.getRootOrgId());
            return OrgUnitServiceHelper.getAllSubordinateOrgs((Long)Long.valueOf("15"), orgList, (boolean)true);
        }
        return result.getHasPermOrgs();
    }
}

