/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.bom;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Objects;
import kd.bd.assistant.plugin.util.BOMVersionUtil;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class BOMVersionEditPluginNew
extends AbstractListPlugin
implements BeforeF7SelectListener,
AfterF7SelectListener {
    private static final String KEY_MATER = "material";
    private static final String KEY_MATERRIALGROUP = "materialgroup";
    private static final String KEY_CREATEORG = "createorg";
    private static final String KEY_NUMBER = "number";
    private static final String KEY_RULE = "bomversionrule";
    private static final String KEY_VERSIONNAME = "versionname";
    private static final String KEY_RULEENTRY = "entryentity";
    private static final String KEY_VERSION = "version";
    private static final String KEY_BD_BOMVERSIONRULE = "bd_bomversionrule_new";
    private static final String KEY_BUILDVERSION = "buildversion";
    private static final String KEY_ECNBILLNO = "ecnbillno";
    private static final String KEY_TYPE = "type";

    public void beforeF7Select(BeforeF7SelectEvent e) {
        ListFilterParameter lfp;
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        String key = e.getProperty().getName();
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        FormShowParameter fsp = e.getFormShowParameter();
        if (fsp == null) {
            return;
        }
        ListShowParameter lsp = fsp instanceof ListShowParameter ? (ListShowParameter)fsp : null;
        ListFilterParameter listFilterParameter = lfp = lsp == null ? null : lsp.getListFilterParameter();
        if (lfp == null) {
            return;
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)KEY_VERSIONNAME)) {
            DynamicObject versionRule = (DynamicObject)model.getValue(KEY_RULE);
            if (versionRule == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7248\u672c\u89c4\u5219\u3002", (String)"BOMVersionEditPluginNew_1", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            long versionRuleId = versionRule.getLong("id");
            qFilterList.add(new QFilter("ruleid", "=", (Object)versionRuleId));
            lfp.setQFilters(qFilterList);
            lsp.setListFilterParameter(lfp);
            e.setFormShowParameter((FormShowParameter)lsp);
        } else if (StringUtils.equals((CharSequence)key, (CharSequence)KEY_RULE)) {
            String type = this.getModel().getValue(KEY_TYPE).toString();
            qFilterList.add(new QFilter("multype", "like", (Object)("%" + type + "%")));
            lfp.setQFilters(qFilterList);
            lsp.setListFilterParameter(lfp);
            e.setFormShowParameter((FormShowParameter)lsp);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit rule = (BasedataEdit)this.getView().getControl(KEY_RULE);
        BasedataEdit versionName = (BasedataEdit)this.getView().getControl(KEY_VERSIONNAME);
        if (rule != null) {
            rule.addAfterF7SelectListener((AfterF7SelectListener)this);
            rule.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (versionName != null) {
            versionName.addAfterF7SelectListener((AfterF7SelectListener)this);
            versionName.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public boolean getIsChangeNum() {
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        Object number = model.getValue(KEY_NUMBER);
        String curNum = number != null ? String.valueOf(number) : "";
        return kd.bos.util.StringUtils.isEmpty((String)curNum);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject ruleCache;
        Object newValue;
        super.propertyChanged(e);
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        String propertyName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet.length <= 0) {
            return;
        }
        Object oldValue = changeSet[0].getOldValue();
        if (Objects.equals(oldValue, newValue = changeSet[0].getNewValue())) {
            return;
        }
        if (KEY_VERSIONNAME.equals(propertyName)) {
            DynamicObject versionname = (DynamicObject)model.getValue(KEY_VERSIONNAME);
            String version = versionname == null ? "" : versionname.getString(KEY_VERSION);
            model.setValue("name", (Object)version);
            view.updateView("name");
            model.setValue(KEY_NUMBER, null);
            this.setNumber();
            this.getModel().getDataEntity().getDataEntityState().setBizChanged(this.getModel().getDataEntityType().getProperty("name").getOrdinal(), false);
        }
        if (KEY_MATER.equals(propertyName)) {
            if (this.isRouteType()) {
                view.setEnable(Boolean.valueOf(newValue == null), new String[]{KEY_MATERRIALGROUP});
            }
            model.setValue(KEY_NUMBER, null);
            this.setNumber();
            ruleCache = (DynamicObject)this.getModel().getValue(KEY_RULE);
            if (ruleCache == null) {
                return;
            }
            long rulePkId = (Long)ruleCache.getPkValue();
            this.showVersion(rulePkId);
        }
        if (KEY_MATERRIALGROUP.equals(propertyName)) {
            if (this.isRouteType()) {
                view.setEnable(Boolean.valueOf(newValue == null), new String[]{KEY_MATER});
            }
            model.setValue(KEY_NUMBER, null);
            this.setNumber();
            ruleCache = (DynamicObject)this.getModel().getValue(KEY_RULE);
            if (ruleCache == null) {
                return;
            }
            long rulePkId = (Long)ruleCache.getPkValue();
            this.showVersion(rulePkId);
        }
        if (KEY_RULE.equals(propertyName)) {
            model.setValue(KEY_NUMBER, null);
            this.setNumber();
            ruleCache = (DynamicObject)newValue;
            this.showVersion(ruleCache == null ? 0L : ruleCache.getLong("id"));
        }
        if (KEY_TYPE.equals(propertyName)) {
            String type = newValue == null ? "A" : newValue.toString();
            DynamicObject rule = this.getDefaultRuleByType(type);
            model.setValue(KEY_RULE, (Object)rule);
            model.setValue(KEY_NUMBER, null);
            this.setNumber();
            view.updateView(KEY_RULE);
            BasedataEdit cmaterialEdit = (BasedataEdit)this.getControl(KEY_MATER);
            cmaterialEdit.setMustInput(!"B".equals(type));
            view.setEnable(Boolean.valueOf(true), new String[]{KEY_MATER});
            if ("B".equals(type)) {
                DynamicObject material = (DynamicObject)model.getValue(KEY_MATER);
                view.setEnable(Boolean.valueOf(material == null), new String[]{KEY_MATERRIALGROUP});
            }
        }
    }

    private boolean isRouteType() {
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        String type = (String)model.getValue(KEY_TYPE);
        return "B".equals(type);
    }

    public void setNumber() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        OperationStatus status = showParameter.getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status) || this.getIsChangeNum()) {
            IFormView view = this.getView();
            IDataModel model = view.getModel();
            QFilter filter1 = new QFilter("bizobjectid", "=", (Object)"bd_bomversion_new");
            QFilter filter2 = new QFilter("enable", "=", (Object)"1");
            if (QueryServiceHelper.exists((String)"bos_coderule", (QFilter[])new QFilter[]{filter1, filter2})) {
                return;
            }
            DynamicObject mat = (DynamicObject)model.getValue(KEY_MATER);
            DynamicObject rule = (DynamicObject)model.getValue(KEY_RULE);
            String type = (String)model.getValue(KEY_TYPE);
            String version = String.valueOf(model.getValue("name"));
            if ("B".equals(type) ? rule == null || StringUtils.isEmpty((CharSequence)version) : mat == null || rule == null || StringUtils.isEmpty((CharSequence)version)) {
                return;
            }
            String number = this.getNumberByMat() + rule.getString(KEY_NUMBER) + "-" + ("B".equals(type) ? "route" : ("C".equals(type) ? "formula" : "bom")) + "-" + version;
            model.setValue(KEY_NUMBER, (Object)number);
            this.getModel().getDataEntity().getDataEntityState().setBizChanged(this.getModel().getDataEntityType().getProperty(KEY_NUMBER).getOrdinal(), false);
            view.updateView(KEY_NUMBER);
        }
    }

    private String getNumberByMat() {
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        DynamicObject mat = (DynamicObject)model.getValue(KEY_MATER);
        DynamicObject materialGroup = (DynamicObject)model.getValue(KEY_MATERRIALGROUP);
        if (mat != null) {
            return mat.getString(KEY_NUMBER) + "-";
        }
        if (materialGroup != null) {
            return materialGroup.getString(KEY_NUMBER) + "-";
        }
        return "";
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        IDataModel model = this.getView().getModel();
        String pageId = this.getView().getFormShowParameter().getFormId();
        if ("bd_bomversion_new".equals(pageId)) {
            model.setValue("status", (Object)"C");
        }
        super.beforeDoOperation(args);
    }

    public DynamicObject getDefaultRuleByType(String type) {
        String defaultField = "B".equals(type) ? "isdefaultroute" : ("C".equals(type) ? "isdefaultprograme" : "isdefault");
        QFilter isDefault = new QFilter(defaultField, "=", (Object)"1");
        QFilter isenable = new QFilter("enable", "=", (Object)"1");
        return BusinessDataServiceHelper.loadSingle((String)KEY_BD_BOMVERSIONRULE, (String)"id,version,number", (QFilter[])new QFilter[]{isDefault, isenable});
    }

    public void afterBindData(EventObject e) {
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        super.afterBindData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        OperationStatus status = showParameter.getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{KEY_NUMBER});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{KEY_CREATEORG});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{KEY_MATER});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{KEY_RULE});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"btnbuildversion"});
            String type = (String)this.getModel().getValue(KEY_TYPE);
            DynamicObject rule = this.getDefaultRuleByType(type);
            RequestContext rx = RequestContext.get();
            Long orgId = rx.getOrgId();
            model.beginInit();
            model.setValue(KEY_RULE, (Object)rule);
            model.setValue(KEY_CREATEORG, (Object)orgId);
            model.endInit();
            view.updateView(KEY_RULE);
            view.updateView(KEY_CREATEORG);
            model.setDataChanged(false);
        }
        this.lockRouteMaterialField();
        BasedataEdit cmaterialEdit = (BasedataEdit)this.getControl(KEY_MATER);
        cmaterialEdit.setMustInput(!"B".equals((String)model.getValue(KEY_TYPE)));
    }

    private void lockRouteMaterialField() {
        if (this.isRouteType()) {
            IFormView view;
            IDataModel model = (view = this.getView()).getModel();
            view.setEnable(Boolean.valueOf(model.getValue(KEY_MATER) == null), new String[]{KEY_MATERRIALGROUP});
            view.setEnable(Boolean.valueOf(model.getValue(KEY_MATERRIALGROUP) == null), new String[]{KEY_MATER});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String key = e.getOperateKey();
        OperationResult result = e.getOperationResult();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)key) && result.isSuccess()) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{KEY_NUMBER});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{KEY_CREATEORG});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"btnbuildversion"});
        } else if (StringUtils.equals((CharSequence)KEY_BUILDVERSION, (CharSequence)key) && result.isSuccess()) {
            DynamicObject org = (DynamicObject)this.getModel().getValue(KEY_CREATEORG);
            DynamicObject mater = (DynamicObject)this.getModel().getValue(KEY_MATER);
            DynamicObject rule = (DynamicObject)this.getModel().getValue(KEY_RULE);
            if (org == null || mater == null || rule == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u521b\u5efa\u7ec4\u7ec7\uff0c\u7269\u6599\u548c\u7248\u672c\u89c4\u5219\u3002", (String)"BOMVersionEditPluginNew_2", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                return;
            }
            String version = BOMVersionUtil.getAutoVersion(org.getPkValue(), mater.getPkValue(), rule.getPkValue(), this.getType());
            if (version == null) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8be5\u7248\u672c\u89c4\u5219\u4e0b\u7684\u6240\u6709\u7248\u672c\u5728\u7ec4\u7ec7\uff1a%1$s\u3001\u7269\u6599\uff1a%2$s\u4e0b\u90fd\u5df2\u5b58\u5728\u3002", (String)"BOMVersionEditPluginNew_3", (String)"bd-assistant-formplugin", (Object[])new Object[0]), org.getString("name"), mater.getString(KEY_NUMBER)));
                return;
            }
            this.getModel().setValue("name", (Object)version);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u81ea\u52a8\u751f\u6210\u7248\u672c\u6210\u529f\u3002", (String)"BOMVersionEditPluginNew_4", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        IDataModel model = this.getModel();
        String ecnbillno = (String)model.getValue(KEY_ECNBILLNO);
        if (ecnbillno != null && !"".equals(ecnbillno)) {
            model.setValue(KEY_ECNBILLNO, null);
        }
        model.setValue(KEY_VERSIONNAME, null);
    }

    public void afterF7Select(AfterF7SelectEvent e) {
        BasedataEdit ruleData;
        if (e.getSource() instanceof BasedataEdit && (ruleData = (BasedataEdit)e.getSource()).getKey().equals(KEY_RULE) && this.getModel().getValue(KEY_RULE) instanceof DynamicObject) {
            DynamicObject ruleCache = (DynamicObject)this.getModel().getValue(KEY_RULE);
            if (ruleCache == null) {
                return;
            }
            long rulePkId = (Long)ruleCache.getPkValue();
            this.showVersion(rulePkId);
        }
    }

    private String getType() {
        Object type = this.getModel().getValue(KEY_TYPE);
        return type == null ? "A" : type.toString();
    }

    private long getDynamicObjectId(DynamicObject mat) {
        if (mat != null) {
            return (Long)mat.getPkValue();
        }
        return 0L;
    }

    public void showVersion(long rulePkId) {
        if (rulePkId == 0L) {
            return;
        }
        QFilter qfilter = new QFilter("id", "=", (Object)rulePkId);
        DynamicObjectCollection coll = QueryServiceHelper.query((String)KEY_BD_BOMVERSIONRULE, (String)"entryentity.id entryid,entryentity.version version , entryentity.seq seq ", (QFilter[])new QFilter[]{qfilter}, (String)"entryentity.seq");
        DynamicObject mater = (DynamicObject)this.getModel().getValue(KEY_MATER);
        if (!this.isRouteType() && mater == null) {
            return;
        }
        DynamicObject materialGroup = (DynamicObject)this.getModel().getValue(KEY_MATERRIALGROUP);
        int tmpSeq = BOMVersionUtil.getMaxSeq(this.getDynamicObjectId(mater), this.getDynamicObjectId(materialGroup), rulePkId, this.getType());
        int size = coll.size();
        boolean flag = false;
        for (int i = 0; i < size; ++i) {
            DynamicObject obj = (DynamicObject)coll.get(i);
            String version = obj.getString(KEY_VERSION);
            int entrySeq = obj.getInt("seq");
            if (entrySeq <= tmpSeq || BOMVersionUtil.isQuoteVersion(this.getDynamicObjectId(mater), this.getDynamicObjectId(materialGroup), version, rulePkId, this.getType()).booleanValue()) continue;
            this.getModel().setValue(KEY_VERSIONNAME, (Object)obj.getLong("entryid"));
            flag = true;
            break;
        }
        if (!flag) {
            this.getModel().setValue(KEY_VERSIONNAME, null);
            this.getModel().setValue("name", (Object)"");
            this.getView().updateView(KEY_VERSIONNAME);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8be5\u7248\u672c\u89c4\u5219\u4e0b\u7684\u6240\u6709\u7248\u672c\u7269\u6599\uff1a%s\u4e0b\u90fd\u5df2\u5b58\u5728\u3002", (String)"BOMVersionEditPluginNew_5", (String)"bd-assistant-formplugin", (Object[])new Object[0]), mater == null ? "" : mater.getString(KEY_NUMBER)));
        }
    }
}

