/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.bom;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.assistant.plugin.constant.BomVersionImportConst;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;

public class BomVersionImportPlugin
extends AbstractBillPlugIn {
    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        Map sourceData = e.getSourceData();
        Object bomVersionRuleObj = sourceData.get("bomversionrule");
        this.replaceVersionToID(e, sourceData);
    }

    public void replaceVersionToID(BeforeImportDataEventArgs e, Map<String, Object> sourceData) {
        Long versionPk;
        if (sourceData == null) {
            return;
        }
        Object versionNameObj = sourceData.get("versionname");
        if (!(versionNameObj instanceof JSONObject)) {
            return;
        }
        JSONObject versionNameJson = (JSONObject)versionNameObj;
        Object versionID = versionNameJson.get((Object)"id");
        if (versionID != null) {
            return;
        }
        Object bomVersionRuleObj = sourceData.get("bomversionrule");
        if (!(bomVersionRuleObj instanceof JSONObject)) {
            e.setCancel(true);
            e.setCancelMessage(ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u7248\u672c\u89c4\u5219\u201d\u3002", (String)"BomVersionImportPlugin_0", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
            e.setFireAfterImportData(false);
            return;
        }
        JSONObject bomVersionRuleJson = (JSONObject)bomVersionRuleObj;
        String version = versionNameJson.getString("version");
        StringBuilder ruleKey = new StringBuilder();
        String ruleNumber = bomVersionRuleJson.getString("number");
        String ruleNname = bomVersionRuleJson.getString("number");
        DynamicObject rule = null;
        if (StringUtils.isNotEmpty((CharSequence)ruleNumber)) {
            ruleKey.append(ruleNumber).append(':').append(version);
            rule = (DynamicObject)BomVersionImportConst.bomVersionRuleIDMap.get(ruleNumber + "_number");
        } else if (StringUtils.isNotEmpty((CharSequence)ruleNname)) {
            ruleKey.append(ruleNname).append(':').append(version);
            rule = (DynamicObject)BomVersionImportConst.bomVersionRuleIDMap.get(ruleNname + "_name");
        }
        if (rule != null && sourceData.containsKey("type")) {
            String type = sourceData.get("type") == null ? "A" : sourceData.get("type").toString();
            Set multypes = Arrays.stream(rule.getString("multype").split(",")).filter(StringUtils::isNotEmpty).collect(Collectors.toSet());
            if (!multypes.contains(type)) {
                e.setCancel(true);
                e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u7248\u672c\u89c4\u5219\u201c%1$s\u201d\u7684\u89c4\u5219\u7c7b\u578b\u4e0d\u5305\u542b\u672c\u6b21\u5bfc\u5165\u7684\u7c7b\u578b\u3002", (String)"BomVersionImportPlugin_1", (String)"bd-assistant-formplugin", (Object[])new Object[0]), rule.getString("number")));
                e.setFireAfterImportData(false);
                return;
            }
        }
        if ((versionPk = (Long)BomVersionImportConst.bomVersionIDMap.get(ruleKey.toString())) != null && versionPk > 0L) {
            versionNameJson.put("importprop", (Object)"id");
            versionNameJson.put("id", (Object)versionPk);
        }
    }
}

