/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.er.web;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import org.apache.commons.lang.StringUtils;

public class ExpItemRelDeptQuery
extends AbstractFormPlugin
implements RowClickEventListener {
    protected static final String ORG_ENTRY_ORG = "orglist";
    protected static final String ORG_ENTRY_EXP = "expitemlist";
    protected static final String ORG_ORG = "orgorg";
    protected static final String ORG_EXP = "relexpitem";
    protected static final String EXP_ENTRY_ORG = "orgentry";
    protected static final String EXP_ENTRY_EXP = "expitementry";
    protected static final String EXP_ORG = "org";
    protected static final String EXP_ADMIN = "admin";
    protected static final String EXP_EXP = "expitem";
    protected static final String ORG_RELATE_COPY = "orgrelatecopy";
    private static final String ALGO = "kd.bd.assistant.plugin.er.web.ExpItemRelDeptQuery";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid expEntry = (EntryGrid)this.getControl(EXP_ENTRY_EXP);
        expEntry.addRowClickListener((RowClickEventListener)this);
        EntryGrid orgList = (EntryGrid)this.getControl(ORG_ENTRY_ORG);
        orgList.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String orgid = (String)showParameter.getCustomParam(EXP_ORG);
        if (orgid == null) {
            long currentOrg = RequestContext.get().getOrgId();
            if (currentOrg == 0L) {
                currentOrg = 100000L;
            }
            orgid = currentOrg + "";
        }
        this.getPageCache().put("filterorg", orgid);
        List orgList = new ArrayList<Long>(8);
        orgList.add(Long.valueOf(orgid));
        orgList = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)1L, orgList, (boolean)true);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        this.getModel().deleteEntryData(ORG_ENTRY_ORG);
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int rowIndex = 0;
        model.beginInit();
        for (Long orgId : orgList) {
            vs.set(ORG_ORG, (Object)orgId, rowIndex);
            ++rowIndex;
        }
        model.batchCreateNewEntryRow(ORG_ENTRY_ORG, vs);
        model.endInit();
        this.getView().updateView(ORG_ENTRY_ORG);
        ArrayList<Long> expItems = (ArrayList<Long>)showParameter.getCustomParam("expitems");
        if (expItems == null || expItems.isEmpty()) {
            QFilter baseDataProFilter = BaseDataServiceHelper.getBaseDataProFilter((String)"er_expenseitemedit", (Long)Long.valueOf(orgid), (String)"id");
            if (baseDataProFilter == null) {
                baseDataProFilter = new QFilter("1", "=", (Object)"1");
            }
            expItems = new ArrayList<Long>(1000);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)ALGO, (String)"er_expenseitemedit", (String)"id", (QFilter[])baseDataProFilter.toArray(), null);){
                for (Row row : dataSet) {
                    expItems.add(row.getLong("id"));
                }
            }
        }
        this.getModel().deleteEntryData(EXP_ENTRY_EXP);
        vs = new TableValueSetter(new String[0]);
        rowIndex = 0;
        model.beginInit();
        for (Object e2 : expItems) {
            vs.set(EXP_EXP, e2, rowIndex);
            ++rowIndex;
        }
        model.batchCreateNewEntryRow(EXP_ENTRY_EXP, vs);
        model.endInit();
        this.getView().updateView(EXP_ENTRY_EXP);
    }

    public void afterBindData(EventObject e) {
        int orgRowCount;
        super.afterBindData(e);
        int expRowCount = this.getModel().getEntryRowCount(EXP_ENTRY_EXP);
        if (expRowCount > 0) {
            EntryGrid expEntry = (EntryGrid)this.getControl(EXP_ENTRY_EXP);
            expEntry.selectRows(0);
            DynamicObject expItem = (DynamicObject)this.getModel().getValue(EXP_EXP, 0);
            this.refreshRelDepts(expItem);
        }
        if ((orgRowCount = this.getModel().getEntryRowCount(ORG_ENTRY_ORG)) > 0) {
            EntryGrid ortListEntry = (EntryGrid)this.getControl(ORG_ENTRY_ORG);
            ortListEntry.selectRows(0);
            DynamicObject relOrg = (DynamicObject)this.getModel().getValue(ORG_ORG, 0);
            this.initRelExpItems(relOrg);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String operateKey;
        super.beforeDoOperation(evt);
        FormOperate opt = (FormOperate)evt.getSource();
        switch (operateKey = opt.getOperateKey()) {
            case "releaseorg": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5373\u5c06\u89e3\u9664\u8d39\u7528\u9879\u76ee\u4e0e\u90e8\u95e8\u95f4\u5173\u8054\u5173\u7cfb", (String)"ExpItemRelDeptQuery_0", (String)"bd-assistant-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("releaseorg", (IFormPlugin)this));
                break;
            }
            case "releasexpitem": {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5373\u5c06\u89e3\u9664\u8d39\u7528\u9879\u76ee\u4e0e\u90e8\u95e8\u95f4\u5173\u8054\u5173\u7cfb", (String)"ExpItemRelDeptQuery_0", (String)"bd-assistant-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("releaseexpitem", (IFormPlugin)this));
                break;
            }
            case "addrelorg": {
                EntryGrid expEntry = (EntryGrid)this.getControl(EXP_ENTRY_EXP);
                if (expEntry.getSelectRows().length == 1) break;
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009 \u8d39\u7528\u9879\u76ee \u540e\u91cd\u8bd5", (String)"ExpItemRelDeptQuery_1", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                break;
            }
            case "addrelexpitem": {
                EntryGrid orgEntry = (EntryGrid)this.getControl(ORG_ENTRY_ORG);
                if (orgEntry.getSelectRows().length == 1) break;
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009 \u90e8\u95e8 \u540e\u91cd\u8bd5", (String)"ExpItemRelDeptQuery_2", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String operateKey;
        super.afterDoOperation(evt);
        FormOperate opt = (FormOperate)evt.getSource();
        switch (operateKey = opt.getOperateKey()) {
            case "addrelorg": {
                ListShowParameter orgList = ShowFormHelper.createShowListForm((String)"bos_adminorg", (boolean)true);
                ListFilterParameter orgParam = new ListFilterParameter();
                QFilter orgFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
                String orgid = this.getPageCache().get("filterorg");
                if (orgid != null && StringUtils.isNotEmpty((String)orgid)) {
                    ArrayList<Long> orgIdList = new ArrayList<Long>();
                    orgIdList.add(Long.valueOf(orgid));
                    List allSubordinateOrgs = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)1L, orgIdList, (boolean)true);
                    orgFilter.and("id", "in", (Object)allSubordinateOrgs);
                }
                orgParam.setFilter(orgFilter);
                orgList.setListFilterParameter(orgParam);
                orgList.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ORG_ENTRY_ORG));
                this.getView().showForm((FormShowParameter)orgList);
                break;
            }
            case "addrelexpitem": {
                EntryGrid orgEntry = (EntryGrid)this.getControl(ORG_ENTRY_ORG);
                int[] selectRows = orgEntry.getSelectRows();
                DynamicObject orgDym = (DynamicObject)this.getModel().getValue(ORG_ORG, selectRows[0]);
                QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataProFilter((String)"er_expenseitemedit", (Long)orgDym.getLong("id"), (String)"id");
                if (baseDataFilter == null) {
                    baseDataFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
                } else {
                    baseDataFilter.and(new QFilter("enable", "=", (Object)Boolean.TRUE));
                }
                ListShowParameter expList = ShowFormHelper.createShowListForm((String)"er_expenseitemedit", (boolean)true);
                ListFilterParameter listParam = new ListFilterParameter();
                listParam.setFilter(baseDataFilter);
                expList.setListFilterParameter(listParam);
                expList.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ORG_ENTRY_EXP));
                this.getView().showForm((FormShowParameter)expList);
                break;
            }
            case "copyrelation": {
                EntryGrid orgEntryGrid = (EntryGrid)this.getControl(ORG_ENTRY_ORG);
                DynamicObjectCollection relExpItemEntry = this.getModel().getEntryEntity(ORG_ENTRY_EXP);
                int[] selectedOrgs = orgEntryGrid.getSelectRows();
                if (selectedOrgs.length == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u590d\u5236\u5173\u8054\u7684\u90e8\u95e8\u3002", (String)"ExpItemRelDeptQuery_3", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                    break;
                }
                if (relExpItemEntry.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u90e8\u95e8\u672a\u5173\u8054\u8d39\u7528\u9879\u76ee\uff0c\u4e0d\u80fd\u8fdb\u884c\u590d\u5236\u5173\u8054\u3002", (String)"ExpItemRelDeptQuery_4", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                    break;
                }
                DynamicObject sourceOrg = (DynamicObject)this.getModel().getValue(ORG_ORG, selectedOrgs[0]);
                String formId = "bd_expitemcopyrelorg";
                MobileFormShowParameter showParameter = new MobileFormShowParameter();
                showParameter.setFormId(formId);
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setCustomParam("sourceorg", sourceOrg.getPkValue());
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, ORG_RELATE_COPY));
                this.getView().showForm((FormShowParameter)showParameter);
                break;
            }
        }
    }

    private void initRelExpItems(DynamicObject relOrg) {
        if (relOrg == null) {
            return;
        }
        QFilter[] qFilters = new QFilter[]{new QFilter("relorg", "=", relOrg.getPkValue())};
        this.getModel().deleteEntryData(ORG_ENTRY_EXP);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int rowIndex = 0;
        model.beginInit();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)ALGO, (String)"bd_expitemreldept", (String)"expenseitem", (QFilter[])qFilters, null);){
            for (Row row : ds) {
                long expenseitem = row.getLong("expenseitem");
                if (expenseitem == 0L) continue;
                vs.set(ORG_EXP, (Object)expenseitem, rowIndex);
                ++rowIndex;
            }
        }
        model.batchCreateNewEntryRow(ORG_ENTRY_EXP, vs);
        model.endInit();
        this.getView().updateView(ORG_ENTRY_EXP);
    }

    private void refreshRelDepts(DynamicObject expItem) {
        Object expItemId = expItem.getPkValue();
        QFilter[] qFilters = new QFilter("expenseitem", "=", expItemId).toArray();
        HashSet<Long> relOrgIds = new HashSet<Long>(2000);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)ALGO, (String)"bd_expitemreldept", (String)"relorg", (QFilter[])qFilters, null);){
            for (Row row : ds) {
                relOrgIds.add(row.getLong("relorg"));
            }
        }
        boolean hasDept = !relOrgIds.isEmpty();
        this.getModel().deleteEntryData(EXP_ENTRY_ORG);
        AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int rowIndex = 0;
        this.getModel().beginInit();
        QFilter orgFilter = new QFilter("view", "=", (Object)1L);
        orgFilter.and(new QFilter("org.id", "in", relOrgIds));
        try (Object ds = QueryServiceHelper.queryDataSet((String)ALGO, (String)"bos_adminorg_structure", (String)"id,org", (QFilter[])orgFilter.toArray(), null);){
            Iterator iterator = ds.iterator();
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                vs.set(EXP_ADMIN, row.get("id"), rowIndex);
                long orgId = row.getLong(EXP_ORG);
                if (orgId != 0L) {
                    vs.set(EXP_ORG, (Object)orgId, rowIndex);
                    relOrgIds.remove(orgId);
                }
                ++rowIndex;
            }
        }
        ds = relOrgIds.iterator();
        while (ds.hasNext()) {
            long relOrgId = (Long)ds.next();
            vs.set(EXP_ORG, (Object)relOrgId, rowIndex);
            ++rowIndex;
        }
        model.batchCreateNewEntryRow(EXP_ENTRY_ORG, vs);
        this.getModel().endInit();
        this.getView().updateView(EXP_ENTRY_ORG);
        EntryGrid orgEntry = (EntryGrid)this.getControl(EXP_ENTRY_ORG);
        this.getModel().setDataChanged(false);
        if (hasDept) {
            orgEntry.setPageIndex(1);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        EntryGrid actEntry = (EntryGrid)evt.getSource();
        String entryKey = actEntry.getEntryKey();
        int[] selectRows = actEntry.getSelectRows();
        if (selectRows.length < 1) {
            return;
        }
        switch (entryKey) {
            case "expitementry": {
                DynamicObject expItem = (DynamicObject)this.getModel().getValue(EXP_EXP, selectRows[0]);
                this.refreshRelDepts(expItem);
                break;
            }
            case "orglist": {
                DynamicObject relOrg = (DynamicObject)this.getModel().getValue(ORG_ORG, selectRows[0]);
                this.initRelExpItems(relOrg);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        int n;
        int n2;
        int[] nArray;
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        if ("releaseorg".equals(callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            EntryGrid expEntry = (EntryGrid)this.getControl(EXP_ENTRY_EXP);
            EntryGrid orgEntry = (EntryGrid)this.getControl(EXP_ENTRY_ORG);
            int[] expRows = expEntry.getSelectRows();
            int[] orgRows = orgEntry.getSelectRows();
            if (expRows.length < 1 || orgRows.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u4e2d \u8d39\u7528\u9879\u76ee \u6216 \u90e8\u95e8 \u5206\u5f55\u884c", (String)"ExpItemRelDeptQuery_5", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject expItem = (DynamicObject)this.getModel().getValue(EXP_EXP, expRows[0]);
            ArrayList<Long> expItemIds = new ArrayList<Long>(8);
            expItemIds.add(expItem.getLong("id"));
            ArrayList<Long> relOrgIds = new ArrayList<Long>(orgRows.length);
            nArray = orgRows;
            n2 = nArray.length;
            for (n = 0; n < n2; ++n) {
                Integer row = nArray[n];
                DynamicObject org = (DynamicObject)this.getModel().getValue(EXP_ORG, row.intValue());
                relOrgIds.add(org.getLong("id"));
            }
            this.releaseExpItemRelDept(expItemIds, relOrgIds);
            this.getModel().deleteEntryRows(EXP_ENTRY_ORG, orgRows);
            this.getView().showMessage(ResManager.loadKDString((String)"\u89e3\u9664\u6210\u529f", (String)"ExpItemRelDeptQuery_6", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
            this.getView().updateView(EXP_ENTRY_ORG);
        }
        if ("releaseexpitem".equals(callBackId) && MessageBoxResult.Yes.equals((Object)result)) {
            EntryGrid orgEntry = (EntryGrid)this.getControl(ORG_ENTRY_ORG);
            int[] orgRows = orgEntry.getSelectRows();
            EntryGrid expItemEntry = (EntryGrid)this.getControl(ORG_ENTRY_EXP);
            int[] expRows = expItemEntry.getSelectRows();
            if (orgRows.length < 1 || expRows.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u4e2d \u8d39\u7528\u9879\u76ee \u6216 \u90e8\u95e8 \u5206\u5f55\u884c", (String)"ExpItemRelDeptQuery_5", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject relOrg = (DynamicObject)this.getModel().getValue(ORG_ORG, orgRows[0]);
            if (relOrg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u7ec4\u7ec7", (String)"ExpItemRelDeptQuery_7", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                return;
            }
            ArrayList<Long> relOrgIds = new ArrayList<Long>(8);
            relOrgIds.add(relOrg.getLong("id"));
            if (expRows.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u4e2d\u8d39\u7528\u9879\u76ee\u540e\u518d\u64cd\u4f5c", (String)"ExpItemRelDeptQuery_8", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                return;
            }
            ArrayList<Long> expItemIds = new ArrayList<Long>();
            nArray = expRows;
            n2 = nArray.length;
            for (n = 0; n < n2; ++n) {
                Integer rowIndex = nArray[n];
                DynamicObject expItem = (DynamicObject)this.getModel().getValue(ORG_EXP, rowIndex.intValue());
                if (expItem == null) continue;
                expItemIds.add(expItem.getLong("id"));
            }
            this.releaseExpItemRelDept(expItemIds, relOrgIds);
            this.getModel().deleteEntryRows(ORG_ENTRY_EXP, expRows);
            this.getView().showMessage(ResManager.loadKDString((String)"\u89e3\u9664\u6210\u529f", (String)"ExpItemRelDeptQuery_6", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
            this.getView().updateView(ORG_ENTRY_EXP);
        }
    }

    private void releaseExpItemRelDept(List<Long> expItemId, List<Long> relOrgIds) {
        QFilter delFilter = new QFilter("expenseitem", "in", expItemId);
        delFilter.and(new QFilter("relorg", "in", relOrgIds));
        DeleteServiceHelper.delete((String)"bd_expitemreldept", (QFilter[])delFilter.toArray());
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        Object returnData = closedCallBackEvent.getReturnData();
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "expitemlist": {
                ListSelectedRowCollection addedItems = (ListSelectedRowCollection)returnData;
                if (addedItems == null || addedItems.isEmpty()) break;
                ArrayList addedItemKeys = new ArrayList(8);
                addedItems.forEach(addedItem -> addedItemKeys.add(addedItem.getPrimaryKeyValue()));
                DynamicObjectCollection expListDym = this.getModel().getEntryEntity(ORG_ENTRY_EXP);
                ArrayList currExpList = new ArrayList(8);
                expListDym.forEach(expItem -> currExpList.add(expItem.getDynamicObject(ORG_EXP).getPkValue()));
                EntryGrid orgEntry = (EntryGrid)this.getControl(ORG_ENTRY_ORG);
                int[] orgRows = orgEntry.getSelectRows();
                DynamicObject orgDym = (DynamicObject)this.getModel().getValue(ORG_ORG, orgRows[0]);
                addedItemKeys.removeAll(currExpList);
                DynamicObjectCollection rels = new DynamicObjectCollection();
                for (Object addItemKey : addedItemKeys) {
                    DynamicObject rel = BusinessDataServiceHelper.newDynamicObject((String)"bd_expitemreldept");
                    rel.set("expenseitem_id", addItemKey);
                    rel.set("relorg", (Object)orgDym);
                    rels.add((Object)rel);
                }
                if (!rels.isEmpty()) {
                    SaveServiceHelper.save((IDataEntityType)rels.getDynamicObjectType(), (Object[])rels.toArray());
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6dfb\u52a0\u5173\u8054\u6210\u529f", (String)"ExpItemRelDeptQuery_9", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                }
                this.initRelExpItems(orgDym);
                break;
            }
            case "orglist": {
                ListSelectedRowCollection orgList = (ListSelectedRowCollection)returnData;
                if (orgList == null || orgList.isEmpty()) break;
                ArrayList addedOrgItems = new ArrayList();
                orgList.forEach(addedItem -> addedOrgItems.add(addedItem.getPrimaryKeyValue()));
                DynamicObjectCollection orgListDym = this.getModel().getEntryEntity(EXP_ENTRY_ORG);
                ArrayList currOrgList = new ArrayList();
                orgListDym.forEach(orgItem -> currOrgList.add(orgItem.getDynamicObject(EXP_ORG).getPkValue()));
                addedOrgItems.removeAll(currOrgList);
                EntryGrid expEntry = (EntryGrid)this.getControl(EXP_ENTRY_EXP);
                int[] selectRows = expEntry.getSelectRows();
                DynamicObject expDym = (DynamicObject)this.getModel().getValue(EXP_EXP, selectRows[0]);
                DynamicObjectCollection newRels = new DynamicObjectCollection();
                for (Object addItemKey : addedOrgItems) {
                    DynamicObject rel = BusinessDataServiceHelper.newDynamicObject((String)"bd_expitemreldept");
                    rel.set("expenseitem", (Object)expDym);
                    rel.set("relorg_id", addItemKey);
                    newRels.add((Object)rel);
                }
                if (!newRels.isEmpty()) {
                    SaveServiceHelper.save((IDataEntityType)newRels.getDynamicObjectType(), (Object[])newRels.toArray());
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6dfb\u52a0\u5173\u8054\u6210\u529f", (String)"ExpItemRelDeptQuery_9", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                }
                this.refreshRelDepts(expDym);
                break;
            }
            case "orgrelatecopy": {
                Map orgMap = (Map)returnData;
                DynamicObjectCollection orgEntry = this.getModel().getEntryEntity(ORG_ENTRY_ORG);
                Set addedOrgPks = orgEntry.stream().filter(v -> v.getDynamicObject(ORG_ORG) != null).map(v -> v.getDynamicObject(ORG_ORG).getPkValue()).collect(Collectors.toSet());
                if (orgMap == null || orgMap.isEmpty()) break;
                Set newOrgSet = orgMap.keySet();
                newOrgSet.removeAll(addedOrgPks);
                if (newOrgSet.isEmpty()) break;
                int[] orgRows = this.getModel().batchCreateNewEntryRow(ORG_ENTRY_ORG, newOrgSet.size());
                Iterator it = orgMap.entrySet().iterator();
                for (int index : orgRows) {
                    if (!it.hasNext()) continue;
                    Map.Entry org = it.next();
                    this.getModel().setValue(ORG_ORG, org.getKey(), index);
                    this.getModel().setValue(ORG_ORG, org.getValue(), index);
                }
                break;
            }
        }
    }
}

