/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.taxc;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class MinimumTaxFormPlugin
extends AbstractFormPlugin
implements CellClickListener,
BeforeF7SelectListener {
    private static final String TAXATIONSYS = "taxationsys";
    private static final String TAXAREA = "taxarea";
    private static final String TAXATIONSYSUSA = "USA";

    public void registerListener(EventObject e) {
        BasedataEdit taxarea = (BasedataEdit)this.getView().getControl(TAXAREA);
        taxarea.addBeforeF7SelectListener(this::beforeF7Select);
        BasedataEdit lables = (BasedataEdit)this.getView().getControl("taxcategoryid");
        lables.addBeforeF7SelectListener(this::riskAddBeforeF7SelectListener);
        this.addItemClickListeners(new String[]{"toolbarap"});
        EntryGrid eg = (EntryGrid)this.getView().getControl("entryentity");
        eg.addCellClickListener((CellClickListener)this);
    }

    private void riskAddBeforeF7SelectListener(BeforeF7SelectEvent event) {
        ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
        if (this.getView().getModel().getValue(TAXATIONSYS) != null) {
            QFilter qFilter = new QFilter("taxationsysid", "=", (Object)this.getView().getModel().getDataEntity().getLong("taxationsys.id"));
            DynamicObject[] collection = BusinessDataServiceHelper.load((String)"bd_taxcategory", (String)"id", (QFilter[])new QFilter[]{qFilter});
            List ids = Arrays.stream(collection).map(e -> e.getLong("id")).collect(Collectors.toList());
            QFilter orgIdsFilter = new QFilter("id", "in", ids);
            formShowParameter.getListFilterParameter().getQFilters().add(orgIdsFilter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        ChangeData cd = e.getChangeSet()[0];
        if (StringUtils.equals((CharSequence)TAXATIONSYS, (CharSequence)propertyName)) {
            this.getModel().setValue(TAXAREA, null);
            DynamicObject newWord = (DynamicObject)cd.getNewValue();
            if (!ObjectUtils.isEmpty((Object)newWord) && !ObjectUtils.isEmpty((Object)newWord)) {
                Long countryId = newWord.getDynamicObject("countryid").getLong("id");
                Date now = new Date();
                QFilter qFilter = new QFilter("country", "=", (Object)countryId).and("enable", "=", (Object)"1").and("startdate", "<=", (Object)now).and("group.enable", "=", (Object)"1").and(QFilter.isNull((String)"enddate").or("enddate", ">=", (Object)now));
                DynamicObject taxareaObj = BusinessDataServiceHelper.loadSingle((String)"bastax_taxarea", (String)"id,group", (QFilter[])new QFilter[]{qFilter});
                if (taxareaObj != null) {
                    this.getModel().setValue(TAXAREA, taxareaObj.getDynamicObject("group").getPkValue());
                }
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        if (StringUtils.equals((CharSequence)fieldKey, (CharSequence)TAXAREA)) {
            DynamicObject taxationsysObj = this.getModel().getDataEntity().getDynamicObject(TAXATIONSYS);
            List areaGroupIds = null;
            if (taxationsysObj != null) {
                Long countryId = taxationsysObj.getDynamicObject("countryid").getLong("id");
                Date now = new Date();
                QFilter qFilter = new QFilter("country", "=", (Object)countryId).and("enable", "=", (Object)"1").and("startdate", "<=", (Object)now).and("group.enable", "=", (Object)"1").and(QFilter.isNull((String)"enddate").or("enddate", ">=", (Object)now));
                DynamicObject[] taxareaObj = BusinessDataServiceHelper.load((String)"bastax_taxarea", (String)"id,group", (QFilter[])new QFilter[]{qFilter});
                if (taxareaObj != null && taxareaObj.length > 0) {
                    areaGroupIds = Arrays.stream(taxareaObj).map(o -> o.getLong("group.id")).collect(Collectors.toList());
                }
            }
            if (!CollectionUtils.isEmpty(areaGroupIds)) {
                QFilter idQFilter = new QFilter("id", "in", areaGroupIds);
                formShowParameter.getListFilterParameter().setFilter(idQFilter);
            } else {
                formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "=", (Object)-1));
            }
        }
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        String fieldkey = cellClickEvent.getFieldKey();
        int row = cellClickEvent.getRow();
        if ("operationcolumnap".equals(fieldkey)) {
            String extentjsonTag = this.getView().getModel().getValue("extentjson_tag", row).toString();
            this.openPage(fieldkey, row, extentjsonTag);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String id = event.getActionId();
        Map returnData = (Map)event.getReturnData();
        String[] ids = id.split("_");
        if (null != returnData) {
            String extentjson = returnData.get("extentjson").toString();
            this.getModel().setValue("extentjson_tag", (Object)extentjson, Integer.parseInt(ids[1]));
            String extent = returnData.get("extent").toString();
            this.getModel().setValue("extent", (Object)extent, Integer.parseInt(ids[1]));
        }
    }

    private void openPage(String key, int row, String extentjsonTag) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bd_extentfilter");
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key + "_" + row);
        showParameter.setCustomParam("extentjson_tag", (Object)extentjsonTag);
        showParameter.setCustomParam("entityFLag", (Object)"bd_minimumtax");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void cellDoubleClick(CellClickEvent arg0) {
    }
}

