/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.taxc;

import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.DecimalEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class TaxRatePlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
CellClickListener {
    private static final String VALUETYPE = "valuetype";
    private static final String TAXUNIT = "taxunit";
    private static final String TAXCATEGORYID = "taxcategoryid";
    private static final String TAXATIONSYS = "taxationsys";
    private static final String VALUETYPE_2 = "2";
    private static final String EXTENT = "extent";
    private static final String EXTENTJSON_TAG = "extentjson_tag";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit taxcategoryidBE = (BasedataEdit)this.getControl(TAXCATEGORYID);
        taxcategoryidBE.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid eg = (EntryGrid)this.getView().getControl("entryentity");
        eg.addCellClickListener((CellClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setMeasureUnitMustInput((String)this.getModel().getValue(VALUETYPE));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Save) {
            DynamicObject[] objs;
            String number = (String)this.getModel().getValue("number");
            QFilter qFilter = new QFilter("number", "=", (Object)number);
            if (!OperationStatus.ADDNEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
                Long pkId = this.getModel().getDataEntity().getLong("id");
                qFilter.and(new QFilter("id", "!=", (Object)pkId));
            }
            if ((objs = BusinessDataServiceHelper.load((String)"bd_taxrate", (String)"id, createorg,number", (QFilter[])new QFilter[]{qFilter})) != null && objs.length > 0) {
                args.setCancel(true);
                DynamicObject obj = objs[0];
                String orgName = obj.getDynamicObject("createorg").getString("name");
                String orgNumber = obj.getDynamicObject("createorg").getString("number");
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"%1$s %2$s\u4e0b\u5b58\u5728\u76f8\u540c\u7684\u7f16\u7801:%3$s", (String)"TaxRatePlugin_0", (String)"bd-assistant-formplugin", (Object[])new Object[0]), orgNumber, orgName, number));
                return;
            }
        }
    }

    public void beforeBindData(EventObject e) {
        this.changeEdit(this.getView().getModel().getDataEntity().getString("taxratetype.number"));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)VALUETYPE)) {
            this.setMeasureUnitMustInput((String)e.getChangeSet()[0].getNewValue());
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)TAXATIONSYS)) {
            this.getModel().setValue(TAXCATEGORYID, null);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"taxratetype")) {
            this.getModel().deleteEntryData("entryentity");
            this.getModel().batchCreateNewEntryRow("entryentity", 1);
            ChangeData cd = e.getChangeSet()[0];
            DynamicObject newWord = (DynamicObject)cd.getNewValue();
            if (newWord == null) {
                this.changeEdit(null);
            } else {
                this.changeEdit(newWord.getString("number"));
            }
        }
    }

    private void changeEdit(String newWord) {
        if ("SLLX-04".equals(newWord) || "SLLX-05".equals(newWord)) {
            TextEdit edit = (TextEdit)this.getView().getControl(EXTENT);
            edit.setMustInput(true);
            DecimalEdit editmin = (DecimalEdit)this.getView().getControl("minimumtax");
            editmin.setMustInput(true);
        } else {
            TextEdit edit = (TextEdit)this.getView().getControl(EXTENT);
            edit.setMustInput(false);
            DecimalEdit editmin = (DecimalEdit)this.getView().getControl("minimumtax");
            editmin.setMustInput(false);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = beforeF7SelectEvent.getProperty().getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)TAXCATEGORYID)) {
            DynamicObject taxation = this.getModel().getDataEntity().getDynamicObject(TAXATIONSYS);
            if (null == taxation) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7a0e\u6536\u5236\u5ea6", (String)"TaxRatePlugin_1", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter taxationsysidQ = new QFilter("taxationsysid", "=", taxation.get("id"));
            beforeF7SelectEvent.getCustomQFilters().add(taxationsysidQ);
        }
    }

    private void setMeasureUnitMustInput(String valueType) {
        BasedataEdit basedataEdit = (BasedataEdit)this.getControl(TAXUNIT);
        basedataEdit.setMustInput(false);
        if (StringUtils.equalsIgnoreCase((CharSequence)valueType, (CharSequence)VALUETYPE_2)) {
            basedataEdit.setMustInput(true);
        }
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        String fieldkey = cellClickEvent.getFieldKey();
        int row = cellClickEvent.getRow();
        if ("operationcolumnap".equals(fieldkey)) {
            String extentjsonTag = this.getView().getModel().getValue(EXTENTJSON_TAG, row).toString();
            this.openPage(fieldkey, row, extentjsonTag);
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String id = event.getActionId();
        Map returnData = (Map)event.getReturnData();
        String[] ids = id.split("_");
        if (null != returnData) {
            String extentjson = returnData.get("extentjson").toString();
            this.getModel().setValue(EXTENTJSON_TAG, (Object)extentjson, Integer.parseInt(ids[1]));
            String extent = returnData.get(EXTENT).toString();
            this.getModel().setValue(EXTENT, (Object)extent, Integer.parseInt(ids[1]));
        }
    }

    private void openPage(String key, int row, String extentjsonTag) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bd_extentfilter");
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, key + "_" + row);
        showParameter.setCustomParam(EXTENTJSON_TAG, (Object)extentjsonTag);
        showParameter.setCustomParam("entityFLag", (Object)"bd_taxrate");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    public void cellDoubleClick(CellClickEvent arg0) {
    }
}

