/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.service.arap;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ToleranceMatchService {
    public static List<Map<String, Object>> getResultByToleranceType(String controller, String contraster, String controlitem, String contrastitem, List<Map<String, Object>> params) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(16);
        if (params.size() == 0) {
            return result;
        }
        DynamicObject toleranceType = BusinessDataServiceHelper.loadSingle((String)"ap_tolerancetype", (String)"id", (QFilter[])new QFilter[]{new QFilter("controller", "=", (Object)controller), new QFilter("contraster", "=", (Object)contraster), new QFilter("controlitem", "=", (Object)controlitem), new QFilter("contrastitem", "=", (Object)contrastitem), new QFilter("enable", "=", (Object)Boolean.TRUE)});
        if (toleranceType == null) {
            return result;
        }
        Long toleranceTypeId = toleranceType.getLong("id");
        DynamicObject toleranceScheme = BusinessDataServiceHelper.loadSingleFromCache((String)"ap_tolerancescheme", (QFilter[])new QFilter[]{new QFilter("controller", "=", (Object)controller), new QFilter("contraster", "=", (Object)contraster), new QFilter("enable", "=", (Object)Boolean.TRUE)});
        if (toleranceScheme == null) {
            return result;
        }
        DynamicObjectCollection entry = toleranceScheme.getDynamicObjectCollection("entry");
        for (DynamicObject row : entry) {
            Long rowToleranceTypeId = row.getDynamicObject("e_tolerancetypeid").getLong("id");
            if (!toleranceTypeId.equals(rowToleranceTypeId)) continue;
            ToleranceMatchService.matchAndCompare(controlitem, contrastitem, row, params, result);
            break;
        }
        return result;
    }

    public static List<Map<String, Object>> getResultByToleranceScheme(String controller, String contraster, List<Map<String, Object>> params) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(16);
        HashMap<String, ArrayList<Map<String, Object>>> paramSplitByToleranceType = new HashMap<String, ArrayList<Map<String, Object>>>(8);
        for (Map<String, Object> map : params) {
            String controlitem = (String)map.get("controlitem");
            String contrastitem = (String)map.get("contrastitem");
            String itemKey = controlitem + "_" + contrastitem;
            ArrayList<Map<String, Object>> itemList = (ArrayList<Map<String, Object>>)paramSplitByToleranceType.get(itemKey);
            if (itemList == null) {
                itemList = new ArrayList<Map<String, Object>>(16);
                itemList.add(map);
                paramSplitByToleranceType.put(itemKey, itemList);
                continue;
            }
            itemList.add(map);
        }
        for (Map.Entry entry : paramSplitByToleranceType.entrySet()) {
            List paramGroupByToleranceType = (List)entry.getValue();
            String controlitem = (String)((Map)paramGroupByToleranceType.get(0)).get("controlitem");
            String contrastitem = (String)((Map)paramGroupByToleranceType.get(0)).get("contrastitem");
            result.addAll(ToleranceMatchService.getResultByToleranceType(controller, contraster, controlitem, contrastitem, paramGroupByToleranceType));
        }
        return result;
    }

    public static void matchAndCompare(String controlitem, String contrastitem, DynamicObject row, List<Map<String, Object>> params, List<Map<String, Object>> result) {
        String toleranceDim = row.getString("e_tolerancedim");
        String dimensionMap = row.getString("e_dimensionmap");
        String limittolerancetype = row.getString("e_limittolerancetype");
        String uptolerancetype = row.getString("e_uptolerancetype");
        ArrayList<Object> tolerancePks = new ArrayList<Object>(16);
        String[] toleranceDims = new String[]{};
        DynamicObjectCollection subEntry = row.getDynamicObjectCollection("subentry");
        if (toleranceDim != null && !"".equals(toleranceDim)) {
            toleranceDims = toleranceDim.substring(1).split(",");
            HashMap<String, ArrayList<Map<String, Object>>> paramGroupByDim = new HashMap<String, ArrayList<Map<String, Object>>>(16);
            for (Map<String, Object> param : params) {
                StringBuilder matchKey = null;
                for (String dim : toleranceDims) {
                    if (!param.containsKey(dim)) {
                        matchKey = null;
                        break;
                    }
                    Object dimValues = param.get(dim);
                    if (dimValues == null || "".equals(dimValues)) {
                        if (matchKey == null) {
                            matchKey = new StringBuilder("null");
                            continue;
                        }
                        matchKey.append('_').append("null");
                        continue;
                    }
                    if (dimValues instanceof List) {
                        List list = (List)dimValues;
                        List dimStrList = list.stream().map(v -> String.valueOf(v)).collect(Collectors.toList());
                        if (matchKey == null) {
                            matchKey = new StringBuilder(String.join((CharSequence)"_", dimStrList));
                            continue;
                        }
                        matchKey.append('_').append(String.valueOf(dimValues));
                        continue;
                    }
                    if (matchKey == null) {
                        matchKey = new StringBuilder(String.valueOf(param.get(dim)));
                        continue;
                    }
                    matchKey.append('_').append(String.valueOf(param.get(dim)));
                }
                if (matchKey == null) continue;
                ArrayList<Map<String, Object>> paramList = (ArrayList<Map<String, Object>>)paramGroupByDim.get(matchKey.toString());
                if (paramList == null) {
                    paramList = new ArrayList<Map<String, Object>>(16);
                    paramList.add(param);
                    paramGroupByDim.put(matchKey.toString(), paramList);
                    continue;
                }
                paramList.add(param);
            }
            ArrayList<Map<String, Object>> toleranceLimits = new ArrayList<Map<String, Object>>(16);
            ArrayList<Map<String, Object>> toleranceUps = new ArrayList<Map<String, Object>>(16);
            Map toleranceDimMap = (Map)SerializationUtils.fromJsonString((String)dimensionMap, Map.class);
            for (DynamicObject dynamicObject : subEntry) {
                HashMap<String, Serializable> rowToleranceLimit = new HashMap<String, Serializable>(16);
                HashMap<String, Serializable> rowToleranceUp = new HashMap<String, Serializable>(16);
                for (Map.Entry entry : toleranceDimMap.entrySet()) {
                    if (!((String)entry.getValue()).endsWith("_pk")) continue;
                    String dimensionKey = ((String)entry.getValue()).substring(0, ((String)entry.getValue()).length() - 3);
                    String string = dynamicObject.getString((String)entry.getKey());
                    List dimensionPkList = Stream.of(string.split(",")).collect(Collectors.toList());
                    HashMap<Long, String> dimensionPkLongList = new HashMap<Long, String>(8);
                    for (String pk : dimensionPkList) {
                        if ("".equals(pk)) continue;
                        dimensionPkLongList.put(Long.valueOf(pk), pk);
                    }
                    rowToleranceLimit.put(dimensionKey, dimensionPkLongList);
                    rowToleranceUp.put(dimensionKey, dimensionPkLongList);
                }
                if (!"notctrl".equals(limittolerancetype)) {
                    rowToleranceLimit.put("tolerancelimit", dynamicObject.getBigDecimal("s_limittolerance"));
                    toleranceLimits.add(rowToleranceLimit);
                }
                if ("notctrl".equals(uptolerancetype)) continue;
                rowToleranceUp.put("uptolerance", dynamicObject.getBigDecimal("s_uptolerance"));
                toleranceUps.add(rowToleranceUp);
            }
            ToleranceMatchService.sortToleranceList(toleranceLimits, "tolerancelimit");
            ToleranceMatchService.sortToleranceList(toleranceUps, "uptolerance");
            block5: for (Map.Entry entry : paramGroupByDim.entrySet()) {
                boolean isContainsOne;
                List values;
                Map dimPks;
                Object dimValues;
                boolean isMatch;
                List value = (List)entry.getValue();
                Map param = (Map)value.get(0);
                if (!"notctrl".equals(uptolerancetype)) {
                    for (Map map : toleranceUps) {
                        isMatch = true;
                        for (String string : toleranceDims) {
                            dimValues = param.get(string);
                            dimPks = (Map)map.get(string);
                            if (dimValues == null || "".equals(dimValues)) {
                                if (dimPks == null || dimPks.size() == 0) continue;
                                isMatch = false;
                                break;
                            }
                            if (dimValues instanceof List) {
                                values = (List)dimValues;
                                isContainsOne = false;
                                if (dimPks.size() == 0) continue;
                                for (Long dataId : values) {
                                    if (dimPks.get(dataId) == null) continue;
                                    isContainsOne = true;
                                    break;
                                }
                                if (isContainsOne) continue;
                                isMatch = false;
                                continue;
                            }
                            if (dimPks == null || dimPks.size() == 0 || dimPks.get((Long)param.get(string)) != null) continue;
                            isMatch = false;
                            break;
                        }
                        if (!isMatch) continue;
                        BigDecimal bigDecimal = (BigDecimal)map.get("uptolerance");
                        ToleranceMatchService.compareUpTolerance(controlitem, contrastitem, bigDecimal, value, uptolerancetype, result, tolerancePks);
                        break;
                    }
                }
                if ("notctrl".equals(limittolerancetype)) continue;
                for (Map map : toleranceLimits) {
                    isMatch = true;
                    for (String string : toleranceDims) {
                        dimValues = param.get(string);
                        dimPks = (Map)map.get(string);
                        if (dimValues == null || "".equals(dimValues)) {
                            if (dimPks == null || dimPks.size() == 0) continue;
                            isMatch = false;
                            break;
                        }
                        if (dimValues instanceof List) {
                            values = (List)dimValues;
                            isContainsOne = false;
                            if (dimPks.size() == 0) continue;
                            for (Long dataId : values) {
                                if (dimPks.get(dataId) == null) continue;
                                isContainsOne = true;
                                break;
                            }
                            if (isContainsOne) continue;
                            isMatch = false;
                            continue;
                        }
                        if (dimPks == null || dimPks.size() == 0 || dimPks.get((Long)param.get(string)) != null) continue;
                        isMatch = false;
                        break;
                    }
                    if (!isMatch) continue;
                    BigDecimal bigDecimal = (BigDecimal)map.get("tolerancelimit");
                    ToleranceMatchService.compareLimitTolerance(controlitem, contrastitem, bigDecimal, value, limittolerancetype, result, tolerancePks);
                    continue block5;
                }
            }
        } else {
            if (!"notctrl".equals(uptolerancetype)) {
                BigDecimal upTolerance = null;
                for (DynamicObject entry : subEntry) {
                    BigDecimal entryUpTolerance = entry.getBigDecimal("s_uptolerance");
                    if (upTolerance == null) {
                        upTolerance = entryUpTolerance;
                        continue;
                    }
                    upTolerance = upTolerance.compareTo(entryUpTolerance) > 0 ? entryUpTolerance : upTolerance;
                }
                ToleranceMatchService.compareUpTolerance(controlitem, contrastitem, upTolerance, params, uptolerancetype, result, tolerancePks);
            }
            if (!"notctrl".equals(limittolerancetype)) {
                BigDecimal limitolerance = null;
                for (DynamicObject entry : subEntry) {
                    BigDecimal entryLimitTolerance = entry.getBigDecimal("s_limittolerance");
                    if (limitolerance == null) {
                        limitolerance = entryLimitTolerance;
                        continue;
                    }
                    limitolerance = limitolerance.compareTo(entryLimitTolerance) > 0 ? entryLimitTolerance : limitolerance;
                }
                ToleranceMatchService.compareLimitTolerance(controlitem, contrastitem, limitolerance, params, limittolerancetype, result, tolerancePks);
            }
        }
    }

    public static void compareLimitTolerance(String controlitem, String contrastitem, BigDecimal toleranceLimit, List<Map<String, Object>> params, String limitTolerancetype, List<Map<String, Object>> result, List<Object> tolerancePks) {
        for (Map<String, Object> paramMap : params) {
            HashMap<String, Object> excessMap;
            Object tolerancePk = paramMap.get("pk");
            if (tolerancePks.contains(tolerancePk)) continue;
            BigDecimal controlValue = (BigDecimal)paramMap.get("controlvalue");
            BigDecimal contrastValue = (BigDecimal)paramMap.get("contrastvalue");
            int contrastDirection = contrastValue.signum();
            int precision = (Integer)paramMap.get("precision");
            BigDecimal subsidenceValue = "percent".equals(limitTolerancetype) ? contrastValue.abs().multiply(BigDecimal.ONE.subtract(toleranceLimit.divide(new BigDecimal("100")).setScale(10, RoundingMode.HALF_UP))).setScale(precision, RoundingMode.HALF_UP) : contrastValue.abs().subtract(toleranceLimit).setScale(precision, RoundingMode.HALF_UP);
            if (contrastDirection == -1 && controlValue.compareTo(subsidenceValue.negate()) > 0) {
                excessMap = new HashMap<String, Object>(8);
                excessMap.put("pk", paramMap.get("pk"));
                excessMap.put("isoverup", true);
                excessMap.put("controlitem", controlitem);
                excessMap.put("contrastitem", contrastitem);
                excessMap.put("overupvalue", controlValue.subtract(subsidenceValue).abs());
                result.add(excessMap);
                tolerancePks.add(paramMap.get("pk"));
                continue;
            }
            if (contrastDirection == -1 || controlValue.compareTo(subsidenceValue) >= 0) continue;
            excessMap = new HashMap(8);
            excessMap.put("pk", paramMap.get("pk"));
            excessMap.put("isoverlower", true);
            excessMap.put("controlitem", controlitem);
            excessMap.put("contrastitem", contrastitem);
            excessMap.put("overlowervalue", subsidenceValue.subtract(controlValue));
            result.add(excessMap);
            tolerancePks.add(paramMap.get("pk"));
        }
    }

    public static void compareUpTolerance(String controlitem, String contrastitem, BigDecimal toleranceUp, List<Map<String, Object>> params, String upTolerancetype, List<Map<String, Object>> result, List<Object> tolerancePks) {
        for (Map<String, Object> paramMap : params) {
            HashMap<String, Object> excessMap;
            Object tolerancePk = paramMap.get("pk");
            if (tolerancePks.contains(tolerancePk)) continue;
            BigDecimal controlValue = (BigDecimal)paramMap.get("controlvalue");
            BigDecimal contrastValue = (BigDecimal)paramMap.get("contrastvalue");
            int contrastDirection = contrastValue.signum();
            int precision = (Integer)paramMap.get("precision");
            BigDecimal subsidenceValue = "percent".equals(upTolerancetype) ? contrastValue.abs().multiply(toleranceUp.divide(new BigDecimal("100")).setScale(10, RoundingMode.HALF_UP).add(BigDecimal.ONE)).setScale(precision, RoundingMode.HALF_UP) : contrastValue.abs().add(toleranceUp).setScale(precision, RoundingMode.HALF_UP);
            if (contrastDirection == -1 && controlValue.compareTo(subsidenceValue.negate()) < 0) {
                excessMap = new HashMap<String, Object>(8);
                excessMap.put("pk", paramMap.get("pk"));
                excessMap.put("isoverlower", true);
                excessMap.put("controlitem", controlitem);
                excessMap.put("contrastitem", contrastitem);
                excessMap.put("overlowervalue", subsidenceValue.subtract(controlValue));
                result.add(excessMap);
                tolerancePks.add(paramMap.get("pk"));
                continue;
            }
            if (contrastDirection == -1 || controlValue.compareTo(subsidenceValue) <= 0) continue;
            excessMap = new HashMap(8);
            excessMap.put("pk", paramMap.get("pk"));
            excessMap.put("isoverup", true);
            excessMap.put("controlitem", controlitem);
            excessMap.put("contrastitem", contrastitem);
            excessMap.put("overupvalue", controlValue.subtract(subsidenceValue));
            result.add(excessMap);
            tolerancePks.add(paramMap.get("pk"));
        }
    }

    public static void sortToleranceList(List<Map<String, Object>> toleranceList, final String tolranceType) {
        Collections.sort(toleranceList, new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                return ((BigDecimal)o1.get(tolranceType)).compareTo((BigDecimal)o2.get(tolranceType));
            }
        });
    }
}

