/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orgview.costcenter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class CostCenterSavePlugin
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(CostCenterSavePlugin.class);
    public static final String SOURCE = "source";
    public static final String BOS_COSTCENTER_SOURCE = "bos_costcentersource";
    public static final String DATA = "data";
    public static final String SOURCE_TYPE = "sourcetype";
    public static final String SOURCE_TYPE_OBJ = "sourcetypeobj";
    public static final String COSTCENTER = "costcenter";
    public static final String ADD_TYPE = "addtype";

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                if (dataEntities == null || dataEntities.length == 0) {
                    return;
                }
                Set<String> costCenterNumSet = this.getCostCenterNumSet(dataEntities);
                Map<String, DynamicObject> costCenterSourceMap = this.getCostCenterSource(costCenterNumSet);
                HashMap<String, Set<String>> cacheDataIdMap = new HashMap<String, Set<String>>(16);
                String addType = dataEntities[0].getDataEntity().getString(CostCenterSavePlugin.ADD_TYPE);
                if ("execl".equals(addType)) {
                    Map<String, DynamicObject> srcTypeMap = this.getsSrcTypesMap();
                    for (ExtendedDataEntity dataEntity : dataEntities) {
                        this.addSrcType(dataEntity, srcTypeMap);
                        this.checkIsPreData(dataEntity);
                        this.checkUsedData(dataEntity, costCenterSourceMap, cacheDataIdMap);
                    }
                }
            }

            private Map<String, DynamicObject> getsSrcTypesMap() {
                DynamicObject[] srcTypes = BusinessDataServiceHelper.load((String)"bos_costcentersourcetype", (String)"id, number, name, bizobject", null);
                HashMap<String, DynamicObject> srcTypeMap = new HashMap<String, DynamicObject>(16);
                for (int i = 0; i < srcTypes.length; ++i) {
                    if (srcTypes[i].getDynamicObject("bizobject") == null) continue;
                    srcTypeMap.put(srcTypes[i].getDynamicObject("bizobject").getString("number"), srcTypes[i]);
                }
                return srcTypeMap;
            }

            private void addSrcType(ExtendedDataEntity dataEntity, Map<String, DynamicObject> srcTypeMap) {
                DynamicObject costCenter = dataEntity.getDataEntity();
                for (DynamicObject row : costCenter.getDynamicObjectCollection("entryentity")) {
                    String sourceTypeObj = row.getString(CostCenterSavePlugin.SOURCE_TYPE_OBJ);
                    if (StringUtils.isEmpty((CharSequence)sourceTypeObj)) {
                        return;
                    }
                    row.set(CostCenterSavePlugin.SOURCE_TYPE, (Object)srcTypeMap.get(sourceTypeObj));
                }
            }

            private void checkUsedData(ExtendedDataEntity dataEntity, Map<String, DynamicObject> costCenterSourceMap, Map<String, Set<String>> cacheDataIdMap) {
                DynamicObject costCenter = dataEntity.getDataEntity();
                if (StringUtils.isEmpty((CharSequence)costCenter.getString("number"))) {
                    return;
                }
                for (DynamicObject row : costCenter.getDynamicObjectCollection("entryentity")) {
                    DynamicObject data = row.getDynamicObject(CostCenterSavePlugin.DATA);
                    if (data == null) {
                        return;
                    }
                    DynamicObject sourceTypeObj = row.getDynamicObject(CostCenterSavePlugin.SOURCE_TYPE);
                    if (sourceTypeObj == null) {
                        return;
                    }
                    String dataId = data.getString("id");
                    String rowDataKey = sourceTypeObj.getString("id") + '@' + dataId;
                    DynamicObject sysCostCenter = costCenterSourceMap.get(rowDataKey);
                    if (sysCostCenter != null && costCenter.getLong("id") != sysCostCenter.getLong("costCenterId")) {
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6240\u9009\u7684\u6765\u6e90\u6570\u636e\u5df2\u7ecf\u88ab\u6210\u672c\u4e2d\u5fc3\uff08%s\uff09 \u5f15\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CostCenterSavePlugin_0", (String)"bd-assistant-formplugin", (Object[])new Object[0]), sysCostCenter.getString("costCenterNum")));
                        return;
                    }
                    for (Map.Entry<String, Set<String>> cacheDataIdEntry : cacheDataIdMap.entrySet()) {
                        if (costCenter.getString("number").equals(cacheDataIdEntry.getKey()) || !cacheDataIdEntry.getValue().contains(rowDataKey)) continue;
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6240\u9009\u7684\u6765\u6e90\u6570\u636e\u5df2\u7ecf\u88ab\u6210\u672c\u4e2d\u5fc3\uff08%s\uff09 \u5f15\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CostCenterSavePlugin_0", (String)"bd-assistant-formplugin", (Object[])new Object[0]), cacheDataIdEntry.getKey()));
                        return;
                    }
                    cacheDataIdMap.computeIfAbsent(costCenter.getString("number"), s -> new HashSet()).add(rowDataKey);
                }
            }

            private Map<String, DynamicObject> getCostCenterSource(Set<String> costCenterNumSet) {
                String fields = "costcenter.number AS costCenterNum,costcenter.id AS costCenterId,sourcetype.id AS sourceTypeId,data AS dataId";
                DynamicObjectCollection costCenterSources = QueryServiceHelper.query((String)CostCenterSavePlugin.BOS_COSTCENTER_SOURCE, (String)fields, null);
                HashMap<String, DynamicObject> costCenterSourceMap = new HashMap<String, DynamicObject>(16);
                costCenterSources.forEach(e -> costCenterSourceMap.put(e.getString("sourceTypeId") + '@' + e.getString("dataId"), (DynamicObject)e));
                return costCenterSourceMap;
            }

            private Set<String> getCostCenterNumSet(ExtendedDataEntity[] dataEntities) {
                HashSet<String> costCenterNumSet = new HashSet<String>(16);
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject costCenter = dataEntity.getDataEntity();
                    costCenterNumSet.add(costCenter.getString("number"));
                }
                return costCenterNumSet;
            }

            private void checkIsPreData(ExtendedDataEntity dataEntity) {
                DynamicObject costCenter = dataEntity.getDataEntity();
                long costCenterId = costCenter.getLong("id");
                DynamicObject parent = costCenter.getDynamicObject("parent");
                if (costCenterId != 100000L && parent == null) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u975e\u6839\u8282\u70b9\u6570\u636e\uff0c\u4e0a\u7ea7\u4e3a\u5fc5\u5f55\u9879\u3002", (String)"CostCenterSavePlugin_1", (String)"bd-assistant-formplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        if (e.getDataEntities() == null || e.getDataEntities().length <= 0) {
            return;
        }
        ArrayList successObjs = new ArrayList();
        ArrayList<String> dataIds = null;
        for (DynamicObject dataEntity : e.getDataEntities()) {
            try {
                long costcenterID = (Long)dataEntity.getPkValue();
                DeleteServiceHelper.delete((String)BOS_COSTCENTER_SOURCE, (QFilter[])new QFilter[]{new QFilter(COSTCENTER, "=", (Object)costcenterID)});
                DynamicObjectCollection col = dataEntity.getDynamicObjectCollection("entryentity");
                if (col == null || col.isEmpty()) continue;
                int count = col.size();
                ArrayList<DynamicObject> array = new ArrayList<DynamicObject>(count);
                dataIds = new ArrayList<String>(col.size());
                int seq = 1;
                for (DynamicObject obj : col) {
                    String dataId;
                    String rowDataKey;
                    DynamicObject sourceTypeObj;
                    DynamicObject data = obj.getDynamicObject(DATA);
                    if (data == null || (sourceTypeObj = obj.getDynamicObject(SOURCE_TYPE)) == null || dataIds.contains(rowDataKey = (dataId = data.getString("id")) + "_" + sourceTypeObj.getString("id"))) continue;
                    dataIds.add(rowDataKey);
                    DynamicObject costcenterSource = BusinessDataServiceHelper.newDynamicObject((String)BOS_COSTCENTER_SOURCE);
                    costcenterSource.set("id", (Object)obj.getLong("entryid"));
                    costcenterSource.set("fseq", (Object)seq++);
                    costcenterSource.set(DATA, (Object)dataId);
                    costcenterSource.set(SOURCE_TYPE, obj.get(SOURCE_TYPE));
                    costcenterSource.set(COSTCENTER, (Object)costcenterID);
                    array.add(costcenterSource);
                }
                if (array.isEmpty()) continue;
                SaveServiceHelper.save((DynamicObject[])array.toArray(new DynamicObject[0]));
            }
            catch (KDBizException exp) {
                ValidationErrorInfo errorInfo = this.buildErrMessage(dataEntity, exp);
                this.operationResult.addErrorInfo((OperateErrorInfo)errorInfo);
                logger.error(errorInfo.getMessage(), (Throwable)exp);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u672c\u4e2d\u5fc3\u6765\u6e90\u6570\u636e\u5931\u8d25\uff1a%s", (String)"CostCenterSavePlugin_2", (String)"bd-assistant-formplugin", (Object[])new Object[0]), errorInfo.getMessage()));
            }
        }
        SaveServiceHelper.save((DynamicObject[])e.getDataEntities());
        e.setDataEntities(successObjs.toArray(new DynamicObject[successObjs.size()]));
    }

    private ValidationErrorInfo buildErrMessage(DynamicObject obj, KDBizException exp) {
        Object pkId = obj.getPkValue();
        int dataIndex = 0;
        int rowIndex = 0;
        ErrorLevel errorLevel = ErrorLevel.Error;
        String msg = exp.getMessage();
        ValidationErrorInfo info = new ValidationErrorInfo("", pkId, dataIndex, rowIndex, exp.getErrorCode().getCode(), ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u4fdd\u5b58\u4e1a\u52a1\u4fe1\u606f", (String)"CostCenterSavePlugin_3", (String)"bd-assistant-formplugin", (Object[])new Object[0]), msg, errorLevel);
        return info;
    }
}

