/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.orgview.costcenter;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class CostCenterSourceMapTreeListPlugin
extends StandardTreeListPlugin {
    private final Log logger = LogFactory.getLog(CostCenterSourceMapTreeListPlugin.class);
    private static final String ROOTNODEID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private Map<String, List<Map<String, String>>> childNodes = null;

    public void beforeShowBill(BeforeShowBillFormEvent arg0) {
        super.beforeShowBill(arg0);
        BillShowParameter paramter = arg0.getParameter();
        Map customParams = paramter.getCustomParams();
        if (!customParams.containsKey("tree_parent_id")) {
            return;
        }
        Object parentParam = customParams.get("tree_parent_id");
        if (parentParam == null || !(parentParam instanceof Map)) {
            return;
        }
        Map parentParamMap = (Map)parentParam;
        Object value = parentParamMap.get("value");
        if (value == null) {
            return;
        }
        paramter.setCustomParam("costcenter", (Object)Long.valueOf(value.toString()));
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if ("tblclose".equalsIgnoreCase(evt.getItemKey())) {
            return;
        }
        super.beforeItemClick(evt);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (operateKey.equals("new_delete") && operationResult.isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        this.initTreeData();
        List<TreeNode> treeNodes = this.getTreeChildren(e.getNodeId().toString());
        e.setChildNodes(treeNodes);
        this.childNodes = null;
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        Map<String, Object> qFilterMap = this.removeFilter(qFilters);
        this.setEffectDateFilter(qFilters, qFilterMap);
        List filterIds = (List)this.getView().getFormShowParameter().getCustomParam("costCenterMapIds");
        String isClear = this.getPageCache().get("isClear");
        if (filterIds != null && filterIds.size() > 0 && !"true".equals(isClear)) {
            qFilters.add(new QFilter("id", "in", (Object)filterIds));
            this.getPageCache().put("isClear", "true");
        } else {
            Object longNumber;
            Object costCenterId = qFilterMap.get("costCenterId");
            QFilter qFilter = null;
            if (costCenterId != null) {
                qFilter = new QFilter("costcenter", "=", costCenterId);
                qFilter.or("parent", "=", costCenterId);
            }
            if ((longNumber = qFilterMap.get("longNumber")) != null) {
                qFilter = qFilter == null ? new QFilter("longnumber", "like", longNumber) : qFilter.or("longnumber", "like", longNumber);
            }
            qFilters.add(qFilter);
        }
        e.setOrderBy("number asc");
    }

    private void setEffectDateFilter(List<QFilter> filters, Map<String, Object> dateMap) {
        if (dateMap.isEmpty()) {
            return;
        }
        Date startDate = (Date)dateMap.get("startDate");
        Date endDate = (Date)dateMap.get("endDate");
        if (startDate == null || endDate == null) {
            return;
        }
        QFilter qFilter = new QFilter("effectdate", "<", (Object)endDate).and(new QFilter("expdate", ">", (Object)startDate));
        filters.add(qFilter);
    }

    protected Map<String, Object> removeFilter(List<QFilter> filters) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(8);
        Iterator<QFilter> iter = filters.iterator();
        while (iter.hasNext()) {
            QFilter filter = iter.next();
            if ("expdate".equals(filter.getProperty())) {
                try {
                    Date startDate = (Date)filter.getValue();
                    resultMap.put("startDate", startDate);
                    List nestList = filter.getNests(true);
                    if (nestList == null || nestList.size() <= 0) continue;
                    Date endDate = (Date)((QFilter.QFilterNest)nestList.get(0)).getFilter().getValue();
                    resultMap.put("endDate", endDate);
                    iter.remove();
                }
                catch (Exception e) {
                    this.logger.error("removeFilter Error", (Throwable)e);
                }
                continue;
            }
            this.buildResultMap(filter, resultMap);
            List list = filter.getNests(true);
            for (QFilter.QFilterNest nest : list) {
                this.buildResultMap(nest.getFilter(), resultMap);
            }
            String property = filter.getProperty();
            if (!"id".equalsIgnoreCase(property) && !"parent".equalsIgnoreCase(property) && !"longnumber".equalsIgnoreCase(property)) continue;
            iter.remove();
        }
        return resultMap;
    }

    private void buildResultMap(QFilter filter, Map<String, Object> resultMap) {
        String property = filter.getProperty();
        if ("id".equalsIgnoreCase(property) || "parent".equalsIgnoreCase(property)) {
            resultMap.put("costCenterId", filter.getValue());
        } else if ("longnumber".equalsIgnoreCase(property)) {
            resultMap.put("longNumber", filter.getValue());
        }
    }

    private List<TreeNode> getTreeChildren(String nodeId) {
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(16);
        List<Map<String, String>> curData = this.getCurTreeData(nodeId);
        if (curData == null || curData.size() == 0) {
            return treeNodes;
        }
        TreeNode treeNode = null;
        for (Map<String, String> entry : curData) {
            boolean isLeaf;
            treeNode = new TreeNode();
            treeNode.setId(entry.get("id"));
            treeNode.setParentid(entry.get("parentid") != null ? entry.get("parentid") : "0");
            treeNode.setText(entry.get("name"));
            treeNode.setLongNumber(entry.get("longnumber"));
            boolean bl = isLeaf = entry.get("isleaf") == null ? true : Boolean.parseBoolean(entry.get("isleaf"));
            if (!isLeaf && this.isLeafNode(entry.get("id")).booleanValue()) {
                treeNode.setLeaf(true);
                treeNode.addChildren(this.getTreeChildren(entry.get("id")));
            } else {
                treeNode.setLeaf(false);
            }
            treeNodes.add(treeNode);
        }
        return treeNodes;
    }

    private List<Map<String, String>> getCurTreeData(String nodeId) {
        String parentId = ROOTNODEID.equals(nodeId) ? "0" : nodeId;
        return this.childNodes.get(parentId);
    }

    private Boolean isLeafNode(String nodeId) {
        String parentId = ROOTNODEID.equals(nodeId) ? "0" : nodeId;
        List<Map<String, String>> child = this.childNodes.get(parentId);
        if (child == null || child.size() == 0) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private void initTreeData() {
        this.childNodes = new HashMap<String, List<Map<String, String>>>(16);
        QFilter qfEnable = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)"bos_costcenter", (String)"id,number,name,parent,longnumber,isleaf", (QFilter[])new QFilter[]{qfEnable}, (String)"number asc");
        DynamicObject val = null;
        HashMap<String, String> map = null;
        List<Map<String, String>> curChild = null;
        for (Map.Entry entry : loadFromCache.entrySet()) {
            val = (DynamicObject)entry.getValue();
            map = new HashMap<String, String>(16);
            map.put("id", val.getString("id"));
            map.put("number", val.getString("number"));
            map.put("name", val.getString("name"));
            map.put("text", val.getString("name"));
            map.put("parentid", val.getDynamicObject("parent") != null ? val.getDynamicObject("parent").getString("id") : "0");
            map.put("longnumber", val.getString("longnumber"));
            map.put("isleaf", val.getString("isleaf"));
            curChild = this.childNodes.get(map.get("parentid"));
            if (curChild == null) {
                curChild = new ArrayList<Map<String, String>>();
            }
            curChild.add(map);
            this.childNodes.put((String)map.get("parentid"), curChild);
        }
    }
}

