/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bd.master.consts.SupplierStatusConst;
import kd.bd.master.helper.BizInfoHelper;
import kd.bd.master.helper.BizpartnerHelper;
import kd.bd.master.helper.GroupStandardHelper;
import kd.bd.master.helper.MasterDataHelper;
import kd.bd.master.helper.SupplierServiceHelper;
import kd.bd.master.util.MasterClearDataEntityCacheUtil;
import kd.bd.master.util.MasterDataUtil;
import kd.bd.master.validator.SupplierSaveValidator;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.OperationContext;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class SupplierSavePlugin
extends AbstractOperationServicePlugIn {
    private static Log log = LogFactory.getLog(SupplierSavePlugin.class);
    private GroupStandardHelper groupStandardHelper = new GroupStandardHelper();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("isdefault_linkman");
        e.getFieldKeys().add("isdefault_bank");
        e.getFieldKeys().add("bankaccount");
        e.getFieldKeys().add("bizfunction");
        e.getFieldKeys().add("type");
        e.getFieldKeys().add("idno");
        e.getFieldKeys().add("simplepinyin");
        e.getFieldKeys().add("group");
        e.getFieldKeys().add("bizpartner");
        e.getFieldKeys().add("supplier_status");
        e.getFieldKeys().add("invoicesupplierid");
        e.getFieldKeys().add("receivingsupplierid");
        e.getFieldKeys().add("deliversupplierid");
        e.getFieldKeys().add("entry_groupstandard");
        e.getFieldKeys().add("invalid");
        e.getFieldKeys().add("deleteidentity");
        e.getFieldKeys().add("associatedaddress");
        e.getFieldKeys().add("simplename");
        e.getFieldKeys().add("country");
        e.getFieldKeys().add("bizpartner_address");
        e.getFieldKeys().add("linkman");
        e.getFieldKeys().add("bizpartner_phone");
        e.getFieldKeys().add("bizpartner_fax");
        e.getFieldKeys().add("societycreditcode");
        e.getFieldKeys().add("tx_register_no");
        e.getFieldKeys().add("artificialperson");
        e.getFieldKeys().add("internal_company");
        e.getFieldKeys().add("picturefield");
        e.getFieldKeys().add("regcapital");
        e.getFieldKeys().add("establishdate");
        e.getFieldKeys().add("businessterm");
        e.getFieldKeys().add("businessscope");
        e.getFieldKeys().add("postal_code");
        e.getFieldKeys().add("admindivision");
        e.getFieldKeys().add("url");
        e.getFieldKeys().add("iban");
        e.getFieldKeys().add("creator");
        e.getFieldKeys().add("taxregistplace");
        e.getFieldKeys().add("entry_tax");
        e.getFieldKeys().add("duns");
        e.getFieldKeys().add("curegcapital");
        e.getFieldKeys().add("source");
        e.getFieldKeys().add("chkisinternalcompany");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        try (TraceSpan span = Tracer.create((String)"SupplierSavePlugin", (String)"validator: SupplierSaveValidator");){
            e.addValidator((AbstractValidator)new SupplierSaveValidator());
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        log.info("SupplierSavePlugin.beginOperationTransaction, record num:" + (e.getDataEntities() == null ? "null" : Integer.valueOf(e.getDataEntities().length)));
        try (TraceSpan span = Tracer.create((String)"SupplierSavePlugin", (String)"beginOperationTransaction");){
            DynamicObject defaultSupSatus = BusinessDataServiceHelper.loadSingleFromCache((Object)SupplierStatusConst.SUPPLIERSTATUS_NORMAL, (String)"bd_supplierstatus");
            this.operationContext = new OperationContext();
            HashMap map = this.operationContext.getParameter();
            if (map == null) {
                map = new HashMap();
                this.operationContext.setParameter(map);
            }
            ArrayList<DynamicObject> newBizPartners = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> oldBizPartners = new ArrayList<DynamicObject>();
            for (DynamicObject data : e.getDataEntities()) {
                String supplierId = MasterDataHelper.getDataPk((DynamicObject)data);
                GroupStandardHelper.setGroupData(map, (DynamicObject)data, (String)supplierId, (String)e.getOperationKey());
                MasterDataHelper.setPublicRequiredFields((DynamicObject)data);
                SupplierServiceHelper.setSupplierRequiredFields((DynamicObject)data, (String)supplierId, (DynamicObject)defaultSupSatus);
                MasterDataHelper.setDataStatus((DynamicObject)data, (OperateOption)this.getOption());
                if (data.get("bizpartner") == null) {
                    newBizPartners.add(data);
                    continue;
                }
                oldBizPartners.add(data);
            }
            if (BizpartnerHelper.isEnablepartner()) {
                try {
                    log.info("newBizPartners:" + newBizPartners.size() + " oldBizPartners" + oldBizPartners.size());
                    BizpartnerHelper.saveBizPartner(newBizPartners, oldBizPartners);
                }
                catch (Exception e2) {
                    e.setCancelOperation(true);
                    throw new KDBizException(e2.getMessage());
                }
            }
            if (BizInfoHelper.isEnableSyncBizInfo()) {
                BizInfoHelper.updateBizInfoByNameAndType((DynamicObject[])e.getDataEntities(), (OperationResult)this.operationResult);
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        try (TraceSpan span = Tracer.create((String)"SupplierSavePlugin", (String)"afterExecuteOperationTransaction");){
            if (e.getDataEntities() == null || e.getDataEntities().length <= 0) {
                return;
            }
            Map map = this.operationContext.getParameter();
            try (TraceSpan span1 = Tracer.create((String)"MaterialSavePlugin", (String)"getGroupOrg");){
                this.groupStandardHelper.getGroupOrg(map, e.getDataEntities(), "bd_suppliergroup");
            }
            ArrayList successObjs = new ArrayList();
            ArrayList entityGroupDetails = new ArrayList();
            HashSet deleteIds = new HashSet();
            boolean flag = false;
            Map grpDetailFromDB = GroupStandardHelper.queryGrpDetailByMasterId((AfterOperationArgs)e, (Map)map);
            for (DynamicObject dataEntity : e.getDataEntities()) {
                try {
                    GroupStandardHelper.setGroupDetail((String)"bd_supplier", (Map)map, successObjs, entityGroupDetails, deleteIds, (DynamicObject)dataEntity, (String)e.getOperationKey(), (Map)grpDetailFromDB);
                }
                catch (KDBizException exp) {
                    this.operationResult.addErrorInfo((OperateErrorInfo)MasterDataUtil.buildErrMessage((DynamicObject)dataEntity, (KDBizException)exp, (String)ResManager.loadKDString((String)"\u4fdd\u5b58\u4f9b\u5e94\u5546\u5931\u8d25\u3002", (String)"SupplierSavePlugin_0", (String)"bd-master-opplugin", (Object[])new Object[0])));
                }
                MasterClearDataEntityCacheUtil.clearDataEntityCache((DynamicObject)dataEntity, (String)"t_bd_supplierlinkman");
                MasterDataHelper.checkMasterId((DynamicObject)dataEntity, (boolean)flag);
            }
            if (deleteIds.size() > 0) {
                DeleteServiceHelper.delete((String)"bd_suppliergroupdetail", (QFilter[])new QFilter[]{new QFilter("id", "in", deleteIds)});
            }
            if (entityGroupDetails.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])entityGroupDetails.toArray(new DynamicObject[0]));
            }
            e.setDataEntities(successObjs.toArray(new DynamicObject[successObjs.size()]));
            if (flag) {
                SaveServiceHelper.save((DynamicObject[])e.getDataEntities());
            }
        }
    }
}

