/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.validator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class BizPartnerDelValidator
extends AbstractValidator {
    public void validate() {
        ArrayList<Object> pks = new ArrayList<Object>(this.dataEntities.length);
        HashMap<Object, ExtendedDataEntity> map = new HashMap<Object, ExtendedDataEntity>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            pks.add(dataEntity.getDataEntity().getPkValue());
            map.put(dataEntity.getDataEntity().getPkValue(), dataEntity);
        }
        if (pks.size() > 0 && map.size() > 0) {
            this.checkBPHaveBeenRefered(pks, map);
        }
    }

    private void checkBPHaveBeenRefered(List<Object> ids, Map<Object, ExtendedDataEntity> map) {
        Long key;
        String querySql = "id,number,bizpartner";
        QFilter qf = new QFilter("bizpartner", "in", ids);
        Map supplierMap = BusinessDataServiceHelper.loadFromCache((String)"bd_supplier", (String)"id,number,bizpartner", (QFilter[])new QFilter[]{qf});
        Map customerMap = BusinessDataServiceHelper.loadFromCache((String)"bd_customer", (String)"id,number,bizpartner", (QFilter[])new QFilter[]{qf});
        if (supplierMap != null && !supplierMap.isEmpty() && supplierMap.size() > 0) {
            for (Map.Entry suppMap : supplierMap.entrySet()) {
                key = ((DynamicObject)suppMap.getValue()).getDynamicObject("bizpartner") == null ? Long.valueOf(0L) : ((DynamicObject)suppMap.getValue()).getDynamicObject("bizpartner").getPkValue();
                this.addErrorMessage(map.get(key), ResManager.loadKDString((String)"\u5546\u52a1\u4f19\u4f34\u5173\u8054\u7684\u4f9b\u5e94\u5546\u5b58\u5728\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"BizPartnerDelValidator_0", (String)"bd-master-opplugin", (Object[])new Object[0]));
            }
        }
        if (customerMap != null && !customerMap.isEmpty() && customerMap.size() > 0) {
            for (Map.Entry cusMap : customerMap.entrySet()) {
                key = ((DynamicObject)cusMap.getValue()).getDynamicObject("bizpartner") == null ? Long.valueOf(0L) : ((DynamicObject)cusMap.getValue()).getDynamicObject("bizpartner").getPkValue();
                this.addErrorMessage(map.get(key), ResManager.loadKDString((String)"\u5546\u52a1\u4f19\u4f34\u5173\u8054\u7684\u5ba2\u6237\u5b58\u5728\uff0c\u4e0d\u53ef\u5220\u9664\u3002", (String)"BizPartnerDelValidator_1", (String)"bd-master-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

