/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bd.master.enums.PartnerType;
import kd.bd.master.helper.MasterCheckHelper;
import kd.bd.master.helper.MasterDataHelper;
import kd.bd.master.inf.MatserCheckInf;
import kd.bd.master.service.SupplierCheckService;
import kd.bd.master.validator.CustomerAndSupplierSaveValidator;
import kd.bd.master.vo.ErrorVo;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;

public class SupplierSaveValidator
extends CustomerAndSupplierSaveValidator {
    @Override
    public void validate() {
        super.validate();
        Long num = Arrays.asList(this.dataEntities).stream().filter(de -> de.getDataEntity().getDynamicObject("internal_company") != null).count();
        Map paramMap = MasterDataHelper.loadAppParameterFromCache((String)"15");
        if (paramMap != null && !paramMap.isEmpty() && (paramMap.get("enableinternalcompany") != null && Boolean.parseBoolean(paramMap.get("enableinternalcompany").toString()) || paramMap.get("enableinternalcompany") == null)) {
            this.checkInternalCompany(this.dataEntities, num, "bd_supplier");
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            this.checkDefault(dataEntity);
            this.checkChkisInternalCompany(dataEntity, "bd_supplier");
        }
        List persons = Arrays.asList(this.dataEntities).stream().filter(ex -> PartnerType.PERSON.getValue().equals(ex.getDataEntity().getString("type"))).collect(Collectors.toList());
        List personErrors = new MasterCheckHelper((MatserCheckInf)new SupplierCheckService()).checkPersonData(persons, this.getOperateKey());
        List otherPersons = Arrays.asList(this.dataEntities).stream().filter(ex -> !PartnerType.PERSON.getValue().equals(ex.getDataEntity().getString("type"))).collect(Collectors.toList());
        List otherPersonerrors = new MasterCheckHelper((MatserCheckInf)new SupplierCheckService()).checkOtherData(otherPersons, this.getOperateKey());
        ArrayList<ErrorVo> errors = new ArrayList<ErrorVo>(personErrors.size() + otherPersonerrors.size());
        errors.addAll(personErrors);
        errors.addAll(otherPersonerrors);
        if (errors.size() > 0) {
            this.getSupplierErrorMSg(errors);
        }
        Set<Long> groupIds = this.checkGroupEffective(this.dataEntities);
        this.checkGroupNew(this.dataEntities, groupIds);
        this.checkTaxCertificate();
    }

    private void getSupplierErrorMSg(List<ErrorVo> errors) {
        ExtendedDataEntity dataEntity = null;
        for (ErrorVo ex : errors) {
            dataEntity = ex.getExtendedDataEntity();
            switch (ex.getUniquenessError()) {
                case ORGNOEXIST: {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"SupplierSaveValidator_7", (String)"bd-master-opplugin", (Object[])new Object[0]));
                    break;
                }
                case ORGNUMBEREXIT: {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u540c\u4e00\u4e2a\u521b\u5efa\u7ec4\u7ec7\u4e0b\u5b58\u5728\u76f8\u540c\u7f16\u7801\u7684\u4f9b\u5e94\u5546\uff0c\u7981\u6b62\u4fdd\u5b58\u3002", (String)"SupplierSaveValidator_8", (String)"bd-master-opplugin", (Object[])new Object[0]));
                    break;
                }
                case ORGNAMEEXIT: {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u540c\u4e00\u4e2a\u521b\u5efa\u7ec4\u7ec7\u4e0b\u5b58\u5728\u76f8\u540c\u540d\u79f0\u7684\u4f9b\u5e94\u5546\uff0c\u7981\u6b62\u4fdd\u5b58\u3002", (String)"SupplierSaveValidator_9", (String)"bd-master-opplugin", (Object[])new Object[0]));
                    break;
                }
                case NAMEANDIDCARDEXIT: {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u540d\u79f0\u548c\u8eab\u4efd\u8bc1\u53f7\u76f8\u540c\u7684\u4f9b\u5e94\u5546\uff0c\u7981\u6b62\u4fdd\u5b58\u3002", (String)"SupplierSaveValidator_10", (String)"bd-master-opplugin", (Object[])new Object[0]));
                    break;
                }
                case ORGNUMBEREXITSUMBIT: {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u540c\u4e00\u4e2a\u521b\u5efa\u7ec4\u7ec7\u4e0b\u5b58\u5728\u76f8\u540c\u7f16\u7801\u7684\u4f9b\u5e94\u5546\uff0c\u7981\u6b62\u63d0\u4ea4\u3002", (String)"SupplierSaveValidator_11", (String)"bd-master-opplugin", (Object[])new Object[0]));
                    break;
                }
                case ORGNAMEEXITSUMBIT: {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u540c\u4e00\u4e2a\u521b\u5efa\u7ec4\u7ec7\u4e0b\u5b58\u5728\u76f8\u540c\u540d\u79f0\u7684\u4f9b\u5e94\u5546\uff0c\u7981\u6b62\u63d0\u4ea4\u3002", (String)"SupplierSaveValidator_12", (String)"bd-master-opplugin", (Object[])new Object[0]));
                    break;
                }
                case NAMEANDIDCARDEXITSUMBIT: {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u540d\u79f0\u548c\u8eab\u4efd\u8bc1\u53f7\u76f8\u540c\u7684\u4f9b\u5e94\u5546\uff0c\u7981\u6b62\u63d0\u4ea4\u3002", (String)"SupplierSaveValidator_13", (String)"bd-master-opplugin", (Object[])new Object[0]));
                    break;
                }
                case IDCARDNOEXIST: {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5de5\u5546\u4fe1\u606f\u4e2d\u7684\u8eab\u4efd\u8bc1\u53f7\u3002", (String)"CustomerAndSupplierSaveValidator_6", (String)"bd-master-opplugin", (Object[])new Object[0]));
                }
            }
        }
    }
}

