/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.errorcode;

import kd.bos.dataentity.resource.ResManager;

public enum ScmErrorLevel {
    FatalError(ScmErrorLevel.getFatalErrorName(), 0),
    Warning(ScmErrorLevel.getWarningName(), 1),
    Error(ScmErrorLevel.getErrorName(), 2),
    Info(ScmErrorLevel.getInfoName(), 3),
    SuccessInfo(ScmErrorLevel.getSuccessInfoName(), 4);

    private String name;
    private int value;

    private ScmErrorLevel(String name, int value) {
        this.name = name;
        this.value = value;
    }

    private static String getFatalErrorName() {
        return ResManager.loadKDString((String)"\u4e2d\u65ad\u9519\u8bef", (String)"ScmErrorLevel_0", (String)"bd-sbd-common", (Object[])new Object[0]);
    }

    private static String getWarningName() {
        return ResManager.loadKDString((String)"\u8b66\u544a", (String)"ScmErrorLevel_1", (String)"bd-sbd-common", (Object[])new Object[0]);
    }

    private static String getErrorName() {
        return ResManager.loadKDString((String)"\u9519\u8bef", (String)"ScmErrorLevel_2", (String)"bd-sbd-common", (Object[])new Object[0]);
    }

    private static String getInfoName() {
        return ResManager.loadKDString((String)"\u4e00\u822c\u63d0\u793a", (String)"ScmErrorLevel_3", (String)"bd-sbd-common", (Object[])new Object[0]);
    }

    private static String getSuccessInfoName() {
        return ResManager.loadKDString((String)"\u6210\u529f\u63d0\u793a", (String)"ScmErrorLevel_4", (String)"bd-sbd-common", (Object[])new Object[0]);
    }

    private String getEnumName() {
        switch (this) {
            case FatalError: {
                return ScmErrorLevel.getFatalErrorName();
            }
            case Warning: {
                return ScmErrorLevel.getWarningName();
            }
            case Error: {
                return ScmErrorLevel.getErrorName();
            }
            case Info: {
                return ScmErrorLevel.getInfoName();
            }
            case SuccessInfo: {
                return ScmErrorLevel.getSuccessInfoName();
            }
        }
        return "";
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.getEnumName();
    }

    public static String getName(int value) {
        String name = null;
        for (ScmErrorLevel type : ScmErrorLevel.values()) {
            if (type.getValue() != value) continue;
            name = type.name;
            break;
        }
        return name;
    }

    public static ScmErrorLevel valueOf(int level) {
        ScmErrorLevel errorLevel = FatalError;
        switch (level) {
            case 1: {
                errorLevel = Warning;
                break;
            }
            case 2: {
                errorLevel = Error;
                break;
            }
            case 3: {
                errorLevel = Info;
                break;
            }
            case 4: {
                errorLevel = SuccessInfo;
                break;
            }
            default: {
                errorLevel = FatalError;
            }
        }
        return errorLevel;
    }
}

