/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.pbd.plugin.list;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.pbd.PbdGroupStandardUtils;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.RefreshNodeEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.ITreeListView;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BuildTreeListFilterEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.tree.TreeFilterParameter;

public class CategoryGroupStandardListPlugin
extends StandardTreeListPlugin {
    private Map<String, List<Map<String, List<Object>>>> filterValues = null;
    private static final Log logger = LogFactory.getLog(CategoryGroupStandardListPlugin.class);
    private static final String ROOT_NODE_ID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private static final String MATERIAL_GROUP_ENTITY = "bd_materialgroup";
    private static final String USEORG_FILEDNAME = "useorg";
    public static final String PGCACHE_CREATEORG = "createOrg";
    private static final String PROP_PARENT = "parent";
    private static final String OP_OPEN = "btn_open";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{OP_OPEN});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void buildTreeListFilter(BuildTreeListFilterEvent e) {
        e.setCancel(true);
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        TreeNode rootNode = this.getTreeModel().getRoot();
        if (rootNode == null || rootNode.getTreeNode(nodeId, 20) == null) {
            return;
        }
        if ("0".equals(nodeId)) {
            return;
        }
        this.treeListView.getTreeView().queryTreeNodeChildren(e.getParentNodeId().toString(), nodeId);
    }

    public void initializeTree(EventObject e) {
        super.initializeTree(e);
        this.initTree();
    }

    private void initTree() {
        TreeNode root = this.getTreeModel().createRootNode();
        if (root != null) {
            root.setChildren(new ArrayList(0));
            this.getTreeModel().setRoot(root);
            String rootId = root.getId();
            this.getTreeModel().setCurrentNodeId((Object)rootId);
            logger.info("\u5206\u7c7b\u6807\u51c6\u6839\u8282\u70b9ID\u4e3a\uff1a" + rootId);
        }
    }

    public void refreshNode(RefreshNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        if ("0".equalsIgnoreCase(nodeId)) {
            e.setChildNodes(new ArrayList());
            return;
        }
        String textFormat = this.getTreeTextFormat();
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        String entity = param.getBillFormId();
        TreeFilterParameter tfp = param.getTreeFilterParameter();
        List qfs = tfp.getQFilters();
        List<TreeNode> treeNodes = this.getTreeChildren(nodeId, textFormat, qfs, entity);
        e.setChildNodes(treeNodes);
    }

    private String getTreeTextFormat() {
        ITreeModel treeModel;
        ITreeListView treeView = this.getTreeListView();
        if (treeView != null && (treeModel = treeView.getTreeModel()) instanceof TreeListModel) {
            TreeListModel treeListModel = (TreeListModel)treeModel;
            return treeListModel.getTextFormat();
        }
        return "";
    }

    private List<TreeNode> getTreeChildren(String nodeId, String textFormat, List<QFilter> qfs, String entity) {
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        String standardId = String.valueOf(PbdGroupStandardUtils.getMaterialGroupType((String)param.getBillFormId()));
        Set<Long> useOrgIds = this.getUseOrgIds(param, entity, standardId);
        Set<Long> orgIds = this.getOrgAndParentOrg(entity, useOrgIds);
        QFilter qFilter = new QFilter("standard", "=", (Object)Long.valueOf(standardId));
        if (ROOT_NODE_ID.equals(nodeId)) {
            nodeId = "0";
        }
        QFilter qFilter2 = new QFilter(PROP_PARENT, "=", (Object)Long.valueOf(nodeId));
        QFilter qFilter4 = new QFilter("createorg", "in", orgIds);
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(4);
        ArrayList<QFilter> commonQfilters = new ArrayList<QFilter>(4);
        String isShowAllNoOrg = (String)param.getCustomParam("isShowAllNoOrg");
        if (orgIds == null || orgIds.size() <= 0) {
            isShowAllNoOrg = "true";
        }
        if (!"true".equals(isShowAllNoOrg)) {
            commonQfilters.add(qFilter4);
        }
        QFilter qFilter3 = new QFilter("enable", "=", (Object)"1");
        commonQfilters.add(qFilter3);
        commonQfilters.add(qFilter);
        if (qfs != null && qfs.size() > 0) {
            commonQfilters.addAll(qfs);
        }
        qFilters.addAll(commonQfilters);
        qFilters.add(qFilter2);
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>();
        DynamicObjectCollection datas = QueryServiceHelper.query((String)MATERIAL_GROUP_ENTITY, (String)"id,number,name,parent,longnumber,isleaf", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"number asc");
        treeNodes.addAll(this.buildTreeNodes((List<DynamicObject>)datas, textFormat, commonQfilters, MATERIAL_GROUP_ENTITY));
        return treeNodes;
    }

    private List<TreeNode> buildTreeNodes(List<DynamicObject> groups, String textFormat, List<QFilter> qfs, String entity) {
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>();
        String isOpenAll = this.getView().getPageCache().get(OP_OPEN);
        HashSet<Long> parentIds = new HashSet<Long>(groups.size());
        for (DynamicObject group : groups) {
            parentIds.add(group.getLong("id"));
        }
        ArrayList<Long> containsNode = new ArrayList<Long>();
        if (parentIds.size() > 0) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            qFilters.addAll(qfs);
            QFilter qFilter = new QFilter(PROP_PARENT, "in", parentIds);
            qFilters.add(qFilter);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"CategoryGroupStandardListPlugin", (String)entity, (String)PROP_PARENT, (QFilter[])qFilters.toArray(new QFilter[0]), null);){
                GroupbyDataSet groupbyDataSet = dataSet.groupBy(new String[]{PROP_PARENT});
                DataSet finish = groupbyDataSet.finish();
                for (Row row : finish) {
                    containsNode.add(row.getLong(PROP_PARENT));
                }
            }
            parentIds.clear();
        }
        for (DynamicObject group : groups) {
            if (group.getLong("id") == 0L) continue;
            TreeNode treeNode = new TreeNode();
            treeNode.setId(group.getString("id"));
            Long parent = group.getLong(PROP_PARENT);
            treeNode.setParentid(parent == 0L ? ROOT_NODE_ID : group.getString(PROP_PARENT));
            treeNode = this.getLocaleStringName(group, textFormat, treeNode);
            treeNode.setLongNumber(group.getString("longnumber"));
            if (containsNode.contains(group.getLong("id"))) {
                if ("true".equals(isOpenAll)) {
                    treeNode.addChildren(this.getTreeChildren(group.getString("id"), textFormat, qfs, entity));
                    treeNode.setIsOpened(true);
                    treeNode.setExpend(true);
                } else {
                    treeNode.addChildren(new ArrayList());
                }
            }
            treeNodes.add(treeNode);
        }
        return treeNodes;
    }

    protected Set<Long> getUseOrgIds(ListShowParameter param, String entity, String standard) {
        Set useOrgIds = null;
        String useOrgsStr = this.getPageCache().get("createOrgs");
        if (StringUtils.isNotBlank((CharSequence)useOrgsStr)) {
            useOrgIds = (Set)SerializationUtils.fromJsonString((String)useOrgsStr, Set.class);
        }
        if (useOrgIds == null) {
            String createOrg = this.getPageCache().get(PGCACHE_CREATEORG);
            useOrgIds = PbdGroupStandardUtils.getCreateOrgs((ListShowParameter)param, (String)entity, (String)createOrg);
            this.getPageCache().put("createOrgs", SerializationUtils.toJsonString((Object)useOrgIds));
        }
        return useOrgIds;
    }

    protected Set<Long> getOrgAndParentOrg(String entity, Set<Long> useOrgs) {
        Set orgs = null;
        String orgsStr = this.getPageCache().get("orgs");
        if (StringUtils.isNotBlank((CharSequence)orgsStr)) {
            orgs = (Set)SerializationUtils.fromJsonString((String)orgsStr, Set.class);
        }
        if (orgs == null) {
            orgs = PbdGroupStandardUtils.getGroupOrgId((String)entity, useOrgs);
            this.getPageCache().put("orgs", SerializationUtils.toJsonString((Object)orgs));
        }
        return orgs;
    }

    protected TreeNode getLocaleStringName(DynamicObject group, String textFormat, TreeNode treeNode) {
        String name = group.getString("name");
        String number = group.getString("number");
        if (StringUtils.isBlank((CharSequence)name)) {
            name = group.getString("name");
        }
        String text = textFormat;
        if (StringUtils.isNotBlank((CharSequence)textFormat)) {
            if (textFormat.contains("{name}") && StringUtils.isNotBlank((CharSequence)name)) {
                text = StringUtils.replace((String)textFormat, (String)"{name}", (String)name);
            }
            if (textFormat.contains("{code}") && StringUtils.isNotBlank((CharSequence)number)) {
                text = StringUtils.replace((String)text, (String)"{code}", (String)number);
            }
        }
        if (StringUtils.isBlank((CharSequence)text)) {
            treeNode.setText(name);
        } else {
            treeNode.setText(text);
        }
        return treeNode;
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String nodeId = this.getTreeListView().getTreeView().getTreeState().getFocusNodeId();
        List qFilters = e.getQFilters();
        QFilter filter = this.genRefreshFilter(nodeId);
        if (filter != null) {
            qFilters.add(filter);
        }
    }

    private QFilter genRefreshFilter(String nodeId) {
        ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
        String billFormId = param.getBillFormId();
        long standardId = PbdGroupStandardUtils.getMaterialGroupType((String)billFormId);
        QFilter qFilter = null;
        if (ROOT_NODE_ID.equals(nodeId)) {
            nodeId = "0";
        }
        if (!"0".equals(nodeId)) {
            Set<Long> useOrgs = this.getUseOrgIds(param, billFormId, String.valueOf(standardId));
            Set<Long> groupOrgs = this.getOrgAndParentOrg(billFormId, useOrgs);
            List groupIds = PbdGroupStandardUtils.queryGroupsByGroupId((String)MATERIAL_GROUP_ENTITY, (Object)String.valueOf(standardId), (Object)nodeId, groupOrgs);
            QFilter qFilter1 = new QFilter("group", "in", (Object)groupIds);
            if (groupIds != null) {
                qFilter1.and("standard", "=", (Object)standardId);
                HashSet<Long> materials = new HashSet<Long>();
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_materialgroupdetail", (String)"material,group,standard", (QFilter[])new QFilter[]{qFilter1}, null);){
                    for (Row row : dataSet) {
                        materials.add(row.getLong("material"));
                    }
                }
                materials.add(0L);
                qFilter = new QFilter("material.id", "in", materials);
                groupIds.add(0L);
                qFilter.and("category.id", "in", (Object)groupIds);
            }
        }
        return qFilter;
    }

    public void click(EventObject evt) {
        String itemKey;
        super.click(evt);
        Control ctr = (Control)evt.getSource();
        if (ctr != null && OP_OPEN.equals(itemKey = ctr.getKey())) {
            TreeView treeView = this.getTreeListView().getTreeView();
            String oldFocusNodeId = treeView.getTreeState().getFocusNodeId();
            TreeNode root = this.getTreeModel().createRootNode();
            if (root == null) {
                this.treeListView.refreshTreeView();
            } else {
                this.getPageCache().put(OP_OPEN, "true");
                this.treeListView.getTreeView().deleteAllNodes();
                treeView.addNode(root);
                this.treeListView.getTreeView().queryTreeNodeChildren(root.getParentid(), root.getId());
                if (oldFocusNodeId != null && !ROOT_NODE_ID.equals(oldFocusNodeId)) {
                    treeView.treeNodeClick("", oldFocusNodeId);
                }
                this.getPageCache().put(OP_OPEN, "false");
            }
        }
    }

    public void expendTreeNode(TreeNodeEvent e) {
        TreeNode node;
        TreeNode rootNode = this.getTreeModel().getRoot();
        String nodeId = (String)e.getNodeId();
        if ((rootNode != null && !StringUtils.isBlank((CharSequence)nodeId) ? rootNode.getTreeNode(nodeId, 20) : null) != null && (node = this.getTreeListView().getTreeModel().refreshNode((Object)nodeId)) != null) {
            node.setIsOpened(true);
            e.setExpandedNode(node);
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        this.filterValues = args.getSearchClickEvent().getFilterValues();
        List<Map<String, List<Object>>> customFiterList = this.filterValues.get("customfilter");
        if (customFiterList == null) {
            return;
        }
        String customfilterSer = SerializationUtils.toJsonString(customFiterList);
        this.getPageCache().remove("customfilter");
        this.getPageCache().put("customfilter", customfilterSer);
        String orgId = null;
        for (Map<String, List<Object>> customFiter : customFiterList) {
            String createOrg;
            List<Object> orgIds;
            List<Object> fieldNames = customFiter.get("FieldName");
            if (fieldNames == null || fieldNames.size() == 0 || !"useorg.id".equals(fieldNames.get(0)) || (orgIds = customFiter.get("Value")) == null || orgIds.size() == 0) continue;
            orgId = String.valueOf(orgIds.get(0));
            if (orgId.equals(createOrg = this.getPageCache().get(PGCACHE_CREATEORG))) {
                return;
            }
            this.getPageCache().put(PGCACHE_CREATEORG, orgId);
            this.getPageCache().put("createOrgs", null);
            this.getPageCache().put("orgs", null);
            ListShowParameter param = (ListShowParameter)this.getView().getFormShowParameter();
            String billFormId = param.getBillFormId();
            String groupStandard = String.valueOf(PbdGroupStandardUtils.getMaterialGroupType((String)billFormId));
            if (StringUtils.isBlank((CharSequence)groupStandard)) {
                TreeView treeView = this.getTreeListView().getTreeView();
                TreeNode root = this.getTreeModel().createRootNode();
                if (root == null) {
                    this.treeListView.refreshTreeView();
                } else {
                    this.treeListView.getTreeView().deleteAllNodes();
                    treeView.addNode(root);
                    treeView.treeNodeClick("", root.getId());
                }
                return;
            }
            TreeView treeView = this.getTreeListView().getTreeView();
            TreeNode root = this.getTreeModel().createRootNode();
            if (root == null) {
                this.treeListView.refreshTreeView();
                break;
            }
            this.treeListView.getTreeView().deleteAllNodes();
            treeView.addNode(root);
            treeView.treeNodeClick("", root.getId());
            break;
        }
    }
}

