/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.pbd.plugin.report;

import java.util.EventObject;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.report.ReportList;
import kd.bos.report.events.SortAndFilterEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;

public class PbdStrategyReportPlugin
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportlistap = (ReportList)this.getControl("reportlistap");
        reportlistap.addHyperClickListener(this::hyperLinkClick);
    }

    protected void filterContainerInit(FilterContainerInitEvent contInitEvent, ReportQueryParam queryParam) {
        super.filterContainerInit(contInitEvent, queryParam);
        FilterColumn filterColumn = contInitEvent.getFilterColumn("createorgfiltercolum");
        if (filterColumn != null && filterColumn.getDefaultValues().size() == 0) {
            filterColumn.getDefaultValues().add(String.valueOf(RequestContext.get().getOrgId()));
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        String field = e.getFieldName();
        if (StringUtils.equals((CharSequence)"category", (CharSequence)field) || StringUtils.equals((CharSequence)"material", (CharSequence)field)) {
            int rowIndex = e.getRowIndex();
            ReportList grid = (ReportList)this.getView().getControl("reportlistap");
            DynamicObject data = grid.getReportModel().getRowData(rowIndex);
            if (data != null) {
                this.showDetail(data);
            }
        }
    }

    private void showDetail(DynamicObject data) {
        FormShowParameter parameter = new FormShowParameter();
        long centrallistid = data.getLong("centrallist");
        long purstrategyid = data.getLong("purstrategy");
        long srcstrategyid = data.getLong("srcstrategy");
        long createorgid = data.getLong("createorg_id");
        long category = data.getLong("category_id");
        long material = data.getLong("material_id");
        String type = data.getString("type");
        parameter.setFormId("bd_strategy_summarydetail");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setStatus(OperationStatus.VIEW);
        parameter.setHasRight(true);
        parameter.getCustomParams().put("centrallistid", centrallistid);
        parameter.getCustomParams().put("purstrategyid", purstrategyid);
        parameter.getCustomParams().put("srcstrategyid", srcstrategyid);
        parameter.getCustomParams().put("category", category);
        parameter.getCustomParams().put("material", material);
        parameter.getCustomParams().put("createorgid", createorgid);
        parameter.getCustomParams().put("type", type);
        this.getView().showForm(parameter);
    }

    public void setSortAndFilter(List<SortAndFilterEvent> allColumns) {
        super.setSortAndFilter(allColumns);
        for (SortAndFilterEvent event : allColumns) {
            event.setSort(true);
            event.setFilter(true);
        }
    }
}

