/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.mservice.update;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bd.master.mservice.update.MasterDataGroupUpgradeService;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.UpgradeResult;

public class SupplierGroupUpgradeService
extends MasterDataGroupUpgradeService {
    private static final Log log = LogFactory.getLog(SupplierGroupUpgradeService.class);

    @Override
    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        String sql = "select cg.fparentid,cg.fid,cg.fnumber,cgl.fname from t_bd_suppliergroup cg left join t_bd_suppliergroup_l cgl on cg.fid =cgl.fid and cgl.flocaleid='zh_CN' order by cg.fparentid;";
        DBRoute dbRoute = new DBRoute(dbKey);
        LinkedHashMap<String, List<String>> data = new LinkedHashMap<String, List<String>>();
        try (DataSet ds = DB.queryDataSet((String)"SupplierGroupUpgradeService.beforeExecuteSqlWithResult", (DBRoute)dbRoute, (String)sql, null);){
            ArrayList<String> groups = null;
            for (Row row : ds) {
                String parentid = row.getString("fparentid");
                String id = row.getString("fid");
                groups = new ArrayList<String>(2);
                groups.add(row.getString("fnumber"));
                groups.add(row.getString("fname"));
                data.put(id + "_split_" + parentid, groups);
            }
        }
        catch (Throwable e) {
            result.setSuccess(false);
            log.error("query data field failed,errorMsgInfo: ", e);
            String err = "query data field failed,errorMsgInfo\uff1a" + e.getMessage();
            result.setErrorInfo(err);
            result.setLog(err);
            return result;
        }
        Map<String, List<Object[]>> results = this.recalculateLongNumberAndFullName(data);
        List<Object[]> longNumbersparams = results.get("longNumber");
        List<Object[]> fullNamesparams = results.get("fullName");
        log.info("group data updated before.");
        try (TXHandle h = TX.required((String)this.getClass().getName());){
            try {
                if (longNumbersparams.size() > 0) {
                    String longNumberSql = "update t_bd_suppliergroup set flongnumber=? where fid=? ";
                    DB.executeBatch((DBRoute)dbRoute, (String)longNumberSql, longNumbersparams);
                }
                if (fullNamesparams.size() > 0) {
                    String fullNameSql = "update t_bd_suppliergroup_l set ffullName=? where fid=?  and flocaleid ='zh_CN'";
                    DB.executeBatch((DBRoute)dbRoute, (String)fullNameSql, fullNamesparams);
                }
            }
            catch (Throwable e) {
                h.markRollback();
                result.setSuccess(false);
                log.error("database execution failed,errorInfo: ", e);
                result.setErrorInfo("database execution failed,errorInfo: " + e.getMessage());
                result.setLog("database execution failed,errorMsgInfo: " + e.getMessage());
                UpgradeResult upgradeResult = result;
                if (h != null) {
                    if (var13_17 != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable) {
                            var13_17.addSuppressed(throwable);
                        }
                    } else {
                        h.close();
                    }
                }
                return upgradeResult;
            }
        }
        log.info("after supplier data updated.");
        result.setSuccess(true);
        result.setLog("data update successful.");
        return result;
    }
}

