/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bd.master.vo.OpResultVo;
import kd.bd.master.webapi.service.MaterialWebpiService;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class MaterialSaveApiService
implements IBillWebApiPlugin {
    private static Log logger = LogFactory.getLog(MaterialSaveApiService.class);
    private MaterialWebpiService apiService = new MaterialWebpiService();

    public ApiResult doCustomService(Map<String, Object> params) {
        ApiResult apiResult = null;
        try {
            apiResult = this.executeMaterialInfo(params);
        }
        catch (Throwable e) {
            apiResult = ApiResult.fail((String)e.toString());
            logger.error("MaterialSaveApiService errorinfo:" + e);
        }
        return apiResult;
    }

    private ApiResult executeMaterialInfo(Map<String, Object> params) throws Throwable {
        ApiResult relut = null;
        OpResultVo opResultVo = null;
        String datas = JSON.toJSONString((Object)params.get("data"));
        if (!StringUtils.isEmpty((String)datas)) {
            JSONArray materials = JSON.parseArray((String)datas);
            if (materials != null && materials.size() > 0) {
                ArrayList<Long> ids = new ArrayList<Long>(materials.size());
                HashMap<Long, JSONObject> jsonDatas = new HashMap<Long, JSONObject>(materials.size());
                ArrayList<JSONObject> newDatas = new ArrayList<JSONObject>();
                for (Object material : materials) {
                    JSONObject mst = JSON.parseObject((String)material.toString());
                    Long id = mst.getLong("id");
                    if (id != null && id != 0L) {
                        ids.add(id);
                        jsonDatas.put(id, mst);
                        continue;
                    }
                    this.apiService.setRequiredParameterValue(mst);
                    newDatas.add(mst);
                }
                if (newDatas != null && newDatas.size() > 0) {
                    opResultVo = this.apiService.createMasterData(newDatas, "bd_material");
                }
                if (ids.size() > 0) {
                    opResultVo = this.apiService.updateMasterData(ids, jsonDatas, "bd_material");
                }
            }
            if (opResultVo != null) {
                if (opResultVo.isResult()) {
                    relut = ApiResult.success((Object)"operate successfully.");
                    relut.setData((Object)opResultVo.getMap());
                } else {
                    relut = ApiResult.fail((String)"operate fail.");
                    relut.setData((Object)opResultVo.getMap());
                }
            }
        } else {
            relut = ApiResult.fail((String)"The incoming JSON data is empty.");
        }
        return relut;
    }
}

