/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.gmc.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class ItemClassStandardUtils {
    private static Log logger = LogFactory.getLog(ItemClassStandardUtils.class);
    public static final String EntityID_Org_structure = "bos_org_structure";
    public static final String EntityID_Org_org = "bos_org";

    public static QFilter getGroupStandardFilter(String entityNumber, Long createOrg, boolean isAddEnable) {
        QFilter standardFilter = null;
        Set<Object> standardSetIds = new HashSet();
        standardSetIds = ItemClassStandardUtils.getGroupStandard(entityNumber, createOrg, isAddEnable);
        standardFilter = new QFilter("id", "in", standardSetIds);
        return standardFilter;
    }

    public static Set<Long> getGroupStandard(String entityNumber, Long createOrg, boolean isAddEnable) {
        HashSet<Long> standardSetIds = new HashSet<Long>();
        try {
            DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)entityNumber);
            if (ctrlview == null) {
                return standardSetIds;
            }
            ORM ormOV = ORM.create();
            QFilter f1 = new QFilter("view.id", "=", ctrlview.getPkValue());
            QFilter f2 = new QFilter("org", "=", (Object)createOrg);
            HashSet<String> orglongnumberSets = new HashSet<String>();
            DataSet ds = ormOV.queryDataSet(ItemClassStandardUtils.class.getName(), EntityID_Org_structure, "longnumber", new QFilter[]{f1, f2});
            Object object = null;
            try {
                for (Row row : ds) {
                    if (row.getString("longnumber") == null) continue;
                    orglongnumberSets.add(row.getString("longnumber"));
                }
            }
            catch (Throwable iter) {
                object = iter;
                throw iter;
            }
            finally {
                if (ds != null) {
                    if (object != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable iter) {
                            ((Throwable)object).addSuppressed(iter);
                        }
                    } else {
                        ds.close();
                    }
                }
            }
            HashSet<String> orgnumberSets = new HashSet<String>();
            for (String orglongnumber : orglongnumberSets) {
                String[] orgnumbers = orglongnumber.split("!");
                orgnumberSets.addAll(new HashSet<String>(Arrays.asList(orgnumbers)));
            }
            QFilter f = new QFilter("number", "in", orgnumberSets);
            f2 = new QFilter("enable", "=", (Object)"1");
            QFilter[] qFilters = new QFilter[]{f, f2};
            HashSet<Long> orgIdSets = new HashSet<Long>();
            try (DataSet ds2 = ormOV.queryDataSet(ItemClassStandardUtils.class.getName(), EntityID_Org_org, "id", qFilters);){
                for (Row row : ds2) {
                    if (row.getLong("id") == null) continue;
                    orgIdSets.add(row.getLong("id"));
                }
            }
            f = new QFilter("createorg", "in", orgIdSets);
            qFilters = isAddEnable ? new QFilter[]{f, f2} : new QFilter[]{f};
            ds2 = ormOV.queryDataSet(ItemClassStandardUtils.class.getName(), "bd_goodsclassstandard", "id", qFilters, "id");
            var14_19 = null;
            try {
                for (Row row : ds2) {
                    if (row.get("id") == null) continue;
                    standardSetIds.add(Long.parseLong(row.get("id").toString()));
                }
            }
            catch (Throwable throwable) {
                var14_19 = throwable;
                throw throwable;
            }
            finally {
                if (ds2 != null) {
                    if (var14_19 != null) {
                        try {
                            ds2.close();
                        }
                        catch (Throwable throwable) {
                            var14_19.addSuppressed(throwable);
                        }
                    } else {
                        ds2.close();
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
        }
        return standardSetIds;
    }

    public static List<String> getAllSuperiorLongnumber(String longnumber) {
        if (StringUtils.isBlank((CharSequence)longnumber) || longnumber.indexOf(46) == -1) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> superiorLongnumberSet = new ArrayList<String>(32);
        String superiorLongnumber = StringUtils.substringBeforeLast((String)longnumber, (String)".");
        superiorLongnumberSet.add(superiorLongnumber);
        while (superiorLongnumber.indexOf(46) > 0) {
            superiorLongnumber = StringUtils.substringBeforeLast((String)superiorLongnumber, (String)".");
            superiorLongnumberSet.add(superiorLongnumber);
        }
        return superiorLongnumberSet;
    }
}

