/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class GenerateMaterialBizInfoHelper {
    private static Log logger = LogFactory.getLog(GenerateMaterialBizInfoHelper.class);

    public static void setTargetBillFields(ExtendedDataEntity[] entitys, String bizOrg, String bizInfoFormId) {
        block5: {
            block4: {
                if (!"0".equals(bizOrg)) break block4;
                ArrayList<Long> orgid = new ArrayList<Long>(entitys.length);
                for (ExtendedDataEntity entity : entitys) {
                    DynamicObject createorg = entity.getDataEntity().getDynamicObject("createorg");
                    if (createorg == null) continue;
                    orgid.add(createorg.getLong("id"));
                }
                Map map = BaseDataServiceHelper.getBdCtrlStrgyBatch((String)bizInfoFormId, orgid);
                DynamicObject ctrlstrategy = BaseDataServiceHelper.getDefaultCtrlStrtgy((String)bizInfoFormId);
                if (map == null || map.size() <= 0) break block5;
                for (ExtendedDataEntity entity : entitys) {
                    DynamicObject materialBizInfo = entity.getDataEntity();
                    DynamicObject createorg = entity.getDataEntity().getDynamicObject("createorg");
                    if (createorg != null && map.containsKey(createorg.getString("id"))) {
                        materialBizInfo.set("ctrlstrategy", map.get(createorg.getString("id")));
                        continue;
                    }
                    if (ctrlstrategy == null) continue;
                    materialBizInfo.set("ctrlstrategy", (Object)ctrlstrategy.getString("defaultctrlstrategy"));
                }
                break block5;
            }
            String ctrlStrgy = BaseDataServiceHelper.getBdCtrlStrgy((String)bizInfoFormId, (String)bizOrg);
            for (ExtendedDataEntity entity : entitys) {
                DynamicObject materialBizInfo = entity.getDataEntity();
                DynamicObject createOrg = BusinessDataServiceHelper.newDynamicObject((String)"bos_org");
                createOrg.set("id", (Object)Long.valueOf(bizOrg));
                materialBizInfo.set("createorg", (Object)createOrg);
                materialBizInfo.set("ctrlstrategy", (Object)ctrlStrgy);
            }
        }
    }

    public static void beforeGenerateChecking(String bizOrg, String materialBizInfoNumber) {
        GenerateMaterialBizInfoHelper.orgPermissionChecking(bizOrg, materialBizInfoNumber);
        GenerateMaterialBizInfoHelper.userPermissionChecking(bizOrg, materialBizInfoNumber);
        GenerateMaterialBizInfoHelper.bizFuncPermissionChecking(bizOrg, materialBizInfoNumber);
    }

    public static void afterConvertChecking(String bizOrgStr, String bizOrgName, String materialBizInfoNumber) {
        long bizOrg = Long.parseLong(bizOrgStr);
        String appNumber = EntityMetadataCache.getDataEntityType((String)"bd_material").getAppId();
        if ("mpdm_materialplan".equals(materialBizInfoNumber)) {
            QFilter f2;
            if (!GenerateMaterialBizInfoHelper.isExtistEntity("mpdm_materialplan")) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u5212\u4fe1\u606f\u6240\u5c5e\u5e94\u7528\u4e0d\u5b58\u5728\u3002", (String)"GenerateMaterialBizInfoHelper_6_3", (String)"bd-master-business", (Object[])new Object[0]));
            }
            String appid = FormMetadataCache.getFormConfig((String)"mpdm_materialplan").getAppId();
            logger.info("mpdm_materialplan get appid:" + appid);
            List calCtrlOrgs = BaseDataServiceHelper.getCreateOrgList((String)"mpdm_materialplan", (String)appid);
            boolean hasCreateCalPermission = calCtrlOrgs.stream().anyMatch(org -> org.equals(bizOrg));
            if (!calCtrlOrgs.isEmpty() && !hasCreateCalPermission) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u65e0\u201c\u7269\u6599\u8ba1\u5212\u4fe1\u606f\u201d\u521b\u5efa\u6743\u9650\u3002", (String)"BASEDATA-E-080082", (String)"bd-master-business", (Object[])new Object[]{bizOrgName}));
            }
            if (PermissionServiceHelper.checkPermission((long)Long.parseLong(RequestContext.get().getUserId()), (String)"DIM_ORG", (long)bizOrg, (String)appNumber, (String)"mpdm_materialplan", (String)"47156aff000000ac") == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7528\u6237\u65e0\u8be5\u7ec4\u7ec7\u7269\u6599\u8ba1\u5212\u4fe1\u606f\u521b\u5efa\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u3002", (String)"GenerateMaterialBizInfoHelper_11_3", (String)"bd-master-business", (Object[])new Object[0]));
            }
            DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)"mpdm_materialplan");
            QFilter f1 = new QFilter("view.id", "=", ctrlview.getPkValue());
            QFilter[] qfilters = new QFilter[]{f1, f2 = new QFilter("org.id", "=", (Object)bizOrg)};
            DynamicObject[] viewOrgs = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)"org", (QFilter[])qfilters);
            if (viewOrgs == null || viewOrgs.length == 0) {
                throw new KDBizException(ResManager.loadKDString((String)"\u201c\u7269\u6599\u8ba1\u5212\u4fe1\u606f\u201d\u4e0b\u201c\u8ba1\u5212\u4fe1\u606f\u521b\u5efa\u7ec4\u7ec7\u201d\u53d6\u503c\u5931\u8d25\uff1a\u8ba1\u7b97\u51fa\u7684\u7ec4\u7ec7\u201c%s\u201d\u6ca1\u6709\u65b0\u589e\u6743\u9650\u3002", (String)"BASEDATA-E-487048", (String)"bd-master-business", (Object[])new Object[]{bizOrgName}));
            }
        }
    }

    private static void orgPermissionChecking(String bizOrgStr, String materialBizInfoNumber) {
        Boolean hasCreateCalPermission;
        List calCtrlOrgs;
        String appid;
        Long bizOrg = Long.valueOf(bizOrgStr);
        logger.info("orgPermissionChecking get bizOrg:" + bizOrg);
        if ("bd_materialinventoryinfo".equals(materialBizInfoNumber)) {
            appid = FormMetadataCache.getFormConfig((String)"bd_materialinventoryinfo").getAppId();
            logger.info("bd_materialinventoryinfo get appid:" + appid);
            List inventoryCtrlOrgs = BaseDataServiceHelper.getCreateOrgList((String)"bd_materialinventoryinfo", (String)appid);
            Boolean hasCreateInventoryPermission = inventoryCtrlOrgs.stream().anyMatch(org -> org.equals(bizOrg));
            if (inventoryCtrlOrgs.size() > 0 && !hasCreateInventoryPermission.booleanValue()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u65e0\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u521b\u5efa\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u3002", (String)"GenerateMaterialBizInfoHelper_2", (String)"bd-master-business", (Object[])new Object[0]));
            }
        }
        if ("bd_materialpurchaseinfo".equals(materialBizInfoNumber)) {
            appid = FormMetadataCache.getFormConfig((String)"bd_materialpurchaseinfo").getAppId();
            logger.info("bd_materialpurchaseinfo get appid:" + appid);
            List purchaseCtrlOrgs = BaseDataServiceHelper.getCreateOrgList((String)"bd_materialpurchaseinfo", (String)appid);
            Boolean hasCreatePurchasePermission = purchaseCtrlOrgs.stream().anyMatch(org -> org.equals(bizOrg));
            if (purchaseCtrlOrgs.size() > 0 && !hasCreatePurchasePermission.booleanValue()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u65e0\u7269\u6599\u91c7\u8d2d\u4fe1\u606f\u521b\u5efa\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u3002", (String)"GenerateMaterialBizInfoHelper_3", (String)"bd-master-business", (Object[])new Object[0]));
            }
        }
        if ("bd_materialsalinfo".equals(materialBizInfoNumber)) {
            appid = FormMetadataCache.getFormConfig((String)"bd_materialsalinfo").getAppId();
            logger.info("bd_materialsalinfo get appid:" + appid);
            List saleCtrlOrgs = BaseDataServiceHelper.getCreateOrgList((String)"bd_materialsalinfo", (String)appid);
            Boolean hasCreateSalePermission = saleCtrlOrgs.stream().anyMatch(org -> org.equals(bizOrg));
            if (saleCtrlOrgs.size() > 0 && !hasCreateSalePermission.booleanValue()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u65e0\u7269\u6599\u9500\u552e\u4fe1\u606f\u521b\u5efa\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u3002", (String)"GenerateMaterialBizInfoHelper_4", (String)"bd-master-business", (Object[])new Object[0]));
            }
        }
        if ("bd_materialmftinfo".equals(materialBizInfoNumber)) {
            appid = FormMetadataCache.getFormConfig((String)"bd_materialmftinfo").getAppId();
            logger.info("bd_materialmftinfo get appid:" + appid);
            List mftCtrlOrgs = BaseDataServiceHelper.getCreateOrgList((String)"bd_materialmftinfo", (String)appid);
            Boolean hasCreateMftPermission = mftCtrlOrgs.stream().anyMatch(org -> org.equals(bizOrg));
            if (mftCtrlOrgs.size() > 0 && !hasCreateMftPermission.booleanValue()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u65e0\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u521b\u5efa\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u3002", (String)"GenerateMaterialBizInfoHelper_5", (String)"bd-master-business", (Object[])new Object[0]));
            }
        }
        if ("bd_inspect_cfg".equals(materialBizInfoNumber)) {
            appid = FormMetadataCache.getFormConfig((String)"bd_inspect_cfg").getAppId();
            logger.info("bd_inspect_cfg get appid:" + appid);
            List inspectCtrlOrgs = BaseDataServiceHelper.getCreateOrgList((String)"bd_inspect_cfg", (String)appid);
            Boolean hasCreateInspectPermission = inspectCtrlOrgs.stream().anyMatch(org -> org.equals(bizOrg));
            if (inspectCtrlOrgs.size() > 0 && !hasCreateInspectPermission.booleanValue()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u65e0\u7269\u6599\u8d28\u68c0\u4fe1\u606f\u521b\u5efa\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u3002", (String)"GenerateMaterialBizInfoHelper_6", (String)"bd-master-business", (Object[])new Object[0]));
            }
        }
        if ("bd_materialcalinfo".equals(materialBizInfoNumber)) {
            appid = FormMetadataCache.getFormConfig((String)"bd_materialcalinfo").getAppId();
            logger.info("bd_materialcalinfo get appid:" + appid);
            calCtrlOrgs = BaseDataServiceHelper.getCreateOrgList((String)"bd_materialcalinfo", (String)appid);
            hasCreateCalPermission = calCtrlOrgs.stream().anyMatch(org -> org.equals(bizOrg));
            if (calCtrlOrgs.size() > 0 && !hasCreateCalPermission.booleanValue()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u65e0\u7269\u6599\u6838\u7b97\u4fe1\u606f\u521b\u5efa\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u3002", (String)"GenerateMaterialBizInfoHelper_6_2", (String)"bd-master-business", (Object[])new Object[0]));
            }
        }
        if ("mpdm_materialplan".equals(materialBizInfoNumber)) {
            if (!GenerateMaterialBizInfoHelper.isExtistEntity("mpdm_materialplan")) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u5212\u4fe1\u606f\u6240\u5c5e\u5e94\u7528\u4e0d\u5b58\u5728\u3002", (String)"GenerateMaterialBizInfoHelper_6_3", (String)"bd-master-business", (Object[])new Object[0]));
            }
            appid = FormMetadataCache.getFormConfig((String)"mpdm_materialplan").getAppId();
            logger.info("mpdm_materialplan get appid:" + appid);
            calCtrlOrgs = BaseDataServiceHelper.getCreateOrgList((String)"mpdm_materialplan", (String)appid);
            hasCreateCalPermission = calCtrlOrgs.stream().anyMatch(org -> org.equals(bizOrg));
            if (calCtrlOrgs.size() > 0 && !hasCreateCalPermission.booleanValue()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u65e0\u7269\u6599\u8ba1\u5212\u4fe1\u606f\u521b\u5efa\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u3002", (String)"GenerateMaterialBizInfoHelper_6_4", (String)"bd-master-business", (Object[])new Object[0]));
            }
        }
    }

    private static void userPermissionChecking(String bizOrg, String materialBizInfoNumber) {
        long dimObjId = Long.parseLong(bizOrg);
        String appNumber = EntityMetadataCache.getDataEntityType((String)"bd_material").getAppId();
        logger.info("userPermissionChecking dimObjId:" + dimObjId + "userPermissionChecking get appNumber:" + appNumber);
        if ("bd_materialinventoryinfo".equals(materialBizInfoNumber) && PermissionServiceHelper.checkPermission((long)Long.parseLong(RequestContext.get().getUserId()), (String)"DIM_ORG", (long)dimObjId, (String)appNumber, (String)"bd_materialinventoryinfo", (String)"47156aff000000ac") == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7528\u6237\u65e0\u8be5\u7ec4\u7ec7\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u521b\u5efa\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u3002", (String)"GenerateMaterialBizInfoHelper_7", (String)"bd-master-business", (Object[])new Object[0]));
        }
        if ("bd_materialpurchaseinfo".equals(materialBizInfoNumber) && PermissionServiceHelper.checkPermission((long)Long.parseLong(RequestContext.get().getUserId()), (String)"DIM_ORG", (long)dimObjId, (String)appNumber, (String)"bd_materialpurchaseinfo", (String)"47156aff000000ac") == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7528\u6237\u65e0\u8be5\u7ec4\u7ec7\u7269\u6599\u91c7\u8d2d\u4fe1\u606f\u521b\u5efa\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u3002", (String)"GenerateMaterialBizInfoHelper_8", (String)"bd-master-business", (Object[])new Object[0]));
        }
        if ("bd_materialsalinfo".equals(materialBizInfoNumber) && PermissionServiceHelper.checkPermission((long)Long.parseLong(RequestContext.get().getUserId()), (String)"DIM_ORG", (long)dimObjId, (String)appNumber, (String)"bd_materialsalinfo", (String)"47156aff000000ac") == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7528\u6237\u65e0\u8be5\u7ec4\u7ec7\u7269\u6599\u9500\u552e\u4fe1\u606f\u521b\u5efa\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u3002", (String)"GenerateMaterialBizInfoHelper_9", (String)"bd-master-business", (Object[])new Object[0]));
        }
        if ("bd_materialmftinfo".equals(materialBizInfoNumber) && PermissionServiceHelper.checkPermission((long)Long.parseLong(RequestContext.get().getUserId()), (String)"DIM_ORG", (long)dimObjId, (String)appNumber, (String)"bd_materialmftinfo", (String)"47156aff000000ac") == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7528\u6237\u65e0\u8be5\u7ec4\u7ec7\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u521b\u5efa\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u3002", (String)"GenerateMaterialBizInfoHelper_10", (String)"bd-master-business", (Object[])new Object[0]));
        }
        if ("bd_inspect_cfg".equals(materialBizInfoNumber) && PermissionServiceHelper.checkPermission((long)Long.parseLong(RequestContext.get().getUserId()), (String)"DIM_ORG", (long)dimObjId, (String)appNumber, (String)"bd_inspect_cfg", (String)"47156aff000000ac") == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7528\u6237\u65e0\u8be5\u7ec4\u7ec7\u7269\u6599\u8d28\u68c0\u4fe1\u606f\u521b\u5efa\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u3002", (String)"GenerateMaterialBizInfoHelper_11", (String)"bd-master-business", (Object[])new Object[0]));
        }
        if ("bd_materialcalinfo".equals(materialBizInfoNumber) && PermissionServiceHelper.checkPermission((long)Long.parseLong(RequestContext.get().getUserId()), (String)"DIM_ORG", (long)dimObjId, (String)appNumber, (String)"bd_materialcalinfo", (String)"47156aff000000ac") == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7528\u6237\u65e0\u8be5\u7ec4\u7ec7\u7269\u6599\u6838\u7b97\u4fe1\u606f\u521b\u5efa\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u3002", (String)"GenerateMaterialBizInfoHelper_11_2", (String)"bd-master-business", (Object[])new Object[0]));
        }
        if ("mpdm_materialplan".equals(materialBizInfoNumber) && PermissionServiceHelper.checkPermission((long)Long.parseLong(RequestContext.get().getUserId()), (String)"DIM_ORG", (long)dimObjId, (String)appNumber, (String)"mpdm_materialplan", (String)"47156aff000000ac") == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7528\u6237\u65e0\u8be5\u7ec4\u7ec7\u7269\u6599\u8ba1\u5212\u4fe1\u606f\u521b\u5efa\u6743\u9650\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u3002", (String)"GenerateMaterialBizInfoHelper_11_3", (String)"bd-master-business", (Object[])new Object[0]));
        }
    }

    private static void bizFuncPermissionChecking(String bizOrgStr, String materialBizInfoNumber) {
        QFilter f2;
        DynamicObject ctrlview;
        QFilter f1;
        QFilter[] qfilters;
        DynamicObject[] viewOrgs;
        Long bizOrg = Long.valueOf(bizOrgStr);
        logger.info("bizFuncPermissionChecking get bizOrg:" + bizOrg);
        if ("bd_materialinventoryinfo".equals(materialBizInfoNumber) && ((viewOrgs = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)"org", (QFilter[])(qfilters = new QFilter[]{f1 = new QFilter("view.id", "=", (ctrlview = BaseDataServiceHelper.getCtrlview((String)"bd_materialinventoryinfo")).getPkValue()), f2 = new QFilter("org.id", "=", (Object)bizOrg)}))) == null || viewOrgs.length == 0)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u65e0\u5e93\u5b58\u804c\u80fd\u6216\u7ec4\u7ec7\u4e0d\u5728\u5e93\u5b58\u4e1a\u52a1\u89c6\u56fe\u65b9\u6848\u5185\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u3002", (String)"GenerateMaterialBizInfoHelper_12", (String)"bd-master-business", (Object[])new Object[0]));
        }
        if ("bd_materialpurchaseinfo".equals(materialBizInfoNumber) && ((viewOrgs = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)"org", (QFilter[])(qfilters = new QFilter[]{f1 = new QFilter("view.id", "=", (ctrlview = BaseDataServiceHelper.getCtrlview((String)"bd_materialpurchaseinfo")).getPkValue()), f2 = new QFilter("org.id", "=", (Object)bizOrg)}))) == null || viewOrgs.length == 0)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u65e0\u91c7\u8d2d\u804c\u80fd\u6216\u7ec4\u7ec7\u4e0d\u5728\u91c7\u8d2d\u4e1a\u52a1\u89c6\u56fe\u65b9\u6848\u5185\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u7269\u6599\u91c7\u8d2d\u4fe1\u606f\u3002", (String)"GenerateMaterialBizInfoHelper_13", (String)"bd-master-business", (Object[])new Object[0]));
        }
        if ("bd_materialsalinfo".equals(materialBizInfoNumber) && ((viewOrgs = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)"org", (QFilter[])(qfilters = new QFilter[]{f1 = new QFilter("view.id", "=", (ctrlview = BaseDataServiceHelper.getCtrlview((String)"bd_materialsalinfo")).getPkValue()), f2 = new QFilter("org.id", "=", (Object)bizOrg)}))) == null || viewOrgs.length == 0)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u65e0\u9500\u552e\u804c\u80fd\u6216\u7ec4\u7ec7\u4e0d\u5728\u9500\u552e\u4e1a\u52a1\u89c6\u56fe\u65b9\u6848\u5185\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u7269\u6599\u9500\u552e\u4fe1\u606f\u3002", (String)"GenerateMaterialBizInfoHelper_14", (String)"bd-master-business", (Object[])new Object[0]));
        }
        if ("bd_materialmftinfo".equals(materialBizInfoNumber) && ((viewOrgs = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)"org", (QFilter[])(qfilters = new QFilter[]{f1 = new QFilter("view.id", "=", (ctrlview = BaseDataServiceHelper.getCtrlview((String)"bd_materialmftinfo")).getPkValue()), f2 = new QFilter("org.id", "=", (Object)bizOrg)}))) == null || viewOrgs.length == 0)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u65e0\u751f\u4ea7\u804c\u80fd\u6216\u7ec4\u7ec7\u4e0d\u5728\u751f\u4ea7\u4e1a\u52a1\u89c6\u56fe\u65b9\u6848\u5185\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u3002", (String)"GenerateMaterialBizInfoHelper_15", (String)"bd-master-business", (Object[])new Object[0]));
        }
        if ("bd_inspect_cfg".equals(materialBizInfoNumber) && ((viewOrgs = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)"org", (QFilter[])(qfilters = new QFilter[]{f1 = new QFilter("view.id", "=", (ctrlview = BaseDataServiceHelper.getCtrlview((String)"bd_inspect_cfg")).getPkValue()), f2 = new QFilter("org.id", "=", (Object)bizOrg)}))) == null || viewOrgs.length == 0)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u65e0\u8d28\u68c0\u804c\u80fd\u6216\u7ec4\u7ec7\u4e0d\u5728\u8d28\u68c0\u4e1a\u52a1\u89c6\u56fe\u65b9\u6848\u5185\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u7269\u6599\u8d28\u68c0\u4fe1\u606f\u3002", (String)"GenerateMaterialBizInfoHelper_16", (String)"bd-master-business", (Object[])new Object[0]));
        }
        if ("bd_materialcalinfo".equals(materialBizInfoNumber) && ((viewOrgs = BusinessDataServiceHelper.load((String)"bos_org_structure", (String)"org", (QFilter[])(qfilters = new QFilter[]{f1 = new QFilter("view.id", "=", (ctrlview = BaseDataServiceHelper.getCtrlview((String)"bd_materialcalinfo")).getPkValue()), f2 = new QFilter("org.id", "=", (Object)bizOrg)}))) == null || viewOrgs.length == 0)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u65e0\u6838\u7b97\u804c\u80fd\u6216\u7ec4\u7ec7\u4e0d\u5728\u6838\u7b97\u4e1a\u52a1\u89c6\u56fe\u65b9\u6848\u5185\uff0c\u4e0d\u5141\u8bb8\u751f\u6210\u7269\u6599\u6838\u7b97\u4fe1\u606f\u3002", (String)"GenerateMaterialBizInfoHelper_17", (String)"bd-master-business", (Object[])new Object[0]));
        }
    }

    public static boolean isExtistEntity(String entityId) {
        String oql = String.format("select fid from T_META_ENTITYDESIGN where fnumber = '%s'", entityId);
        try (DataSet dataSet = DB.queryDataSet((String)GenerateMaterialBizInfoHelper.class.getName(), (DBRoute)DBRoute.meta, (String)oql);){
            Row row;
            String fparentid;
            if (dataSet.hasNext() && StringUtils.isNotBlank((CharSequence)(fparentid = (row = dataSet.next()).getString("fid")))) {
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }
}

