/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.master.enums.EnableEnum;
import kd.bd.master.helper.MasterDataHelper;
import kd.bd.master.vo.BillParamterCkVo;
import kd.bd.master.vo.ErrorEntity;
import kd.bd.master.vo.MaterialReturnVo;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.param.impl.ParameterReaderServiceImpl;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataRefrenceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class MaterialServiceHelper {
    private static Log logger = LogFactory.getLog(MaterialServiceHelper.class);
    public static final String NEW_NULL_FID = "0";
    private static final String CONFIG_PROPERTIES_FEATURE = "3";

    public Set<Long> getFixedonversionList(DynamicObject material) {
        String convertType = "1";
        Long baseUnitId = this.getDataByType(material.get("baseunit"));
        QFilter qFilter = null;
        qFilter = new QFilter("converttype", "=", (Object)convertType);
        Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)"bd_measureunitconv", (String)"desmuid,srcmuid", (QFilter[])new QFilter[]{qFilter});
        HashSet<String> measureunitconvs = new HashSet<String>(loadFromCache.size());
        for (Object measureunitconv : loadFromCache.values()) {
            StringBuilder conv = new StringBuilder();
            measureunitconvs.add(conv.append(this.getDataByType(measureunitconv.get("desmuid"))).append('-').append(this.getDataByType(measureunitconv.get("srcmuid"))).toString());
            StringBuilder conv2 = new StringBuilder();
            measureunitconvs.add(conv2.append(this.getDataByType(measureunitconv.get("srcmuid"))).append('-').append(this.getDataByType(measureunitconv.get("desmuid"))).toString());
        }
        DynamicObjectCollection entrys = material.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entrys) {
            String converttypeRow = entry.getString("converttype");
            if (convertType != null && !convertType.equals(converttypeRow)) continue;
            StringBuilder conv = new StringBuilder();
            measureunitconvs.add(conv.append(baseUnitId).append('-').append(this.getDataByType(entry.get("measureunitid"))).toString());
            StringBuilder conv2 = new StringBuilder();
            measureunitconvs.add(conv2.append(this.getDataByType(entry.get("measureunitid"))).append('-').append(baseUnitId).toString());
        }
        Set<Long> desmulist = new HashSet<Long>();
        desmulist = this.getUnitForWardRec(baseUnitId, measureunitconvs, desmulist);
        return desmulist;
    }

    private Set<Long> getUnitForWardRec(Long srcmuId, Set<String> measureunitconvs, Set<Long> desmulist) {
        String leftSrcmuId = srcmuId.toString() + "-";
        for (String measureunitconv : measureunitconvs) {
            Long unitId;
            String[] split;
            if (!measureunitconv.startsWith(leftSrcmuId) || (split = measureunitconv.split("-")).length != 2 || desmulist.contains(unitId = Long.valueOf(split[1]))) continue;
            desmulist.add(unitId);
            this.getUnitForWardRec(unitId, measureunitconvs, desmulist);
        }
        return desmulist;
    }

    public Long getDataByType(Object object) {
        Long dataId = 0L;
        if (object instanceof DynamicObject) {
            DynamicObject createorg = (DynamicObject)object;
            dataId = (Long)createorg.getPkValue();
        } else if (object instanceof Long) {
            dataId = (Long)object;
        }
        return dataId;
    }

    public static void updateMaterialInfo(List<Object> successPkIds) {
        MaterialServiceHelper.updateMaterialInfo("bd_materialinventoryinfo", successPkIds);
        MaterialServiceHelper.updateMaterialInfo("bd_materialsalinfo", successPkIds);
        MaterialServiceHelper.updateMaterialInfo("bd_materialpurchaseinfo", successPkIds);
        MaterialServiceHelper.updateMaterialInfo("bd_materialmftinfo", successPkIds);
        MaterialServiceHelper.updateMaterialInfo("bd_inspect_cfg", successPkIds);
        MaterialServiceHelper.updateMaterialInfo("bd_materialcalinfo", successPkIds);
        MaterialServiceHelper.updaMematerialplan("mpdm_materialplan", successPkIds);
    }

    private static void updaMematerialplan(String mpdmMaterialplan, List<Object> successPkIds) {
        try (TXHandle tx = TX.requiresNew();){
            DynamicObject[] dots = BusinessDataServiceHelper.load((String)mpdmMaterialplan, (String)"id,enable,disabler,disabledate", (QFilter[])new QFilter[]{new QFilter("masterid", "in", successPkIds)});
            if (dots != null && dots.length > 0) {
                for (DynamicObject dot : dots) {
                    dot.set("enable", (Object)NEW_NULL_FID);
                    dot.set("disabler", (Object)RequestContext.get().getUserId());
                    dot.set("disabledate", (Object)new Date());
                }
                SaveServiceHelper.update((DynamicObject[])dots);
            }
        }
    }

    private static void updateMaterialInfo(String entityType, List<Object> materialIds) {
        DynamicObject[] dots = BusinessDataServiceHelper.load((String)entityType, (String)"id,enable,disabler,disabledate", (QFilter[])new QFilter[]{new QFilter("masterid", "in", materialIds)});
        if (dots != null && dots.length > 0) {
            for (DynamicObject dot : dots) {
                dot.set("enable", (Object)NEW_NULL_FID);
                dot.set("disabler", (Object)RequestContext.get().getUserId());
                dot.set("disabledate", (Object)new Date());
            }
            SaveServiceHelper.update((DynamicObject[])dots);
        }
    }

    public static void addAuxptyUnitbeforeF7Select(IDataModel model, BeforeF7SelectEvent beforeF7SelectEvent, Long baseUnitId) {
        FormShowParameter fsp = beforeF7SelectEvent.getFormShowParameter();
        if (fsp instanceof ListShowParameter) {
            DynamicObject material = model.getDataEntity();
            material.set("entryentity", (Object)model.getEntryEntity("entryentity"));
            Set<Long> desmulist = new MaterialServiceHelper().getFixedonversionList(material);
            desmulist.add(baseUnitId);
            QFilter floatconFilter = new QFilter("id", "not in", desmulist);
            ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().getQFilters().add(floatconFilter);
            return;
        }
    }

    public static void addAuxptyInfobeforeF7Select(IDataModel model, BeforeF7SelectEvent beforeF7SelectEvent) {
        int rowCount = model.getEntryRowCount("auxptyentry");
        ArrayList<Long> selectedAuxpty = new ArrayList<Long>();
        for (int i = 0; i < rowCount; ++i) {
            Long auxptyId;
            DynamicObject auxProperty = (DynamicObject)model.getValue("auxpty", i);
            Long l = auxptyId = auxProperty == null ? null : Long.valueOf(auxProperty.getLong("id"));
            if (auxptyId == null) continue;
            selectedAuxpty.add(auxptyId);
        }
        if (selectedAuxpty != null && selectedAuxpty.size() > 0) {
            QFilter qfilter = new QFilter("id", "not in", selectedAuxpty);
            ((ListShowParameter)beforeF7SelectEvent.getFormShowParameter()).getListFilterParameter().getQFilters().add(qfilter);
        }
    }

    public static Boolean getPrecisionProperty() {
        AppParam appParam = new AppParam();
        appParam.setAppId("0efa1992000000ac");
        appParam.setViewType("15");
        appParam.setOrgId(Long.valueOf(OrgUnitServiceHelper.getRootOrgId()));
        appParam.setActBookId(Long.valueOf(0L));
        Map paramMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam);
        boolean isOpenPrecision = false;
        logger.info("\u83b7\u53d6\u7cfb\u7edf\u53c2\u6570\u7cbe\u5ea6\u8bbe\u7f6e \uff1aparamMap" + paramMap);
        if (paramMap != null && paramMap.get("ismaterialprecisionenable") != null) {
            logger.info("\u83b7\u53d6\u7cfb\u7edf\u53c2\u6570\u662f\u5426\u542f\u7528\u7cbe\u5ea6 \uff1aparamMap" + paramMap);
            Object ismaterialprecisionenable = paramMap.get("ismaterialprecisionenable");
            isOpenPrecision = (Boolean)ismaterialprecisionenable;
        }
        return isOpenPrecision;
    }

    public static void updateMaterialUnit(Map<String, Object> map, List<DynamicObject> measureUnits, List<Object> deleteUnitIds, DynamicObject dataEntity) throws KDBizException {
        DynamicObjectCollection col = dataEntity.getDynamicObjectCollection("entryentity");
        if (col != null && !col.isEmpty()) {
            Object materialId = dataEntity.getPkValue();
            ArrayList ids = new ArrayList();
            logger.info("\u5f00\u59cb\u540c\u6b65\u4fdd\u5b58\u8ba1\u91cf\u5355\u4f4d>>");
            for (DynamicObject obj : col) {
                Object id;
                DynamicObject measureunit = (DynamicObject)obj.get("measureunitid");
                if (measureunit == null || (id = measureunit.getPkValue()) == null || ids.contains(id.toString())) continue;
                DynamicObject objUnitConvert = null;
                objUnitConvert = BusinessDataServiceHelper.newDynamicObject((String)"bd_multimeasureunit");
                StringBuilder builder = new StringBuilder();
                builder.append("current id is:").append(id);
                logger.info(builder.toString());
                objUnitConvert.set("measureunitid", id);
                objUnitConvert.set("denominator", obj.get("denominator"));
                objUnitConvert.set("numerator", obj.get("numerator"));
                objUnitConvert.set("converttype", obj.get("converttype"));
                objUnitConvert.set("appscen", obj.get("appscen"));
                objUnitConvert.set("precision", obj.get("precision"));
                objUnitConvert.set("materialid", materialId);
                measureUnits.add(objUnitConvert);
            }
        }
        if (((Boolean)map.get(dataEntity.getPkValue().toString())).booleanValue()) {
            deleteUnitIds.add(dataEntity.getPkValue());
        }
    }

    public List<ErrorEntity> checkIsuseauxptyReferences(Set<Object> isuseauxptyChangeMaterialIds, ExtendedDataEntity[] dataEntitys, String entityNumber, List<String> ignoreRefEntityIds) {
        ArrayList<ErrorEntity> errors = new ArrayList<ErrorEntity>();
        if (isuseauxptyChangeMaterialIds != null && !isuseauxptyChangeMaterialIds.isEmpty()) {
            Map checkRefrenced = BaseDataRefrenceHelper.checkRefrenced((String)entityNumber, (Object[])isuseauxptyChangeMaterialIds.toArray(new Object[0]), ignoreRefEntityIds, null, null);
            for (ExtendedDataEntity dataEntity : dataEntitys) {
                ArrayList<String> errmsg = new ArrayList<String>();
                Object materialId = dataEntity.getDataEntity().getPkValue();
                BaseDataCheckRefrenceResult refrenceResult = (BaseDataCheckRefrenceResult)checkRefrenced.get(materialId);
                if (refrenceResult == null || !refrenceResult.isRefence() || !refrenceResult.isRefence()) continue;
                MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)refrenceResult.getRefenceKey().getRefEntityKey());
                String billName = refMainType.getDisplayName().getLocaleValue();
                String fieldName = refrenceResult.getRefenceKey().getRefCol();
                for (IDataEntityProperty property : refMainType.getAllFields().values()) {
                    if (property instanceof IFieldHandle && StringUtils.equalsIgnoreCase((CharSequence)property.getAlias(), (CharSequence)refrenceResult.getRefenceKey().getRefCol())) {
                        fieldName = ((IFieldHandle)property).getDisplayName().getLocaleValue();
                        break;
                    }
                    if (!(property instanceof MulBasedataProp) || !StringUtils.equalsIgnoreCase((CharSequence)refrenceResult.getRefenceKey().getRefCol(), (CharSequence)"fbasedataid") || !StringUtils.equalsIgnoreCase((CharSequence)refrenceResult.getRefenceKey().getRefTable(), (CharSequence)((MulBasedataProp)property).getAlias())) continue;
                    fieldName = ((MulBasedataProp)property).getDisplayName().getLocaleValue();
                    break;
                }
                String msg = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5f15\u7528\u4e0d\u80fd\u4fee\u6539\u542f\u7528\u8f85\u52a9\u5c5e\u6027\u5f00\u5173\uff1a\u201c%1$s\u201d\u7684\u5b57\u6bb5\u201c%2$s\u201d\u5f15\u7528\u4e86\u6b64\u8d44\u6599\u6570\u636e\u3002", (String)"MaterialServiceHelper_6", (String)"bd-master-business", (Object[])new Object[0]), billName, fieldName);
                errmsg.add(msg);
                errors.add(new ErrorEntity(dataEntity, errmsg));
            }
        }
        return errors;
    }

    public List<ErrorEntity> checkSuiteReferences(Set<Object> suitChangeMaterialIds, Set<Object> materialTypeIds, ExtendedDataEntity[] dataEntitys, String entityNumber, List<String> ignoreRefEntityIds) {
        Object msg;
        String fieldName;
        String billName;
        MainEntityType refMainType;
        BaseDataCheckRefrenceResult refrenceResult;
        Object materialId;
        ArrayList<String> errmsg;
        Map checkRefrenced;
        ArrayList<ErrorEntity> errors = new ArrayList<ErrorEntity>();
        if (suitChangeMaterialIds != null && suitChangeMaterialIds.size() > 0) {
            checkRefrenced = BaseDataRefrenceHelper.checkRefrenced((String)entityNumber, (Object[])suitChangeMaterialIds.toArray(new Object[0]), ignoreRefEntityIds, null, null);
            for (ExtendedDataEntity dataEntity : dataEntitys) {
                errmsg = new ArrayList<String>();
                materialId = dataEntity.getDataEntity().getPkValue();
                refrenceResult = (BaseDataCheckRefrenceResult)checkRefrenced.get(materialId);
                if (refrenceResult == null || !refrenceResult.isRefence() || !refrenceResult.isRefence()) continue;
                refMainType = EntityMetadataCache.getDataEntityType((String)refrenceResult.getRefenceKey().getRefEntityKey());
                billName = refMainType.getDisplayName().getLocaleValue();
                fieldName = refrenceResult.getRefenceKey().getRefCol();
                for (IDataEntityProperty property : refMainType.getAllFields().values()) {
                    if (property instanceof IFieldHandle && StringUtils.equalsIgnoreCase((CharSequence)property.getAlias(), (CharSequence)refrenceResult.getRefenceKey().getRefCol())) {
                        fieldName = ((IFieldHandle)property).getDisplayName().getLocaleValue();
                        break;
                    }
                    if (!(property instanceof MulBasedataProp) || !StringUtils.equalsIgnoreCase((CharSequence)refrenceResult.getRefenceKey().getRefCol(), (CharSequence)"fbasedataid") || !StringUtils.equalsIgnoreCase((CharSequence)refrenceResult.getRefenceKey().getRefTable(), (CharSequence)((MulBasedataProp)property).getAlias())) continue;
                    fieldName = ((MulBasedataProp)property).getDisplayName().getLocaleValue();
                    break;
                }
                msg = String.format(ResManager.loadKDString((String)"\u88ab\u5f15\u7528\u7684\u7269\u6599\uff0c\u4e0d\u53ef\u4ee5\u66f4\u6539\u5957\u4ef6\u6807\u8bc6\uff1a\u201c%1$s\u201d\u7684\u5b57\u6bb5\u201c%2$s\u201d\u5f15\u7528\u4e86\u6b64\u8d44\u6599\u6570\u636e\u3002", (String)"MaterialServiceHelper_4", (String)"bd-master-business", (Object[])new Object[0]), billName, fieldName);
                errmsg.add((String)msg);
                errors.add(new ErrorEntity(dataEntity, errmsg));
            }
        }
        if (materialTypeIds != null && materialTypeIds.size() > 0) {
            checkRefrenced = BaseDataRefrenceHelper.checkRefrenced((String)entityNumber, (Object[])materialTypeIds.toArray(new Object[0]), ignoreRefEntityIds, null, null);
            for (ExtendedDataEntity dataEntity : dataEntitys) {
                errmsg = new ArrayList();
                materialId = dataEntity.getDataEntity().getPkValue();
                refrenceResult = (BaseDataCheckRefrenceResult)checkRefrenced.get(materialId);
                if (refrenceResult == null || !refrenceResult.isRefence() || !refrenceResult.isRefence()) continue;
                refMainType = EntityMetadataCache.getDataEntityType((String)refrenceResult.getRefenceKey().getRefEntityKey());
                billName = refMainType.getDisplayName().getLocaleValue();
                fieldName = refrenceResult.getRefenceKey().getRefCol();
                for (IDataEntityProperty property : refMainType.getAllFields().values()) {
                    if (property instanceof IFieldHandle && StringUtils.equalsIgnoreCase((CharSequence)property.getAlias(), (CharSequence)refrenceResult.getRefenceKey().getRefCol())) {
                        fieldName = ((IFieldHandle)property).getDisplayName().getLocaleValue();
                        break;
                    }
                    if (!(property instanceof MulBasedataProp) || !StringUtils.equalsIgnoreCase((CharSequence)refrenceResult.getRefenceKey().getRefCol(), (CharSequence)"fbasedataid") || !StringUtils.equalsIgnoreCase((CharSequence)refrenceResult.getRefenceKey().getRefTable(), (CharSequence)((MulBasedataProp)property).getAlias())) continue;
                    fieldName = ((MulBasedataProp)property).getDisplayName().getLocaleValue();
                    break;
                }
                msg = String.format(ResManager.loadKDString((String)"\u88ab\u5f15\u7528\u4e14\u5df2\u6253\u5f00\u5957\u4ef6\u6807\u8bc6\u7684\u7269\u6599\uff0c\u4e0d\u5141\u8bb8\u66f4\u6539\u7269\u6599\u7c7b\u578b\uff1a\u201c%1$s\u201d\u7684\u5b57\u6bb5\u201c%2$s\u201d\u5f15\u7528\u4e86\u6b64\u8d44\u6599\u6570\u636e\u3002", (String)"MaterialServiceHelper_5", (String)"bd-master-business", (Object[])new Object[0]), billName, fieldName);
                errmsg.add((String)msg);
                errors.add(new ErrorEntity(dataEntity, errmsg));
            }
        }
        return errors;
    }

    public List<ErrorEntity> checkReferences(Set<Object> materialIds, ExtendedDataEntity[] dataEntitys, String entityNumber, List<String> ignoreRefEntityIds) {
        ArrayList<ErrorEntity> errors = new ArrayList<ErrorEntity>();
        if (materialIds != null && !materialIds.isEmpty()) {
            Map checkRefrenced = BaseDataRefrenceHelper.checkRefrenced((String)entityNumber, (Object[])materialIds.toArray(new Object[0]), ignoreRefEntityIds, null, null);
            for (ExtendedDataEntity dataEntity : dataEntitys) {
                ArrayList<String> errmsg = new ArrayList<String>();
                Object materialId = dataEntity.getDataEntity().getPkValue();
                BaseDataCheckRefrenceResult refrenceResult = (BaseDataCheckRefrenceResult)checkRefrenced.get(materialId);
                if (refrenceResult == null || !refrenceResult.isRefence() || !refrenceResult.isRefence()) continue;
                MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)refrenceResult.getRefenceKey().getRefEntityKey());
                String billName = refMainType.getDisplayName().getLocaleValue();
                String fieldName = refrenceResult.getRefenceKey().getRefCol();
                for (IDataEntityProperty property : refMainType.getAllFields().values()) {
                    if (property instanceof IFieldHandle && StringUtils.equalsIgnoreCase((CharSequence)property.getAlias(), (CharSequence)refrenceResult.getRefenceKey().getRefCol())) {
                        fieldName = ((IFieldHandle)property).getDisplayName().getLocaleValue();
                        break;
                    }
                    if (!(property instanceof MulBasedataProp) || !StringUtils.equalsIgnoreCase((CharSequence)refrenceResult.getRefenceKey().getRefCol(), (CharSequence)"fbasedataid") || !StringUtils.equalsIgnoreCase((CharSequence)refrenceResult.getRefenceKey().getRefTable(), (CharSequence)((MulBasedataProp)property).getAlias())) continue;
                    fieldName = ((MulBasedataProp)property).getDisplayName().getLocaleValue();
                    break;
                }
                String msg = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5f15\u7528\u4e0d\u80fd\u4fee\u6539\u57fa\u672c\u5355\u4f4d\u6216\u8005\u8f85\u52a9\u5355\u4f4d\uff1a\u201c%1$s\u201d\u7684\u5b57\u6bb5\u201c%2$s\u201d\u5f15\u7528\u4e86\u6b64\u8d44\u6599\u6570\u636e\u3002", (String)"MaterialServiceHelper_2", (String)"bd-master-business", (Object[])new Object[0]), billName, fieldName);
                errmsg.add(msg);
                errors.add(new ErrorEntity(dataEntity, errmsg));
            }
        }
        return errors;
    }

    public List<ErrorEntity> checkConfiguredcodeReferences(Set<Object> configuredcodeMaterialIds, ExtendedDataEntity[] dataEntitys, String entityNumber, List<String> checkRefEntityIds) {
        ArrayList<ErrorEntity> errors = new ArrayList<ErrorEntity>();
        if (configuredcodeMaterialIds != null && configuredcodeMaterialIds.size() > 0) {
            Map checkRefrenced = BaseDataRefrenceHelper.checkRefrenced((String)entityNumber, (Object[])configuredcodeMaterialIds.toArray(new Object[0]), null, checkRefEntityIds, null);
            for (ExtendedDataEntity dataEntity : dataEntitys) {
                ArrayList<String> errmsg = new ArrayList<String>();
                Object materialId = dataEntity.getDataEntity().getPkValue();
                BaseDataCheckRefrenceResult refrenceResult = (BaseDataCheckRefrenceResult)checkRefrenced.get(materialId);
                if (refrenceResult == null || !refrenceResult.isRefence() || !refrenceResult.isRefence()) continue;
                String msg = ResManager.loadKDString((String)"\u7269\u6599\u5df2\u88ab\u914d\u7f6e\u53f7\u57fa\u7840\u8d44\u6599\u7269\u6599\u5c5e\u6027\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u7269\u6599\u7684\u7269\u6599\u7c7b\u578b\u6216\u8005\u914d\u7f6e\u5c5e\u6027\u7684\u503c\u3002", (String)"MaterialServiceHelper_3", (String)"bd-master-business", (Object[])new Object[0]);
                errmsg.add(msg);
                errors.add(new ErrorEntity(dataEntity, errmsg));
            }
        }
        return errors;
    }

    public MaterialReturnVo dataModifyVerification(Set<Object> materialIds, ExtendedDataEntity[] dataEntitys) {
        HashSet<Object> configuredcodeMaterialIds = new HashSet<Object>();
        HashSet<Object> suitChangeMaterialIds = new HashSet<Object>();
        HashSet<Object> isuseauxptyChangeMaterialIds = new HashSet<Object>();
        HashSet<Object> materialTypeIds = new HashSet<Object>();
        Map materials = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (String)"id,baseunit,auxptyunit,configproperties,materialtype,suite,isuseauxpty", (QFilter[])new QFilter[]{new QFilter("id", "in", materialIds)});
        if (materials == null || materials.isEmpty()) {
            return new MaterialReturnVo(materialIds, configuredcodeMaterialIds, suitChangeMaterialIds, materialTypeIds, isuseauxptyChangeMaterialIds);
        }
        for (ExtendedDataEntity dataEntity : dataEntitys) {
            String oldSuite;
            String newSuite;
            Long oldAuxptyunitId;
            Object materialId = dataEntity.getDataEntity().getPkValue();
            if (!materials.containsKey(materialId)) continue;
            DynamicObject material = (DynamicObject)materials.get(materialId);
            Long newBaseunitId = this.getDataByType(dataEntity.getDataEntity().get("baseunit"));
            Long oldBaseunitId = this.getDataByType(material.get("baseunit"));
            Long newAuxptyunitId = this.getDataByType(dataEntity.getDataEntity().get("auxptyunit"));
            if (newAuxptyunitId.equals(oldAuxptyunitId = this.getDataByType(material.get("auxptyunit"))) && newBaseunitId.equals(oldBaseunitId)) {
                materialIds.remove(materialId);
            }
            String oldConfigproperties = material.getString("configproperties");
            String newConfigproperties = dataEntity.getDataEntity().getString("configproperties");
            String oldMaterialType = material.getString("materialtype");
            String newMaterialType = dataEntity.getDataEntity().getString("materialtype");
            if (StringUtils.isNotBlank((CharSequence)oldMaterialType) && !oldMaterialType.equals(newMaterialType) && "1".equals(oldMaterialType) || StringUtils.isNotBlank((CharSequence)oldConfigproperties) && !oldConfigproperties.equals(newConfigproperties) && !"1".equals(oldConfigproperties)) {
                configuredcodeMaterialIds.add(materialId);
            }
            if (!(newSuite = dataEntity.getDataEntity().getString("suite")).equals(oldSuite = material.getString("suite"))) {
                suitChangeMaterialIds.add(materialId);
            } else if (Boolean.parseBoolean(newSuite) && !oldMaterialType.equals(newMaterialType)) {
                materialTypeIds.add(materialId);
            }
            String newIsuseauxpty = dataEntity.getDataEntity().getString("isuseauxpty");
            String oldIsuseauxpty = material.getString("isuseauxpty");
            if (newIsuseauxpty.equals(oldIsuseauxpty)) continue;
            isuseauxptyChangeMaterialIds.add(materialId);
        }
        return new MaterialReturnVo(materialIds, configuredcodeMaterialIds, suitChangeMaterialIds, materialTypeIds, isuseauxptyChangeMaterialIds);
    }

    public List<String> checkUnitconvertPrecision(ExtendedDataEntity dataEntity) {
        ArrayList<String> errors = new ArrayList<String>();
        DynamicObjectCollection unitconverts = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
        if (unitconverts == null || unitconverts.size() <= 0) {
            return errors;
        }
        if (dataEntity.getBillPkId() == null && NEW_NULL_FID.equals(dataEntity.getDataEntity().getPkValue().toString())) {
            return errors;
        }
        Map oldUnitconverts = BusinessDataServiceHelper.loadFromCache((String)"bd_multimeasureunit", (String)"id,precision", (QFilter[])new QFilter[]{new QFilter("materialid", "=", dataEntity.getBillPkId())});
        if (oldUnitconverts == null || oldUnitconverts.size() <= 0) {
            return errors;
        }
        HashMap<String, DynamicObject> oldUnitconvertMaps = new HashMap<String, DynamicObject>(oldUnitconverts.size());
        for (DynamicObject oldUnitconvert : oldUnitconverts.values()) {
            oldUnitconvertMaps.put(oldUnitconvert.get("id").toString(), oldUnitconvert);
        }
        for (DynamicObject unitconvert : unitconverts) {
            String id = unitconvert.getString("unitconvertid");
            if (id == null || !oldUnitconvertMaps.containsKey(id)) continue;
            Integer oldPrecision = ((DynamicObject)oldUnitconvertMaps.get(id)).getInt("precision");
            Integer newPrecision = Integer.parseInt(unitconvert.get("precision").toString());
            if (oldPrecision > newPrecision) {
                errors.add(ResManager.loadKDString((String)"\u542f\u7528\u7269\u6599\u5355\u4f4d\u7cbe\u5ea6\u53c2\u6570\u540e\uff0c\u4fee\u6539\u540e\u7684\u5355\u4f4d\u7cbe\u5ea6\u4e0d\u5141\u8bb8\u5c0f\u4e8e\u4fee\u6539\u524d\u7684\u5355\u4f4d\u7cbe\u5ea6\u3002", (String)"MaterialServiceHelper_0", (String)"bd-master-business", (Object[])new Object[0]));
            }
            oldUnitconvertMaps.remove(id);
        }
        if (oldUnitconvertMaps != null && oldUnitconvertMaps.size() > 0) {
            errors.add(ResManager.loadKDString((String)"\u542f\u7528\u7269\u6599\u5355\u4f4d\u7cbe\u5ea6\u53c2\u6570\u540e\uff0c\u5df2\u7ecf\u6dfb\u52a0\u7684\u8ba1\u91cf\u5355\u4f4d\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"MaterialServiceHelper_1", (String)"bd-master-business", (Object[])new Object[0]));
        }
        return errors;
    }

    public static Boolean isMaterialBizVisible(DynamicObject material, String bizInfoEntityId, String enableBizInfoBtnId) {
        Boolean hasBizFuncPermission;
        DynamicObject useOrg = material.getDynamicObject("useorg");
        Long useOrgId = useOrg == null ? 0L : useOrg.getLong("id");
        String enable = material.getString("enable");
        boolean enableBizInfo = "bd_materialcalinfo".equals(bizInfoEntityId) || "bd_materialplan".equals(bizInfoEntityId) ? true : material.getBoolean(enableBizInfoBtnId);
        String configProp = material.getString("configproperties");
        logger.info("isMaterialBizVisible:bizInfoEntityId=" + bizInfoEntityId + ",enableBizInfoBtnId=" + enableBizInfoBtnId + ",useOrgId=" + useOrgId + ",enable=" + enable + ",enableBizInfo=" + enableBizInfo + ",configProp=" + configProp);
        if (useOrgId.equals(0L) || !EnableEnum.ENABLE.getCode().equals(enable) || !enableBizInfo || CONFIG_PROPERTIES_FEATURE.equals(configProp)) {
            return Boolean.FALSE;
        }
        if ("bd_materialplan".equals(bizInfoEntityId)) {
            bizInfoEntityId = "mpdm_materialplan";
        }
        if (!(hasBizFuncPermission = MasterDataHelper.hasBizFuncPermission(useOrgId, bizInfoEntityId)).booleanValue()) {
            return Boolean.FALSE;
        }
        String appNumber = EntityMetadataCache.getDataEntityType((String)"bd_material").getAppId();
        Boolean hasViewOperPermission = MasterDataHelper.hasOperPermission(useOrgId, appNumber, bizInfoEntityId, "47150e89000000ac");
        if (!hasViewOperPermission.booleanValue()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static BillParamterCkVo getBillParameter() {
        Map plan;
        Map insp;
        Map mtm;
        Map inv;
        Map cal;
        Map pur;
        ParameterReaderServiceImpl ptr = new ParameterReaderServiceImpl();
        Map map = ptr.loadBillParameterObjectFromCache("bd_material");
        if (map == null || map.size() < 1 || map != null && map.size() > 0 && map.containsKey("mtcollaboration") && !Boolean.parseBoolean(map.get("mtcollaboration").toString())) {
            return null;
        }
        boolean salck = true;
        boolean purck = true;
        boolean invck = true;
        boolean mtmck = true;
        boolean inspck = true;
        boolean calck = true;
        boolean planck = true;
        StringBuilder error = new StringBuilder();
        Map sal = ptr.loadBillParameterObjectFromCache("bd_materialsalinfo");
        if (sal != null && sal.size() > 0 && sal.containsKey("submitandaudit") && Boolean.parseBoolean(sal.get("submitandaudit").toString())) {
            salck = false;
            error.append(ResManager.loadKDString((String)"\u56e0\u7269\u6599\u9500\u552e\u4fe1\u606f\u5f00\u542f\u4e86\u201c\u63d0\u4ea4\u540e\u81ea\u52a8\u5ba1\u6838\u201d\u53c2\u6570\uff0c\u7269\u6599\u4e1a\u52a1\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25\u3002", (String)"MaterialServiceHelper_7", (String)"bd-master-business", (Object[])new Object[0]));
            error.append("\r\n");
        }
        if ((pur = ptr.loadBillParameterObjectFromCache("bd_materialpurchaseinfo")) != null && pur.size() > 0 && pur.containsKey("submitandaudit") && Boolean.parseBoolean(pur.get("submitandaudit").toString())) {
            purck = false;
            error.append(ResManager.loadKDString((String)"\u56e0\u7269\u6599\u91c7\u8d2d\u4fe1\u606f\u5f00\u542f\u4e86\u201c\u63d0\u4ea4\u540e\u81ea\u52a8\u5ba1\u6838\u201d\u53c2\u6570\uff0c\u7269\u6599\u4e1a\u52a1\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25\u3002", (String)"MaterialServiceHelper_8", (String)"bd-master-business", (Object[])new Object[0]));
            error.append("\r\n");
        }
        if ((cal = ptr.loadBillParameterObjectFromCache("bd_materialcalinfo")) != null && cal.size() > 0 && cal.containsKey("submitandaudit") && Boolean.parseBoolean(cal.get("submitandaudit").toString())) {
            calck = false;
            error.append(ResManager.loadKDString((String)"\u56e0\u7269\u6599\u6838\u7b97\u4fe1\u606f\u5f00\u542f\u4e86\u201c\u63d0\u4ea4\u540e\u81ea\u52a8\u5ba1\u6838\u201d\u53c2\u6570\uff0c\u7269\u6599\u4e1a\u52a1\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25\u3002", (String)"MaterialServiceHelper_9", (String)"bd-master-business", (Object[])new Object[0]));
            error.append("\r\n");
        }
        if ((inv = ptr.loadBillParameterObjectFromCache("bd_materialinventoryinfo")) != null && inv.size() > 0 && inv.containsKey("submitandaudit") && Boolean.parseBoolean(inv.get("submitandaudit").toString())) {
            invck = false;
            error.append(ResManager.loadKDString((String)"\u56e0\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u5f00\u542f\u4e86\u201c\u63d0\u4ea4\u540e\u81ea\u52a8\u5ba1\u6838\u201d\u53c2\u6570\uff0c\u7269\u6599\u4e1a\u52a1\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25\u3002", (String)"MaterialServiceHelper_10", (String)"bd-master-business", (Object[])new Object[0]));
            error.append("\r\n");
        }
        if ((mtm = ptr.loadBillParameterObjectFromCache("bd_materialmftinfo")) != null && mtm.size() > 0 && mtm.containsKey("submitandaudit") && Boolean.parseBoolean(mtm.get("submitandaudit").toString())) {
            mtmck = false;
            error.append(ResManager.loadKDString((String)"\u56e0\u7269\u6599\u751f\u4ea7\u4fe1\u606f\u5f00\u542f\u4e86\u201c\u63d0\u4ea4\u540e\u81ea\u52a8\u5ba1\u6838\u201d\u53c2\u6570\uff0c\u7269\u6599\u4e1a\u52a1\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25\u3002", (String)"MaterialServiceHelper_11", (String)"bd-master-business", (Object[])new Object[0]));
            error.append("\r\n");
        }
        if ((insp = ptr.loadBillParameterObjectFromCache("bd_inspect_cfg")) != null && insp.size() > 0 && insp.containsKey("submitandaudit") && Boolean.parseBoolean(insp.get("submitandaudit").toString())) {
            inspck = false;
            error.append(ResManager.loadKDString((String)"\u56e0\u7269\u6599\u8d28\u68c0\u4fe1\u606f\u5f00\u542f\u4e86\u201c\u63d0\u4ea4\u540e\u81ea\u52a8\u5ba1\u6838\u201d\u53c2\u6570\uff0c\u7269\u6599\u4e1a\u52a1\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25\u3002", (String)"MaterialServiceHelper_12", (String)"bd-master-business", (Object[])new Object[0]));
            error.append("\r\n");
        }
        if ((plan = ptr.loadBillParameterObjectFromCache("mpdm_materialplan")) != null && plan.size() > 0 && plan.containsKey("submitandaudit") && Boolean.parseBoolean(plan.get("submitandaudit").toString())) {
            planck = false;
            error.append(ResManager.loadKDString((String)"\u56e0\u7269\u6599\u8ba1\u5212\u4fe1\u606f\u5f00\u542f\u4e86\u201c\u63d0\u4ea4\u540e\u81ea\u52a8\u5ba1\u6838\u201d\u53c2\u6570\uff0c\u7269\u6599\u4e1a\u52a1\u4fe1\u606f\u4fdd\u5b58\u5931\u8d25\u3002", (String)"MaterialServiceHelper_13", (String)"bd-master-business", (Object[])new Object[0]));
            error.append("\r\n");
        }
        if (map != null && map.size() > 0 && map.containsKey("mtcollaboration") && Boolean.parseBoolean(map.get("mtcollaboration").toString()) && salck && purck && invck && mtmck && inspck && calck && planck) {
            return new BillParamterCkVo(true, "");
        }
        return new BillParamterCkVo(false, error.toString());
    }

    public static Map<String, Object> getBillParameterWithForm(String formId) {
        ParameterReaderServiceImpl ptr = new ParameterReaderServiceImpl();
        Map map = ptr.loadBillParameterObjectFromCache(formId);
        if (map == null) {
            return Collections.EMPTY_MAP;
        }
        return map;
    }
}

